/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.end2end.BaseQueryIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runners.Parameterized;

@Category(value={ParallelStatsDisabledTest.class})
public class AggregateQueryIT
extends BaseQueryIT {
    @Parameterized.Parameters(name="AggregateQueryIT_{index}")
    public static synchronized Collection<Object> data() {
        return BaseQueryIT.allIndexes();
    }

    public AggregateQueryIT(String indexDDL, boolean columnEncoded, boolean keepDeletedCells) {
        super(indexDDL, columnEncoded, keepDeletedCells);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGroupByPlusOne() throws Exception {
        String query = "SELECT a_integer+1 FROM " + tableName + " WHERE organization_id=? and a_integer = 5 GROUP BY a_integer+1";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (java.sql.Connection conn = DriverManager.getConnection(AggregateQueryIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)6L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSplitWithCachedMeta() throws Exception {
        String query = "SELECT a_string, b_string, count(1) FROM " + tableName + " WHERE organization_id=? and entity_id<=? GROUP BY a_string,b_string";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        java.sql.Connection conn = DriverManager.getConnection(AggregateQueryIT.getUrl(), props);
        Admin admin = null;
        try {
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            statement.setString(2, "00A423122312312");
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((Object)"b", (Object)rs.getString(2));
            Assert.assertEquals((long)2L, (long)rs.getLong(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((Object)"c", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getLong(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((Object)"e", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getLong(3));
            Assert.assertFalse((boolean)rs.next());
            TableName tn = TableName.valueOf((String)tableName);
            admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();
            Configuration configuration = conn.unwrap(PhoenixConnection.class).getQueryServices().getConfiguration();
            Connection hbaseConn = ConnectionFactory.createConnection((Configuration)configuration);
            RegionLocator regionLocator = hbaseConn.getRegionLocator(TableName.valueOf((String)tableName));
            regionLocator.clearRegionLocationCache();
            int nRegions = regionLocator.getAllRegionLocations().size();
            admin.split(tn, ByteUtil.concat((byte[])Bytes.toBytes((String)tenantId), (byte[][])new byte[][]{Bytes.toBytes((String)"00A3")}));
            int retryCount = 0;
            do {
                Thread.sleep(2000L);
            } while (++retryCount < 10 && regionLocator.getAllRegionLocations().size() == nRegions);
            Assert.assertNotEquals((long)nRegions, (long)regionLocator.getAllRegionLocations().size());
            statement.setString(1, tenantId);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((Object)"b", (Object)rs.getString(2));
            Assert.assertEquals((long)2L, (long)rs.getLong(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((Object)"c", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getLong(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((Object)"e", (Object)rs.getString(2));
            Assert.assertEquals((long)1L, (long)rs.getLong(3));
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            if (admin != null) {
                admin.close();
            }
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCountIsNull() throws Exception {
        String query = "SELECT count(1) FROM " + tableName + " WHERE X_DECIMAL is null";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (java.sql.Connection conn = DriverManager.getConnection(AggregateQueryIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)6L, (long)rs.getLong(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCountWithNoScanRanges() throws Exception {
        String query = "SELECT count(1) FROM " + tableName + " WHERE organization_id = 'not_existing_organization_id'";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (java.sql.Connection conn = DriverManager.getConnection(AggregateQueryIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)0L, (long)rs.getLong(1));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT count(1) FROM " + tableName + " WHERE organization_id = 'not_existing_organization_id' having count(*)>0";
            rs = conn.prepareStatement(query).executeQuery();
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT count(1) FROM " + tableName + " WHERE organization_id = 'not_existing_organization_id' limit 1 offset 1";
            rs = conn.prepareStatement(query).executeQuery();
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT count(1),123 FROM " + tableName + " WHERE organization_id = 'not_existing_organization_id'";
            rs = conn.prepareStatement(query).executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)0L, (long)rs.getLong(1));
            Assert.assertEquals((Object)"123", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT count(1),sum(x_decimal) FROM " + tableName + " WHERE organization_id = 'not_existing_organization_id'";
            rs = conn.prepareStatement(query).executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)0L, (long)rs.getLong(1));
            Assert.assertEquals(null, (Object)rs.getBigDecimal(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCountIsNotNull() throws Exception {
        String query = "SELECT count(1) FROM " + tableName + " WHERE X_DECIMAL is not null";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (java.sql.Connection conn = DriverManager.getConnection(AggregateQueryIT.getUrl(), props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getLong(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInFilterOnKey() throws Exception {
        String query = "SELECT count(entity_id) FROM " + tableName + " WHERE organization_id IN (?,?)";
        String url = AggregateQueryIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (java.sql.Connection conn = DriverManager.getConnection(url, props);){
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            statement.setString(2, tenantId);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)9L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }
}

