/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class AbsFunctionEnd2EndIT
extends ParallelStatsDisabledIT {
    private static final String TABLE_NAME = AbsFunctionEnd2EndIT.generateUniqueName();
    private static final String KEY = "key";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void initTable() throws Exception {
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = DriverManager.getConnection(AbsFunctionEnd2EndIT.getUrl());
            String ddl = "CREATE TABLE " + TABLE_NAME + " (k VARCHAR NOT NULL PRIMARY KEY, \"DEC\" DECIMAL, doub DOUBLE, fl FLOAT, inte INTEGER, lon BIGINT, smalli SMALLINT, tinyi TINYINT)";
            conn.createStatement().execute(ddl);
            conn.commit();
        }
        finally {
            TestUtil.closeStmtAndConn(stmt, conn);
        }
    }

    private void updateSignedTable(Connection conn, double data) throws Exception {
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + TABLE_NAME + " VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
        stmt.setString(1, KEY);
        Double d = data;
        stmt.setBigDecimal(2, BigDecimal.valueOf(data));
        stmt.setDouble(3, d);
        stmt.setFloat(4, d.floatValue());
        stmt.setInt(5, d.intValue());
        stmt.setLong(6, d.longValue());
        stmt.setShort(7, d.shortValue());
        stmt.setByte(8, d.byteValue());
        stmt.executeUpdate();
        conn.commit();
    }

    private void testSignedNumberSpec(Connection conn, double data) throws Exception {
        this.updateSignedTable(conn, data);
        ResultSet rs = conn.createStatement().executeQuery("SELECT ABS(\"DEC\"),ABS(doub),ABS(fl),ABS(inte),ABS(lon),ABS(smalli),ABS(tinyi) FROM " + TABLE_NAME);
        Assert.assertTrue((boolean)rs.next());
        Double d = data;
        Assert.assertEquals((long)rs.getBigDecimal(1).compareTo(BigDecimal.valueOf(data).abs()), (long)0L);
        Assert.assertEquals((double)rs.getDouble(2), (double)Math.abs(data), (double)1.0E-6);
        Assert.assertEquals((double)rs.getFloat(3), (double)Math.abs(d.floatValue()), (double)1.0E-6);
        Assert.assertEquals((long)rs.getInt(4), (long)Math.abs(d.intValue()));
        Assert.assertEquals((long)rs.getLong(5), (long)Math.abs(d.longValue()));
        Assert.assertEquals((long)rs.getShort(6), (long)Math.abs(d.shortValue()));
        Assert.assertEquals((long)rs.getByte(7), (long)Math.abs(d.byteValue()));
        Assert.assertTrue((!rs.next() ? 1 : 0) != 0);
        PreparedStatement stmt = conn.prepareStatement("SELECT k FROM " + TABLE_NAME + " WHERE ABS(\"DEC\")=? AND ABS(doub)=? AND ABS(fl)=? AND ABS(inte)=? AND ABS(lon)=? AND ABS(smalli)=? AND ABS(tinyi)=?");
        stmt.setBigDecimal(1, BigDecimal.valueOf(data).abs());
        stmt.setDouble(2, Math.abs(d));
        stmt.setFloat(3, Math.abs(d.floatValue()));
        stmt.setInt(4, Math.abs(d.intValue()));
        stmt.setLong(5, Math.abs(d.longValue()));
        stmt.setShort(6, (short)Math.abs(d.shortValue()));
        stmt.setByte(7, (byte)Math.abs(d.byteValue()));
        rs = stmt.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)KEY, (Object)rs.getString(1));
        Assert.assertTrue((!rs.next() ? 1 : 0) != 0);
    }

    @Test
    public void testSignedNumber() throws Exception {
        Connection conn = DriverManager.getConnection(AbsFunctionEnd2EndIT.getUrl());
        this.testSignedNumberSpec(conn, 0.0);
        this.testSignedNumberSpec(conn, 1.0);
        this.testSignedNumberSpec(conn, -1.0);
        this.testSignedNumberSpec(conn, 123.1234);
        this.testSignedNumberSpec(conn, -123.1234);
    }
}

