/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.RawCellBuilder;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcUtils;
import org.apache.hadoop.hbase.metrics.MetricRegistry;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.regionserver.OnlineRegions;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.coprocessor.TaskMetaDataEndpoint;
import org.apache.phoenix.coprocessor.generated.MetaDataProtos;
import org.apache.phoenix.coprocessor.generated.TaskMetaDataProtos;
import org.apache.phoenix.protobuf.ProtobufUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class TaskMetaDataEndpointTest {
    private TaskMetaDataEndpoint taskMetaDataEndpoint;
    private Configuration configuration;
    @Mock
    private Region region;
    @Mock
    private RegionInfo regionInfo;
    @Mock
    private Connection connection;
    @Mock
    private RpcController controller;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.configuration = new Configuration();
        RegionCoprocessorEnvironment environment = new RegionCoprocessorEnvironment(){

            public Region getRegion() {
                return TaskMetaDataEndpointTest.this.region;
            }

            public RegionInfo getRegionInfo() {
                return TaskMetaDataEndpointTest.this.regionInfo;
            }

            public OnlineRegions getOnlineRegions() {
                return null;
            }

            public ConcurrentMap<String, Object> getSharedData() {
                return null;
            }

            public ServerName getServerName() {
                return null;
            }

            public Connection getConnection() {
                return TaskMetaDataEndpointTest.this.connection;
            }

            public Connection createConnection(Configuration conf) {
                return null;
            }

            public MetricRegistry getMetricRegistryForRegionServer() {
                return null;
            }

            public RawCellBuilder getCellBuilder() {
                return null;
            }

            public int getVersion() {
                return 0;
            }

            public String getHBaseVersion() {
                return null;
            }

            public RegionCoprocessor getInstance() {
                return null;
            }

            public int getPriority() {
                return 0;
            }

            public int getLoadSequence() {
                return 0;
            }

            public Configuration getConfiguration() {
                return TaskMetaDataEndpointTest.this.configuration;
            }

            public ClassLoader getClassLoader() {
                return null;
            }
        };
        this.taskMetaDataEndpoint = new TaskMetaDataEndpoint();
        this.taskMetaDataEndpoint.start((CoprocessorEnvironment)environment);
    }

    @Test
    public void testUpsertTaskDetails() throws Exception {
        Put mutation = new Put(Bytes.toBytes((String)"row1"));
        TaskMetaDataProtos.TaskMutateRequest.Builder builder = TaskMetaDataProtos.TaskMutateRequest.newBuilder();
        ClientProtos.MutationProto mp = ProtobufUtil.toProto((Mutation)mutation);
        builder.addTableMetadataMutations(mp.toByteString());
        TaskMetaDataProtos.TaskMutateRequest request = builder.build();
        CoprocessorRpcUtils.BlockingRpcCallback rpcCallback = new CoprocessorRpcUtils.BlockingRpcCallback();
        ((Region)Mockito.doNothing().when((Object)this.region)).mutateRowsWithLocks(Mockito.anyCollection(), (Collection)Mockito.any(), Mockito.anyLong(), Mockito.anyLong());
        this.taskMetaDataEndpoint.upsertTaskDetails(this.controller, request, (RpcCallback)rpcCallback);
        ((Region)Mockito.verify((Object)this.region, (VerificationMode)Mockito.times((int)1))).mutateRowsWithLocks(Mockito.anyCollection(), (Collection)Mockito.any(), Mockito.anyLong(), Mockito.anyLong());
    }

    @Test
    public void testUpsertTaskDetailsFailure() throws Exception {
        Put mutation = new Put(Bytes.toBytes((String)"row2"));
        TaskMetaDataProtos.TaskMutateRequest.Builder builder = TaskMetaDataProtos.TaskMutateRequest.newBuilder();
        ClientProtos.MutationProto mp = ProtobufUtil.toProto((Mutation)mutation);
        builder.addTableMetadataMutations(mp.toByteString());
        TaskMetaDataProtos.TaskMutateRequest request = builder.build();
        CoprocessorRpcUtils.BlockingRpcCallback rpcCallback = new CoprocessorRpcUtils.BlockingRpcCallback();
        ((Region)Mockito.doThrow(IOException.class).when((Object)this.region)).mutateRowsWithLocks(Mockito.anyCollection(), (Collection)Mockito.any(), Mockito.anyLong(), Mockito.anyLong());
        this.taskMetaDataEndpoint.upsertTaskDetails(this.controller, request, (RpcCallback)rpcCallback);
        ((Region)Mockito.verify((Object)this.region, (VerificationMode)Mockito.times((int)1))).mutateRowsWithLocks(Mockito.anyCollection(), (Collection)Mockito.any(), Mockito.anyLong(), Mockito.anyLong());
        Assert.assertEquals((Object)MetaDataProtos.MutationCode.UNABLE_TO_UPSERT_TASK, (Object)((MetaDataProtos.MetaDataResponse)rpcCallback.get()).getReturnCode());
    }
}

