/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.query.BaseConnectionlessQueryTest;
import org.apache.phoenix.util.DateUtil;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.QueryUtil;
import org.junit.Assert;
import org.junit.Test;

public class TenantSpecificViewIndexCompileTest
extends BaseConnectionlessQueryTest {
    @Test
    public void testOrderByOptimizedOut() throws Exception {
        Properties props = new Properties();
        Connection conn = DriverManager.getConnection(TenantSpecificViewIndexCompileTest.getUrl());
        conn.createStatement().execute("CREATE TABLE t(t_id VARCHAR NOT NULL, k1 VARCHAR, k2 VARCHAR, v1 VARCHAR, CONSTRAINT pk PRIMARY KEY(t_id, k1, k2)) multi_tenant=true");
        String tenantId = "me";
        props.setProperty("TenantId", tenantId);
        conn = DriverManager.getConnection(TenantSpecificViewIndexCompileTest.getUrl(), props);
        conn.createStatement().execute("CREATE VIEW v(v2 VARCHAR) AS SELECT * FROM t WHERE k1 = 'a'");
        conn.createStatement().execute("CREATE INDEX i1 ON v(v2) INCLUDE(v1)");
        ResultSet rs = conn.createStatement().executeQuery("EXPLAIN SELECT v1,v2 FROM v WHERE v2 > 'a' ORDER BY v2");
        Assert.assertEquals((Object)"CLIENT PARALLEL 1-WAY RANGE SCAN OVER _IDX_T [-9223372036854775808,'me','a'] - [-9223372036854775808,'me',*]", (Object)QueryUtil.getExplainPlan((ResultSet)rs));
    }

    @Test
    public void testOrderByOptimizedOutWithoutPredicateInView() throws Exception {
        Connection conn = DriverManager.getConnection(TenantSpecificViewIndexCompileTest.getUrl());
        conn.createStatement().execute("CREATE TABLE t(t_id CHAR(15) NOT NULL, k1 CHAR(3) NOT NULL, k2 CHAR(15) NOT NULL, k3 DATE NOT NULL, v1 VARCHAR, CONSTRAINT pk PRIMARY KEY(t_id, k1, k2, k3)) multi_tenant=true");
        conn.createStatement().execute("CREATE VIEW v1  AS SELECT * FROM t");
        conn = this.createTenantSpecificConnection();
        Object sql = "SELECT * FROM v1 ORDER BY k1, k2, k3";
        String expectedExplainOutput = "CLIENT PARALLEL 1-WAY RANGE SCAN OVER T ['tenant123456789']";
        this.assertExplainPlanIsCorrect(conn, (String)sql, expectedExplainOutput);
        this.assertOrderByHasBeenOptimizedOut(conn, (String)sql);
        sql = "SELECT * FROM v1 WHERE k1 = 'xyz' ORDER BY k1, k2, k3";
        expectedExplainOutput = "CLIENT PARALLEL 1-WAY RANGE SCAN OVER T ['tenant123456789','xyz']";
        this.assertExplainPlanIsCorrect(conn, (String)sql, expectedExplainOutput);
        this.assertOrderByHasBeenOptimizedOut(conn, (String)sql);
        sql = "SELECT * FROM v1 WHERE k1 > 'xyz' ORDER BY k1, k2, k3";
        expectedExplainOutput = "CLIENT PARALLEL 1-WAY RANGE SCAN OVER T ['tenant123456789','xy{'] - ['tenant123456789',*]";
        this.assertExplainPlanIsCorrect(conn, (String)sql, expectedExplainOutput);
        this.assertOrderByHasBeenOptimizedOut(conn, (String)sql);
        String datePredicate = this.createStaticDate();
        sql = "SELECT * FROM v1 WHERE k1 = 'xyz' AND k2 = '123456789012345' AND k3 < TO_DATE('" + datePredicate + "') ORDER BY k1, k2, k3";
        expectedExplainOutput = "CLIENT PARALLEL 1-WAY RANGE SCAN OVER T ['tenant123456789','xyz','123456789012345',*] - ['tenant123456789','xyz','123456789012345','2015-01-01 08:00:00.000']";
        this.assertExplainPlanIsCorrect(conn, (String)sql, expectedExplainOutput);
        this.assertOrderByHasBeenOptimizedOut(conn, (String)sql);
        sql = "SELECT * FROM v1 WHERE k2 < 'abcde1234567890' ORDER BY k1, k2, k3";
        expectedExplainOutput = "CLIENT PARALLEL 1-WAY RANGE SCAN OVER T ['tenant123456789']\n    SERVER FILTER BY K2 < 'abcde1234567890'";
        this.assertExplainPlanIsCorrect(conn, (String)sql, expectedExplainOutput);
        this.assertOrderByHasBeenOptimizedOut(conn, (String)sql);
    }

    @Test
    public void testOrderByOptimizedOutWithPredicateInView() throws Exception {
        Connection conn = DriverManager.getConnection(TenantSpecificViewIndexCompileTest.getUrl());
        conn.createStatement().execute("CREATE TABLE t(t_id CHAR(15) NOT NULL, k1 CHAR(3) NOT NULL, k2 CHAR(15) NOT NULL, k3 DATE NOT NULL, v1 VARCHAR, CONSTRAINT pk PRIMARY KEY(t_id, k1, k2, k3)) multi_tenant=true");
        conn.createStatement().execute("CREATE VIEW v1  AS SELECT * FROM t WHERE k1 = 'xyz'");
        conn = this.createTenantSpecificConnection();
        Object sql = "SELECT * FROM v1 ORDER BY k2, k3";
        Object expectedExplainOutput = "CLIENT PARALLEL 1-WAY RANGE SCAN OVER T ['tenant123456789','xyz']";
        this.assertExplainPlanIsCorrect(conn, (String)sql, (String)expectedExplainOutput);
        this.assertOrderByHasBeenOptimizedOut(conn, (String)sql);
        sql = "SELECT * FROM v1 ORDER BY k2, k3";
        expectedExplainOutput = "CLIENT PARALLEL 1-WAY RANGE SCAN OVER T ['tenant123456789','xyz']";
        this.assertExplainPlanIsCorrect(conn, (String)sql, (String)expectedExplainOutput);
        this.assertOrderByHasBeenOptimizedOut(conn, (String)sql);
        sql = "SELECT * FROM v1 WHERE k1 = 'xyz' ORDER BY k2, k3";
        expectedExplainOutput = "CLIENT PARALLEL 1-WAY RANGE SCAN OVER T ['tenant123456789','xyz']";
        this.assertExplainPlanIsCorrect(conn, (String)sql, (String)expectedExplainOutput);
        this.assertOrderByHasBeenOptimizedOut(conn, (String)sql);
        sql = "SELECT * FROM v1 WHERE k2 < 'abcde1234567890' ORDER BY k2, k3";
        expectedExplainOutput = "CLIENT PARALLEL 1-WAY RANGE SCAN OVER T ['tenant123456789','xyz',*] - ['tenant123456789','xyz','abcde1234567890']";
        this.assertExplainPlanIsCorrect(conn, (String)sql, (String)expectedExplainOutput);
        this.assertOrderByHasBeenOptimizedOut(conn, (String)sql);
        String datePredicate = this.createStaticDate();
        sql = "SELECT * FROM v1 WHERE k2 = '123456789012345' AND k3 < TO_DATE('" + datePredicate + "') ORDER BY k2, k3";
        expectedExplainOutput = "CLIENT PARALLEL 1-WAY RANGE SCAN OVER T ['tenant123456789','xyz','123456789012345',*] - ['tenant123456789','xyz','123456789012345','2015-01-01 08:00:00.000']";
        this.assertExplainPlanIsCorrect(conn, (String)sql, (String)expectedExplainOutput);
        this.assertOrderByHasBeenOptimizedOut(conn, (String)sql);
        sql = "SELECT * FROM v1 WHERE k3 < TO_DATE('" + datePredicate + "') ORDER BY k2, k3";
        expectedExplainOutput = "CLIENT PARALLEL 1-WAY RANGE SCAN OVER T ['tenant123456789','xyz']\n    SERVER FILTER BY K3 < DATE '" + datePredicate + "'";
        this.assertExplainPlanIsCorrect(conn, (String)sql, (String)expectedExplainOutput);
        this.assertOrderByHasBeenOptimizedOut(conn, (String)sql);
    }

    @Test
    public void testOrderByOptimizedOutWithMultiplePredicatesInView() throws Exception {
        Connection conn = DriverManager.getConnection(TenantSpecificViewIndexCompileTest.getUrl());
        conn.createStatement().execute("CREATE TABLE t(t_id CHAR(15) NOT NULL, k1 CHAR(3) NOT NULL, k2 CHAR(5) NOT NULL, k3 DATE NOT NULL, v1 VARCHAR, CONSTRAINT pk PRIMARY KEY(t_id, k1, k2, k3 DESC)) multi_tenant=true");
        conn.createStatement().execute("CREATE VIEW v1  AS SELECT * FROM t WHERE k1 = 'xyz' AND k2='abcde'");
        conn = this.createTenantSpecificConnection();
        Object sql = "SELECT * FROM v1 ORDER BY k3 DESC";
        String expectedExplainOutput = "CLIENT PARALLEL 1-WAY RANGE SCAN OVER T ['tenant123456789','xyz','abcde']";
        this.assertExplainPlanIsCorrect(conn, (String)sql, expectedExplainOutput);
        this.assertOrderByHasBeenOptimizedOut(conn, (String)sql);
        sql = "SELECT * FROM v1 ORDER BY k3 DESC";
        expectedExplainOutput = "CLIENT PARALLEL 1-WAY RANGE SCAN OVER T ['tenant123456789','xyz','abcde']";
        this.assertExplainPlanIsCorrect(conn, (String)sql, expectedExplainOutput);
        this.assertOrderByHasBeenOptimizedOut(conn, (String)sql);
        sql = "SELECT * FROM v1 WHERE k3 <= TO_DATE('" + this.createStaticDate() + "') ORDER BY k3 DESC";
        expectedExplainOutput = "CLIENT PARALLEL 1-WAY RANGE SCAN OVER T ['tenant123456789','xyz','abcde',~'2015-01-01 08:00:00.000'] - ['tenant123456789','xyz','abcde',*]";
        this.assertExplainPlanIsCorrect(conn, (String)sql, expectedExplainOutput);
        this.assertOrderByHasBeenOptimizedOut(conn, (String)sql);
        sql = "SELECT * FROM v1 WHERE k3 <= TO_DATE('" + this.createStaticDate() + "') ORDER BY k3";
        expectedExplainOutput = "CLIENT PARALLEL 1-WAY REVERSE RANGE SCAN OVER T ['tenant123456789','xyz','abcde',~'2015-01-01 08:00:00.000'] - ['tenant123456789','xyz','abcde',*]";
        this.assertExplainPlanIsCorrect(conn, (String)sql, expectedExplainOutput);
        this.assertOrderByHasBeenOptimizedOut(conn, (String)sql);
    }

    @Test
    public void testViewConstantsOptimizedOut() throws Exception {
        Properties props = new Properties();
        Connection conn = DriverManager.getConnection(TenantSpecificViewIndexCompileTest.getUrl());
        conn.createStatement().execute("CREATE TABLE t(t_id VARCHAR NOT NULL, k1 VARCHAR, k2 VARCHAR, v1 VARCHAR, CONSTRAINT pk PRIMARY KEY(t_id, k1, k2)) multi_tenant=true");
        String tenantId = "me";
        props.setProperty("TenantId", tenantId);
        conn = DriverManager.getConnection(TenantSpecificViewIndexCompileTest.getUrl(), props);
        conn.createStatement().execute("CREATE VIEW v(v2 VARCHAR) AS SELECT * FROM t WHERE k2 = 'a'");
        conn.createStatement().execute("CREATE INDEX i1 ON v(v2)");
        ResultSet rs = conn.createStatement().executeQuery("EXPLAIN SELECT v2 FROM v WHERE v2 > 'a' and k2 = 'a' ORDER BY v2,k2");
        Assert.assertEquals((Object)"CLIENT PARALLEL 1-WAY RANGE SCAN OVER _IDX_T [-9223372036854775808,'me','a'] - [-9223372036854775808,'me',*]\n    SERVER FILTER BY FIRST KEY ONLY", (Object)QueryUtil.getExplainPlan((ResultSet)rs));
        rs = conn.createStatement().executeQuery("EXPLAIN SELECT v1 FROM v WHERE v2 > 'a' ORDER BY k2");
        Assert.assertEquals((Object)"CLIENT PARALLEL 1-WAY RANGE SCAN OVER T ['me']\n    SERVER FILTER BY (V2 > 'a' AND K2 = 'a')", (Object)QueryUtil.getExplainPlan((ResultSet)rs));
        rs = conn.createStatement().executeQuery("EXPLAIN SELECT v1 FROM v WHERE v2 > 'a' and k2='b' ORDER BY k2");
        Assert.assertEquals((Object)"DEGENERATE SCAN OVER V", (Object)QueryUtil.getExplainPlan((ResultSet)rs));
    }

    @Test
    public void testViewConstantsOptimizedOutOnReadOnlyView() throws Exception {
        Properties props = new Properties();
        Connection conn = DriverManager.getConnection(TenantSpecificViewIndexCompileTest.getUrl());
        conn.createStatement().execute("CREATE TABLE t(t_id VARCHAR NOT NULL, k1 VARCHAR, k2 VARCHAR, v1 VARCHAR, CONSTRAINT pk PRIMARY KEY(t_id, k1, k2)) multi_tenant=true");
        String tenantId = "me";
        props.setProperty("TenantId", tenantId);
        conn = DriverManager.getConnection(TenantSpecificViewIndexCompileTest.getUrl(), props);
        conn.createStatement().execute("CREATE VIEW v(v2 VARCHAR) AS SELECT * FROM t WHERE k2 = 'a'");
        conn.createStatement().execute("CREATE VIEW v2(v3 VARCHAR) AS SELECT * FROM v WHERE k1 > 'a'");
        conn.createStatement().execute("CREATE INDEX i2 ON v2(v3) include(v2)");
        ResultSet rs = conn.createStatement().executeQuery("EXPLAIN SELECT v2 FROM v2 WHERE v3 > 'a' and k2 = 'a' ORDER BY v3,k2");
        Assert.assertEquals((Object)"CLIENT PARALLEL 1-WAY RANGE SCAN OVER _IDX_T [-9223372036854775808,'me','a'] - [-9223372036854775808,'me',*]", (Object)QueryUtil.getExplainPlan((ResultSet)rs));
    }

    private Connection createTenantSpecificConnection() throws SQLException {
        Properties props = new Properties();
        String tenantId = "tenant123456789";
        props.setProperty("TenantId", tenantId);
        Connection conn = DriverManager.getConnection(TenantSpecificViewIndexCompileTest.getUrl(), props);
        return conn;
    }

    private void assertExplainPlanIsCorrect(Connection conn, String sql, String expectedExplainOutput) throws SQLException {
        ResultSet rs = conn.createStatement().executeQuery("EXPLAIN " + sql);
        Assert.assertEquals((Object)expectedExplainOutput, (Object)QueryUtil.getExplainPlan((ResultSet)rs));
    }

    private void assertOrderByHasBeenOptimizedOut(Connection conn, String sql) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(sql);
        QueryPlan plan = PhoenixRuntime.getOptimizedQueryPlan((PreparedStatement)stmt);
        Assert.assertEquals((long)0L, (long)plan.getOrderBy().getOrderByExpressions().size());
    }

    private String createStaticDate() {
        Calendar cal = Calendar.getInstance();
        cal.set(6, 1);
        cal.set(1, 2015);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.setTimeZone(TimeZone.getTimeZone("America/Los_Angeles"));
        return DateUtil.DEFAULT_DATE_FORMATTER.format(cal.getTime());
    }
}

