/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.filter.SkipScanFilter;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixPreparedStatement;
import org.apache.phoenix.query.BaseConnectionlessQueryTest;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;

public class StatementHintsCompilationTest
extends BaseConnectionlessQueryTest {
    private static boolean usingSkipScan(Scan scan) {
        Filter filter = scan.getFilter();
        if (filter instanceof FilterList) {
            FilterList filterList = (FilterList)filter;
            for (Filter childFilter : filterList.getFilters()) {
                if (!(childFilter instanceof SkipScanFilter)) continue;
                return true;
            }
            return false;
        }
        return filter instanceof SkipScanFilter;
    }

    private static QueryPlan compileStatement(String query) throws SQLException {
        return StatementHintsCompilationTest.compileStatement(query, Collections.emptyList(), null);
    }

    private static QueryPlan compileStatement(String query, List<Object> binds, Integer limit) throws SQLException {
        PhoenixConnection pconn = DriverManager.getConnection(StatementHintsCompilationTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES)).unwrap(PhoenixConnection.class);
        PhoenixPreparedStatement pstmt = new PhoenixPreparedStatement(pconn, query);
        TestUtil.bindParams(pstmt, binds);
        QueryPlan plan = pstmt.compileQuery();
        Assert.assertEquals((Object)limit, (Object)plan.getLimit());
        return plan;
    }

    @Test
    public void testSelectForceSkipScan() throws Exception {
        String id = "000000000000001";
        String query = "SELECT /*+ SKIP_SCAN */ * FROM atable WHERE entity_id='" + id + "'";
        Scan scan = StatementHintsCompilationTest.compileStatement(query).getContext().getScan();
        Assert.assertTrue((String)"The first filter should be SkipScanFilter.", (boolean)StatementHintsCompilationTest.usingSkipScan(scan));
    }

    @Test
    public void testSelectForceRangeScan() throws Exception {
        String query = "SELECT /*+ RANGE_SCAN */ * FROM atable WHERE organization_id in ('000000000000001', '000000000000002', '000000000000003', '000000000000004')";
        Scan scan = StatementHintsCompilationTest.compileStatement(query).getContext().getScan();
        Assert.assertFalse((String)"The first filter should not be SkipScanFilter.", (boolean)StatementHintsCompilationTest.usingSkipScan(scan));
    }

    @Test
    public void testSelectForceRangeScanForEH() throws Exception {
        Connection conn = DriverManager.getConnection(StatementHintsCompilationTest.getUrl());
        conn.createStatement().execute("create table eh (organization_id char(15) not null,parent_id char(15) not null, created_date date not null, entity_history_id char(15) not null constraint pk primary key (organization_id, parent_id, created_date, entity_history_id))");
        ResultSet rs = conn.createStatement().executeQuery("explain select /*+ RANGE_SCAN */ ORGANIZATION_ID, PARENT_ID, CREATED_DATE, ENTITY_HISTORY_ID from eh where ORGANIZATION_ID='111111111111111' and SUBSTR(PARENT_ID, 1, 3) = 'foo' and CREATED_DATE >= TO_DATE ('2012-11-01 00:00:00') and CREATED_DATE < TO_DATE ('2012-11-30 00:00:00') order by ORGANIZATION_ID, PARENT_ID, CREATED_DATE DESC, ENTITY_HISTORY_ID limit 100");
        Assert.assertEquals((Object)"CLIENT PARALLEL 1-WAY RANGE SCAN OVER EH ['111111111111111','foo            ','2012-11-01 00:00:00.000'] - ['111111111111111','fop            ','2012-11-30 00:00:00.000']\n    SERVER FILTER BY FIRST KEY ONLY AND (CREATED_DATE >= DATE '2012-11-01 00:00:00.000' AND CREATED_DATE < DATE '2012-11-30 00:00:00.000')\n    SERVER TOP 100 ROWS SORTED BY [ORGANIZATION_ID, PARENT_ID, CREATED_DATE DESC, ENTITY_HISTORY_ID]\nCLIENT MERGE SORT\nCLIENT LIMIT 100", (Object)QueryUtil.getExplainPlan((ResultSet)rs));
    }

    @Test
    public void testSerialHint() throws Exception {
        String query = "SELECT /*+ SERIAL */ COUNT(*) FROM atable";
        Assert.assertTrue((String)"Expected a SERIAL query", (boolean)((String)StatementHintsCompilationTest.compileStatement(query).getExplainPlan().getPlanSteps().get(0)).contains("SERIAL"));
        query = "SELECT /*+ SERIAL */ * FROM atable limit 10";
        Assert.assertTrue((String)"Expected a SERIAL query", (boolean)((String)StatementHintsCompilationTest.compileStatement(query, Collections.emptyList(), 10).getExplainPlan().getPlanSteps().get(0)).contains("SERIAL"));
    }
}

