/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.phoenix.compile.ScanRanges;
import org.apache.phoenix.filter.SkipScanFilter;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Test;

public class ScanRangesIntersectTest {
    @Test
    public void testPointLookupIntersect() throws Exception {
        List<KeyRange> keys = ScanRangesIntersectTest.points("a", "j", "m", "z");
        ScanRanges ranges = ScanRanges.createPointLookup(keys);
        ScanRangesIntersectTest.assertIntersect(ranges, "b", "l", "j");
    }

    private static void assertIntersect(ScanRanges ranges, String lowerRange, String upperRange, String ... expectedPoints) {
        List<KeyRange> expectedKeys = ScanRangesIntersectTest.points(expectedPoints);
        Collections.sort(expectedKeys, KeyRange.COMPARATOR);
        Scan scan = new Scan();
        scan.setFilter((Filter)ranges.getSkipScanFilter());
        byte[] startKey = lowerRange == null ? KeyRange.UNBOUND : PVarchar.INSTANCE.toBytes((Object)lowerRange);
        byte[] stopKey = upperRange == null ? KeyRange.UNBOUND : PVarchar.INSTANCE.toBytes((Object)upperRange);
        Scan newScan = ranges.intersectScan(scan, startKey, stopKey, 0, true);
        if (expectedPoints.length == 0) {
            Assert.assertNull((Object)newScan);
        } else {
            Assert.assertNotNull((Object)newScan);
            SkipScanFilter filter = (SkipScanFilter)newScan.getFilter();
            Assert.assertEquals(expectedKeys, filter.getSlots().get(0));
        }
    }

    private static List<KeyRange> points(String ... points) {
        ArrayList keys = Lists.newArrayListWithExpectedSize((int)points.length);
        for (String point : points) {
            keys.add(KeyRange.getKeyRange((byte[])PVarchar.INSTANCE.toBytes((Object)point)));
        }
        return keys;
    }
}

