/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.util.Properties;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixPreparedStatement;
import org.apache.phoenix.query.BaseConnectionlessQueryTest;
import org.junit.Assert;
import org.junit.Test;

public class ScanBoundaryFunctionTest
extends BaseConnectionlessQueryTest {
    @Test
    public void testScanStartKeyWithLiteral() throws Exception {
        Properties props = new Properties();
        PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(ScanBoundaryFunctionTest.getUrl(), props);
        String sql = "SELECT * FROM SYSTEM.CATALOG WHERE SCAN_START_KEY() = ?";
        PreparedStatement stmt = conn.prepareStatement(sql);
        stmt.setBytes(1, Bytes.toBytes((String)"startkey"));
        PhoenixPreparedStatement pstmt = stmt.unwrap(PhoenixPreparedStatement.class);
        QueryPlan plan = pstmt.optimizeQuery(sql);
        Scan scan = plan.getContext().getScan();
        Assert.assertNotNull((Object)scan.getStartRow());
        Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"startkey"), (byte[])scan.getStartRow());
    }

    @Test
    public void testScanEndKeyWithLiteral() throws Exception {
        Properties props = new Properties();
        PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(ScanBoundaryFunctionTest.getUrl(), props);
        String sql = "SELECT * FROM SYSTEM.CATALOG WHERE SCAN_END_KEY() = ?";
        PreparedStatement stmt = conn.prepareStatement(sql);
        stmt.setBytes(1, Bytes.toBytes((String)"endkey"));
        PhoenixPreparedStatement pstmt = stmt.unwrap(PhoenixPreparedStatement.class);
        QueryPlan plan = pstmt.optimizeQuery(sql);
        Scan scan = plan.getContext().getScan();
        Assert.assertNotNull((Object)scan.getStopRow());
        Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"endkey"), (byte[])scan.getStopRow());
    }

    @Test
    public void testScanBothKeysWithLiterals() throws Exception {
        Properties props = new Properties();
        PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(ScanBoundaryFunctionTest.getUrl(), props);
        String sql = "SELECT * FROM SYSTEM.CATALOG WHERE SCAN_START_KEY() = ? AND SCAN_END_KEY() = ?";
        PreparedStatement stmt = conn.prepareStatement(sql);
        stmt.setBytes(1, Bytes.toBytes((String)"statz--__39gf04i583130~305i-4"));
        stmt.setBytes(2, Bytes.toBytes((String)"##__39gf04i583130~305i-end-4"));
        PhoenixPreparedStatement pstmt = stmt.unwrap(PhoenixPreparedStatement.class);
        QueryPlan plan = pstmt.optimizeQuery(sql);
        Scan scan = plan.getContext().getScan();
        Assert.assertNotNull((Object)scan.getStartRow());
        Assert.assertNotNull((Object)scan.getStopRow());
        Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"statz--__39gf04i583130~305i-4"), (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"##__39gf04i583130~305i-end-4"), (byte[])scan.getStopRow());
    }

    @Test
    public void testScanStartKeyWithBindParameter() throws Exception {
        Properties props = new Properties();
        PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(ScanBoundaryFunctionTest.getUrl(), props);
        String sql = "SELECT * FROM SYSTEM.CATALOG WHERE SCAN_START_KEY() = ?";
        PreparedStatement stmt = conn.prepareStatement(sql);
        stmt.setBytes(1, Bytes.toBytes((String)"bindstart"));
        PhoenixPreparedStatement pstmt = stmt.unwrap(PhoenixPreparedStatement.class);
        QueryPlan plan = pstmt.optimizeQuery(sql);
        Scan scan = plan.getContext().getScan();
        Assert.assertNotNull((Object)scan.getStartRow());
        Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"bindstart"), (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])new byte[0], (byte[])scan.getStopRow());
    }

    @Test
    public void testScanStartKeyWithBindParameter2() throws Exception {
        Properties props = new Properties();
        PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(ScanBoundaryFunctionTest.getUrl(), props);
        String sql = "SELECT * FROM SYSTEM.CATALOG WHERE SCAN_START_KEY() = ? AND SCAN_END_KEY() = ?";
        PreparedStatement stmt = conn.prepareStatement(sql);
        stmt.setBytes(1, Bytes.toBytes((String)"bindstart"));
        stmt.setBytes(2, null);
        PhoenixPreparedStatement pstmt = stmt.unwrap(PhoenixPreparedStatement.class);
        QueryPlan plan = pstmt.optimizeQuery(sql);
        Scan scan = plan.getContext().getScan();
        Assert.assertNotNull((Object)scan.getStartRow());
        Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"bindstart"), (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])new byte[0], (byte[])scan.getStopRow());
    }

    @Test
    public void testScanEndKeyWithBindParameter() throws Exception {
        Properties props = new Properties();
        PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(ScanBoundaryFunctionTest.getUrl(), props);
        String sql = "SELECT * FROM SYSTEM.CATALOG WHERE SCAN_END_KEY() = ?";
        PreparedStatement stmt = conn.prepareStatement(sql);
        stmt.setBytes(1, Bytes.toBytes((String)"bindend"));
        PhoenixPreparedStatement pstmt = stmt.unwrap(PhoenixPreparedStatement.class);
        QueryPlan plan = pstmt.optimizeQuery(sql);
        Scan scan = plan.getContext().getScan();
        Assert.assertNotNull((Object)scan.getStopRow());
        Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"bindend"), (byte[])scan.getStopRow());
        Assert.assertArrayEquals((byte[])new byte[0], (byte[])scan.getStartRow());
    }

    @Test
    public void testScanEndKeyWithBindParameter2() throws Exception {
        Properties props = new Properties();
        PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(ScanBoundaryFunctionTest.getUrl(), props);
        String sql = "SELECT * FROM SYSTEM.CATALOG WHERE SCAN_START_KEY() = ? AND SCAN_END_KEY() = ?";
        PreparedStatement stmt = conn.prepareStatement(sql);
        stmt.setBytes(1, new byte[0]);
        stmt.setBytes(2, Bytes.toBytes((String)"bindend"));
        PhoenixPreparedStatement pstmt = stmt.unwrap(PhoenixPreparedStatement.class);
        QueryPlan plan = pstmt.optimizeQuery(sql);
        Scan scan = plan.getContext().getScan();
        Assert.assertNotNull((Object)scan.getStopRow());
        Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"bindend"), (byte[])scan.getStopRow());
        Assert.assertArrayEquals((byte[])new byte[0], (byte[])scan.getStartRow());
    }

    @Test
    public void testScanBothKeysWithBindParameters() throws Exception {
        Properties props = new Properties();
        PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(ScanBoundaryFunctionTest.getUrl(), props);
        String sql = "SELECT * FROM SYSTEM.CATALOG WHERE SCAN_START_KEY() = ? AND SCAN_END_KEY() = ?";
        PreparedStatement stmt = conn.prepareStatement(sql);
        stmt.setBytes(1, Bytes.toBytes((String)"bindstart"));
        stmt.setBytes(2, Bytes.toBytes((String)"bindend"));
        PhoenixPreparedStatement pstmt = stmt.unwrap(PhoenixPreparedStatement.class);
        QueryPlan plan = pstmt.optimizeQuery(sql);
        Scan scan = plan.getContext().getScan();
        Assert.assertNotNull((Object)scan.getStartRow());
        Assert.assertNotNull((Object)scan.getStopRow());
        Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"bindstart"), (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"bindend"), (byte[])scan.getStopRow());
    }

    @Test
    public void testScanWithRegularWhereAndBoundary() throws Exception {
        Properties props = new Properties();
        PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(ScanBoundaryFunctionTest.getUrl(), props);
        String sql = "SELECT * FROM SYSTEM.CATALOG WHERE TABLE_NAME = 'TEST' AND SCAN_END_KEY() = ?";
        PreparedStatement stmt = conn.prepareStatement(sql);
        stmt.setBytes(1, Bytes.toBytes((String)"boundary"));
        PhoenixPreparedStatement pstmt = stmt.unwrap(PhoenixPreparedStatement.class);
        QueryPlan plan = pstmt.optimizeQuery(sql);
        Scan scan = plan.getContext().getScan();
        Assert.assertNotNull((Object)scan.getStopRow());
        Assert.assertNotNull((Object)scan.getStartRow());
        Assert.assertArrayEquals((byte[])Bytes.toBytesBinary((String)"\\x00\\x00TEST"), (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"boundary"), (byte[])scan.getStopRow());
        sql = "SELECT * FROM SYSTEM.CATALOG WHERE TABLE_NAME = 'TEST' AND SCAN_START_KEY() = ? AND SCAN_END_KEY() = ?";
        stmt = conn.prepareStatement(sql);
        stmt.setBytes(1, Bytes.toBytes((String)"boundary"));
        stmt.setBytes(2, Bytes.toBytes((String)"boundary"));
        pstmt = stmt.unwrap(PhoenixPreparedStatement.class);
        plan = pstmt.optimizeQuery(sql);
        scan = plan.getContext().getScan();
        Assert.assertNotNull((Object)scan.getStopRow());
        Assert.assertNotNull((Object)scan.getStartRow());
        Assert.assertArrayEquals((byte[])Bytes.toBytesBinary((String)"\\x00\\x00TEST"), (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"boundary"), (byte[])scan.getStopRow());
    }
}

