/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.compile.ScanRanges;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.schema.PDatum;
import org.apache.phoenix.schema.RowKeySchema;
import org.apache.phoenix.schema.SaltingUtil;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PChar;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.thirdparty.com.google.common.base.Function;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.ByteUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SaltedScanRangesTest {
    private static Integer nBuckets = 3;
    private final ScanRanges scanRanges;
    private final KeyRange keyRange;
    private final boolean expectedResult;
    private static final Function<KeyRange[], List<KeyRange>> ARRAY_TO_LIST = new Function<KeyRange[], List<KeyRange>>(){

        public List<KeyRange> apply(KeyRange[] input) {
            return Lists.newArrayList((Object[])input);
        }
    };

    public SaltedScanRangesTest(ScanRanges scanRanges, int[] widths, KeyRange keyRange, boolean expectedResult) {
        this.keyRange = keyRange;
        this.scanRanges = scanRanges;
        this.expectedResult = expectedResult;
    }

    @Test
    public void test() {
        byte[] lowerInclusiveKey = this.keyRange.getLowerRange();
        if (!this.keyRange.isLowerInclusive() && !Bytes.equals((byte[])lowerInclusiveKey, (byte[])KeyRange.UNBOUND)) {
            lowerInclusiveKey = ByteUtil.nextKey((byte[])lowerInclusiveKey);
        }
        byte[] upperExclusiveKey = this.keyRange.getUpperRange();
        if (this.keyRange.isUpperInclusive()) {
            upperExclusiveKey = ByteUtil.nextKey((byte[])upperExclusiveKey);
        }
        Assert.assertEquals((Object)this.expectedResult, (Object)this.scanRanges.intersectRegion(lowerInclusiveKey, upperExclusiveKey, false));
    }

    @Parameterized.Parameters(name="{0} {2}")
    public static synchronized Collection<Object> data() {
        ArrayList testCases = Lists.newArrayList();
        testCases.addAll(SaltedScanRangesTest.foreach(new KeyRange[][]{{PVarchar.INSTANCE.getKeyRange(Bytes.toBytes((String)"c"), true, Bytes.toBytes((String)"e"), false, SortOrder.ASC)}}, new int[]{0}, KeyRange.getKeyRange((byte[])KeyRange.UNBOUND, (byte[])new byte[]{1}), false, true));
        testCases.addAll(SaltedScanRangesTest.foreach(new KeyRange[][]{{PVarchar.INSTANCE.getKeyRange(Bytes.toBytes((String)"c"), true, Bytes.toBytes((String)"e"), false, SortOrder.ASC)}}, new int[]{0}, KeyRange.getKeyRange((byte[])new byte[]{1}, (byte[])new byte[]{2}), false, true));
        testCases.addAll(SaltedScanRangesTest.foreach(new KeyRange[][]{{PVarchar.INSTANCE.getKeyRange(Bytes.toBytes((String)"c"), true, Bytes.toBytes((String)"e"), false, SortOrder.ASC)}}, new int[]{0}, KeyRange.getKeyRange((byte[])new byte[]{2}, (byte[])KeyRange.UNBOUND), false, true));
        testCases.addAll(SaltedScanRangesTest.foreach(new KeyRange[][]{{PVarchar.INSTANCE.getKeyRange(Bytes.toBytes((String)"c"), true, Bytes.toBytes((String)"e"), false, SortOrder.ASC)}}, new int[]{0}, KeyRange.getKeyRange((byte[])new byte[]{1}, (byte[])ByteUtil.concat((byte[])new byte[]{1}, (byte[][])new byte[][]{Bytes.toBytes((String)"c")})), false, false));
        testCases.addAll(SaltedScanRangesTest.foreach(new KeyRange[][]{{PVarchar.INSTANCE.getKeyRange(Bytes.toBytes((String)"c"), true, Bytes.toBytes((String)"e"), false, SortOrder.ASC)}}, new int[]{0}, KeyRange.getKeyRange((byte[])ByteUtil.concat((byte[])new byte[]{1}, (byte[][])new byte[][]{Bytes.toBytes((String)"e")}), (byte[])new byte[]{2}), false, false));
        testCases.addAll(SaltedScanRangesTest.foreach(new KeyRange[][]{{PVarchar.INSTANCE.getKeyRange(Bytes.toBytes((String)"c"), true, Bytes.toBytes((String)"e"), false, SortOrder.ASC)}}, new int[]{0}, KeyRange.getKeyRange((byte[])ByteUtil.concat((byte[])new byte[]{1}, (byte[][])new byte[][]{Bytes.toBytes((String)"d")}), (byte[])new byte[]{2}), false, true));
        testCases.addAll(SaltedScanRangesTest.foreach(new KeyRange[][]{{PVarchar.INSTANCE.getKeyRange(Bytes.toBytes((String)"c"), true, Bytes.toBytes((String)"e"), false, SortOrder.ASC), PVarchar.INSTANCE.getKeyRange(Bytes.toBytes((String)"h"), true, Bytes.toBytes((String)"i"), false, SortOrder.ASC), PVarchar.INSTANCE.getKeyRange(Bytes.toBytes((String)"m"), true, Bytes.toBytes((String)"p"), false, SortOrder.ASC)}}, new int[]{0}, KeyRange.getKeyRange((byte[])ByteUtil.concat((byte[])new byte[]{1}, (byte[][])new byte[][]{Bytes.toBytes((String)"f")}), (byte[])ByteUtil.concat((byte[])new byte[]{1}, (byte[][])new byte[][]{Bytes.toBytes((String)"g")})), false, true));
        testCases.addAll(SaltedScanRangesTest.foreach(new KeyRange[][]{{PVarchar.INSTANCE.getKeyRange(Bytes.toBytes((String)"c"), true, Bytes.toBytes((String)"e"), false, SortOrder.ASC), PVarchar.INSTANCE.getKeyRange(Bytes.toBytes((String)"h"), true, Bytes.toBytes((String)"i"), false, SortOrder.ASC), PVarchar.INSTANCE.getKeyRange(Bytes.toBytes((String)"m"), true, Bytes.toBytes((String)"p"), false, SortOrder.ASC)}}, new int[]{0}, KeyRange.getKeyRange((byte[])ByteUtil.concat((byte[])new byte[]{1}, (byte[][])new byte[][]{Bytes.toBytes((String)"f")}), (byte[])ByteUtil.concat((byte[])new byte[]{1}, (byte[][])new byte[][]{Bytes.toBytes((String)"g")})), true, false));
        testCases.addAll(SaltedScanRangesTest.foreach(new KeyRange[][]{{PVarchar.INSTANCE.getKeyRange(Bytes.toBytes((String)"c"), true, KeyRange.UNBOUND, false, SortOrder.ASC)}}, new int[]{1}, KeyRange.getKeyRange((byte[])new byte[]{1, 0}, (byte[])new byte[]{2, 0}), false, true));
        return testCases;
    }

    private static Collection<?> foreach(ScanRanges ranges, int[] widths, KeyRange keyRange, boolean expectedResult) {
        ArrayList ret = Lists.newArrayList();
        ret.add(new Object[]{ranges, widths, keyRange, expectedResult});
        return ret;
    }

    private static Collection<?> foreach(KeyRange[][] ranges, int[] widths, KeyRange keyRange, boolean useSkipScan, boolean expectedResult) {
        ArrayList<List<KeyRange>> slots = Lists.transform((List)Lists.newArrayList((Object[])ranges), ARRAY_TO_LIST);
        slots = new ArrayList<List<KeyRange>>(slots);
        slots.add(0, Collections.singletonList(KeyRange.getKeyRange((byte[])new byte[]{0})));
        RowKeySchema.RowKeySchemaBuilder builder = new RowKeySchema.RowKeySchemaBuilder(10);
        builder.addField((PDatum)SaltingUtil.SALTING_COLUMN, false, SortOrder.getDefault());
        for (final int width : widths) {
            if (width > 0) {
                builder.addField(new PDatum(){

                    public boolean isNullable() {
                        return false;
                    }

                    public PDataType getDataType() {
                        return PChar.INSTANCE;
                    }

                    public Integer getMaxLength() {
                        return width;
                    }

                    public Integer getScale() {
                        return null;
                    }

                    public SortOrder getSortOrder() {
                        return SortOrder.getDefault();
                    }
                }, false, SortOrder.getDefault());
                continue;
            }
            builder.addField(new PDatum(){

                public boolean isNullable() {
                    return false;
                }

                public PDataType getDataType() {
                    return PVarchar.INSTANCE;
                }

                public Integer getMaxLength() {
                    return width;
                }

                public Integer getScale() {
                    return null;
                }

                public SortOrder getSortOrder() {
                    return SortOrder.getDefault();
                }
            }, false, SortOrder.getDefault());
        }
        ScanRanges scanRanges = ScanRanges.createSingleSpan((RowKeySchema)builder.build(), slots, (Integer)nBuckets, (boolean)useSkipScan);
        return SaltedScanRangesTest.foreach(scanRanges, widths, keyRange, expectedResult);
    }
}

