/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.util.Properties;
import org.apache.phoenix.query.BaseConnectionlessQueryTest;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;

public class QueryMetaDataTest
extends BaseConnectionlessQueryTest {
    @Test
    public void testNoParameterMetaData() throws Exception {
        String query = "SELECT a_string, b_string FROM atable WHERE organization_id='000000000000000'";
        Connection conn = DriverManager.getConnection(QueryMetaDataTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
        PreparedStatement statement = conn.prepareStatement(query);
        ParameterMetaData pmd = statement.getParameterMetaData();
        Assert.assertEquals((long)0L, (long)pmd.getParameterCount());
    }

    @Test
    public void testCaseInsensitive() throws Exception {
        String query = "SELECT A_string, b_striNG FROM ataBle WHERE ORGANIZATION_ID='000000000000000'";
        Connection conn = DriverManager.getConnection(QueryMetaDataTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
        PreparedStatement statement = conn.prepareStatement(query);
        ParameterMetaData pmd = statement.getParameterMetaData();
        Assert.assertEquals((long)0L, (long)pmd.getParameterCount());
    }

    @Test
    public void testParameterMetaData() throws Exception {
        String query = "SELECT a_string, b_string FROM atable WHERE organization_id=? and (a_integer = ? or a_date = ? or b_string = ? or a_string = 'foo')";
        Connection conn = DriverManager.getConnection(QueryMetaDataTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
        PreparedStatement statement = conn.prepareStatement(query);
        ParameterMetaData pmd = statement.getParameterMetaData();
        Assert.assertEquals((long)4L, (long)pmd.getParameterCount());
        Assert.assertEquals((Object)String.class.getName(), (Object)pmd.getParameterClassName(1));
        Assert.assertEquals((Object)Integer.class.getName(), (Object)pmd.getParameterClassName(2));
        Assert.assertEquals((Object)Date.class.getName(), (Object)pmd.getParameterClassName(3));
        Assert.assertEquals((Object)String.class.getName(), (Object)pmd.getParameterClassName(4));
    }

    @Test
    public void testUpsertParameterMetaData() throws Exception {
        String query = "UPSERT INTO atable VALUES (?, ?, ?, ?, ?)";
        Connection conn = DriverManager.getConnection(QueryMetaDataTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
        PreparedStatement statement = conn.prepareStatement(query);
        ParameterMetaData pmd = statement.getParameterMetaData();
        Assert.assertEquals((long)5L, (long)pmd.getParameterCount());
        Assert.assertEquals((Object)String.class.getName(), (Object)pmd.getParameterClassName(1));
        Assert.assertEquals((Object)String.class.getName(), (Object)pmd.getParameterClassName(2));
        Assert.assertEquals((Object)String.class.getName(), (Object)pmd.getParameterClassName(3));
        Assert.assertEquals((Object)String.class.getName(), (Object)pmd.getParameterClassName(4));
        Assert.assertEquals((Object)Integer.class.getName(), (Object)pmd.getParameterClassName(5));
    }

    @Test
    public void testToDateFunctionMetaData() throws Exception {
        String query = "SELECT a_string, b_string FROM atable WHERE a_date > to_date(?)";
        Connection conn = DriverManager.getConnection(QueryMetaDataTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
        PreparedStatement statement = conn.prepareStatement(query);
        ParameterMetaData pmd = statement.getParameterMetaData();
        Assert.assertEquals((long)1L, (long)pmd.getParameterCount());
        Assert.assertEquals((Object)String.class.getName(), (Object)pmd.getParameterClassName(1));
    }

    @Test
    public void testLimitParameterMetaData() throws Exception {
        String query = "SELECT a_string, b_string FROM atable WHERE organization_id=? and a_string = 'foo' LIMIT ?";
        Connection conn = DriverManager.getConnection(QueryMetaDataTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
        PreparedStatement statement = conn.prepareStatement(query);
        ParameterMetaData pmd = statement.getParameterMetaData();
        Assert.assertEquals((long)2L, (long)pmd.getParameterCount());
        Assert.assertEquals((Object)String.class.getName(), (Object)pmd.getParameterClassName(1));
        Assert.assertEquals((Object)Integer.class.getName(), (Object)pmd.getParameterClassName(2));
    }

    @Test
    public void testRoundParameterMetaData() throws Exception {
        String query = "SELECT a_string, b_string FROM atable WHERE round(a_date,'day', ?) = ?";
        Connection conn = DriverManager.getConnection(QueryMetaDataTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
        PreparedStatement statement = conn.prepareStatement(query);
        ParameterMetaData pmd = statement.getParameterMetaData();
        Assert.assertEquals((long)2L, (long)pmd.getParameterCount());
        Assert.assertEquals((Object)Integer.class.getName(), (Object)pmd.getParameterClassName(1));
        Assert.assertEquals((Object)Date.class.getName(), (Object)pmd.getParameterClassName(2));
    }

    @Test
    public void testInListParameterMetaData1() throws Exception {
        String query = "SELECT a_string, b_string FROM atable WHERE a_string IN (?, ?)";
        Connection conn = DriverManager.getConnection(QueryMetaDataTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
        PreparedStatement statement = conn.prepareStatement(query);
        ParameterMetaData pmd = statement.getParameterMetaData();
        Assert.assertEquals((long)2L, (long)pmd.getParameterCount());
        Assert.assertEquals((Object)String.class.getName(), (Object)pmd.getParameterClassName(1));
        Assert.assertEquals((Object)String.class.getName(), (Object)pmd.getParameterClassName(2));
    }

    @Test
    public void testInListParameterMetaData2() throws Exception {
        String query = "SELECT a_string, b_string FROM atable WHERE ? IN (2.2, 3)";
        Connection conn = DriverManager.getConnection(QueryMetaDataTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
        PreparedStatement statement = conn.prepareStatement(query);
        ParameterMetaData pmd = statement.getParameterMetaData();
        Assert.assertEquals((long)1L, (long)pmd.getParameterCount());
        Assert.assertEquals((Object)BigDecimal.class.getName(), (Object)pmd.getParameterClassName(1));
    }

    @Test
    public void testInListParameterMetaData3() throws Exception {
        String query = "SELECT a_string, b_string FROM atable WHERE ? IN ('foo')";
        Connection conn = DriverManager.getConnection(QueryMetaDataTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
        PreparedStatement statement = conn.prepareStatement(query);
        ParameterMetaData pmd = statement.getParameterMetaData();
        Assert.assertEquals((long)1L, (long)pmd.getParameterCount());
        Assert.assertEquals((Object)String.class.getName(), (Object)pmd.getParameterClassName(1));
    }

    @Test
    public void testInListParameterMetaData4() throws Exception {
        String query = "SELECT a_string, b_string FROM atable WHERE ? IN (?, ?)";
        Connection conn = DriverManager.getConnection(QueryMetaDataTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
        PreparedStatement statement = conn.prepareStatement(query);
        ParameterMetaData pmd = statement.getParameterMetaData();
        Assert.assertEquals((long)3L, (long)pmd.getParameterCount());
        Assert.assertEquals(null, (Object)pmd.getParameterClassName(1));
        Assert.assertEquals(null, (Object)pmd.getParameterClassName(2));
        Assert.assertEquals(null, (Object)pmd.getParameterClassName(3));
    }

    @Test
    public void testCaseMetaData() throws Exception {
        String query1 = "SELECT a_string, b_string FROM atable WHERE case when a_integer = 1 then ? when a_integer > 2 then 2 end > 3";
        Connection conn = DriverManager.getConnection(QueryMetaDataTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
        PreparedStatement statement = conn.prepareStatement(query1);
        ParameterMetaData pmd = statement.getParameterMetaData();
        Assert.assertEquals((long)1L, (long)pmd.getParameterCount());
        Assert.assertEquals((Object)BigDecimal.class.getName(), (Object)pmd.getParameterClassName(1));
        Assert.assertEquals((long)1L, (long)pmd.isNullable(1));
        String query2 = "SELECT a_string, b_string FROM atable WHERE case when a_integer = 1 then 1 when a_integer > 2 then 2 end > ?";
        PreparedStatement statement2 = conn.prepareStatement(query2);
        ParameterMetaData pmd2 = statement2.getParameterMetaData();
        Assert.assertEquals((long)1L, (long)pmd2.getParameterCount());
        Assert.assertEquals((Object)Integer.class.getName(), (Object)pmd2.getParameterClassName(1));
        Assert.assertEquals((long)1L, (long)pmd2.isNullable(1));
    }

    @Test
    public void testSubstrParameterMetaData() throws Exception {
        String query = "SELECT a_string, b_string FROM atable WHERE substr(a_string,?,?) = ?";
        Connection conn = DriverManager.getConnection(QueryMetaDataTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
        PreparedStatement statement = conn.prepareStatement(query);
        ParameterMetaData pmd = statement.getParameterMetaData();
        Assert.assertEquals((long)3L, (long)pmd.getParameterCount());
        Assert.assertEquals((Object)Long.class.getName(), (Object)pmd.getParameterClassName(1));
        Assert.assertEquals((Object)Long.class.getName(), (Object)pmd.getParameterClassName(2));
        Assert.assertEquals((Object)String.class.getName(), (Object)pmd.getParameterClassName(3));
    }

    @Test
    public void testKeyPrefixParameterMetaData() throws Exception {
        String query = "SELECT a_string, b_string FROM atable WHERE organization_id='000000000000000' and substr(entity_id,1,3)=? and a_string = 'foo'";
        Connection conn = DriverManager.getConnection(QueryMetaDataTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
        PreparedStatement statement = conn.prepareStatement(query);
        ParameterMetaData pmd = statement.getParameterMetaData();
        Assert.assertEquals((long)1L, (long)pmd.getParameterCount());
        Assert.assertEquals((Object)String.class.getName(), (Object)pmd.getParameterClassName(1));
    }

    @Test
    public void testDateSubstractExpressionMetaData1() throws Exception {
        String query = "SELECT entity_id,a_string FROM atable where a_date-2.5-?=a_date";
        Connection conn = DriverManager.getConnection(QueryMetaDataTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
        PreparedStatement statement = conn.prepareStatement(query);
        ParameterMetaData pmd = statement.getParameterMetaData();
        Assert.assertEquals((long)1L, (long)pmd.getParameterCount());
        Assert.assertEquals((Object)BigDecimal.class.getName(), (Object)pmd.getParameterClassName(1));
    }

    @Test
    public void testDateSubstractExpressionMetaData2() throws Exception {
        String query = "SELECT entity_id,a_string FROM atable where a_date-?=a_date";
        Connection conn = DriverManager.getConnection(QueryMetaDataTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
        PreparedStatement statement = conn.prepareStatement(query);
        ParameterMetaData pmd = statement.getParameterMetaData();
        Assert.assertEquals((long)1L, (long)pmd.getParameterCount());
        Assert.assertEquals(null, (Object)pmd.getParameterClassName(1));
    }

    @Test
    public void testDateSubstractExpressionMetaData3() throws Exception {
        String query = "SELECT entity_id,a_string FROM atable where a_date-?=a_integer";
        Connection conn = DriverManager.getConnection(QueryMetaDataTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
        PreparedStatement statement = conn.prepareStatement(query);
        ParameterMetaData pmd = statement.getParameterMetaData();
        Assert.assertEquals((long)1L, (long)pmd.getParameterCount());
        Assert.assertEquals(null, (Object)pmd.getParameterClassName(1));
    }

    @Test
    public void testTwoDateSubstractExpressionMetaData() throws Exception {
        String query = "SELECT entity_id,a_string FROM atable where ?-a_date=1";
        Connection conn = DriverManager.getConnection(QueryMetaDataTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
        PreparedStatement statement = conn.prepareStatement(query);
        ParameterMetaData pmd = statement.getParameterMetaData();
        Assert.assertEquals((long)1L, (long)pmd.getParameterCount());
        Assert.assertEquals((Object)Date.class.getName(), (Object)pmd.getParameterClassName(1));
    }

    @Test
    public void testDateAdditionExpressionMetaData1() throws Exception {
        String query = "SELECT entity_id,a_string FROM atable where 1+a_date+?>a_date";
        Connection conn = DriverManager.getConnection(QueryMetaDataTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
        PreparedStatement statement = conn.prepareStatement(query);
        ParameterMetaData pmd = statement.getParameterMetaData();
        Assert.assertEquals((long)1L, (long)pmd.getParameterCount());
        Assert.assertEquals((Object)BigDecimal.class.getName(), (Object)pmd.getParameterClassName(1));
    }

    @Test
    public void testDateAdditionExpressionMetaData2() throws Exception {
        String query = "SELECT entity_id,a_string FROM atable where ?+a_date>a_date";
        Connection conn = DriverManager.getConnection(QueryMetaDataTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
        PreparedStatement statement = conn.prepareStatement(query);
        ParameterMetaData pmd = statement.getParameterMetaData();
        Assert.assertEquals((long)1L, (long)pmd.getParameterCount());
        Assert.assertEquals((Object)BigDecimal.class.getName(), (Object)pmd.getParameterClassName(1));
    }

    @Test
    public void testCoerceToDecimalArithmeticMetaData() throws Exception {
        String[] ops;
        for (String op : ops = new String[]{"+", "-", "*", "/"}) {
            String query = "SELECT entity_id,a_string FROM atable where a_integer" + op + "2.5" + op + "?=0";
            Connection conn = DriverManager.getConnection(QueryMetaDataTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setInt(1, 4);
            ParameterMetaData pmd = statement.getParameterMetaData();
            Assert.assertEquals((long)1L, (long)pmd.getParameterCount());
            Assert.assertEquals((Object)BigDecimal.class.getName(), (Object)pmd.getParameterClassName(1));
        }
    }

    @Test
    public void testLongArithmeticMetaData() throws Exception {
        String[] ops;
        for (String op : ops = new String[]{"+", "-", "*", "/"}) {
            String query = "SELECT entity_id,a_string FROM atable where a_integer" + op + "2" + op + "?=0";
            Connection conn = DriverManager.getConnection(QueryMetaDataTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setInt(1, 4);
            ParameterMetaData pmd = statement.getParameterMetaData();
            Assert.assertEquals((long)1L, (long)pmd.getParameterCount());
            Assert.assertEquals((Object)Long.class.getName(), (Object)pmd.getParameterClassName(1));
        }
    }

    @Test
    public void testBasicResultSetMetaData() throws Exception {
        String query = "SELECT organization_id, a_string, b_string, a_integer i, a_date FROM atable WHERE organization_id='000000000000000' and substr(entity_id,1,3)=? and a_string = 'foo'";
        Connection conn = DriverManager.getConnection(QueryMetaDataTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
        PreparedStatement statement = conn.prepareStatement(query);
        ResultSetMetaData md = statement.getMetaData();
        Assert.assertEquals((long)5L, (long)md.getColumnCount());
        Assert.assertEquals((Object)"organization_id".toUpperCase(), (Object)md.getColumnName(1));
        Assert.assertEquals((Object)"a_string".toUpperCase(), (Object)md.getColumnName(2));
        Assert.assertEquals((Object)"b_string".toUpperCase(), (Object)md.getColumnName(3));
        Assert.assertEquals((Object)"a_integer".toUpperCase(), (Object)md.getColumnName(4));
        Assert.assertEquals((Object)"i".toUpperCase(), (Object)md.getColumnLabel(4));
        Assert.assertEquals((Object)"a_date".toUpperCase(), (Object)md.getColumnName(5));
        Assert.assertEquals((Object)String.class.getName(), (Object)md.getColumnClassName(1));
        Assert.assertEquals((Object)String.class.getName(), (Object)md.getColumnClassName(2));
        Assert.assertEquals((Object)String.class.getName(), (Object)md.getColumnClassName(3));
        Assert.assertEquals((Object)Integer.class.getName(), (Object)md.getColumnClassName(4));
        Assert.assertEquals((Object)Date.class.getName(), (Object)md.getColumnClassName(5));
        Assert.assertEquals((Object)"atable".toUpperCase(), (Object)md.getTableName(1));
        Assert.assertEquals((long)4L, (long)md.getColumnType(4));
        Assert.assertEquals((Object)true, (Object)md.isReadOnly(1));
        Assert.assertEquals((Object)false, (Object)md.isDefinitelyWritable(1));
        Assert.assertEquals((Object)"i".toUpperCase(), (Object)md.getColumnLabel(4));
        Assert.assertEquals((Object)"a_date".toUpperCase(), (Object)md.getColumnLabel(5));
        Assert.assertEquals((long)0L, (long)md.isNullable(1));
        Assert.assertEquals((long)1L, (long)md.isNullable(5));
    }

    @Test
    public void testStringConcatMetaData() throws Exception {
        String query = "SELECT entity_id,a_string FROM atable where 2 || a_integer || ? like '2%'";
        Connection conn = DriverManager.getConnection(QueryMetaDataTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
        PreparedStatement statement = conn.prepareStatement(query);
        statement.setString(1, "foo");
        ParameterMetaData pmd = statement.getParameterMetaData();
        Assert.assertEquals((long)1L, (long)pmd.getParameterCount());
        Assert.assertEquals((Object)String.class.getName(), (Object)pmd.getParameterClassName(1));
    }

    @Test
    public void testRowValueConstructorBindParamMetaData() throws Exception {
        String query = "SELECT a_integer, x_integer FROM aTable WHERE (a_integer, x_integer, a_string) = (?, ?, ?)";
        Connection conn = DriverManager.getConnection(QueryMetaDataTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
        PreparedStatement statement = conn.prepareStatement(query);
        ParameterMetaData pmd = statement.getParameterMetaData();
        Assert.assertEquals((long)3L, (long)pmd.getParameterCount());
        Assert.assertEquals((Object)Integer.class.getName(), (Object)pmd.getParameterClassName(1));
        Assert.assertEquals((Object)Integer.class.getName(), (Object)pmd.getParameterClassName(2));
        Assert.assertEquals((Object)String.class.getName(), (Object)pmd.getParameterClassName(3));
    }

    @Test
    public void testRowValueConstructorBindParamMetaDataWithMoreNumberOfBindArgs() throws Exception {
        String query = "SELECT a_integer, x_integer FROM aTable WHERE (a_integer, x_integer) = (?, ?, ?)";
        Connection conn = DriverManager.getConnection(QueryMetaDataTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
        PreparedStatement statement = conn.prepareStatement(query);
        ParameterMetaData pmd = statement.getParameterMetaData();
        Assert.assertEquals((long)3L, (long)pmd.getParameterCount());
        Assert.assertEquals((Object)Integer.class.getName(), (Object)pmd.getParameterClassName(1));
        Assert.assertEquals((Object)Integer.class.getName(), (Object)pmd.getParameterClassName(2));
        Assert.assertEquals(null, (Object)pmd.getParameterClassName(3));
    }

    @Test
    public void testRowValueConstructorBindParamMetaDataWithLessNumberOfBindArgs() throws Exception {
        String query = "SELECT a_integer, x_integer FROM aTable WHERE (a_integer, x_integer, a_string) = (?, ?)";
        Connection conn = DriverManager.getConnection(QueryMetaDataTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
        PreparedStatement statement = conn.prepareStatement(query);
        ParameterMetaData pmd = statement.getParameterMetaData();
        Assert.assertEquals((long)2L, (long)pmd.getParameterCount());
        Assert.assertEquals((Object)Integer.class.getName(), (Object)pmd.getParameterClassName(1));
        Assert.assertEquals((Object)Integer.class.getName(), (Object)pmd.getParameterClassName(2));
    }

    @Test
    public void testRowValueConstructorBindParamMetaDataWithBindArgsAtSamePlacesOnLHSRHS() throws Exception {
        String query = "SELECT a_integer, x_integer FROM aTable WHERE (a_integer, ?) = (a_integer, ?)";
        Connection conn = DriverManager.getConnection(QueryMetaDataTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
        PreparedStatement statement = conn.prepareStatement(query);
        ParameterMetaData pmd = statement.getParameterMetaData();
        Assert.assertEquals((long)2L, (long)pmd.getParameterCount());
        Assert.assertEquals(null, (Object)pmd.getParameterClassName(1));
        Assert.assertEquals(null, (Object)pmd.getParameterClassName(2));
    }

    @Test
    public void testRowValueConstructorBindParamMetaDataWithBindArgsAtDiffPlacesOnLHSRHS() throws Exception {
        String query = "SELECT a_integer, x_integer FROM aTable WHERE (a_integer, ?) = (?, a_integer)";
        Connection conn = DriverManager.getConnection(QueryMetaDataTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
        PreparedStatement statement = conn.prepareStatement(query);
        ParameterMetaData pmd = statement.getParameterMetaData();
        Assert.assertEquals((long)2L, (long)pmd.getParameterCount());
        Assert.assertEquals((Object)Integer.class.getName(), (Object)pmd.getParameterClassName(1));
        Assert.assertEquals((Object)Integer.class.getName(), (Object)pmd.getParameterClassName(2));
    }

    public void testRowValueConstructorBindParamMetaDataWithBindArgsOnLHSAndLiteralExprOnRHS() throws Exception {
        String query = "SELECT a_integer, x_integer FROM aTable WHERE (?, ?) = 7";
        Connection conn = DriverManager.getConnection(QueryMetaDataTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
        PreparedStatement statement = conn.prepareStatement(query);
        ParameterMetaData pmd = statement.getParameterMetaData();
        Assert.assertEquals((long)2L, (long)pmd.getParameterCount());
        Assert.assertEquals((Object)Integer.class.getName(), (Object)pmd.getParameterClassName(1));
        Assert.assertEquals(null, (Object)pmd.getParameterClassName(2));
    }

    @Test
    public void testRowValueConstructorBindParamMetaDataWithBindArgsOnRHSAndLiteralExprOnLHS() throws Exception {
        String query = "SELECT a_integer, x_integer FROM aTable WHERE 7 = (?, ?)";
        Connection conn = DriverManager.getConnection(QueryMetaDataTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
        PreparedStatement statement = conn.prepareStatement(query);
        ParameterMetaData pmd = statement.getParameterMetaData();
        Assert.assertEquals((long)2L, (long)pmd.getParameterCount());
        Assert.assertEquals((Object)Integer.class.getName(), (Object)pmd.getParameterClassName(1));
        Assert.assertEquals(null, (Object)pmd.getParameterClassName(2));
    }

    @Test
    public void testNonEqualityRowValueConstructorBindParamMetaDataWithBindArgsOnRHSAndLiteralExprOnLHS() throws Exception {
        String query = "SELECT a_integer, x_integer FROM aTable WHERE 7 >= (?, ?)";
        Connection conn = DriverManager.getConnection(QueryMetaDataTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
        PreparedStatement statement = conn.prepareStatement(query);
        ParameterMetaData pmd = statement.getParameterMetaData();
        Assert.assertEquals((long)2L, (long)pmd.getParameterCount());
        Assert.assertEquals((Object)Integer.class.getName(), (Object)pmd.getParameterClassName(1));
        Assert.assertEquals(null, (Object)pmd.getParameterClassName(2));
    }

    @Test
    public void testBindParamMetaDataForNestedRVC() throws Exception {
        String query = "SELECT organization_id, entity_id, a_string FROM aTable WHERE (organization_id, (entity_id, a_string)) >= (?, (?, ?))";
        Connection conn = DriverManager.getConnection(QueryMetaDataTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
        PreparedStatement statement = conn.prepareStatement(query);
        ParameterMetaData pmd = statement.getParameterMetaData();
        Assert.assertEquals((long)3L, (long)pmd.getParameterCount());
        Assert.assertEquals((Object)String.class.getName(), (Object)pmd.getParameterClassName(1));
        Assert.assertEquals((Object)String.class.getName(), (Object)pmd.getParameterClassName(2));
        Assert.assertEquals((Object)String.class.getName(), (Object)pmd.getParameterClassName(3));
    }
}

