/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.phoenix.compile.MutationPlan;
import org.apache.phoenix.compile.PostIndexDDLCompiler;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.query.BaseConnectionlessQueryTest;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.TableRef;
import org.junit.Assert;
import org.junit.Test;

public class PostIndexDDLCompilerTest
extends BaseConnectionlessQueryTest {
    @Test
    public void testHintInSubquery() throws Exception {
        try (Connection conn = DriverManager.getConnection(PostIndexDDLCompilerTest.getUrl());){
            this.setupTables(conn);
            PhoenixStatement stmt = conn.createStatement().unwrap(PhoenixStatement.class);
            String query = "UPSERT /*+ NO_INDEX */ INTO T(k, v1) SELECT /*+ NO_INDEX */  k,v1 FROM T WHERE v1 = '4'";
            MutationPlan plan = stmt.compileMutation(query);
            Assert.assertEquals((Object)"T", (Object)plan.getQueryPlan().getTableRef().getTable().getTableName().getString());
            query = "UPSERT INTO T(k, v1) SELECT /*+ NO_INDEX */  k,v1 FROM T WHERE v1 = '4'";
            plan = stmt.compileMutation(query);
            Assert.assertEquals((Object)"IDX", (Object)plan.getQueryPlan().getTableRef().getTable().getTableName().getString());
        }
    }

    @Test
    public void testCompile() throws Exception {
        try (Connection conn = DriverManager.getConnection(PostIndexDDLCompilerTest.getUrl());){
            this.setupTables(conn);
            PhoenixConnection pConn = conn.unwrap(PhoenixConnection.class);
            PTable pDataTable = pConn.getTable(new PTableKey(null, "T"));
            PostIndexDDLCompiler compiler = new PostIndexDDLCompiler(pConn, new TableRef(pDataTable));
            MutationPlan plan = compiler.compile(pConn.getTable(new PTableKey(null, "IDX")));
            Assert.assertEquals((Object)"T", (Object)plan.getQueryPlan().getTableRef().getTable().getTableName().getString());
        }
    }

    @Test
    public void testCreateTableWithNoVerify() throws SQLException {
        String ddl = "CREATE TABLE A (K VARCHAR PRIMARY KEY DESC) NOVERIFY";
        try (Connection conn = DriverManager.getConnection(PostIndexDDLCompilerTest.getUrl());){
            PhoenixStatement stmt = conn.createStatement().unwrap(PhoenixStatement.class);
            MutationPlan plan = stmt.compileMutation(ddl);
            MutationState state = plan.execute();
            Assert.assertEquals((Object)"CREATE TABLE\n", (Object)plan.getExplainPlan().toString());
            Assert.assertEquals((long)0L, (long)state.getMaxSize());
            Assert.assertEquals((long)0L, (long)state.getMaxSizeBytes());
        }
    }

    private void setupTables(Connection conn) throws SQLException {
        conn.createStatement().execute("CREATE TABLE T (k VARCHAR NOT NULL PRIMARY KEY, v1 CHAR(15), v2 VARCHAR)");
        conn.createStatement().execute("CREATE INDEX IDX ON T(v1, v2)");
    }
}

