/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixPreparedStatement;
import org.apache.phoenix.query.BaseConnectionlessQueryTest;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;

public class LimitCompilerTest
extends BaseConnectionlessQueryTest {
    private static QueryPlan compileStatement(String query, List<Object> binds) throws SQLException {
        PhoenixConnection pconn = DriverManager.getConnection(LimitCompilerTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES)).unwrap(PhoenixConnection.class);
        PhoenixPreparedStatement pstmt = new PhoenixPreparedStatement(pconn, query);
        TestUtil.bindParams(pstmt, binds);
        return pstmt.compileQuery();
    }

    @Test
    public void testLimit() throws SQLException {
        String tenantId = "000000000000001";
        String query = "select * from atable where organization_id='" + tenantId + "' limit 5";
        List<Object> binds = Collections.emptyList();
        QueryPlan plan = LimitCompilerTest.compileStatement(query, binds);
        Scan scan = plan.getContext().getScan();
        Assert.assertNull((Object)scan.getFilter());
        Assert.assertArrayEquals((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId), (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])ByteUtil.nextKey((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId)), (byte[])scan.getStopRow());
        Assert.assertEquals((Object)plan.getLimit(), (Object)5);
    }

    @Test
    public void testNoLimit() throws SQLException {
        String tenantId = "000000000000001";
        String query = "select * from atable where organization_id='" + tenantId + "'";
        List<Object> binds = Collections.emptyList();
        QueryPlan plan = LimitCompilerTest.compileStatement(query, binds);
        Scan scan = plan.getContext().getScan();
        Assert.assertNull((Object)scan.getFilter());
        Assert.assertNull((Object)plan.getLimit());
        Assert.assertArrayEquals((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId), (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])ByteUtil.nextKey((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId)), (byte[])scan.getStopRow());
    }

    @Test
    public void testBoundLimit() throws SQLException {
        String tenantId = "000000000000001";
        String query = "select * from atable where organization_id='" + tenantId + "' limit ?";
        List<Object> binds = Arrays.asList(5);
        QueryPlan plan = LimitCompilerTest.compileStatement(query, binds);
        Scan scan = plan.getContext().getScan();
        Assert.assertNull((Object)scan.getFilter());
        Assert.assertArrayEquals((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId), (byte[])scan.getStartRow());
        Assert.assertArrayEquals((byte[])ByteUtil.nextKey((byte[])PVarchar.INSTANCE.toBytes((Object)tenantId)), (byte[])scan.getStopRow());
        Assert.assertEquals((Object)plan.getLimit(), (Object)5);
    }

    @Test
    public void testTypeMismatchBoundLimit() throws SQLException {
        String query = "select * from atable limit ?";
        List<Object> binds = Arrays.asList("foo");
        try {
            LimitCompilerTest.compileStatement(query, binds);
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Type mismatch"));
        }
    }

    @Test
    public void testNegativeBoundLimit() throws SQLException {
        String query = "select * from atable limit ?";
        List<Object> binds = Arrays.asList(-1);
        QueryPlan plan = LimitCompilerTest.compileStatement(query, binds);
        Assert.assertNull((Object)plan.getLimit());
    }

    @Test
    public void testBindTypeMismatch() throws SQLException {
        Long tenantId = 0L;
        String keyPrefix = "002";
        List<Object> binds = Arrays.asList(tenantId, keyPrefix);
        String query = "select * from atable where organization_id=? and substr(entity_id,1,3)=?";
        try {
            LimitCompilerTest.compileStatement(query, binds);
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("ERROR 203 (22005): Type mismatch."));
        }
    }
}

