/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import java.sql.Date;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.execute.AggregatePlan;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.RowKeyColumnExpression;
import org.apache.phoenix.expression.function.CountAggregateFunction;
import org.apache.phoenix.expression.function.RoundDateExpression;
import org.apache.phoenix.filter.BooleanExpressionFilter;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixPreparedStatement;
import org.apache.phoenix.query.BaseConnectionlessQueryTest;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PDatum;
import org.apache.phoenix.schema.RowKeyValueAccessor;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;

public class HavingCompilerTest
extends BaseConnectionlessQueryTest {
    private static Expressions compileStatement(String query, List<Object> binds) throws SQLException {
        PhoenixConnection pconn = DriverManager.getConnection(HavingCompilerTest.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES)).unwrap(PhoenixConnection.class);
        PhoenixPreparedStatement pstmt = new PhoenixPreparedStatement(pconn, query);
        TestUtil.bindParams(pstmt, binds);
        QueryPlan plan = pstmt.compileQuery();
        Assert.assertTrue((boolean)(plan instanceof AggregatePlan));
        Filter filter = plan.getContext().getScan().getFilter();
        Assert.assertTrue((filter == null || filter instanceof BooleanExpressionFilter ? 1 : 0) != 0);
        BooleanExpressionFilter boolFilter = (BooleanExpressionFilter)filter;
        AggregatePlan aggPlan = (AggregatePlan)plan;
        return new Expressions(boolFilter == null ? null : boolFilter.getExpression(), aggPlan.getHaving());
    }

    @Test
    public void testHavingToWhere() throws SQLException {
        String query = "select count(1) from atable group by a_string having a_string = 'foo'";
        List<Object> binds = Collections.emptyList();
        Expressions expressions = HavingCompilerTest.compileStatement(query, binds);
        Expression w = TestUtil.constantComparison(CompareOperator.EQUAL, A_STRING, (Object)"foo");
        Assert.assertEquals((Object)w, (Object)expressions.whereClause);
        Assert.assertNull((Object)expressions.havingClause);
    }

    @Test
    public void testHavingFuncToWhere() throws SQLException {
        String query = "select count(1) from atable group by a_date having round(a_date, 'hour') > ?";
        Date date = new Date(System.currentTimeMillis());
        List<Object> binds = Arrays.asList(date);
        Expressions expressions = HavingCompilerTest.compileStatement(query, binds);
        Expression w = TestUtil.constantComparison(CompareOperator.GREATER, RoundDateExpression.create(Arrays.asList(A_DATE, LiteralExpression.newConstant((Object)"hour"), LiteralExpression.newConstant((Object)1))), (Object)date);
        Assert.assertEquals((Object)w, (Object)expressions.whereClause);
        Assert.assertNull((Object)expressions.havingClause);
    }

    @Test
    public void testHavingToAndWhere() throws SQLException {
        String query = "select count(1) from atable where b_string > 'bar' group by a_string having a_string = 'foo'";
        List<Object> binds = Collections.emptyList();
        Expressions expressions = HavingCompilerTest.compileStatement(query, binds);
        Expression w = TestUtil.and(TestUtil.constantComparison(CompareOperator.GREATER, B_STRING, (Object)"bar"), TestUtil.constantComparison(CompareOperator.EQUAL, A_STRING, (Object)"foo"));
        Assert.assertEquals((Object)w, (Object)expressions.whereClause);
        Assert.assertNull((Object)expressions.havingClause);
    }

    @Test
    public void testAndHavingToAndWhere() throws SQLException {
        String query = "select count(1) from atable where b_string > 'bar' group by a_string having count(1) >= 1 and a_string = 'foo'";
        List<Object> binds = Collections.emptyList();
        Expressions expressions = HavingCompilerTest.compileStatement(query, binds);
        Expression h = TestUtil.constantComparison(CompareOperator.GREATER_OR_EQUAL, (Expression)new CountAggregateFunction(), (Object)1L);
        Expression w = TestUtil.and(TestUtil.constantComparison(CompareOperator.GREATER, B_STRING, (Object)"bar"), TestUtil.constantComparison(CompareOperator.EQUAL, A_STRING, (Object)"foo"));
        Assert.assertEquals((Object)w, (Object)expressions.whereClause);
        Assert.assertEquals((Object)h, (Object)expressions.havingClause);
    }

    @Test
    public void testAndHavingToWhere() throws SQLException {
        String query = "select count(1) from atable group by a_string having count(1) >= 1 and a_string = 'foo'";
        List<Object> binds = Collections.emptyList();
        Expressions expressions = HavingCompilerTest.compileStatement(query, binds);
        Expression h = TestUtil.constantComparison(CompareOperator.GREATER_OR_EQUAL, (Expression)new CountAggregateFunction(), (Object)1L);
        Expression w = TestUtil.constantComparison(CompareOperator.EQUAL, A_STRING, (Object)"foo");
        Assert.assertEquals((Object)w, (Object)expressions.whereClause);
        Assert.assertEquals((Object)h, (Object)expressions.havingClause);
    }

    @Test
    public void testInListHavingToWhere() throws SQLException {
        String query = "select count(1) from atable group by a_string having a_string in ('foo', 'bar')";
        List<Object> binds = Collections.emptyList();
        Expressions expressions = HavingCompilerTest.compileStatement(query, binds);
        Expression w = TestUtil.in(A_STRING, "foo", "bar");
        Assert.assertEquals((Object)w, (Object)expressions.whereClause);
        Assert.assertNull((Object)expressions.havingClause);
    }

    @Test
    public void testAggFuncInHaving() throws SQLException {
        String query = "select count(1) from atable group by a_string having count(a_string) >= 1";
        List<Object> binds = Collections.emptyList();
        Expressions expressions = HavingCompilerTest.compileStatement(query, binds);
        Expression h = TestUtil.constantComparison(CompareOperator.GREATER_OR_EQUAL, (Expression)new CountAggregateFunction(Arrays.asList(A_STRING)), (Object)1L);
        Assert.assertNull((Object)expressions.whereClause);
        Assert.assertEquals((Object)h, (Object)expressions.havingClause);
    }

    @Test
    public void testOrAggFuncInHaving() throws SQLException {
        String query = "select count(1) from atable group by a_string having count(1) >= 1 or a_string = 'foo'";
        List<Object> binds = Collections.emptyList();
        Expressions expressions = HavingCompilerTest.compileStatement(query, binds);
        PColumn aCol = ATABLE.getColumnForColumnName("A_STRING");
        Expression h = TestUtil.or(TestUtil.constantComparison(CompareOperator.GREATER_OR_EQUAL, (Expression)new CountAggregateFunction(), (Object)1L), TestUtil.constantComparison(CompareOperator.EQUAL, (Expression)new RowKeyColumnExpression((PDatum)aCol, new RowKeyValueAccessor(Arrays.asList(aCol), 0)), (Object)"foo"));
        Assert.assertNull((Object)expressions.whereClause);
        Assert.assertEquals((Object)h, (Object)expressions.havingClause);
    }

    @Test
    public void testAndAggColsInHaving() throws SQLException {
        String query = "select count(1) from atable group by a_string,b_string having a_string = 'a' and b_string = 'b'";
        List<Object> binds = Collections.emptyList();
        Expressions expressions = HavingCompilerTest.compileStatement(query, binds);
        Expression w = TestUtil.and(TestUtil.constantComparison(CompareOperator.EQUAL, A_STRING, (Object)"a"), TestUtil.constantComparison(CompareOperator.EQUAL, B_STRING, (Object)"b"));
        Assert.assertEquals((Object)w, (Object)expressions.whereClause);
        Assert.assertNull((Object)expressions.havingClause);
    }

    @Test
    public void testOrAggColsInHaving() throws SQLException {
        String query = "select count(1) from atable group by a_string,b_string having a_string = 'a' or b_string = 'b'";
        List<Object> binds = Collections.emptyList();
        Expressions expressions = HavingCompilerTest.compileStatement(query, binds);
        Expression w = TestUtil.or(TestUtil.constantComparison(CompareOperator.EQUAL, A_STRING, (Object)"a"), TestUtil.constantComparison(CompareOperator.EQUAL, B_STRING, (Object)"b"));
        Assert.assertEquals((Object)w, (Object)expressions.whereClause);
        Assert.assertNull((Object)expressions.havingClause);
    }

    @Test
    public void testNonAggColInHaving() throws SQLException {
        String query = "select count(1) from atable group by a_string having b_string = 'bar'";
        List<Object> binds = Collections.emptyList();
        try {
            HavingCompilerTest.compileStatement(query, binds);
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("ERROR 1019 (42Y26): Only aggregate maybe used in the HAVING clause."));
        }
    }

    private static class Expressions {
        private Expression whereClause;
        private Expression havingClause;

        private Expressions(Expression whereClause, Expression havingClause) {
            this.whereClause = whereClause;
            this.havingClause = havingClause;
        }
    }
}

