/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.phoenix.query.BaseConnectionlessQueryTest;
import org.apache.phoenix.util.CursorUtil;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;

@SuppressWarnings(value={"RV_RETURN_VALUE_IGNORED"}, justification="Test code.")
public class CursorCompilerTest
extends BaseConnectionlessQueryTest {
    @Test
    public void testCursorLifecycleCompile() throws SQLException {
        String query = "SELECT a_string, b_string FROM atable";
        Object sql = "DECLARE testCursor CURSOR FOR " + query;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.put("phoenix.query.request.metrics.enabled", "true");
        Connection conn = DriverManager.getConnection(CursorCompilerTest.getUrl(), props);
        PreparedStatement statement = conn.prepareStatement((String)sql);
        statement.execute();
        Assert.assertTrue((boolean)CursorUtil.cursorDeclared((String)"testCursor"));
        sql = "OPEN testCursor";
        statement = conn.prepareStatement((String)sql);
        statement.execute();
        sql = "FETCH NEXT FROM testCursor";
        statement = conn.prepareStatement((String)sql);
        statement.executeQuery();
    }
}

