/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.parse.CreateTableStatement;
import org.apache.phoenix.parse.SQLParser;
import org.apache.phoenix.query.BaseConnectionlessQueryTest;
import org.apache.phoenix.schema.ColumnAlreadyExistsException;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;

public class CreateTableCompilerTest
extends BaseConnectionlessQueryTest {
    @Test
    public void testCreateTableWithDuplicateColumns() throws SQLException {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (PhoenixConnection conn = DriverManager.getConnection(CreateTableCompilerTest.getUrl(), props).unwrap(PhoenixConnection.class);){
            String ddl = "CREATE TABLE T (ID INTEGER PRIMARY KEY, DUPE INTEGER, DUPE INTEGER)";
            conn.createStatement().execute(ddl);
            Assert.fail();
        }
        catch (ColumnAlreadyExistsException e) {
            Assert.assertEquals((Object)"DUPE", (Object)e.getColumnName());
        }
    }

    @Test
    public void testCreateTableWithNoVerify() throws SQLException {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (PhoenixConnection conn = DriverManager.getConnection(CreateTableCompilerTest.getUrl(), props).unwrap(PhoenixConnection.class);){
            String ddl = "CREATE TABLE T (ID INTEGER PRIMARY KEY, A INTEGER, B INTEGER) NOVERIFY";
            boolean result = conn.createStatement().execute(ddl);
            Assert.assertFalse((boolean)result);
        }
    }

    @Test
    public void testCreateTableWithNoVerifyValidateStmt() throws SQLException {
        String ddl = "CREATE TABLE A (K VARCHAR PRIMARY KEY DESC) NOVERIFY";
        CreateTableStatement stmt = (CreateTableStatement)new SQLParser(ddl).parseStatement();
        Assert.assertTrue((boolean)stmt.isNoVerify());
    }
}

