/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.cache;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.cache.TenantCacheImpl;
import org.apache.phoenix.coprocessorclient.MetaDataProtocol;
import org.apache.phoenix.coprocessorclient.ServerCachingProtocol;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.memory.GlobalMemoryManager;
import org.apache.phoenix.memory.MemoryManager;
import org.apache.phoenix.thirdparty.com.google.common.base.Ticker;
import org.apache.phoenix.util.ByteUtil;
import org.junit.Assert;
import org.junit.Test;

public class TenantCacheTest {
    public static ServerCachingProtocol.ServerCacheFactory cacheFactory = new ServerCachingProtocol.ServerCacheFactory(){

        public void readFields(DataInput arg0) throws IOException {
        }

        public void write(DataOutput arg0) throws IOException {
        }

        public Closeable newCache(ImmutableBytesWritable cachePtr, byte[] txState, MemoryManager.MemoryChunk chunk, boolean useProtoForIndexMaintainer, int clientVersion) throws SQLException {
            return chunk;
        }
    };

    @Test
    public void testInvalidateClosesMemoryChunk() throws SQLException {
        int maxServerCacheTimeToLive = 10000;
        int maxServerCachePersistenceTimeToLive = 10;
        long maxBytes = 1000L;
        GlobalMemoryManager memoryManager = new GlobalMemoryManager(maxBytes);
        TenantCacheImpl newTenantCache = new TenantCacheImpl((MemoryManager)memoryManager, maxServerCacheTimeToLive, maxServerCachePersistenceTimeToLive);
        ImmutableBytesPtr cacheId = new ImmutableBytesPtr(Bytes.toBytes((long)1L));
        ImmutableBytesWritable cachePtr = new ImmutableBytesWritable(Bytes.toBytes((String)"a"));
        newTenantCache.addServerCache(cacheId, cachePtr, ByteUtil.EMPTY_BYTE_ARRAY, cacheFactory, true, false, MetaDataProtocol.PHOENIX_VERSION);
        Assert.assertEquals((long)(maxBytes - 1L), (long)memoryManager.getAvailableMemory());
        newTenantCache.removeServerCache(cacheId);
        Assert.assertEquals((long)maxBytes, (long)memoryManager.getAvailableMemory());
    }

    @Test
    public void testTimeoutClosesMemoryChunk() throws Exception {
        int maxServerCacheTimeToLive = 10;
        int maxServerCachePersistenceTimeToLive = 10;
        long maxBytes = 1000L;
        GlobalMemoryManager memoryManager = new GlobalMemoryManager(maxBytes);
        ManualTicker ticker = new ManualTicker();
        TenantCacheImpl cache = new TenantCacheImpl((MemoryManager)memoryManager, maxServerCacheTimeToLive, maxServerCachePersistenceTimeToLive, (Ticker)ticker);
        ImmutableBytesPtr cacheId1 = new ImmutableBytesPtr(Bytes.toBytes((long)1L));
        ImmutableBytesWritable cachePtr = new ImmutableBytesWritable(Bytes.toBytes((String)"a"));
        cache.addServerCache(cacheId1, cachePtr, ByteUtil.EMPTY_BYTE_ARRAY, cacheFactory, true, false, MetaDataProtocol.PHOENIX_VERSION);
        Assert.assertEquals((long)(maxBytes - 1L), (long)memoryManager.getAvailableMemory());
        ticker.time += (long)((maxServerCacheTimeToLive + 1) * 1000000);
        cache.cleanUp();
        Assert.assertEquals((long)maxBytes, (long)memoryManager.getAvailableMemory());
    }

    @Test
    public void testFreeMemoryOnAccess() throws Exception {
        int maxServerCacheTimeToLive = 10;
        int maxServerCachePersistenceTimeToLive = 10;
        long maxBytes = 1000L;
        GlobalMemoryManager memoryManager = new GlobalMemoryManager(maxBytes);
        ManualTicker ticker = new ManualTicker();
        TenantCacheImpl cache = new TenantCacheImpl((MemoryManager)memoryManager, maxServerCacheTimeToLive, maxServerCachePersistenceTimeToLive, (Ticker)ticker);
        ImmutableBytesPtr cacheId1 = new ImmutableBytesPtr(Bytes.toBytes((long)1L));
        ImmutableBytesWritable cachePtr = new ImmutableBytesWritable(Bytes.toBytes((String)"a"));
        cache.addServerCache(cacheId1, cachePtr, ByteUtil.EMPTY_BYTE_ARRAY, cacheFactory, true, false, MetaDataProtocol.PHOENIX_VERSION);
        Assert.assertEquals((long)(maxBytes - 1L), (long)memoryManager.getAvailableMemory());
        ticker.time += (long)((maxServerCacheTimeToLive + 1) * 1000000);
        Assert.assertNull((Object)cache.getServerCache(cacheId1));
        Assert.assertEquals((long)maxBytes, (long)memoryManager.getAvailableMemory());
    }

    @Test
    public void testExpiredCacheOnAddingNew() throws Exception {
        int maxServerCacheTimeToLive = 10;
        int maxServerCachePersistenceTimeToLive = 10;
        long maxBytes = 10L;
        GlobalMemoryManager memoryManager = new GlobalMemoryManager(maxBytes);
        ManualTicker ticker = new ManualTicker();
        TenantCacheImpl cache = new TenantCacheImpl((MemoryManager)memoryManager, maxServerCacheTimeToLive, maxServerCachePersistenceTimeToLive, (Ticker)ticker);
        ImmutableBytesPtr cacheId1 = new ImmutableBytesPtr(Bytes.toBytes((long)1L));
        ImmutableBytesWritable cachePtr = new ImmutableBytesWritable(Bytes.toBytes((String)"12345678"));
        cache.addServerCache(cacheId1, cachePtr, ByteUtil.EMPTY_BYTE_ARRAY, cacheFactory, true, false, MetaDataProtocol.PHOENIX_VERSION);
        Assert.assertEquals((long)2L, (long)memoryManager.getAvailableMemory());
        ticker.time += (long)((maxServerCacheTimeToLive + 1) * 1000000);
        cache.addServerCache(cacheId1, cachePtr, ByteUtil.EMPTY_BYTE_ARRAY, cacheFactory, true, false, MetaDataProtocol.PHOENIX_VERSION);
        Assert.assertEquals((long)2L, (long)memoryManager.getAvailableMemory());
    }

    @Test
    public void testExpiresButStaysInPersistentAfterTimeout() throws Exception {
        int maxServerCacheTimeToLive = 100;
        int maxServerCachePersistenceTimeToLive = 1000;
        long maxBytes = 1000L;
        GlobalMemoryManager memoryManager = new GlobalMemoryManager(maxBytes);
        ManualTicker ticker = new ManualTicker();
        TenantCacheImpl cache = new TenantCacheImpl((MemoryManager)memoryManager, maxServerCacheTimeToLive, maxServerCachePersistenceTimeToLive, (Ticker)ticker);
        ImmutableBytesPtr cacheId1 = new ImmutableBytesPtr(Bytes.toBytes((long)1L));
        ImmutableBytesWritable cachePtr = new ImmutableBytesWritable(Bytes.toBytes((String)"a"));
        cache.addServerCache(cacheId1, cachePtr, ByteUtil.EMPTY_BYTE_ARRAY, cacheFactory, true, true, MetaDataProtocol.PHOENIX_VERSION);
        Assert.assertEquals((long)(maxBytes - 1L), (long)memoryManager.getAvailableMemory());
        Assert.assertNotNull((Object)cache.getServerCache(cacheId1));
        ticker.time += (long)((maxServerCacheTimeToLive + 1) * 1000000);
        cache.cleanUp();
        Assert.assertEquals((long)(maxBytes - 1L), (long)memoryManager.getAvailableMemory());
        Assert.assertNotNull((Object)cache.getServerCache(cacheId1));
        ticker.time += (long)((maxServerCachePersistenceTimeToLive + 1) * 1000000);
        cache.cleanUp();
        Assert.assertEquals((long)maxBytes, (long)memoryManager.getAvailableMemory());
        Assert.assertNull((Object)cache.getServerCache(cacheId1));
    }

    @Test
    public void testExpiresButStaysInPersistentAfterRemove() throws Exception {
        int maxServerCacheTimeToLive = 100;
        int maxServerCachePersistenceTimeToLive = 1000;
        long maxBytes = 1000L;
        GlobalMemoryManager memoryManager = new GlobalMemoryManager(maxBytes);
        ManualTicker ticker = new ManualTicker();
        TenantCacheImpl cache = new TenantCacheImpl((MemoryManager)memoryManager, maxServerCacheTimeToLive, maxServerCachePersistenceTimeToLive, (Ticker)ticker);
        ImmutableBytesPtr cacheId1 = new ImmutableBytesPtr(Bytes.toBytes((long)1L));
        ImmutableBytesWritable cachePtr = new ImmutableBytesWritable(Bytes.toBytes((String)"12"));
        cache.addServerCache(cacheId1, cachePtr, ByteUtil.EMPTY_BYTE_ARRAY, cacheFactory, true, true, MetaDataProtocol.PHOENIX_VERSION);
        Assert.assertEquals((long)(maxBytes - 2L), (long)memoryManager.getAvailableMemory());
        Assert.assertNotNull((Object)cache.getServerCache(cacheId1));
        cache.removeServerCache(cacheId1);
        Assert.assertEquals((long)(maxBytes - 2L), (long)memoryManager.getAvailableMemory());
        Assert.assertNotNull((Object)cache.getServerCache(cacheId1));
    }

    @Test
    public void testEvictPersistentCacheIfSpaceIsNeeded() throws Exception {
        int maxServerCacheTimeToLive = 100;
        int maxServerCachePersistenceTimeToLive = 1000;
        long maxBytes = 10L;
        GlobalMemoryManager memoryManager = new GlobalMemoryManager(maxBytes);
        ManualTicker ticker = new ManualTicker();
        TenantCacheImpl cache = new TenantCacheImpl((MemoryManager)memoryManager, maxServerCacheTimeToLive, maxServerCachePersistenceTimeToLive, (Ticker)ticker);
        ImmutableBytesPtr cacheId1 = new ImmutableBytesPtr(Bytes.toBytes((long)1L));
        ImmutableBytesWritable cachePtr1 = new ImmutableBytesWritable(Bytes.toBytes((String)"1234"));
        cache.addServerCache(cacheId1, cachePtr1, ByteUtil.EMPTY_BYTE_ARRAY, cacheFactory, true, true, MetaDataProtocol.PHOENIX_VERSION);
        Assert.assertEquals((long)6L, (long)memoryManager.getAvailableMemory());
        cache.removeServerCache(cacheId1);
        Assert.assertNotNull((Object)cache.getServerCache(cacheId1));
        Assert.assertEquals((long)6L, (long)memoryManager.getAvailableMemory());
        ImmutableBytesPtr cacheId2 = new ImmutableBytesPtr(Bytes.toBytes((long)2L));
        ImmutableBytesWritable cachePtr2 = new ImmutableBytesWritable(Bytes.toBytes((String)"12345678"));
        cache.addServerCache(cacheId2, cachePtr2, ByteUtil.EMPTY_BYTE_ARRAY, cacheFactory, true, true, MetaDataProtocol.PHOENIX_VERSION);
        Assert.assertEquals((long)2L, (long)memoryManager.getAvailableMemory());
        Assert.assertNull((Object)cache.getServerCache(cacheId1));
        Assert.assertNotNull((Object)cache.getServerCache(cacheId2));
    }

    public static class ManualTicker
    extends Ticker {
        public long time = 0L;

        public long read() {
            return this.time;
        }
    }
}

