/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.cache;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessor;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.cache.ServerMetadataCache;
import org.apache.phoenix.coprocessorclient.metrics.MetricsMetadataCachingSource;
import org.apache.phoenix.coprocessorclient.metrics.MetricsPhoenixCoprocessorSourceFactory;
import org.apache.phoenix.end2end.IndexToolIT;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.PhoenixRegionServerEndpointTestImpl;
import org.apache.phoenix.end2end.ServerMetadataCacheTestImpl;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.jdbc.PhoenixResultSet;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.monitoring.GlobalClientMetrics;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Category(value={NeedsOwnMiniClusterTest.class})
public class ServerMetadataCacheIT
extends ParallelStatsDisabledIT {
    private final Random RANDOM = new Random(42L);
    private static ServerName serverName;

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap props = Maps.newHashMapWithExpectedSize((int)1);
        props.put("phoenix.default.update.cache.frequency", "NEVER");
        props.put("phoenix.ddl.timestamp.validation.enabled", Boolean.toString(true));
        props.put("phoenix.metadata.invalidate.cache.enabled", Boolean.toString(true));
        props.put("phoenix.task.handling.interval.ms", Long.toString(Long.MAX_VALUE));
        props.put("phoenix.task.handling.initial.delay.ms", Long.toString(Long.MAX_VALUE));
        ServerMetadataCacheIT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
        Assert.assertEquals((long)1L, (long)ServerMetadataCacheIT.getUtility().getHBaseCluster().getNumLiveRegionServers());
        serverName = ServerMetadataCacheIT.getUtility().getHBaseCluster().getRegionServer(0).getServerName();
    }

    @Before
    public void resetMetrics() {
        GlobalClientMetrics.GLOBAL_CLIENT_STALE_METADATA_CACHE_EXCEPTION_COUNTER.getMetric().reset();
    }

    @After
    public void resetMetadataCache() {
        ServerMetadataCacheTestImpl.resetCache();
    }

    private ServerMetadataCacheTestImpl getServerMetadataCache() {
        String phoenixRegionServerEndpoint = config.get("hbase.coprocessor.regionserver.classes");
        Assert.assertNotNull((Object)phoenixRegionServerEndpoint);
        RegionServerCoprocessor coproc = (RegionServerCoprocessor)ServerMetadataCacheIT.getUtility().getHBaseCluster().getRegionServer(0).getRegionServerCoprocessorHost().findCoprocessor(phoenixRegionServerEndpoint);
        Assert.assertNotNull((Object)coproc);
        ServerMetadataCache cache = ((PhoenixRegionServerEndpointTestImpl)coproc).getServerMetadataCache();
        Assert.assertNotNull((Object)cache);
        return (ServerMetadataCacheTestImpl)cache;
    }

    @Test
    public void testCacheForBaseTable() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableNameStr = ServerMetadataCacheIT.generateUniqueName();
        ConnectionQueryServices spyCQS = (ConnectionQueryServices)Mockito.spy((Object)driver.getConnectionQueryServices(ServerMetadataCacheIT.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES)));
        try (PhoenixConnection conn = spyCQS.connect(ServerMetadataCacheIT.getUrl(), props);){
            conn.setAutoCommit(false);
            this.createTable((Connection)conn, tableNameStr);
            PTable pTable = PhoenixRuntime.getTableNoCache((Connection)conn, (String)tableNameStr);
            ServerMetadataCacheTestImpl cache = this.getServerMetadataCache();
            cache.setConnectionForTesting((Connection)conn);
            byte[] tableName = Bytes.toBytes((String)tableNameStr);
            long lastDDLTimestampFromCache = cache.getLastDDLTimestampForTable(null, null, tableName);
            Assert.assertEquals((long)pTable.getLastDDLTimestamp(), (long)lastDDLTimestampFromCache);
            ((ConnectionQueryServices)Mockito.verify((Object)spyCQS, (VerificationMode)Mockito.times((int)2))).getTable((PName)ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.eq((Object)tableName), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
            cache.getLastDDLTimestampForTable(null, null, tableName);
            cache.getLastDDLTimestampForTable(null, null, tableName);
            ((ConnectionQueryServices)Mockito.verify((Object)spyCQS, (VerificationMode)Mockito.times((int)2))).getTable((PName)ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.eq((Object)tableName), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
        }
    }

    @Test
    public void testCacheForGlobalView() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableNameStr = ServerMetadataCacheIT.generateUniqueName();
        ConnectionQueryServices spyCQS = (ConnectionQueryServices)Mockito.spy((Object)driver.getConnectionQueryServices(ServerMetadataCacheIT.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES)));
        try (PhoenixConnection conn = spyCQS.connect(ServerMetadataCacheIT.getUrl(), props);){
            conn.setAutoCommit(false);
            this.createTable((Connection)conn, tableNameStr);
            String whereClause = " WHERE v1 = 1000";
            String viewNameStr = ServerMetadataCacheIT.generateUniqueName();
            this.createViewWhereClause((Connection)conn, tableNameStr, viewNameStr, whereClause);
            PTable viewTable = PhoenixRuntime.getTableNoCache((Connection)conn, (String)viewNameStr);
            ServerMetadataCacheTestImpl cache = this.getServerMetadataCache();
            cache.setConnectionForTesting((Connection)conn);
            long lastDDLTimestampFromCache = cache.getLastDDLTimestampForTable(null, null, Bytes.toBytes((String)viewNameStr));
            byte[] viewNameBytes = Bytes.toBytes((String)viewNameStr);
            Assert.assertEquals((long)viewTable.getLastDDLTimestamp(), (long)lastDDLTimestampFromCache);
            ((ConnectionQueryServices)Mockito.verify((Object)spyCQS, (VerificationMode)Mockito.times((int)2))).getTable((PName)ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.eq((Object)viewNameBytes), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
            cache.getLastDDLTimestampForTable(null, null, viewNameBytes);
            cache.getLastDDLTimestampForTable(null, null, viewNameBytes);
            ((ConnectionQueryServices)Mockito.verify((Object)spyCQS, (VerificationMode)Mockito.times((int)2))).getTable((PName)ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.eq((Object)viewNameBytes), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
        }
    }

    @Test
    public void testCacheForTenantView() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableNameStr = ServerMetadataCacheIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(ServerMetadataCacheIT.getUrl(), props);){
            conn.setAutoCommit(false);
            this.createTable(conn, tableNameStr);
        }
        String tenantId = "T_" + ServerMetadataCacheIT.generateUniqueName();
        Properties tenantProps = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        tenantProps.setProperty("TenantId", tenantId);
        String whereClause = " WHERE v1 = 1000";
        String tenantViewNameStr = ServerMetadataCacheIT.generateUniqueName();
        ConnectionQueryServices spyCQS = (ConnectionQueryServices)Mockito.spy((Object)driver.getConnectionQueryServices(ServerMetadataCacheIT.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES)));
        try (PhoenixConnection conn = spyCQS.connect(ServerMetadataCacheIT.getUrl(), tenantProps);){
            this.createViewWhereClause((Connection)conn, tableNameStr, tenantViewNameStr, whereClause);
            PTable tenantViewTable = PhoenixRuntime.getTableNoCache((Connection)conn, (String)tenantViewNameStr);
            ServerMetadataCacheTestImpl cache = this.getServerMetadataCache();
            cache.setConnectionForTesting((Connection)conn);
            byte[] tenantIDBytes = Bytes.toBytes((String)tenantId);
            long lastDDLTimestampFromCache = cache.getLastDDLTimestampForTable(tenantIDBytes, null, Bytes.toBytes((String)tenantViewNameStr));
            Assert.assertEquals((long)tenantViewTable.getLastDDLTimestamp(), (long)lastDDLTimestampFromCache);
            byte[] tenantViewNameBytes = Bytes.toBytes((String)tenantViewNameStr);
            ((ConnectionQueryServices)Mockito.verify((Object)spyCQS, (VerificationMode)Mockito.times((int)2))).getTable((PName)ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.eq((Object)tenantViewNameBytes), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
            cache.getLastDDLTimestampForTable(tenantIDBytes, null, Bytes.toBytes((String)tenantViewNameStr));
            cache.getLastDDLTimestampForTable(tenantIDBytes, null, Bytes.toBytes((String)tenantViewNameStr));
            ((ConnectionQueryServices)Mockito.verify((Object)spyCQS, (VerificationMode)Mockito.times((int)2))).getTable((PName)ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.eq((Object)tenantViewNameBytes), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
        }
    }

    @Test
    public void testInvalidateCacheForBaseTable() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableNameStr = ServerMetadataCacheIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(ServerMetadataCacheIT.getUrl(), props);){
            conn.setAutoCommit(false);
            this.createTable(conn, tableNameStr);
            PTable pTable = PhoenixRuntime.getTableNoCache((Connection)conn, (String)tableNameStr);
            ServerMetadataCacheTestImpl cache = this.getServerMetadataCache();
            cache.setConnectionForTesting(conn);
            byte[] tableName = Bytes.toBytes((String)tableNameStr);
            long lastDDLTimestampFromCache = cache.getLastDDLTimestampForTable(null, null, tableName);
            Assert.assertEquals((long)pTable.getLastDDLTimestamp(), (long)lastDDLTimestampFromCache);
            cache.invalidate(null, null, tableName);
            Assert.assertNull((Object)cache.getLastDDLTimestampForTableFromCacheOnly(null, null, tableName));
        }
    }

    @Test
    public void testInvalidateCacheForBaseTableWithSchemaName() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String schemaName = ServerMetadataCacheIT.generateUniqueName();
        String tableName = ServerMetadataCacheIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        try (Connection conn = DriverManager.getConnection(ServerMetadataCacheIT.getUrl(), props);){
            conn.setAutoCommit(false);
            this.createTable(conn, fullTableName);
            PTable pTable = PhoenixRuntime.getTableNoCache((Connection)conn, (String)fullTableName);
            ServerMetadataCacheTestImpl cache = this.getServerMetadataCache();
            cache.setConnectionForTesting(conn);
            byte[] tableNameBytes = Bytes.toBytes((String)fullTableName);
            long lastDDLTimestampFromCache = cache.getLastDDLTimestampForTable(null, Bytes.toBytes((String)schemaName), Bytes.toBytes((String)tableName));
            Assert.assertEquals((long)pTable.getLastDDLTimestamp(), (long)lastDDLTimestampFromCache);
            cache.invalidate(null, Bytes.toBytes((String)schemaName), Bytes.toBytes((String)tableName));
            Assert.assertNull((Object)cache.getLastDDLTimestampForTableFromCacheOnly(null, Bytes.toBytes((String)schemaName), Bytes.toBytes((String)tableName)));
        }
    }

    @Test
    public void testInvalidateCacheForTenantView() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableNameStr = ServerMetadataCacheIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(ServerMetadataCacheIT.getUrl(), props);){
            conn.setAutoCommit(false);
            this.createTable(conn, tableNameStr);
        }
        String tenantId = "T_" + ServerMetadataCacheIT.generateUniqueName();
        Properties tenantProps = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        tenantProps.setProperty("TenantId", tenantId);
        String whereClause = " WHERE V1 = 1000";
        String tenantViewNameStr = ServerMetadataCacheIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(ServerMetadataCacheIT.getUrl(), tenantProps);){
            this.createViewWhereClause(conn, tableNameStr, tenantViewNameStr, whereClause);
            PTable tenantViewTable = PhoenixRuntime.getTableNoCache((Connection)conn, (String)tenantViewNameStr);
            ServerMetadataCacheTestImpl cache = this.getServerMetadataCache();
            cache.setConnectionForTesting(conn);
            byte[] tenantIDBytes = Bytes.toBytes((String)tenantId);
            byte[] tenantViewNameBytes = Bytes.toBytes((String)tenantViewNameStr);
            long lastDDLTimestampFromCache = cache.getLastDDLTimestampForTable(tenantIDBytes, null, tenantViewNameBytes);
            Assert.assertEquals((long)tenantViewTable.getLastDDLTimestamp(), (long)lastDDLTimestampFromCache);
            cache.invalidate(tenantIDBytes, null, tenantViewNameBytes);
            Assert.assertNull((Object)cache.getLastDDLTimestampForTableFromCacheOnly(tenantIDBytes, null, tenantViewNameBytes));
        }
    }

    @Test
    public void testInvalidateCacheForBaseTableWithAlterStatement() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableNameStr = ServerMetadataCacheIT.generateUniqueName();
        byte[] tableNameBytes = Bytes.toBytes((String)tableNameStr);
        ServerMetadataCacheTestImpl cache = this.getServerMetadataCache();
        try (Connection conn = DriverManager.getConnection(ServerMetadataCacheIT.getUrl(), props);){
            conn.setAutoCommit(false);
            this.createTable(conn, tableNameStr);
            PTable pTable = PhoenixRuntime.getTableNoCache((Connection)conn, (String)tableNameStr);
            long lastDDLTimestamp = pTable.getLastDDLTimestamp();
            Assert.assertEquals((long)lastDDLTimestamp, (long)cache.getLastDDLTimestampForTable(null, null, tableNameBytes));
            String alterDDLStmt = "ALTER TABLE " + tableNameStr + " SET DISABLE_WAL = true";
            conn.createStatement().execute(alterDDLStmt);
            Assert.assertNull((Object)cache.getLastDDLTimestampForTableFromCacheOnly(null, null, tableNameBytes));
            long lastDDLTimestampAfterAlterStmt = cache.getLastDDLTimestampForTable(null, null, tableNameBytes);
            Assert.assertNotNull((Object)lastDDLTimestampAfterAlterStmt);
            Assert.assertTrue((lastDDLTimestampAfterAlterStmt > lastDDLTimestamp ? 1 : 0) != 0);
        }
    }

    @Test
    public void testInvalidateCacheForBaseTableWithDropTableStatement() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableNameStr = ServerMetadataCacheIT.generateUniqueName();
        byte[] tableNameBytes = Bytes.toBytes((String)tableNameStr);
        ServerMetadataCacheTestImpl cache = this.getServerMetadataCache();
        try (Connection conn = DriverManager.getConnection(ServerMetadataCacheIT.getUrl(), props);){
            conn.setAutoCommit(false);
            this.createTable(conn, tableNameStr);
            PTable pTable = PhoenixRuntime.getTableNoCache((Connection)conn, (String)tableNameStr);
            long lastDDLTimestamp = pTable.getLastDDLTimestamp();
            Assert.assertEquals((long)lastDDLTimestamp, (long)cache.getLastDDLTimestampForTable(null, null, tableNameBytes));
            Assert.assertNotNull((Object)cache.getLastDDLTimestampForTableFromCacheOnly(null, null, tableNameBytes));
            String alterDDLStmt = "DROP TABLE " + tableNameStr;
            conn.createStatement().execute(alterDDLStmt);
            Assert.assertNull((Object)cache.getLastDDLTimestampForTableFromCacheOnly(null, null, tableNameBytes));
        }
    }

    @Test
    public void testInvalidateCacheForBaseTableWithUpdateIndexStatement() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String url = QueryUtil.getConnectionUrl((Properties)props, (Configuration)config, (String)"client");
        String tableNameStr = "TBL_" + ServerMetadataCacheIT.generateUniqueName();
        String indexNameStr = "IND_" + ServerMetadataCacheIT.generateUniqueName();
        byte[] indexNameBytes = Bytes.toBytes((String)indexNameStr);
        ServerMetadataCacheTestImpl cache = this.getServerMetadataCache();
        try (Connection conn = DriverManager.getConnection(url, props);){
            conn.setAutoCommit(false);
            this.createTable(conn, tableNameStr);
            String indexDDLStmt = "CREATE INDEX " + indexNameStr + " ON " + tableNameStr + "(v1)";
            conn.createStatement().execute(indexDDLStmt);
            TestUtil.waitForIndexState(conn, indexNameStr, PIndexState.ACTIVE);
            PTable indexTable = PhoenixRuntime.getTableNoCache((Connection)conn, (String)indexNameStr);
            long lastDDLTimestamp = indexTable.getLastDDLTimestamp();
            Assert.assertEquals((long)lastDDLTimestamp, (long)cache.getLastDDLTimestampForTable(null, null, indexNameBytes));
            Thread.sleep(1L);
            String disableIndexDDL = "ALTER INDEX " + indexNameStr + " ON " + tableNameStr + " DISABLE";
            conn.createStatement().execute(disableIndexDDL);
            TestUtil.waitForIndexState(conn, indexNameStr, PIndexState.DISABLE);
            Assert.assertNull((Object)cache.getLastDDLTimestampForTableFromCacheOnly(null, null, indexNameBytes));
            long lastDDLTimestampAfterUpdateIndexStmt = cache.getLastDDLTimestampForTable(null, null, indexNameBytes);
            Assert.assertNotNull((Object)lastDDLTimestampAfterUpdateIndexStmt);
            Assert.assertTrue((lastDDLTimestampAfterUpdateIndexStmt > lastDDLTimestamp ? 1 : 0) != 0);
        }
    }

    @Test
    public void testUpdateLastDDLTimestampTableAfterIndexCreation() throws Exception {
        String tableName = ServerMetadataCacheIT.generateUniqueName();
        byte[] tableNameBytes = Bytes.toBytes((String)tableName);
        String indexName = ServerMetadataCacheIT.generateUniqueName();
        byte[] indexNameBytes = Bytes.toBytes((String)indexName);
        ServerMetadataCacheTestImpl cache = this.getServerMetadataCache();
        try (Connection conn = DriverManager.getConnection(ServerMetadataCacheIT.getUrl());){
            conn.setAutoCommit(true);
            this.createTable(conn, tableName);
            long tableLastDDLTimestampBeforeIndexCreation = this.getLastDDLTimestamp(tableName);
            Assert.assertNotNull((Object)cache.getLastDDLTimestampForTable(null, null, tableNameBytes));
            Thread.sleep(1L);
            this.createIndex(conn, tableName, indexName, "v1");
            Assert.assertNull((Object)cache.getLastDDLTimestampForTableFromCacheOnly(null, null, tableNameBytes));
            long tableLastDDLTimestampAfterIndexCreation = this.getLastDDLTimestamp(tableName);
            Assert.assertNotNull((Object)tableLastDDLTimestampAfterIndexCreation);
            Assert.assertTrue((tableLastDDLTimestampAfterIndexCreation > tableLastDDLTimestampBeforeIndexCreation ? 1 : 0) != 0);
            long indexLastDDLTimestampAfterCreation = this.getLastDDLTimestamp(indexName);
            Assert.assertNotNull((Object)indexLastDDLTimestampAfterCreation);
            Thread.sleep(1L);
            this.dropIndex(conn, tableName, indexName);
            Assert.assertNull((Object)cache.getLastDDLTimestampForTableFromCacheOnly(null, null, tableNameBytes));
            Assert.assertNull((Object)cache.getLastDDLTimestampForTableFromCacheOnly(null, null, indexNameBytes));
            long tableLastDDLTimestampAfterIndexDeletion = this.getLastDDLTimestamp(tableName);
            Assert.assertNotNull((Object)tableLastDDLTimestampAfterIndexDeletion);
            Assert.assertTrue((tableLastDDLTimestampAfterIndexDeletion > tableLastDDLTimestampAfterIndexCreation ? 1 : 0) != 0);
        }
    }

    @Test
    public void testUpdateLastDDLTimestampViewAfterIndexCreation() throws Exception {
        String tableName = "T_" + ServerMetadataCacheIT.generateUniqueName();
        String globalViewName = "GV_" + ServerMetadataCacheIT.generateUniqueName();
        byte[] globalViewNameBytes = Bytes.toBytes((String)globalViewName);
        String globalViewIndexName = "GV_IDX_" + ServerMetadataCacheIT.generateUniqueName();
        byte[] globalViewIndexNameBytes = Bytes.toBytes((String)globalViewIndexName);
        ServerMetadataCacheTestImpl cache = this.getServerMetadataCache();
        try (Connection conn = DriverManager.getConnection(ServerMetadataCacheIT.getUrl());
             Statement stmt = conn.createStatement();){
            String whereClause = " WHERE v1 < 1000";
            this.createTable(conn, tableName);
            this.createViewWhereClause(conn, tableName, globalViewName, whereClause);
            Assert.assertNotNull((Object)cache.getLastDDLTimestampForTable(null, null, globalViewNameBytes));
            long viewLastDDLTimestampBeforeIndexCreation = this.getLastDDLTimestamp(globalViewName);
            this.createIndex(conn, globalViewName, globalViewIndexName, "v1");
            Assert.assertNull((Object)cache.getLastDDLTimestampForTableFromCacheOnly(null, null, globalViewNameBytes));
            long viewLastDDLTimestampAfterIndexCreation = this.getLastDDLTimestamp(globalViewName);
            Assert.assertTrue((viewLastDDLTimestampAfterIndexCreation > viewLastDDLTimestampBeforeIndexCreation ? 1 : 0) != 0);
            long indexLastDDLTimestampAfterCreation = this.getLastDDLTimestamp(globalViewIndexName);
            Assert.assertNotNull((Object)indexLastDDLTimestampAfterCreation);
            Thread.sleep(1L);
            this.dropIndex(conn, globalViewName, globalViewIndexName);
            Assert.assertNull((Object)cache.getLastDDLTimestampForTableFromCacheOnly(null, null, globalViewNameBytes));
            Assert.assertNull((Object)cache.getLastDDLTimestampForTableFromCacheOnly(null, null, globalViewIndexNameBytes));
            long viewLastDDLTimestampAfterIndexDeletion = this.getLastDDLTimestamp(globalViewName);
            Assert.assertNotNull((Object)viewLastDDLTimestampAfterIndexDeletion);
            Assert.assertTrue((viewLastDDLTimestampAfterIndexDeletion > viewLastDDLTimestampAfterIndexCreation ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSelectQueryWithOldDDLTimestamp() throws SQLException {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String url1 = QueryUtil.getConnectionUrl((Properties)props, (Configuration)config, (String)"client1");
        String url2 = QueryUtil.getConnectionUrl((Properties)props, (Configuration)config, (String)"client2");
        String tableName = ServerMetadataCacheIT.generateUniqueName();
        ConnectionQueryServices spyCqs1 = (ConnectionQueryServices)Mockito.spy((Object)driver.getConnectionQueryServices(url1, props));
        ConnectionQueryServices spyCqs2 = (ConnectionQueryServices)Mockito.spy((Object)driver.getConnectionQueryServices(url2, props));
        try (PhoenixConnection conn1 = spyCqs1.connect(url1, props);
             PhoenixConnection conn2 = spyCqs2.connect(url2, props);){
            this.createTable((Connection)conn1, tableName);
            this.upsert((Connection)conn1, tableName, true);
            this.query((Connection)conn2, tableName);
            int expectedNumCacheUpdates = 1;
            ((ConnectionQueryServices)Mockito.verify((Object)spyCqs2, (VerificationMode)Mockito.times((int)expectedNumCacheUpdates))).addTable((PTable)ArgumentMatchers.any(PTable.class), ArgumentMatchers.anyLong());
            this.alterTableAddColumn((Connection)conn1, tableName, "newCol1");
            Mockito.reset((Object[])new ConnectionQueryServices[]{spyCqs2});
            this.query((Connection)conn2, tableName);
            expectedNumCacheUpdates = 1;
            ((ConnectionQueryServices)Mockito.verify((Object)spyCqs2, (VerificationMode)Mockito.times((int)expectedNumCacheUpdates))).addTable((PTable)ArgumentMatchers.any(PTable.class), ArgumentMatchers.anyLong());
            Assert.assertEquals((String)"Client should have encountered a StaleMetadataCacheException", (long)1L, (long)GlobalClientMetrics.GLOBAL_CLIENT_STALE_METADATA_CACHE_EXCEPTION_COUNTER.getMetric().getValue());
            this.query((Connection)conn2, tableName);
            ((ConnectionQueryServices)Mockito.verify((Object)spyCqs2, (VerificationMode)Mockito.times((int)expectedNumCacheUpdates))).addTable((PTable)ArgumentMatchers.any(PTable.class), ArgumentMatchers.anyLong());
            Assert.assertEquals((String)"Client should have encountered a StaleMetadataCacheException", (long)1L, (long)GlobalClientMetrics.GLOBAL_CLIENT_STALE_METADATA_CACHE_EXCEPTION_COUNTER.getMetric().getValue());
        }
    }

    @Test
    public void testSelectQueryServerSideExceptionInValidation() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String url1 = QueryUtil.getConnectionUrl((Properties)props, (Configuration)config, (String)"client1");
        String url2 = QueryUtil.getConnectionUrl((Properties)props, (Configuration)config, (String)"client2");
        String tableName = ServerMetadataCacheIT.generateUniqueName();
        ConnectionQueryServices spyCqs1 = (ConnectionQueryServices)Mockito.spy((Object)driver.getConnectionQueryServices(url1, props));
        ConnectionQueryServices spyCqs2 = (ConnectionQueryServices)Mockito.spy((Object)driver.getConnectionQueryServices(url2, props));
        ServerMetadataCacheTestImpl cache = null;
        try (PhoenixConnection conn1 = spyCqs1.connect(url1, props);
             PhoenixConnection conn2 = spyCqs2.connect(url2, props);){
            this.createTable((Connection)conn1, tableName);
            this.upsert((Connection)conn1, tableName, true);
            cache = this.getServerMetadataCache();
            ServerMetadataCacheTestImpl spyCache = (ServerMetadataCacheTestImpl)((Object)Mockito.spy((Object)((Object)cache)));
            ((ServerMetadataCacheTestImpl)((Object)Mockito.doThrow((Throwable[])new Throwable[]{new SQLException("FAIL")}).doCallRealMethod().when((Object)spyCache))).getLastDDLTimestampForTable((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.eq((Object)Bytes.toBytes((String)tableName)));
            ServerMetadataCacheTestImpl.setInstance(serverName, spyCache);
            this.query((Connection)conn2, tableName);
            ((ConnectionQueryServices)Mockito.verify((Object)spyCqs2, (VerificationMode)Mockito.times((int)1))).refreshLiveRegionServers();
        }
    }

    @Test
    public void testSelectQueryWithOldDDLTimestampWithExceptionRetry() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String url1 = QueryUtil.getConnectionUrl((Properties)props, (Configuration)config, (String)"client1");
        String url2 = QueryUtil.getConnectionUrl((Properties)props, (Configuration)config, (String)"client2");
        String tableName = ServerMetadataCacheIT.generateUniqueName();
        ConnectionQueryServices spyCqs1 = (ConnectionQueryServices)Mockito.spy((Object)driver.getConnectionQueryServices(url1, props));
        ConnectionQueryServices spyCqs2 = (ConnectionQueryServices)Mockito.spy((Object)driver.getConnectionQueryServices(url2, props));
        ServerMetadataCacheTestImpl cache = null;
        try (PhoenixConnection conn1 = spyCqs1.connect(url1, props);
             PhoenixConnection conn2 = spyCqs2.connect(url2, props);){
            this.createTable((Connection)conn1, tableName);
            this.upsert((Connection)conn1, tableName, true);
            this.query((Connection)conn2, tableName);
            int expectedNumCacheUpdates = 1;
            ((ConnectionQueryServices)Mockito.verify((Object)spyCqs2, (VerificationMode)Mockito.times((int)expectedNumCacheUpdates))).addTable((PTable)ArgumentMatchers.any(PTable.class), ArgumentMatchers.anyLong());
            this.alterTableAddColumn((Connection)conn1, tableName, "newCol1");
            Mockito.reset((Object[])new ConnectionQueryServices[]{spyCqs2});
            cache = this.getServerMetadataCache();
            ServerMetadataCacheTestImpl spyCache = (ServerMetadataCacheTestImpl)((Object)Mockito.spy((Object)((Object)cache)));
            ((ServerMetadataCacheTestImpl)((Object)Mockito.doThrow((Throwable[])new Throwable[]{new SQLException("FAIL")}).doCallRealMethod().when((Object)spyCache))).getLastDDLTimestampForTable((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.eq((Object)Bytes.toBytes((String)tableName)));
            ServerMetadataCacheTestImpl.setInstance(serverName, spyCache);
            this.query((Connection)conn2, tableName);
            expectedNumCacheUpdates = 1;
            ((ConnectionQueryServices)Mockito.verify((Object)spyCqs2, (VerificationMode)Mockito.times((int)expectedNumCacheUpdates))).addTable((PTable)ArgumentMatchers.any(PTable.class), ArgumentMatchers.anyLong());
            ((ConnectionQueryServices)Mockito.verify((Object)spyCqs2, (VerificationMode)Mockito.times((int)1))).refreshLiveRegionServers();
        }
    }

    @Test
    public void testSelectQueryFails() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String url1 = QueryUtil.getConnectionUrl((Properties)props, (Configuration)config, (String)"client1");
        String url2 = QueryUtil.getConnectionUrl((Properties)props, (Configuration)config, (String)"client2");
        String tableName = ServerMetadataCacheIT.generateUniqueName();
        ConnectionQueryServices spyCqs1 = (ConnectionQueryServices)Mockito.spy((Object)driver.getConnectionQueryServices(url1, props));
        ConnectionQueryServices spyCqs2 = (ConnectionQueryServices)Mockito.spy((Object)driver.getConnectionQueryServices(url2, props));
        ServerMetadataCacheTestImpl cache = null;
        try (PhoenixConnection conn1 = spyCqs1.connect(url1, props);
             PhoenixConnection conn2 = spyCqs2.connect(url2, props);){
            this.createTable((Connection)conn1, tableName);
            this.upsert((Connection)conn1, tableName, true);
            cache = this.getServerMetadataCache();
            ServerMetadataCacheTestImpl spyCache = (ServerMetadataCacheTestImpl)((Object)Mockito.spy((Object)((Object)cache)));
            SQLException e = new SQLException("FAIL");
            ((ServerMetadataCacheTestImpl)((Object)Mockito.doThrow((Throwable[])new Throwable[]{e}).when((Object)spyCache))).getLastDDLTimestampForTable((byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (byte[])ArgumentMatchers.eq((Object)Bytes.toBytes((String)tableName)));
            ServerMetadataCacheTestImpl.setInstance(serverName, spyCache);
            this.query((Connection)conn2, tableName);
            Assert.fail((String)"Query should have thrown Exception");
        }
        catch (Exception e) {
            Assert.assertTrue((String)"SQLException was not thrown when last ddl timestamp validation encountered errors twice.", (boolean)(e instanceof SQLException));
        }
    }

    @Test
    public void testSelectQueryOnView() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String url1 = QueryUtil.getConnectionUrl((Properties)props, (Configuration)config, (String)"client1");
        String url2 = QueryUtil.getConnectionUrl((Properties)props, (Configuration)config, (String)"client2");
        String tableName = ServerMetadataCacheIT.generateUniqueName();
        ConnectionQueryServices spyCqs1 = (ConnectionQueryServices)Mockito.spy((Object)driver.getConnectionQueryServices(url1, props));
        ConnectionQueryServices spyCqs2 = (ConnectionQueryServices)Mockito.spy((Object)driver.getConnectionQueryServices(url2, props));
        try (PhoenixConnection conn1 = spyCqs1.connect(url1, props);
             PhoenixConnection conn2 = spyCqs2.connect(url2, props);){
            this.createTable((Connection)conn1, tableName);
            this.upsert((Connection)conn1, tableName, true);
            String view1 = ServerMetadataCacheIT.generateUniqueName();
            String view2 = ServerMetadataCacheIT.generateUniqueName();
            this.createView((Connection)conn1, tableName, view1);
            this.createView((Connection)conn1, view1, view2);
            this.query((Connection)conn2, view2);
            int expectedNumCacheUpdates = 3;
            ((ConnectionQueryServices)Mockito.verify((Object)spyCqs2, (VerificationMode)Mockito.times((int)expectedNumCacheUpdates))).addTable((PTable)ArgumentMatchers.any(PTable.class), ArgumentMatchers.anyLong());
            this.alterViewAddColumn((Connection)conn1, view1, "foo");
            Mockito.reset((Object[])new ConnectionQueryServices[]{spyCqs2});
            this.query((Connection)conn2, view2);
            ((ConnectionQueryServices)Mockito.verify((Object)spyCqs2, (VerificationMode)Mockito.times((int)1))).getTable((PName)ArgumentMatchers.eq(null), (byte[])ArgumentMatchers.any(byte[].class), (byte[])ArgumentMatchers.eq((Object)PVarchar.INSTANCE.toBytes((Object)tableName)), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
            ((ConnectionQueryServices)Mockito.verify((Object)spyCqs2, (VerificationMode)Mockito.times((int)1))).getTable((PName)ArgumentMatchers.eq(null), (byte[])ArgumentMatchers.any(byte[].class), (byte[])ArgumentMatchers.eq((Object)PVarchar.INSTANCE.toBytes((Object)view1)), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
            ((ConnectionQueryServices)Mockito.verify((Object)spyCqs2, (VerificationMode)Mockito.times((int)1))).getTable((PName)ArgumentMatchers.eq(null), (byte[])ArgumentMatchers.any(byte[].class), (byte[])ArgumentMatchers.eq((Object)PVarchar.INSTANCE.toBytes((Object)view2)), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
            expectedNumCacheUpdates = 3;
            ((ConnectionQueryServices)Mockito.verify((Object)spyCqs2, (VerificationMode)Mockito.times((int)expectedNumCacheUpdates))).addTable((PTable)ArgumentMatchers.any(PTable.class), ArgumentMatchers.anyLong());
        }
    }

    @Test
    public void testSelectQueryOnSystemTables() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String url = QueryUtil.getConnectionUrl((Properties)props, (Configuration)config, (String)"client");
        ConnectionQueryServices cqs = driver.getConnectionQueryServices(url, props);
        try (PhoenixConnection conn = cqs.connect(url, props);){
            this.query((Connection)conn, PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME);
            this.query((Connection)conn, PhoenixDatabaseMetaData.SYSTEM_TASK_NAME);
            this.query((Connection)conn, PhoenixDatabaseMetaData.SYSTEM_CHILD_LINK_NAME);
            this.query((Connection)conn, PhoenixDatabaseMetaData.SYSTEM_LOG_NAME);
        }
    }

    @Test
    public void testSystemTablesBootstrap() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String url = QueryUtil.getConnectionUrl((Properties)props, (Configuration)config);
        ConnectionQueryServices cqs = driver.getConnectionQueryServices(url, props);
        try (PhoenixConnection conn = cqs.connect(url, props);){
            this.query((Connection)conn, PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME);
            this.query((Connection)conn, PhoenixDatabaseMetaData.SYSTEM_TASK_NAME);
            this.query((Connection)conn, PhoenixDatabaseMetaData.SYSTEM_CHILD_LINK_NAME);
            this.query((Connection)conn, PhoenixDatabaseMetaData.SYSTEM_LOG_NAME);
        }
    }

    @Test
    public void testQueryViewAfterParentRemovedFromCache() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String url = QueryUtil.getConnectionUrl((Properties)props, (Configuration)config);
        ConnectionQueryServices cqs = driver.getConnectionQueryServices(url, props);
        String tableName = ServerMetadataCacheIT.generateUniqueName();
        String viewName = ServerMetadataCacheIT.generateUniqueName();
        try (PhoenixConnection conn = cqs.connect(url, props);){
            this.createTable((Connection)conn, tableName);
            this.createView((Connection)conn, tableName, viewName);
            this.query((Connection)conn, viewName);
            this.alterTableDropColumn((Connection)conn, tableName, "v2");
            this.query((Connection)conn, viewName);
        }
        catch (TableNotFoundException e) {
            Assert.fail((String)"TableNotFoundException should not be encountered by client.");
        }
    }

    @Test
    public void testSelectQueryAfterAlterIndex() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String url1 = QueryUtil.getConnectionUrl((Properties)props, (Configuration)config, (String)"client1");
        String url2 = QueryUtil.getConnectionUrl((Properties)props, (Configuration)config, (String)"client2");
        String tableName = ServerMetadataCacheIT.generateUniqueName();
        String indexName = ServerMetadataCacheIT.generateUniqueName();
        ConnectionQueryServices spyCqs1 = (ConnectionQueryServices)Mockito.spy((Object)driver.getConnectionQueryServices(url1, props));
        ConnectionQueryServices spyCqs2 = (ConnectionQueryServices)Mockito.spy((Object)driver.getConnectionQueryServices(url2, props));
        try (PhoenixConnection conn1 = spyCqs1.connect(url1, props);
             PhoenixConnection conn2 = spyCqs2.connect(url2, props);){
            this.createTable((Connection)conn1, tableName);
            this.createIndex((Connection)conn1, tableName, indexName, "v1");
            TestUtil.waitForIndexState((Connection)conn1, indexName, PIndexState.ACTIVE);
            this.query((Connection)conn2, tableName);
            ((ConnectionQueryServices)Mockito.verify((Object)spyCqs2, (VerificationMode)Mockito.times((int)1))).getTable((PName)ArgumentMatchers.eq(null), (byte[])ArgumentMatchers.any(byte[].class), (byte[])ArgumentMatchers.eq((Object)PVarchar.INSTANCE.toBytes((Object)tableName)), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
            ((ConnectionQueryServices)Mockito.verify((Object)spyCqs2, (VerificationMode)Mockito.times((int)1))).addTable((PTable)ArgumentMatchers.any(PTable.class), ArgumentMatchers.anyLong());
            this.alterIndexChangeState((Connection)conn1, tableName, indexName, " REBUILD");
            PhoenixStatement stmt = conn2.createStatement().unwrap(PhoenixStatement.class);
            stmt.executeQuery("SELECT k FROM " + tableName + " WHERE v1=1");
            Assert.assertEquals((String)"Query on secondary key should have used index.", (Object)indexName, (Object)stmt.getQueryPlan().getTableRef().getTable().getTableName().toString());
            ((ConnectionQueryServices)Mockito.verify((Object)spyCqs2, (VerificationMode)Mockito.times((int)2))).getTable((PName)ArgumentMatchers.eq(null), (byte[])ArgumentMatchers.any(byte[].class), (byte[])ArgumentMatchers.eq((Object)PVarchar.INSTANCE.toBytes((Object)tableName)), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
            ((ConnectionQueryServices)Mockito.verify((Object)spyCqs2, (VerificationMode)Mockito.times((int)1))).getTable((PName)ArgumentMatchers.eq(null), (byte[])ArgumentMatchers.any(byte[].class), (byte[])ArgumentMatchers.eq((Object)PVarchar.INSTANCE.toBytes((Object)indexName)), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
            ((ConnectionQueryServices)Mockito.verify((Object)spyCqs2, (VerificationMode)Mockito.times((int)3))).addTable((PTable)ArgumentMatchers.any(PTable.class), ArgumentMatchers.anyLong());
            this.queryWithIndex((Connection)conn2, tableName);
            ((ConnectionQueryServices)Mockito.verify((Object)spyCqs2, (VerificationMode)Mockito.times((int)2))).getTable((PName)ArgumentMatchers.eq(null), (byte[])ArgumentMatchers.any(byte[].class), (byte[])ArgumentMatchers.eq((Object)PVarchar.INSTANCE.toBytes((Object)tableName)), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
            ((ConnectionQueryServices)Mockito.verify((Object)spyCqs2, (VerificationMode)Mockito.times((int)3))).addTable((PTable)ArgumentMatchers.any(PTable.class), ArgumentMatchers.anyLong());
        }
    }

    @Test
    public void testSelectQueryAddIndex() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String url1 = QueryUtil.getConnectionUrl((Properties)props, (Configuration)config, (String)"client1");
        String url2 = QueryUtil.getConnectionUrl((Properties)props, (Configuration)config, (String)"client2");
        String tableName = ServerMetadataCacheIT.generateUniqueName();
        String indexName = ServerMetadataCacheIT.generateUniqueName();
        ConnectionQueryServices spyCqs1 = (ConnectionQueryServices)Mockito.spy((Object)driver.getConnectionQueryServices(url1, props));
        ConnectionQueryServices spyCqs2 = (ConnectionQueryServices)Mockito.spy((Object)driver.getConnectionQueryServices(url2, props));
        try (PhoenixConnection conn1 = spyCqs1.connect(url1, props);
             PhoenixConnection conn2 = spyCqs2.connect(url2, props);){
            this.createTable((Connection)conn1, tableName);
            this.query((Connection)conn2, tableName);
            this.createIndex((Connection)conn1, tableName, indexName, "v1");
            TestUtil.waitForIndexState((Connection)conn1, indexName, PIndexState.ACTIVE);
            PhoenixStatement stmt = conn2.createStatement().unwrap(PhoenixStatement.class);
            ResultSet rs = stmt.executeQuery("SELECT k FROM " + tableName + " WHERE v1=1");
            Assert.assertEquals((String)"Query on secondary key should have used index.", (Object)indexName, (Object)stmt.getQueryPlan().getContext().getCurrentTable().getTable().getName().getString());
        }
    }

    @Test
    public void testSelectQueryDropIndex() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String url1 = QueryUtil.getConnectionUrl((Properties)props, (Configuration)config, (String)"client1");
        String url2 = QueryUtil.getConnectionUrl((Properties)props, (Configuration)config, (String)"client2");
        String tableName = ServerMetadataCacheIT.generateUniqueName();
        String indexName = ServerMetadataCacheIT.generateUniqueName();
        ConnectionQueryServices spyCqs1 = (ConnectionQueryServices)Mockito.spy((Object)driver.getConnectionQueryServices(url1, props));
        ConnectionQueryServices spyCqs2 = (ConnectionQueryServices)Mockito.spy((Object)driver.getConnectionQueryServices(url2, props));
        try (PhoenixConnection conn1 = spyCqs1.connect(url1, props);
             PhoenixConnection conn2 = spyCqs2.connect(url2, props);){
            this.createTable((Connection)conn1, tableName);
            this.createIndex((Connection)conn1, tableName, indexName, "v1");
            this.query((Connection)conn2, tableName);
            this.dropIndex((Connection)conn1, tableName, indexName);
            PhoenixStatement stmt = conn2.createStatement().unwrap(PhoenixStatement.class);
            ResultSet rs = stmt.executeQuery("SELECT /*+ INDEX(" + tableName + " " + indexName + ") */ * FROM " + tableName + " WHERE v1=1");
            Assert.assertEquals((String)"Query should have used data table since index was dropped", (Object)tableName, (Object)stmt.getQueryPlan().getContext().getCurrentTable().getTable().getName().getString());
        }
    }

    @Test
    public void testUpsertMultipleTablesWithOldDDLTimestamp() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String url1 = QueryUtil.getConnectionUrl((Properties)props, (Configuration)config, (String)"client1");
        String url2 = QueryUtil.getConnectionUrl((Properties)props, (Configuration)config, (String)"client2");
        String tableName1 = ServerMetadataCacheIT.generateUniqueName();
        String tableName2 = ServerMetadataCacheIT.generateUniqueName();
        ConnectionQueryServices spyCqs1 = (ConnectionQueryServices)Mockito.spy((Object)driver.getConnectionQueryServices(url1, props));
        ConnectionQueryServices spyCqs2 = (ConnectionQueryServices)Mockito.spy((Object)driver.getConnectionQueryServices(url2, props));
        try (PhoenixConnection conn1 = spyCqs1.connect(url1, props);
             PhoenixConnection conn2 = spyCqs2.connect(url2, props);){
            this.createTable((Connection)conn1, tableName1);
            this.createTable((Connection)conn1, tableName2);
            this.query((Connection)conn2, tableName1);
            this.query((Connection)conn2, tableName2);
            this.alterTableAddColumn((Connection)conn1, tableName2, "col3");
            this.multiTableUpsert((Connection)conn2, tableName1, tableName2);
            ((ConnectionQueryServices)Mockito.verify((Object)spyCqs2, (VerificationMode)Mockito.times((int)2))).getTable((PName)ArgumentMatchers.eq(null), (byte[])ArgumentMatchers.any(byte[].class), (byte[])ArgumentMatchers.eq((Object)PVarchar.INSTANCE.toBytes((Object)tableName1)), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
            ((ConnectionQueryServices)Mockito.verify((Object)spyCqs2, (VerificationMode)Mockito.times((int)2))).getTable((PName)ArgumentMatchers.eq(null), (byte[])ArgumentMatchers.any(byte[].class), (byte[])ArgumentMatchers.eq((Object)PVarchar.INSTANCE.toBytes((Object)tableName2)), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
        }
    }

    @Test
    public void testUpsertViewWithOldDDLTimestamp() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String url1 = QueryUtil.getConnectionUrl((Properties)props, (Configuration)config, (String)"client1");
        String url2 = QueryUtil.getConnectionUrl((Properties)props, (Configuration)config, (String)"client2");
        String tableName = ServerMetadataCacheIT.generateUniqueName();
        String viewName1 = ServerMetadataCacheIT.generateUniqueName();
        String viewName2 = ServerMetadataCacheIT.generateUniqueName();
        ConnectionQueryServices spyCqs1 = (ConnectionQueryServices)Mockito.spy((Object)driver.getConnectionQueryServices(url1, props));
        ConnectionQueryServices spyCqs2 = (ConnectionQueryServices)Mockito.spy((Object)driver.getConnectionQueryServices(url2, props));
        try (PhoenixConnection conn1 = spyCqs1.connect(url1, props);
             PhoenixConnection conn2 = spyCqs2.connect(url2, props);){
            this.createTable((Connection)conn1, tableName);
            this.createView((Connection)conn1, tableName, viewName1);
            this.createView((Connection)conn1, viewName1, viewName2);
            this.query((Connection)conn2, viewName2);
            ((ConnectionQueryServices)Mockito.verify((Object)spyCqs2, (VerificationMode)Mockito.times((int)1))).getTable((PName)ArgumentMatchers.eq(null), (byte[])ArgumentMatchers.any(byte[].class), (byte[])ArgumentMatchers.eq((Object)PVarchar.INSTANCE.toBytes((Object)tableName)), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
            ((ConnectionQueryServices)Mockito.verify((Object)spyCqs2, (VerificationMode)Mockito.times((int)1))).getTable((PName)ArgumentMatchers.eq(null), (byte[])ArgumentMatchers.any(byte[].class), (byte[])ArgumentMatchers.eq((Object)PVarchar.INSTANCE.toBytes((Object)viewName1)), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
            ((ConnectionQueryServices)Mockito.verify((Object)spyCqs2, (VerificationMode)Mockito.times((int)1))).getTable((PName)ArgumentMatchers.eq(null), (byte[])ArgumentMatchers.any(byte[].class), (byte[])ArgumentMatchers.eq((Object)PVarchar.INSTANCE.toBytes((Object)viewName2)), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
            this.alterViewAddColumn((Connection)conn1, viewName1, "col3");
            this.upsert((Connection)conn2, viewName2, true);
            ((ConnectionQueryServices)Mockito.verify((Object)spyCqs2, (VerificationMode)Mockito.times((int)2))).getTable((PName)ArgumentMatchers.eq(null), (byte[])ArgumentMatchers.any(byte[].class), (byte[])ArgumentMatchers.eq((Object)PVarchar.INSTANCE.toBytes((Object)tableName)), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
            ((ConnectionQueryServices)Mockito.verify((Object)spyCqs2, (VerificationMode)Mockito.times((int)2))).getTable((PName)ArgumentMatchers.eq(null), (byte[])ArgumentMatchers.any(byte[].class), (byte[])ArgumentMatchers.eq((Object)PVarchar.INSTANCE.toBytes((Object)viewName1)), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
            ((ConnectionQueryServices)Mockito.verify((Object)spyCqs2, (VerificationMode)Mockito.times((int)2))).getTable((PName)ArgumentMatchers.eq(null), (byte[])ArgumentMatchers.any(byte[].class), (byte[])ArgumentMatchers.eq((Object)PVarchar.INSTANCE.toBytes((Object)viewName2)), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
            Assert.assertEquals((String)"Client should have encountered a StaleMetadataCacheException", (long)1L, (long)GlobalClientMetrics.GLOBAL_CLIENT_STALE_METADATA_CACHE_EXCEPTION_COUNTER.getMetric().getValue());
            this.upsert((Connection)conn2, viewName1, true);
            ((ConnectionQueryServices)Mockito.verify((Object)spyCqs2, (VerificationMode)Mockito.times((int)2))).getTable((PName)ArgumentMatchers.eq(null), (byte[])ArgumentMatchers.any(byte[].class), (byte[])ArgumentMatchers.eq((Object)PVarchar.INSTANCE.toBytes((Object)tableName)), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
            ((ConnectionQueryServices)Mockito.verify((Object)spyCqs2, (VerificationMode)Mockito.times((int)2))).getTable((PName)ArgumentMatchers.eq(null), (byte[])ArgumentMatchers.any(byte[].class), (byte[])ArgumentMatchers.eq((Object)PVarchar.INSTANCE.toBytes((Object)viewName1)), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
            ((ConnectionQueryServices)Mockito.verify((Object)spyCqs2, (VerificationMode)Mockito.times((int)2))).getTable((PName)ArgumentMatchers.eq(null), (byte[])ArgumentMatchers.any(byte[].class), (byte[])ArgumentMatchers.eq((Object)PVarchar.INSTANCE.toBytes((Object)viewName2)), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
            Assert.assertEquals((String)"Client should not have encountered another StaleMetadataCacheException", (long)1L, (long)GlobalClientMetrics.GLOBAL_CLIENT_STALE_METADATA_CACHE_EXCEPTION_COUNTER.getMetric().getValue());
        }
    }

    @Test
    public void testUpsertDroppedTable() throws SQLException {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String url1 = QueryUtil.getConnectionUrl((Properties)props, (Configuration)config, (String)"client1");
        String url2 = QueryUtil.getConnectionUrl((Properties)props, (Configuration)config, (String)"client2");
        String tableName = ServerMetadataCacheIT.generateUniqueName();
        ConnectionQueryServices spyCqs1 = (ConnectionQueryServices)Mockito.spy((Object)driver.getConnectionQueryServices(url1, props));
        ConnectionQueryServices spyCqs2 = (ConnectionQueryServices)Mockito.spy((Object)driver.getConnectionQueryServices(url2, props));
        try (PhoenixConnection conn1 = spyCqs1.connect(url1, props);
             PhoenixConnection conn2 = spyCqs2.connect(url2, props);){
            this.createTable((Connection)conn1, tableName);
            this.upsert((Connection)conn1, tableName, false);
            this.upsert((Connection)conn1, tableName, false);
            this.upsert((Connection)conn1, tableName, false);
            conn2.createStatement().execute("DROP TABLE " + tableName);
            conn1.commit();
            Assert.fail((String)"Commit should have failed with TableNotFoundException");
        }
        catch (Exception e) {
            Assert.assertTrue((String)"TableNotFoundException was not thrown when table was dropped concurrently with upserts.", (boolean)(e instanceof TableNotFoundException));
        }
    }

    @Test
    public void testUpsertDroppedTableColumn() throws SQLException {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String url1 = QueryUtil.getConnectionUrl((Properties)props, (Configuration)config, (String)"client1");
        String url2 = QueryUtil.getConnectionUrl((Properties)props, (Configuration)config, (String)"client2");
        String tableName = ServerMetadataCacheIT.generateUniqueName();
        ConnectionQueryServices spyCqs1 = (ConnectionQueryServices)Mockito.spy((Object)driver.getConnectionQueryServices(url1, props));
        ConnectionQueryServices spyCqs2 = (ConnectionQueryServices)Mockito.spy((Object)driver.getConnectionQueryServices(url2, props));
        try (PhoenixConnection conn1 = spyCqs1.connect(url1, props);
             PhoenixConnection conn2 = spyCqs2.connect(url2, props);){
            this.createTable((Connection)conn1, tableName);
            this.upsert((Connection)conn1, tableName, false);
            this.upsert((Connection)conn1, tableName, false);
            this.upsert((Connection)conn1, tableName, false);
            this.alterTableDropColumn((Connection)conn2, tableName, "v1");
            conn1.commit();
            Assert.fail((String)"Commit should have failed with ColumnNotFoundException");
        }
        catch (Exception e) {
            Assert.assertTrue((String)"ColumnNotFoundException was not thrown when column was dropped concurrently with upserts.", (boolean)(e instanceof ColumnNotFoundException));
        }
    }

    @Test
    public void testUpsertAddTableColumn() throws SQLException {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String url1 = QueryUtil.getConnectionUrl((Properties)props, (Configuration)config, (String)"client1");
        String url2 = QueryUtil.getConnectionUrl((Properties)props, (Configuration)config, (String)"client2");
        String tableName = ServerMetadataCacheIT.generateUniqueName();
        ConnectionQueryServices spyCqs1 = (ConnectionQueryServices)Mockito.spy((Object)driver.getConnectionQueryServices(url1, props));
        ConnectionQueryServices spyCqs2 = (ConnectionQueryServices)Mockito.spy((Object)driver.getConnectionQueryServices(url2, props));
        try (PhoenixConnection conn1 = spyCqs1.connect(url1, props);
             PhoenixConnection conn2 = spyCqs2.connect(url2, props);){
            this.createTable((Connection)conn1, tableName);
            this.upsert((Connection)conn1, tableName, false);
            this.upsert((Connection)conn1, tableName, false);
            this.upsert((Connection)conn1, tableName, false);
            this.alterTableAddColumn((Connection)conn2, tableName, "v5");
            conn1.commit();
        }
    }

    @Test
    public void testConcurrentUpsertIndexCreation() throws SQLException {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String url1 = QueryUtil.getConnectionUrl((Properties)props, (Configuration)config, (String)"client1");
        String url2 = QueryUtil.getConnectionUrl((Properties)props, (Configuration)config, (String)"client2");
        String tableName = ServerMetadataCacheIT.generateUniqueName();
        String indexName = ServerMetadataCacheIT.generateUniqueName();
        ConnectionQueryServices spyCqs1 = (ConnectionQueryServices)Mockito.spy((Object)driver.getConnectionQueryServices(url1, props));
        ConnectionQueryServices spyCqs2 = (ConnectionQueryServices)Mockito.spy((Object)driver.getConnectionQueryServices(url2, props));
        try (PhoenixConnection conn1 = spyCqs1.connect(url1, props);
             PhoenixConnection conn2 = spyCqs2.connect(url2, props);){
            this.createTable((Connection)conn1, tableName);
            this.upsert((Connection)conn1, tableName, false);
            this.upsert((Connection)conn1, tableName, false);
            this.upsert((Connection)conn1, tableName, false);
            this.createIndex((Connection)conn2, tableName, indexName, "v1");
            this.upsert((Connection)conn1, tableName, false);
            this.upsert((Connection)conn1, tableName, false);
            conn1.commit();
            ResultSet rs = conn1.createStatement().executeQuery("SELECT COUNT(*) FROM " + tableName);
            rs.next();
            int tableCount = rs.getInt(1);
            rs = conn1.createStatement().executeQuery("SELECT COUNT(*) FROM " + indexName);
            rs.next();
            int indexCount = rs.getInt(1);
            Assert.assertEquals((String)"All index mutations were not generated when index was created concurrently with upserts.", (long)tableCount, (long)indexCount);
        }
    }

    @Test
    public void testConcurrentUpsertDropIndex() throws SQLException {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String url1 = QueryUtil.getConnectionUrl((Properties)props, (Configuration)config, (String)"client1");
        String url2 = QueryUtil.getConnectionUrl((Properties)props, (Configuration)config, (String)"client2");
        String tableName = ServerMetadataCacheIT.generateUniqueName();
        String indexName = ServerMetadataCacheIT.generateUniqueName();
        ConnectionQueryServices spyCqs1 = (ConnectionQueryServices)Mockito.spy((Object)driver.getConnectionQueryServices(url1, props));
        ConnectionQueryServices spyCqs2 = (ConnectionQueryServices)Mockito.spy((Object)driver.getConnectionQueryServices(url2, props));
        try (PhoenixConnection conn1 = spyCqs1.connect(url1, props);
             PhoenixConnection conn2 = spyCqs2.connect(url2, props);){
            this.createTable((Connection)conn1, tableName);
            this.createIndex((Connection)conn1, tableName, indexName, "v1");
            this.upsert((Connection)conn1, tableName, false);
            this.upsert((Connection)conn1, tableName, false);
            this.upsert((Connection)conn1, tableName, false);
            this.dropIndex((Connection)conn2, tableName, indexName);
            this.upsert((Connection)conn1, tableName, false);
            this.upsert((Connection)conn1, tableName, false);
            conn1.commit();
        }
    }

    @Test
    public void testConcurrentUpsertIndexStateChange() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String url1 = QueryUtil.getConnectionUrl((Properties)props, (Configuration)config, (String)"client1");
        String url2 = QueryUtil.getConnectionUrl((Properties)props, (Configuration)config, (String)"client2");
        String tableName = ServerMetadataCacheIT.generateUniqueName();
        String indexName = ServerMetadataCacheIT.generateUniqueName();
        ConnectionQueryServices spyCqs1 = (ConnectionQueryServices)Mockito.spy((Object)driver.getConnectionQueryServices(url1, props));
        ConnectionQueryServices spyCqs2 = (ConnectionQueryServices)Mockito.spy((Object)driver.getConnectionQueryServices(url2, props));
        try (PhoenixConnection conn1 = spyCqs1.connect(url1, props);
             PhoenixConnection conn2 = spyCqs2.connect(url2, props);){
            this.createTable((Connection)conn1, tableName);
            this.createIndex((Connection)conn1, tableName, indexName, "v1");
            this.alterIndexChangeState((Connection)conn1, tableName, indexName, " DISABLE");
            this.upsert((Connection)conn1, tableName, false);
            this.upsert((Connection)conn1, tableName, false);
            this.upsert((Connection)conn1, tableName, false);
            this.alterIndexChangeState((Connection)conn2, tableName, indexName, " REBUILD");
            this.upsert((Connection)conn1, tableName, false);
            this.upsert((Connection)conn1, tableName, false);
            conn1.commit();
            ResultSet rs = conn1.createStatement().executeQuery("SELECT COUNT(*) FROM " + tableName);
            rs.next();
            int tableCount = rs.getInt(1);
            rs = conn1.createStatement().executeQuery("SELECT COUNT(*) FROM " + indexName);
            rs.next();
            int indexCount = rs.getInt(1);
            Assert.assertEquals((String)"All index mutations were not generated when index was created concurrently with upserts.", (long)tableCount, (long)indexCount);
        }
    }

    @Test
    public void testClientCannotCreateIndexOnDroppedColumn() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String url1 = QueryUtil.getConnectionUrl((Properties)props, (Configuration)config, (String)"client1");
        String url2 = QueryUtil.getConnectionUrl((Properties)props, (Configuration)config, (String)"client2");
        String tableName = ServerMetadataCacheIT.generateUniqueName();
        String indexName = ServerMetadataCacheIT.generateUniqueName();
        ConnectionQueryServices spyCqs1 = (ConnectionQueryServices)Mockito.spy((Object)driver.getConnectionQueryServices(url1, props));
        ConnectionQueryServices spyCqs2 = (ConnectionQueryServices)Mockito.spy((Object)driver.getConnectionQueryServices(url2, props));
        try (PhoenixConnection conn1 = spyCqs1.connect(url1, props);
             PhoenixConnection conn2 = spyCqs2.connect(url2, props);){
            this.createTable((Connection)conn1, tableName);
            this.alterTableDropColumn((Connection)conn2, tableName, "v2");
            this.createIndex((Connection)conn1, tableName, indexName, "v2");
            Assert.fail((String)"Client should not be able to create index on dropped column.");
        }
        catch (ColumnNotFoundException columnNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testConcurrentUpsertDropView() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String url1 = QueryUtil.getConnectionUrl((Properties)props, (Configuration)config, (String)"client1");
        String url2 = QueryUtil.getConnectionUrl((Properties)props, (Configuration)config, (String)"client2");
        String tableName = ServerMetadataCacheIT.generateUniqueName();
        String viewName1 = ServerMetadataCacheIT.generateUniqueName();
        String viewName2 = ServerMetadataCacheIT.generateUniqueName();
        ConnectionQueryServices spyCqs1 = (ConnectionQueryServices)Mockito.spy((Object)driver.getConnectionQueryServices(url1, props));
        ConnectionQueryServices spyCqs2 = (ConnectionQueryServices)Mockito.spy((Object)driver.getConnectionQueryServices(url2, props));
        try (PhoenixConnection conn1 = spyCqs1.connect(url1, props);
             PhoenixConnection conn2 = spyCqs2.connect(url2, props);){
            this.createTable((Connection)conn1, tableName);
            this.createView((Connection)conn1, tableName, viewName1);
            this.createView((Connection)conn1, viewName1, viewName2);
            this.upsert((Connection)conn2, viewName2, false);
            this.dropView((Connection)conn1, viewName1, true);
            this.upsert((Connection)conn2, viewName2, true);
        }
        catch (Exception e) {
            Assert.assertTrue((String)"TableNotFoundException was not thrown when parent view was dropped (cascade) concurrently with upserts.", (boolean)(e instanceof TableNotFoundException));
        }
    }

    @Test
    public void testServerSideMetrics() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String url1 = QueryUtil.getConnectionUrl((Properties)props, (Configuration)config, (String)"client1");
        String url2 = QueryUtil.getConnectionUrl((Properties)props, (Configuration)config, (String)"client2");
        String tableName = ServerMetadataCacheIT.generateUniqueName();
        String indexName = ServerMetadataCacheIT.generateUniqueName();
        ConnectionQueryServices cqs1 = driver.getConnectionQueryServices(url1, props);
        ConnectionQueryServices cqs2 = driver.getConnectionQueryServices(url2, props);
        MetricsMetadataCachingSource metricsSource = MetricsPhoenixCoprocessorSourceFactory.getInstance().getMetadataCachingSource();
        MetricsMetadataCachingSource.MetadataCachingMetricValues oldMetricValues = metricsSource.getCurrentMetricValues();
        long cacheHit = 0L;
        long cacheMiss = 0L;
        long validateDDLRequestCount = 0L;
        long cacheInvOpsCount = 0L;
        long cacheInvSuccessCount = 0L;
        long cacheInvFailureCount = 0L;
        long cacheInvRpcTimeCount = 0L;
        long cacheInvTotalTimeCount = 0L;
        try (PhoenixConnection conn1 = cqs1.connect(url1, props);
             PhoenixConnection conn2 = cqs2.connect(url2, props);){
            this.createTable((Connection)conn1, tableName);
            this.query((Connection)conn2, tableName);
            ++validateDDLRequestCount;
            ++cacheMiss;
            this.createIndex((Connection)conn1, tableName, indexName, "v1");
            cacheInvOpsCount += 2L;
            cacheInvRpcTimeCount += 2L;
            cacheInvTotalTimeCount += 2L;
            cacheInvSuccessCount += 2L;
            this.query((Connection)conn2, tableName);
            ++validateDDLRequestCount;
            ++cacheMiss;
            this.query((Connection)conn2, tableName);
            ++validateDDLRequestCount;
            ++cacheHit;
            this.query((Connection)conn2, tableName);
            MetricsMetadataCachingSource.MetadataCachingMetricValues newMetricValues = metricsSource.getCurrentMetricValues();
            Assert.assertEquals((String)"Incorrect number of cache hits on region server.", (long)(cacheHit += 2L), (long)(newMetricValues.getCacheHitCount() - oldMetricValues.getCacheHitCount()));
            Assert.assertEquals((String)"Incorrect number of cache misses on region server.", (long)(++cacheMiss), (long)(newMetricValues.getCacheMissCount() - oldMetricValues.getCacheMissCount()));
            Assert.assertEquals((String)"Incorrect number of validate ddl timestamp requests.", (long)(++validateDDLRequestCount), (long)(newMetricValues.getValidateDDLTimestampRequestsCount() - oldMetricValues.getValidateDDLTimestampRequestsCount()));
            Assert.assertEquals((String)"Incorrect number of cache invalidation ops count.", (long)cacheInvOpsCount, (long)(newMetricValues.getCacheInvalidationOpsCount() - oldMetricValues.getCacheInvalidationOpsCount()));
            Assert.assertEquals((String)"Incorrect number of successful cache invalidation ops count.", (long)cacheInvSuccessCount, (long)(newMetricValues.getCacheInvalidationSuccessCount() - oldMetricValues.getCacheInvalidationSuccessCount()));
            Assert.assertEquals((String)"Incorrect number of failed cache invalidation ops count.", (long)cacheInvFailureCount, (long)(newMetricValues.getCacheInvalidationFailureCount() - oldMetricValues.getCacheInvalidationFailureCount()));
            Assert.assertEquals((String)"Incorrect number of cache invalidation RPC times.", (long)cacheInvRpcTimeCount, (long)(newMetricValues.getCacheInvalidationRpcTimeCount() - oldMetricValues.getCacheInvalidationRpcTimeCount()));
            Assert.assertEquals((String)"Incorrect number of cache invalidation total times.", (long)cacheInvTotalTimeCount, (long)(newMetricValues.getCacheInvalidationTotalTimeCount() - oldMetricValues.getCacheInvalidationTotalTimeCount()));
        }
    }

    @Test
    public void testInvalidateMetadataCacheOnNonServerConnection() {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (PhoenixConnection conn = DriverManager.getConnection(ServerMetadataCacheIT.getUrl(), props).unwrap(PhoenixConnection.class);){
            ConnectionQueryServices cqs = conn.getQueryServices();
            cqs.invalidateServerMetadataCache(null);
            Assert.fail((String)"Shouldn't come here");
        }
        catch (Throwable t) {
            Assert.assertNotNull((Object)t);
            Assert.assertTrue((boolean)t.getMessage().contains("Cannot invalidate server metadata cache on a non-server connection"));
        }
    }

    @Test
    public void testDroppedTableColumnNotVisibleToViewUsingSameClient() throws Exception {
        this.testDroppedTableColumnNotVisibleToView(true);
    }

    @Test
    public void testDroppedTableColumnNotVisibleToViewUsingDifferentClients() throws Exception {
        this.testDroppedTableColumnNotVisibleToView(false);
    }

    public void testDroppedTableColumnNotVisibleToView(boolean useSameClient) throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String url1 = QueryUtil.getConnectionUrl((Properties)props, (Configuration)config, (String)"client1");
        String url2 = QueryUtil.getConnectionUrl((Properties)props, (Configuration)config, (String)"client2");
        String tableName = ServerMetadataCacheIT.generateUniqueName();
        String viewName1 = ServerMetadataCacheIT.generateUniqueName();
        String viewName2 = ServerMetadataCacheIT.generateUniqueName();
        ConnectionQueryServices cqs1 = driver.getConnectionQueryServices(url1, props);
        ConnectionQueryServices cqs2 = driver.getConnectionQueryServices(url2, props);
        try (PhoenixConnection conn = cqs1.connect(url1, props);
             PhoenixConnection conn2 = useSameClient ? conn : cqs2.connect(url2, props);){
            this.createTable((Connection)conn, tableName);
            this.createView((Connection)conn, tableName, viewName1);
            this.createView((Connection)conn, viewName1, viewName2);
            this.query((Connection)conn2, viewName2);
            this.alterTableDropColumn((Connection)conn, tableName, "v2");
            this.query((Connection)conn2, tableName);
            conn2.createStatement().execute("SELECT v2 FROM " + viewName2);
            Assert.fail((String)"Column dropped from base table should not be visible to view.");
        }
        catch (ColumnNotFoundException columnNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testAncestorLastDDLMapPopulatedInDifferentClient() throws Exception {
        String SCHEMA1 = ServerMetadataCacheIT.generateUniqueName();
        String SCHEMA2 = ServerMetadataCacheIT.generateUniqueName();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String baseTable = SchemaUtil.getTableName((String)SCHEMA1, (String)ServerMetadataCacheIT.generateUniqueName());
        String index = ServerMetadataCacheIT.generateUniqueName();
        String view = SchemaUtil.getTableName((String)SCHEMA2, (String)ServerMetadataCacheIT.generateUniqueName());
        String viewIndex = ServerMetadataCacheIT.generateUniqueName();
        String baseTable2 = SchemaUtil.getTableName((String)SCHEMA1, (String)ServerMetadataCacheIT.generateUniqueName());
        String index2 = ServerMetadataCacheIT.generateUniqueName();
        String view2 = SchemaUtil.getTableName((String)SCHEMA2, (String)ServerMetadataCacheIT.generateUniqueName());
        String viewIndex2 = ServerMetadataCacheIT.generateUniqueName();
        String url1 = QueryUtil.getConnectionUrl((Properties)props, (Configuration)config, (String)"client1");
        String url2 = QueryUtil.getConnectionUrl((Properties)props, (Configuration)config, (String)"client2");
        ConnectionQueryServices cqs1 = driver.getConnectionQueryServices(url1, props);
        ConnectionQueryServices cqs2 = driver.getConnectionQueryServices(url2, props);
        try (PhoenixConnection conn = cqs1.connect(url1, props);
             PhoenixConnection conn2 = cqs2.connect(url2, props);){
            this.createTable((Connection)conn, baseTable);
            this.createView((Connection)conn, baseTable, view);
            this.createIndex((Connection)conn, baseTable, index, "v2");
            this.createIndex((Connection)conn, view, viewIndex, "v1");
            this.createTable((Connection)conn, baseTable2);
            this.createView((Connection)conn, baseTable2, view2);
            this.createIndex((Connection)conn, baseTable2, index2, "v2");
            this.createIndex((Connection)conn, view2, viewIndex2, "v1");
            this.query((Connection)conn2, view);
            PTable basePTable = PhoenixRuntime.getTable((Connection)conn2, (String)baseTable);
            PTable viewPTable = PhoenixRuntime.getTable((Connection)conn2, (String)view);
            PTable viewIndexPTable = PhoenixRuntime.getTable((Connection)conn2, (String)SchemaUtil.getTableName((String)SCHEMA2, (String)viewIndex));
            PTable indexPTable = PhoenixRuntime.getTable((Connection)conn2, (String)SchemaUtil.getTableName((String)SCHEMA1, (String)index));
            Map map = viewPTable.getAncestorLastDDLTimestampMap();
            Assert.assertEquals((Object)basePTable.getLastDDLTimestamp(), map.get(basePTable.getKey()));
            map = viewIndexPTable.getAncestorLastDDLTimestampMap();
            Assert.assertEquals((long)2L, (long)map.size());
            Assert.assertEquals((Object)basePTable.getLastDDLTimestamp(), map.get(basePTable.getKey()));
            Assert.assertEquals((Object)viewPTable.getLastDDLTimestamp(), map.get(viewPTable.getKey()));
            map = indexPTable.getAncestorLastDDLTimestampMap();
            Assert.assertEquals((long)1L, (long)map.size());
            Assert.assertEquals((Object)basePTable.getLastDDLTimestamp(), map.get(basePTable.getKey()));
            Assert.assertEquals((long)1L, (long)basePTable.getIndexes().size());
            map = ((PTable)basePTable.getIndexes().get(0)).getAncestorLastDDLTimestampMap();
            Assert.assertEquals((long)1L, (long)map.size());
            Assert.assertEquals((Object)basePTable.getLastDDLTimestamp(), map.get(basePTable.getKey()));
            PTable basePTable2 = PhoenixRuntime.getTable((Connection)conn2, (String)baseTable2);
            map = basePTable2.getAncestorLastDDLTimestampMap();
            Assert.assertEquals((long)0L, (long)map.size());
            Assert.assertEquals((long)1L, (long)basePTable2.getIndexes().size());
            map = ((PTable)basePTable2.getIndexes().get(0)).getAncestorLastDDLTimestampMap();
            Assert.assertEquals((Object)basePTable2.getLastDDLTimestamp(), map.get(basePTable2.getKey()));
            PTable viewPTable2 = PhoenixRuntime.getTable((Connection)conn2, (String)view2);
            map = viewPTable2.getAncestorLastDDLTimestampMap();
            Assert.assertEquals((Object)basePTable2.getLastDDLTimestamp(), map.get(basePTable2.getKey()));
            Assert.assertEquals((long)2L, (long)viewPTable2.getIndexes().size());
            for (PTable indexOfView : viewPTable2.getIndexes()) {
                if (indexOfView.getTableName().getString().equals(index2)) {
                    map = indexOfView.getAncestorLastDDLTimestampMap();
                    Assert.assertEquals((Object)basePTable2.getLastDDLTimestamp(), map.get(basePTable2.getKey()));
                    continue;
                }
                map = indexOfView.getAncestorLastDDLTimestampMap();
                Assert.assertEquals((Object)basePTable2.getLastDDLTimestamp(), map.get(basePTable2.getKey()));
                Assert.assertEquals((Object)viewPTable2.getLastDDLTimestamp(), map.get(viewPTable2.getKey()));
            }
        }
    }

    @Test
    public void testInheritedIndexOnTenantViewsDifferentNames() throws Exception {
        this.testInheritedIndexOnTenantViews(false);
    }

    @Test
    public void testInheritedIndexOnTenantViewsSameNames() throws Exception {
        this.testInheritedIndexOnTenantViews(true);
    }

    public void testInheritedIndexOnTenantViews(boolean sameTenantViewNames) throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String url = QueryUtil.getConnectionUrl((Properties)props, (Configuration)config, (String)"client1");
        ConnectionQueryServices cqs = driver.getConnectionQueryServices(url, props);
        String baseTableName = ServerMetadataCacheIT.generateUniqueName();
        String globalViewName = ServerMetadataCacheIT.generateUniqueName();
        String globalViewIndexName = ServerMetadataCacheIT.generateUniqueName();
        String tenantViewName1 = ServerMetadataCacheIT.generateUniqueName();
        String tenantViewName2 = sameTenantViewNames ? tenantViewName1 : ServerMetadataCacheIT.generateUniqueName();
        try (PhoenixConnection conn = cqs.connect(url, props);){
            PhoenixConnection tenantConn2;
            conn.createStatement().execute("CREATE TABLE " + baseTableName + " (TENANT_ID CHAR(9) NOT NULL, KP CHAR(3) NOT NULL, PK CHAR(3) NOT NULL, KV CHAR(2), KV2 CHAR(2) CONSTRAINT PK PRIMARY KEY(TENANT_ID, KP, PK)) MULTI_TENANT=true,UPDATE_CACHE_FREQUENCY=NEVER");
            conn.createStatement().execute("CREATE VIEW " + globalViewName + " AS SELECT * FROM " + baseTableName + " WHERE  KP = '001'");
            conn.createStatement().execute("CREATE INDEX " + globalViewIndexName + " on " + globalViewName + " (KV)  INCLUDE (KV2) ASYNC");
            String tenantId1 = "tenantId1";
            String tenantId2 = "tenantId2";
            Properties tenantProps1 = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
            Properties tenantProps2 = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
            tenantProps1.setProperty("TenantId", tenantId1);
            tenantProps2.setProperty("TenantId", tenantId2);
            try (PhoenixConnection tenantConn1 = cqs.connect(url, tenantProps1);){
                tenantConn2 = cqs.connect(url, tenantProps2);
                try {
                    tenantConn1.createStatement().execute("CREATE VIEW " + tenantViewName1 + " AS SELECT * FROM " + globalViewName);
                    tenantConn1.createStatement().execute("UPSERT INTO " + tenantViewName1 + " (PK, KV, KV2) VALUES ('PK1', 'KV', '01')");
                    tenantConn1.commit();
                    tenantConn2.createStatement().execute("CREATE VIEW " + tenantViewName2 + " AS SELECT * FROM " + globalViewName);
                    tenantConn2.createStatement().execute("UPSERT INTO " + tenantViewName2 + " (PK, KV, KV2) VALUES ('PK2', 'KV', '02')");
                    tenantConn2.commit();
                }
                finally {
                    if (tenantConn2 != null) {
                        tenantConn2.close();
                    }
                }
            }
            IndexToolIT.runIndexTool(false, "", globalViewName, globalViewIndexName);
            tenantConn1 = cqs.connect(url, tenantProps1);
            try {
                tenantConn2 = cqs.connect(url, tenantProps2);
                try {
                    String query1 = "SELECT KV2 FROM  " + tenantViewName1 + " WHERE KV = 'KV'";
                    String query2 = "SELECT KV2 FROM  " + tenantViewName2 + " WHERE KV = 'KV'";
                    ResultSet rs = tenantConn1.createStatement().executeQuery(query1);
                    ServerMetadataCacheIT.assertPlan((PhoenixResultSet)rs, "", tenantViewName1 + "#" + globalViewIndexName);
                    Assert.assertTrue((boolean)rs.next());
                    Assert.assertEquals((Object)"01", (Object)rs.getString(1));
                    rs = tenantConn2.createStatement().executeQuery(query2);
                    ServerMetadataCacheIT.assertPlan((PhoenixResultSet)rs, "", tenantViewName2 + "#" + globalViewIndexName);
                    Assert.assertTrue((boolean)rs.next());
                    Assert.assertEquals((Object)"02", (Object)rs.getString(1));
                }
                finally {
                    if (tenantConn2 != null) {
                        tenantConn2.close();
                    }
                }
            }
            finally {
                if (tenantConn1 != null) {
                    tenantConn1.close();
                }
            }
        }
    }

    @Test
    public void testCacheUpdatedBeforeDDLOperations() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String url1 = QueryUtil.getConnectionUrl((Properties)props, (Configuration)config, (String)"client1");
        String tableName = ServerMetadataCacheIT.generateUniqueName();
        String indexName = ServerMetadataCacheIT.generateUniqueName();
        String viewName = ServerMetadataCacheIT.generateUniqueName();
        String childViewName = ServerMetadataCacheIT.generateUniqueName();
        int numTableRPCs = 0;
        int numViewRPCs = 0;
        ConnectionQueryServices spyCqs1 = (ConnectionQueryServices)Mockito.spy((Object)driver.getConnectionQueryServices(url1, props));
        try (PhoenixConnection conn1 = spyCqs1.connect(url1, props);){
            this.createTable((Connection)conn1, tableName);
            this.createIndex((Connection)conn1, tableName, indexName, "v2");
            ServerMetadataCacheIT.assertNumGetTableRPC(spyCqs1, tableName, numTableRPCs += 5);
            this.createView((Connection)conn1, tableName, viewName);
            ServerMetadataCacheIT.assertNumGetTableRPC(spyCqs1, tableName, ++numTableRPCs);
            this.createView((Connection)conn1, viewName, childViewName);
            ServerMetadataCacheIT.assertNumGetTableRPC(spyCqs1, tableName, ++numTableRPCs);
            ServerMetadataCacheIT.assertNumGetTableRPC(spyCqs1, viewName, ++numViewRPCs);
            this.alterTableAddColumn((Connection)conn1, tableName, "newcol1");
            ++numTableRPCs;
            this.alterTableDropColumn((Connection)conn1, tableName, "newcol1");
            ServerMetadataCacheIT.assertNumGetTableRPC(spyCqs1, tableName, ++numTableRPCs);
            this.alterViewAddColumn((Connection)conn1, viewName, "newcol2");
            ++numViewRPCs;
            ++numTableRPCs;
            this.alterViewDropColumn((Connection)conn1, viewName, "newcol2");
            ServerMetadataCacheIT.assertNumGetTableRPC(spyCqs1, viewName, ++numViewRPCs);
            ServerMetadataCacheIT.assertNumGetTableRPC(spyCqs1, tableName, ++numTableRPCs);
        }
    }

    @Test
    public void testNoDDLTimestampValidationWithTableUCF() throws Exception {
        String tableName = ServerMetadataCacheIT.generateUniqueName();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String url1 = QueryUtil.getConnectionUrl((Properties)props, (Configuration)config, (String)"client1");
        String url2 = QueryUtil.getConnectionUrl((Properties)props, (Configuration)config, (String)"client2");
        ConnectionQueryServices cqs1 = driver.getConnectionQueryServices(url1, props);
        ConnectionQueryServices cqs2 = driver.getConnectionQueryServices(url2, props);
        MetricsMetadataCachingSource metricsSource = MetricsPhoenixCoprocessorSourceFactory.getInstance().getMetadataCachingSource();
        MetricsMetadataCachingSource.MetadataCachingMetricValues oldMetricValues = metricsSource.getCurrentMetricValues();
        try (PhoenixConnection conn1 = cqs1.connect(url1, props);
             PhoenixConnection conn2 = cqs2.connect(url2, props);){
            this.createTableWithUCF((Connection)conn1, tableName, 172800000L);
            for (int i = 0; i < 3; ++i) {
                this.query((Connection)conn2, tableName);
                this.upsert((Connection)conn2, tableName, true);
                this.query((Connection)conn1, tableName);
                this.upsert((Connection)conn1, tableName, true);
            }
            MetricsMetadataCachingSource.MetadataCachingMetricValues newMetricValues = metricsSource.getCurrentMetricValues();
            Assert.assertEquals((String)"There should have been no timestamp validation requests.", (long)0L, (long)(newMetricValues.getValidateDDLTimestampRequestsCount() - oldMetricValues.getValidateDDLTimestampRequestsCount()));
        }
    }

    @Test
    public void testLastDDLTimestampNotSetOnTable() throws SQLException {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String url1 = QueryUtil.getConnectionUrl((Properties)props, (Configuration)config, (String)"client1");
        String tableName = ServerMetadataCacheIT.generateUniqueName();
        ConnectionQueryServices cqs1 = driver.getConnectionQueryServices(url1, props);
        try (PhoenixConnection conn1 = cqs1.connect(url1, props);){
            this.createTable((Connection)conn1, tableName);
            String pkCols = "TENANT_ID, TABLE_SCHEM, TABLE_NAME, COLUMN_NAME, COLUMN_FAMILY";
            String upsertSql = "UPSERT INTO " + PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME + " (" + pkCols + ", LAST_DDL_TIMESTAMP) SELECT " + pkCols + ", NULL FROM " + PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME + " WHERE TABLE_NAME  = '" + tableName + "'";
            conn1.createStatement().executeUpdate(upsertSql);
            conn1.commit();
            conn1.unwrap(PhoenixConnection.class).getQueryServices().clearCache();
            PhoenixRuntime.getTableNoCache((Connection)conn1, (String)tableName);
            this.query((Connection)conn1, tableName);
            Assert.assertNotNull((Object)PhoenixRuntime.getTable((Connection)conn1, (String)tableName).getLastDDLTimestamp());
        }
    }

    public static void assertNumGetTableRPC(ConnectionQueryServices spyCqs, String tableName, int numExpectedRPCs) throws SQLException {
        ((ConnectionQueryServices)Mockito.verify((Object)spyCqs, (VerificationMode)Mockito.times((int)numExpectedRPCs))).getTable((PName)ArgumentMatchers.eq(null), (byte[])ArgumentMatchers.any(byte[].class), (byte[])ArgumentMatchers.eq((Object)PVarchar.INSTANCE.toBytes((Object)tableName)), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
    }

    public static void assertPlan(PhoenixResultSet rs, String schemaName, String tableName) {
        PTable table = rs.getContext().getCurrentTable().getTable();
        Assert.assertTrue((table.getSchemaName().getString().equals(schemaName) && table.getTableName().getString().equals(tableName) ? 1 : 0) != 0);
    }

    private long getLastDDLTimestamp(String tableName) throws SQLException {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String url = QueryUtil.getConnectionUrl((Properties)props, (Configuration)config, (String)"client1");
        try (Connection conn = DriverManager.getConnection(url);){
            PTable table = PhoenixRuntime.getTableNoCache((Connection)conn, (String)tableName);
            long l = table.getLastDDLTimestamp();
            return l;
        }
    }

    private void createTable(Connection conn, String tableName) throws SQLException {
        conn.createStatement().execute("CREATE TABLE " + tableName + "(k INTEGER NOT NULL PRIMARY KEY, v1 INTEGER, v2 INTEGER)");
    }

    private void createTableWithUCF(Connection conn, String tableName, long ucf) throws SQLException {
        conn.createStatement().execute("CREATE TABLE " + tableName + "(k INTEGER NOT NULL PRIMARY KEY, v1 INTEGER, v2 INTEGER) UPDATE_CACHE_FREQUENCY=" + ucf);
    }

    private void createView(Connection conn, String parentName, String viewName) throws SQLException {
        conn.createStatement().execute("CREATE VIEW " + viewName + " AS SELECT * FROM " + parentName);
    }

    private void createViewWhereClause(Connection conn, String parentName, String viewName, String whereClause) throws SQLException {
        conn.createStatement().execute("CREATE VIEW " + viewName + " AS SELECT * FROM " + parentName + whereClause);
    }

    private void createIndex(Connection conn, String tableName, String indexName, String col) throws SQLException {
        conn.createStatement().execute("CREATE INDEX " + indexName + " ON " + tableName + "(" + col + ")");
    }

    private void upsert(Connection conn, String tableName, boolean doCommit) throws SQLException {
        conn.createStatement().execute("UPSERT INTO " + tableName + " (k, v1, v2) VALUES (" + this.RANDOM.nextInt() + ", " + this.RANDOM.nextInt() + ", " + this.RANDOM.nextInt() + ")");
        if (doCommit) {
            conn.commit();
        }
    }

    private void query(Connection conn, String tableName) throws SQLException {
        ResultSet rs = conn.createStatement().executeQuery("SELECT COUNT(*) FROM " + tableName);
        rs.next();
    }

    private void queryWithIndex(Connection conn, String tableName) throws SQLException {
        ResultSet rs = conn.createStatement().executeQuery("SELECT k FROM " + tableName + " WHERE v1=1");
        rs.next();
    }

    private void alterTableAddColumn(Connection conn, String tableName, String columnName) throws SQLException {
        conn.createStatement().execute("ALTER TABLE " + tableName + " ADD IF NOT EXISTS " + columnName + " INTEGER");
    }

    private void alterTableDropColumn(Connection conn, String tableName, String columnName) throws SQLException {
        conn.createStatement().execute("ALTER TABLE " + tableName + " DROP COLUMN " + columnName);
    }

    private void alterViewAddColumn(Connection conn, String viewName, String columnName) throws SQLException {
        conn.createStatement().execute("ALTER VIEW " + viewName + " ADD IF NOT EXISTS " + columnName + " INTEGER");
    }

    private void alterViewDropColumn(Connection conn, String viewName, String columnName) throws SQLException {
        conn.createStatement().execute("ALTER VIEW " + viewName + " DROP COLUMN  " + columnName);
    }

    private void alterIndexChangeState(Connection conn, String tableName, String indexName, String state) throws SQLException, InterruptedException {
        conn.createStatement().execute("ALTER INDEX " + indexName + " ON " + tableName + state);
    }

    private void dropIndex(Connection conn, String tableName, String indexName) throws SQLException {
        conn.createStatement().execute("DROP INDEX " + indexName + " ON " + tableName);
    }

    private void dropView(Connection conn, String viewName, boolean cascade) throws SQLException {
        String sql = "DROP VIEW " + viewName;
        if (cascade) {
            sql = sql + " CASCADE";
        }
        conn.createStatement().execute(sql);
    }

    private void multiTableUpsert(Connection conn, String tableName1, String tableName2) throws SQLException {
        conn.createStatement().execute("UPSERT INTO " + tableName1 + " (k, v1, v2) VALUES (" + this.RANDOM.nextInt() + ", " + this.RANDOM.nextInt() + ", " + this.RANDOM.nextInt() + ")");
        conn.createStatement().execute("UPSERT INTO " + tableName1 + " (k, v1, v2) VALUES (" + this.RANDOM.nextInt() + ", " + this.RANDOM.nextInt() + ", " + this.RANDOM.nextInt() + ")");
        conn.createStatement().execute("UPSERT INTO " + tableName2 + " (k, v1, v2) VALUES (" + this.RANDOM.nextInt() + ", " + this.RANDOM.nextInt() + ", " + this.RANDOM.nextInt() + ")");
        conn.createStatement().execute("UPSERT INTO " + tableName1 + " (k, v1, v2) VALUES (" + this.RANDOM.nextInt() + ", " + this.RANDOM.nextInt() + ", " + this.RANDOM.nextInt() + ")");
        conn.createStatement().execute("UPSERT INTO " + tableName2 + " (k, v1, v2) VALUES (" + this.RANDOM.nextInt() + ", " + this.RANDOM.nextInt() + ", " + this.RANDOM.nextInt() + ")");
        conn.commit();
    }
}

