/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.cache;

import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.cache.JodaTimezoneCache;
import org.apache.phoenix.schema.IllegalDataException;
import org.joda.time.DateTimeZone;
import org.junit.Assert;
import org.junit.Test;

public class JodaTimezoneCacheTest {
    @Test
    public void testGetInstanceByteBufferUTC() {
        DateTimeZone instance = JodaTimezoneCache.getInstance((ByteBuffer)ByteBuffer.wrap(Bytes.toBytes((String)"UTC")));
        Assert.assertNotNull((Object)instance);
    }

    @Test
    public void testGetInstanceString() {
        DateTimeZone instance = JodaTimezoneCache.getInstance((String)"America/St_Vincent");
        Assert.assertNotNull((Object)instance);
    }

    @Test(expected=IllegalDataException.class)
    public void testGetInstanceStringUnknown() {
        JodaTimezoneCache.getInstance((String)"SOME_UNKNOWN_TIMEZONE");
    }

    @Test
    public void testGetInstanceImmutableBytesWritable() {
        ImmutableBytesWritable ptr = new ImmutableBytesWritable(Bytes.toBytes((String)"Europe/Isle_of_Man"));
        DateTimeZone instance = JodaTimezoneCache.getInstance((ImmutableBytesWritable)ptr);
        Assert.assertNotNull((Object)instance);
    }
}

