/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix;

import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.phoenix.util.ReadOnlyProps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sandbox {
    private static final Logger LOGGER = LoggerFactory.getLogger(Sandbox.class);

    public static void main(String[] args) throws Exception {
        System.out.println("Starting Phoenix sandbox");
        Configuration conf = HBaseConfiguration.create();
        BaseTest.setUpConfigForMiniCluster(conf, new ReadOnlyProps((Map)ImmutableMap.of((Object)"phoenix.jdbc.extra.arguments", (Object)"")));
        final HBaseTestingUtility testUtil = new HBaseTestingUtility(conf);
        testUtil.startMiniCluster();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    if (testUtil != null) {
                        testUtil.shutdownMiniCluster();
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Exception caught when shutting down mini cluster", (Throwable)e);
                }
            }
        });
        int clientPort = testUtil.getZkCluster().getClientPort();
        System.out.println("\n\n\tPhoenix Sandbox is started\n\n");
        System.out.printf("\tYou can now connect with url 'jdbc:phoenix:localhost:%d'\n\tor connect via sqlline with 'bin/sqlline.py localhost:%d'\n\n", clientPort, clientPort);
        Thread.sleep(Long.MAX_VALUE);
    }
}

