/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RegionServerAccounting;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.wal.FSHLog;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALSplitter;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.hbase.index.IndexTableName;
import org.apache.phoenix.hbase.index.IndexTestingUtils;
import org.apache.phoenix.hbase.index.covered.ColumnGroup;
import org.apache.phoenix.hbase.index.covered.CoveredColumn;
import org.apache.phoenix.hbase.index.covered.CoveredColumnIndexSpecifierBuilder;
import org.apache.phoenix.hbase.index.util.TestIndexManagementUtil;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.util.ConfigUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={NeedsOwnMiniClusterTest.class})
@Ignore
public class WALReplayWithIndexWritesAndCompressedWALIT {
    public static final Logger LOGGER = LoggerFactory.getLogger(WALReplayWithIndexWritesAndCompressedWALIT.class);
    @Rule
    public IndexTableName table = new IndexTableName();
    private String INDEX_TABLE_NAME = this.table.getTableNameString() + "_INDEX";
    final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private Path hbaseRootDir = null;
    private Path oldLogDir;
    private Path logDir;
    private FileSystem fs;
    private Configuration conf;

    @Before
    public void setUp() throws Exception {
        this.setupCluster();
        this.conf = HBaseConfiguration.create((Configuration)this.UTIL.getConfiguration());
        this.conf.setBoolean("phoenix.index.failure.throw.exception", false);
        this.fs = this.UTIL.getDFSCluster().getFileSystem();
        this.hbaseRootDir = new Path(this.conf.get("hbase.rootdir"));
        this.oldLogDir = new Path(this.hbaseRootDir, "oldWALs");
        this.logDir = new Path(this.hbaseRootDir, "WALs");
    }

    private void setupCluster() throws Exception {
        this.configureCluster();
        this.startCluster();
    }

    protected void configureCluster() throws Exception {
        Configuration conf = this.UTIL.getConfiguration();
        this.setDefaults(conf);
        conf.setBoolean("hbase.regionserver.wal.enablecompression", true);
        ConfigUtil.setReplicationConfigIfAbsent((Configuration)conf);
    }

    protected final void setDefaults(Configuration conf) {
        conf.setInt("hbase.client.retries.number", 3);
        conf.setInt("hbase.client.pause", 1000);
        conf.setInt("zookeeper.recovery.retry", 3);
        conf.setInt("zookeeper.recovery.retry.intervalmill", 100);
        conf.setInt("zookeeper.session.timeout", 30000);
        conf.setInt("hbase.rpc.timeout", 5000);
        conf.setBoolean("dfs.support.append", true);
        IndexTestingUtils.setupConfig(conf);
    }

    protected void startCluster() throws Exception {
        this.UTIL.startMiniDFSCluster(3);
        this.UTIL.startMiniZKCluster();
        Path hbaseRootDir = this.UTIL.getDFSCluster().getFileSystem().makeQualified(new Path("/hbase"));
        LOGGER.info("hbase.rootdir=" + hbaseRootDir);
        this.UTIL.getConfiguration().set("hbase.rootdir", hbaseRootDir.toString());
        this.UTIL.startMiniHBaseCluster(1, 1);
    }

    @After
    public void tearDown() throws Exception {
        boolean refCountLeaked = BaseTest.isAnyStoreRefCountLeaked(this.UTIL.getAdmin());
        this.UTIL.shutdownMiniHBaseCluster();
        this.UTIL.shutdownMiniDFSCluster();
        this.UTIL.shutdownMiniZKCluster();
        Assert.assertFalse((String)"refCount leaked", (boolean)refCountLeaked);
    }

    private void deleteDir(Path p) throws IOException {
        if (this.fs.exists(p) && !this.fs.delete(p, true)) {
            throw new IOException("Failed remove of " + p);
        }
    }

    @Test
    public void testReplayEditsWrittenViaHRegion() throws Exception {
        String tableNameStr = "testReplayEditsWrittenViaHRegion";
        RegionInfo hri = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)"testReplayEditsWrittenViaHRegion")).setSplit(false).build();
        Path basedir = CommonFSUtils.getTableDir((Path)this.hbaseRootDir, (TableName)TableName.valueOf((String)"testReplayEditsWrittenViaHRegion"));
        this.deleteDir(basedir);
        TableDescriptor htd = this.createBasic3FamilyHTD("testReplayEditsWrittenViaHRegion");
        byte[] family = new byte[]{97};
        ColumnGroup fam1 = new ColumnGroup(this.INDEX_TABLE_NAME);
        fam1.add(new CoveredColumn(family, CoveredColumn.ALL_QUALIFIERS));
        CoveredColumnIndexSpecifierBuilder builder = new CoveredColumnIndexSpecifierBuilder();
        builder.addIndexGroup(fam1);
        builder.build(htd);
        WALFactory walFactory = new WALFactory(this.conf, "localhost,1234");
        WAL wal = this.createWAL(this.conf, walFactory);
        HRegion region0 = HRegion.createHRegion((RegionInfo)hri, (Path)this.hbaseRootDir, (Configuration)this.conf, (TableDescriptor)htd, (WAL)wal);
        region0.close();
        region0.getWAL().close();
        HRegionServer mockRS = (HRegionServer)Mockito.mock(HRegionServer.class);
        Mockito.when((Object)mockRS.getWAL(null)).thenReturn((Object)wal);
        RegionServerAccounting rsa = (RegionServerAccounting)Mockito.mock(RegionServerAccounting.class);
        Mockito.when((Object)mockRS.getRegionServerAccounting()).thenReturn((Object)rsa);
        ServerName mockServerName = (ServerName)Mockito.mock(ServerName.class);
        Mockito.when((Object)mockServerName.getServerName()).thenReturn((Object)"testReplayEditsWrittenViaHRegion,1234");
        Mockito.when((Object)mockRS.getServerName()).thenReturn((Object)mockServerName);
        HRegion region = (HRegion)Mockito.spy((Object)HRegion.createHRegion((RegionInfo)hri, (Path)this.hbaseRootDir, (Configuration)this.conf, (TableDescriptor)htd, (WAL)wal, (boolean)true, (RegionServerServices)mockRS));
        byte[] rowkey = Bytes.toBytes((String)"indexed_row_key");
        Put p = new Put(rowkey);
        p.addColumn(family, Bytes.toBytes((String)"qual"), Bytes.toBytes((String)"value"));
        region.put(p);
        ((HRegionServer)Mockito.verify((Object)mockRS, (VerificationMode)Mockito.times((int)1))).abort(Mockito.anyString(), (Throwable)Mockito.any(Exception.class));
        TestIndexManagementUtil.createIndexTable(this.UTIL.getAdmin(), this.INDEX_TABLE_NAME);
        this.runWALSplit(this.conf, walFactory);
        WAL wal2 = this.createWAL(this.conf, walFactory);
        HRegion region1 = HRegion.createHRegion((RegionInfo)hri, (Path)this.hbaseRootDir, (Configuration)this.conf, (TableDescriptor)htd, (WAL)wal, (boolean)true, (RegionServerServices)mockRS);
        Connection hbaseConn = ConnectionFactory.createConnection((Configuration)this.UTIL.getConfiguration());
        Table index = hbaseConn.getTable(TableName.valueOf((String)this.INDEX_TABLE_NAME));
        int indexSize = this.getKeyValueCount(index);
        Assert.assertEquals((String)"Index wasn't propertly updated from WAL replay!", (long)1L, (long)indexSize);
        Get g = new Get(rowkey);
        Result result = region1.get(g);
        Assert.assertEquals((String)"Primary region wasn't updated from WAL replay!", (long)1L, (long)result.size());
        Admin admin = this.UTIL.getAdmin();
        admin.disableTable(TableName.valueOf((String)this.INDEX_TABLE_NAME));
        admin.deleteTable(TableName.valueOf((String)this.INDEX_TABLE_NAME));
        admin.close();
    }

    private TableDescriptor createBasic3FamilyHTD(String tableName) {
        TableDescriptorBuilder tableBuilder = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)tableName));
        ColumnFamilyDescriptor a = ColumnFamilyDescriptorBuilder.of((byte[])Bytes.toBytes((String)"a"));
        tableBuilder.setColumnFamily(a);
        ColumnFamilyDescriptor b = ColumnFamilyDescriptorBuilder.of((byte[])Bytes.toBytes((String)"b"));
        tableBuilder.setColumnFamily(b);
        ColumnFamilyDescriptor c = ColumnFamilyDescriptorBuilder.of((byte[])Bytes.toBytes((String)"c"));
        tableBuilder.setColumnFamily(c);
        return tableBuilder.build();
    }

    private WAL createWAL(Configuration c, WALFactory walFactory) throws IOException {
        WAL wal = walFactory.getWAL(null);
        HBaseTestingUtility.setMaxRecoveryErrorCount((OutputStream)((FSHLog)wal).getOutputStream(), (int)1);
        return wal;
    }

    private Path runWALSplit(Configuration c, WALFactory walFactory) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)c);
        List splits = WALSplitter.split((Path)this.hbaseRootDir, (Path)new Path(this.logDir, "localhost,1234"), (Path)this.oldLogDir, (FileSystem)fs, (Configuration)c, (WALFactory)walFactory);
        Assert.assertEquals((String)("splits=" + splits), (long)1L, (long)splits.size());
        Assert.assertTrue((boolean)fs.exists((Path)splits.get(0)));
        LOGGER.info("Split file=" + splits.get(0));
        return (Path)splits.get(0);
    }

    private int getKeyValueCount(Table table) throws IOException {
        Scan scan = new Scan();
        scan.setMaxVersions(0x7FFFFFFE);
        ResultScanner results = table.getScanner(scan);
        int count = 0;
        for (Result res : results) {
            LOGGER.debug((count += res.listCells().size()) + ") " + res);
        }
        results.close();
        return count;
    }
}

