/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.io.util.LRUDictionary;
import org.apache.hadoop.hbase.regionserver.wal.CompressionContext;
import org.apache.hadoop.hbase.regionserver.wal.IndexedWALEditCodec;
import org.apache.hadoop.hbase.regionserver.wal.WALCellCodec;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.phoenix.hbase.index.IndexTestingUtils;
import org.apache.phoenix.hbase.index.wal.IndexedKeyValue;
import org.apache.phoenix.util.PhoenixKeyValueUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ReadWriteKeyValuesWithCodecTest {
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final byte[] ROW = Bytes.toBytes((String)"row");
    private static final byte[] FAMILY = Bytes.toBytes((String)"family");

    @BeforeClass
    public static synchronized void setupCodec() {
        Configuration conf = UTIL.getConfiguration();
        IndexTestingUtils.setupConfig(conf);
        conf.set("hbase.regionserver.wal.codec", IndexedWALEditCodec.class.getName());
    }

    @Test
    public void testWithoutCompression() throws Exception {
        Path testDir = UTIL.getDataTestDir("TestReadWriteCustomEdits_withoutCompression");
        Path testFile = new Path(testDir, "testfile");
        FileSystem fs = UTIL.getTestFileSystem();
        List<WALEdit> edits = this.getEdits();
        this.writeReadAndVerify(null, fs, edits, testFile);
    }

    @Test
    public void testWithCompression() throws Exception {
        Path testDir = UTIL.getDataTestDir("TestReadWriteCustomEdits_withCompression");
        Path testFile = new Path(testDir, "testfile");
        FileSystem fs = UTIL.getTestFileSystem();
        List<WALEdit> edits = this.getEdits();
        CompressionContext compression = new CompressionContext(LRUDictionary.class, false, false);
        this.writeReadAndVerify(compression, fs, edits, testFile);
    }

    private List<WALEdit> getEdits() {
        ArrayList<WALEdit> edits = new ArrayList<WALEdit>();
        Put p = new Put(ROW);
        p.addColumn(FAMILY, null, Bytes.toBytes((String)"v1"));
        WALEdit withPut = new WALEdit();
        this.addMutation(withPut, (Mutation)p, FAMILY);
        edits.add(withPut);
        Delete d = new Delete(ROW);
        d.addColumn(FAMILY, null);
        WALEdit withDelete = new WALEdit();
        this.addMutation(withDelete, (Mutation)d, FAMILY);
        edits.add(withDelete);
        WALEdit withPutsAndDeletes = new WALEdit();
        this.addMutation(withPutsAndDeletes, (Mutation)d, FAMILY);
        this.addMutation(withPutsAndDeletes, (Mutation)p, FAMILY);
        edits.add(withPutsAndDeletes);
        WALEdit justIndexUpdates = new WALEdit();
        byte[] table = Bytes.toBytes((String)"targetTable");
        IndexedKeyValue ikv = IndexedKeyValue.newIndexedKeyValue((byte[])table, (Mutation)p);
        justIndexUpdates.add((Cell)ikv);
        edits.add(justIndexUpdates);
        WALEdit mixed = new WALEdit();
        this.addMutation(mixed, (Mutation)d, FAMILY);
        mixed.add((Cell)ikv);
        this.addMutation(mixed, (Mutation)p, FAMILY);
        edits.add(mixed);
        return edits;
    }

    private void addMutation(WALEdit edit, Mutation m, byte[] family) {
        List kvs = (List)m.getFamilyCellMap().get(FAMILY);
        for (Cell kv : kvs) {
            edit.add((Cell)PhoenixKeyValueUtil.maybeCopyCell((Cell)kv));
        }
    }

    private void writeWALEdit(WALCellCodec codec, List<Cell> kvs, FSDataOutputStream out) throws IOException {
        out.writeInt(kvs.size());
        Codec.Encoder cellEncoder = codec.getEncoder((OutputStream)out);
        for (Cell kv : kvs) {
            cellEncoder.write(kv);
        }
    }

    private void writeReadAndVerify(CompressionContext compressionContext, FileSystem fs, List<WALEdit> edits, Path testFile) throws IOException {
        int i;
        WALCellCodec codec = WALCellCodec.create((Configuration)UTIL.getConfiguration(), (CompressionContext)compressionContext);
        FSDataOutputStream out = fs.create(testFile);
        for (WALEdit edit : edits) {
            this.writeWALEdit(codec, edit.getCells(), out);
        }
        out.close();
        FSDataInputStream in = fs.open(testFile);
        ArrayList<WALEdit> read = new ArrayList<WALEdit>();
        for (i = 0; i < edits.size(); ++i) {
            WALEdit edit = new WALEdit();
            int numEdits = in.readInt();
            edit.readFromCells(codec.getDecoder((InputStream)in), numEdits);
            read.add(edit);
        }
        in.close();
        for (i = 0; i < edits.size(); ++i) {
            WALEdit expected = edits.get(i);
            WALEdit found = (WALEdit)read.get(i);
            for (int j = 0; j < expected.getCells().size(); ++j) {
                Cell fkv = (Cell)found.getCells().get(j);
                Cell ekv = (Cell)expected.getCells().get(j);
                Assert.assertEquals((String)("KV mismatch for edit! Expected: " + expected + ", but found: " + found), (Object)ekv, (Object)fkv);
            }
        }
    }
}

