/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.stats;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.schema.stats.StatisticsCollectionRunTracker;
import org.apache.phoenix.schema.stats.StatisticsCollector;
import org.apache.phoenix.schema.stats.StatisticsWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticsScanner
implements InternalScanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatisticsScanner.class);
    private InternalScanner delegate;
    private StatisticsWriter statsWriter;
    private Region region;
    private StatisticsCollector tracker;
    private ImmutableBytesPtr family;
    private final Configuration config;
    private final RegionCoprocessorEnvironment env;

    public StatisticsScanner(StatisticsCollector tracker, StatisticsWriter stats, RegionCoprocessorEnvironment env, InternalScanner delegate, ImmutableBytesPtr family) {
        this.tracker = tracker;
        this.statsWriter = stats;
        this.delegate = delegate;
        this.region = env.getRegion();
        this.env = env;
        this.family = family;
        this.config = env.getConfiguration();
        StatisticsCollectionRunTracker.getInstance((Configuration)this.config).addCompactingRegion(this.region.getRegionInfo());
    }

    public boolean next(List<Cell> result) throws IOException {
        boolean ret = this.delegate.next(result);
        this.updateStats(result);
        return ret;
    }

    public boolean next(List<Cell> result, ScannerContext scannerContext) throws IOException {
        return this.next(result);
    }

    private void updateStats(List<Cell> results) throws IOException {
        if (!results.isEmpty()) {
            this.tracker.collectStatistics(results);
        }
    }

    public void close() throws IOException {
        boolean async = this.getConfig().getBoolean("phoenix.stats.commit.async", true);
        StatisticsCollectionRunTracker collectionTracker = this.getStatsCollectionRunTracker(this.config);
        StatisticsScannerCallable callable = this.createCallable();
        if (this.isConnectionClosed()) {
            LOGGER.debug("Not updating table statistics because the server is stopping/stopped");
            return;
        }
        if (!async) {
            callable.call();
        } else {
            collectionTracker.runTask((Callable)callable);
        }
    }

    StatisticsCollectionRunTracker getStatsCollectionRunTracker(Configuration c) {
        return StatisticsCollectionRunTracker.getInstance((Configuration)c);
    }

    Configuration getConfig() {
        return this.config;
    }

    StatisticsWriter getStatisticsWriter() {
        return this.statsWriter;
    }

    Region getRegion() {
        return this.region;
    }

    Connection getConnection() {
        return this.env.getConnection();
    }

    StatisticsScannerCallable createCallable() {
        return new StatisticsScannerCallable();
    }

    StatisticsCollector getTracker() {
        return this.tracker;
    }

    InternalScanner getDelegate() {
        return this.delegate;
    }

    private boolean isConnectionClosed() {
        return this.getConnection() == null || this.getConnection().isClosed() || this.getConnection().isAborted();
    }

    class StatisticsScannerCallable
    implements Callable<Void> {
        StatisticsScannerCallable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Void call() throws IOException {
            IOException toThrow = null;
            StatisticsCollectionRunTracker collectionTracker = StatisticsScanner.this.getStatsCollectionRunTracker(StatisticsScanner.this.config);
            RegionInfo regionInfo = StatisticsScanner.this.getRegion().getRegionInfo();
            try {
                ArrayList<Mutation> mutations = new ArrayList<Mutation>();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Deleting the stats for the region " + regionInfo.getRegionNameAsString() + " as part of major compaction");
                }
                StatisticsScanner.this.getStatisticsWriter().deleteStatsForRegion(StatisticsScanner.this.region, StatisticsScanner.this.tracker, StatisticsScanner.this.family, mutations);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Adding new stats for the region " + regionInfo.getRegionNameAsString() + " as part of major compaction");
                }
                StatisticsScanner.this.getStatisticsWriter().addStats(StatisticsScanner.this.tracker, StatisticsScanner.this.family, mutations, StatisticsScanner.this.tracker.getGuidePostDepth());
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Committing new stats for the region " + regionInfo.getRegionNameAsString() + " as part of major compaction");
                }
                StatisticsScanner.this.getStatisticsWriter().commitStats(mutations, StatisticsScanner.this.tracker);
                return null;
            }
            catch (IOException e) {
                if (StatisticsScanner.this.isConnectionClosed()) {
                    LOGGER.debug("Ignoring error updating statistics because region is closing/closed");
                }
                LOGGER.error("Failed to update statistics table!", (Throwable)e);
                toThrow = e;
                return toThrow;
            }
            finally {
                try {
                    collectionTracker.removeCompactingRegion(regionInfo);
                    StatisticsScanner.this.getStatisticsWriter().close();
                    StatisticsScanner.this.getTracker().close();
                }
                catch (IOException e) {
                    if (toThrow == null) {
                        toThrow = e;
                    }
                    LOGGER.error("Error while closing the stats table", (Throwable)e);
                }
                finally {
                    try {
                        StatisticsScanner.this.getDelegate().close();
                    }
                    catch (IOException e) {
                        if (toThrow == null) {
                            toThrow = e;
                        }
                        LOGGER.error("Error while closing the scanner", (Throwable)e);
                    }
                    finally {
                        if (toThrow == null) return null;
                        throw toThrow;
                    }
                }
            }
        }
    }
}

