/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.stats;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.stats.GuidePostsInfo;
import org.apache.phoenix.schema.stats.GuidePostsInfoBuilder;
import org.apache.phoenix.schema.stats.StatisticsCollector;
import org.apache.phoenix.schema.stats.StatisticsScanner;
import org.apache.phoenix.schema.stats.StatisticsUtil;
import org.apache.phoenix.schema.stats.StatisticsWriter;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultStatisticsCollector
implements StatisticsCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultStatisticsCollector.class);
    final Map<ImmutableBytesPtr, Pair<Long, GuidePostsInfoBuilder>> guidePostsInfoWriterMap = Maps.newHashMap();
    private final Table htable;
    private StatisticsWriter statsWriter;
    final Pair<Long, GuidePostsInfoBuilder> cachedGuidePosts;
    final byte[] guidePostWidthBytes;
    final byte[] guidePostPerRegionBytes;
    final byte[] ptableKey;
    private long guidePostDepth;
    private long maxTimeStamp = 0L;
    private ImmutableBytesWritable currentRow;
    private final String tableName;
    private final boolean isViewIndexTable;
    private final Region region;
    private final Configuration configuration;

    public DefaultStatisticsCollector(Configuration configuration, Region region, String tableName, byte[] family, byte[] gp_width_bytes, byte[] gp_per_region_bytes, StatisticsWriter statsWriter, Table htable) {
        this.configuration = configuration;
        this.region = region;
        this.guidePostWidthBytes = gp_width_bytes;
        this.guidePostPerRegionBytes = gp_per_region_bytes;
        String pName = tableName;
        if (MetaDataUtil.isViewIndex((String)tableName)) {
            pName = MetaDataUtil.getViewIndexUserTableName((String)tableName);
            this.isViewIndexTable = true;
        } else {
            this.isViewIndexTable = false;
        }
        this.ptableKey = SchemaUtil.getTableKeyFromFullName((String)pName);
        this.tableName = tableName;
        if (family != null) {
            ImmutableBytesPtr cfKey = new ImmutableBytesPtr(family);
            this.cachedGuidePosts = new Pair((Object)0L, (Object)new GuidePostsInfoBuilder());
            this.guidePostsInfoWriterMap.put(cfKey, this.cachedGuidePosts);
        } else {
            this.cachedGuidePosts = null;
        }
        this.statsWriter = statsWriter;
        this.htable = htable;
    }

    @Override
    public void init() throws IOException {
        try {
            this.initGuidepostDepth();
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        LOGGER.info("Initialization complete for " + this.getClass() + " statistics collector for table " + this.tableName);
    }

    private void initGuidepostDepth() throws IOException, SQLException {
        if (this.guidePostPerRegionBytes != null || this.guidePostWidthBytes != null) {
            this.getGuidePostDepthFromStatement();
            LOGGER.info("Guide post depth determined from SQL statement: " + this.guidePostDepth);
        } else {
            long guidepostWidth = this.getGuidePostDepthFromSystemCatalog();
            if (guidepostWidth >= 0L) {
                this.guidePostDepth = guidepostWidth;
                LOGGER.info("Guide post depth determined from SYSTEM.CATALOG: " + this.guidePostDepth);
            } else {
                this.guidePostDepth = StatisticsUtil.getGuidePostDepth((int)this.configuration.getInt("phoenix.stats.guidepost.per.region", 0), (long)this.configuration.getLongBytes("phoenix.stats.guidepost.width", 314572800L), (TableDescriptor)this.region.getTableDescriptor());
                LOGGER.info("Guide post depth determined from global configuration: " + this.guidePostDepth);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getGuidePostDepthFromSystemCatalog() throws IOException, SQLException {
        try {
            long guidepostWidth = -1L;
            Get get = new Get(this.ptableKey);
            get.addColumn(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.GUIDE_POSTS_WIDTH_BYTES);
            Result result = this.htable.get(get);
            if (!result.isEmpty()) {
                Cell cell = (Cell)result.listCells().get(0);
                guidepostWidth = PLong.INSTANCE.getCodec().decodeLong(cell.getValueArray(), cell.getValueOffset(), SortOrder.getDefault());
            } else if (!this.isViewIndexTable) {
                try (Connection conn = QueryUtil.getConnectionOnServer((Configuration)this.configuration);){
                    PTable table = conn.unwrap(PhoenixConnection.class).getTable(this.tableName);
                    if (table.getType() == PTableType.INDEX && IndexUtil.isGlobalIndex((PTable)table)) {
                        PName parentName = table.getParentName();
                        byte[] parentKey = SchemaUtil.getTableKeyFromFullName((String)parentName.getString());
                        get = new Get(parentKey);
                        get.addColumn(PhoenixDatabaseMetaData.TABLE_FAMILY_BYTES, PhoenixDatabaseMetaData.GUIDE_POSTS_WIDTH_BYTES);
                        result = this.htable.get(get);
                        if (!result.isEmpty()) {
                            Cell cell = (Cell)result.listCells().get(0);
                            guidepostWidth = PLong.INSTANCE.getCodec().decodeLong(cell.getValueArray(), cell.getValueOffset(), SortOrder.getDefault());
                        }
                    }
                }
            }
            long l = guidepostWidth;
            return l;
        }
        finally {
            if (this.htable != null) {
                try {
                    this.htable.close();
                }
                catch (IOException e) {
                    LOGGER.warn("Failed to close " + this.htable.getName(), (Throwable)e);
                }
            }
        }
    }

    private void getGuidePostDepthFromStatement() {
        int guidepostPerRegion = 0;
        long guidepostWidth = 314572800L;
        if (this.guidePostPerRegionBytes != null) {
            guidepostPerRegion = PInteger.INSTANCE.getCodec().decodeInt(this.guidePostPerRegionBytes, 0, SortOrder.getDefault());
        }
        if (this.guidePostWidthBytes != null) {
            guidepostWidth = PLong.INSTANCE.getCodec().decodeInt(this.guidePostWidthBytes, 0, SortOrder.getDefault());
        }
        this.guidePostDepth = StatisticsUtil.getGuidePostDepth((int)guidepostPerRegion, (long)guidepostWidth, (TableDescriptor)this.region.getTableDescriptor());
    }

    @Override
    public long getMaxTimeStamp() {
        return this.maxTimeStamp;
    }

    @Override
    public void close() throws IOException {
        if (this.statsWriter != null) {
            this.statsWriter.close();
        }
    }

    @Override
    public void updateStatistics(Region region, Scan scan) {
        try {
            ArrayList<Mutation> mutations = new ArrayList<Mutation>();
            this.writeStatistics(region, true, mutations, EnvironmentEdgeManager.currentTimeMillis(), scan);
            this.commitStats(mutations);
        }
        catch (IOException e) {
            LOGGER.error("Unable to update SYSTEM.STATS table.", (Throwable)e);
        }
    }

    private void writeStatistics(Region region, boolean delete, List<Mutation> mutations, long currentTime, Scan scan) throws IOException {
        Set<ImmutableBytesPtr> fams = this.guidePostsInfoWriterMap.keySet();
        if (this.cachedGuidePosts == null) {
            boolean collectingForLocalIndex = scan != null && !scan.getFamilyMap().isEmpty() && MetaDataUtil.isLocalIndexFamily((byte[])((byte[])scan.getFamilyMap().keySet().iterator().next()));
            for (Store store : region.getStores()) {
                ImmutableBytesPtr cfKey = new ImmutableBytesPtr(store.getColumnFamilyDescriptor().getName());
                boolean isLocalIndexStore = MetaDataUtil.isLocalIndexFamily((ImmutableBytesPtr)cfKey);
                if (isLocalIndexStore != collectingForLocalIndex || this.guidePostsInfoWriterMap.containsKey(cfKey)) continue;
                Pair emptyGps = new Pair((Object)0L, (Object)new GuidePostsInfoBuilder());
                this.guidePostsInfoWriterMap.put(cfKey, (Pair<Long, GuidePostsInfoBuilder>)emptyGps);
            }
        }
        for (ImmutableBytesPtr fam : fams) {
            if (delete) {
                this.statsWriter.deleteStatsForRegion(region, this, fam, mutations);
                LOGGER.info("Generated " + mutations.size() + " mutations to delete existing stats");
            }
            if (this.guidePostDepth <= 0L) continue;
            int oldSize = mutations.size();
            this.statsWriter.addStats(this, fam, mutations, this.guidePostDepth);
            LOGGER.info("Generated " + (mutations.size() - oldSize) + " mutations for new stats");
        }
    }

    private void commitStats(List<Mutation> mutations) throws IOException {
        this.statsWriter.commitStats(mutations, this);
        LOGGER.info("Committed " + mutations.size() + " mutations for stats");
    }

    @Override
    public void collectStatistics(List<Cell> results) {
        if (this.guidePostDepth == 0L || results.size() == 0) {
            return;
        }
        HashMap famMap = Maps.newHashMap();
        boolean incrementRow = false;
        Cell c = results.get(0);
        ImmutableBytesWritable row = new ImmutableBytesWritable(c.getRowArray(), c.getRowOffset(), (int)c.getRowLength());
        if (this.currentRow == null || !row.equals((Object)this.currentRow)) {
            this.currentRow = row;
            incrementRow = true;
        }
        for (Cell cell : results) {
            Pair<Long, GuidePostsInfoBuilder> gps;
            this.maxTimeStamp = Math.max(this.maxTimeStamp, cell.getTimestamp());
            if (this.cachedGuidePosts == null) {
                ImmutableBytesPtr cfKey = new ImmutableBytesPtr(cell.getFamilyArray(), cell.getFamilyOffset(), (int)cell.getFamilyLength());
                gps = this.guidePostsInfoWriterMap.get(cfKey);
                if (gps == null) {
                    gps = new Pair((Object)0L, (Object)new GuidePostsInfoBuilder());
                    this.guidePostsInfoWriterMap.put(cfKey, gps);
                }
                if (famMap.get(cfKey) == null) {
                    famMap.put(cfKey, true);
                    ((GuidePostsInfoBuilder)gps.getSecond()).incrementRowCount();
                }
            } else {
                gps = this.cachedGuidePosts;
                if (incrementRow) {
                    ((GuidePostsInfoBuilder)this.cachedGuidePosts.getSecond()).incrementRowCount();
                    incrementRow = false;
                }
            }
            int kvLength = KeyValueUtil.getSerializedSize((Cell)cell, (boolean)true);
            long byteCount = (Long)gps.getFirst() + (long)kvLength;
            gps.setFirst((Object)byteCount);
            if (byteCount < this.guidePostDepth || !((GuidePostsInfoBuilder)gps.getSecond()).addGuidePostOnCollection(row, byteCount, ((GuidePostsInfoBuilder)gps.getSecond()).getRowCount())) continue;
            gps.setFirst((Object)0L);
            ((GuidePostsInfoBuilder)gps.getSecond()).resetRowCount();
        }
    }

    @Override
    public GuidePostsInfo getGuidePosts(ImmutableBytesPtr fam) {
        Pair<Long, GuidePostsInfoBuilder> pair = this.guidePostsInfoWriterMap.get(fam);
        if (pair != null) {
            return ((GuidePostsInfoBuilder)pair.getSecond()).build();
        }
        return null;
    }

    @Override
    public long getGuidePostDepth() {
        return this.guidePostDepth;
    }

    @Override
    public StatisticsWriter getStatisticsWriter() {
        return this.statsWriter;
    }

    @Override
    public InternalScanner createCompactionScanner(RegionCoprocessorEnvironment env, Store store, InternalScanner delegate) {
        ImmutableBytesPtr cfKey = new ImmutableBytesPtr(store.getColumnFamilyDescriptor().getName());
        LOGGER.info("StatisticsScanner created for table: " + this.tableName + " CF: " + store.getColumnFamilyName());
        return new StatisticsScanner(this, this.statsWriter, env, delegate, cfKey);
    }
}

