/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce.index;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.hbase.index.table.HTableFactory;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.mapreduce.index.IndexTool;
import org.apache.phoenix.mapreduce.index.IndexVerificationOutputRow;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.phoenix.util.ByteUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexVerificationOutputRepository
implements AutoCloseable {
    public static final byte[] ROW_KEY_SEPARATOR_BYTE = Bytes.toBytes((String)"|");
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexVerificationOutputRepository.class);
    private Table indexTable;
    private byte[] indexName;
    private Table outputTable;
    private IndexTool.IndexDisableLoggingType disableLoggingVerifyType = IndexTool.IndexDisableLoggingType.NONE;
    private boolean shouldLogBeyondMaxLookback = true;
    public static final String OUTPUT_TABLE_NAME = "PHOENIX_INDEX_TOOL";
    public static final byte[] OUTPUT_TABLE_NAME_BYTES = Bytes.toBytes((String)"PHOENIX_INDEX_TOOL");
    public static final byte[] OUTPUT_TABLE_COLUMN_FAMILY = QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES;
    public static final String DATA_TABLE_NAME = "DTName";
    public static final byte[] DATA_TABLE_NAME_BYTES = Bytes.toBytes((String)"DTName");
    public static final String INDEX_TABLE_NAME = "ITName";
    public static final byte[] INDEX_TABLE_NAME_BYTES = Bytes.toBytes((String)"ITName");
    public static final String DATA_TABLE_ROW_KEY = "DTRowKey";
    public static final byte[] DATA_TABLE_ROW_KEY_BYTES = Bytes.toBytes((String)"DTRowKey");
    public static final String INDEX_TABLE_ROW_KEY = "ITRowKey";
    public static final byte[] INDEX_TABLE_ROW_KEY_BYTES = Bytes.toBytes((String)"ITRowKey");
    public static final String DATA_TABLE_TS = "DTTS";
    public static final byte[] DATA_TABLE_TS_BYTES = Bytes.toBytes((String)"DTTS");
    public static final String INDEX_TABLE_TS = "ITTS";
    public static final byte[] INDEX_TABLE_TS_BYTES = Bytes.toBytes((String)"ITTS");
    public static final String ERROR_MESSAGE = "Error";
    public static final byte[] ERROR_MESSAGE_BYTES = Bytes.toBytes((String)"Error");
    public static final String ERROR_TYPE = "ErrorType";
    public static final byte[] ERROR_TYPE_BYTES = Bytes.toBytes((String)"ErrorType");
    public static final String VERIFICATION_PHASE = "Phase";
    public static final byte[] VERIFICATION_PHASE_BYTES = Bytes.toBytes((String)"Phase");
    public static final String EXPECTED_VALUE = "ExpectedValue";
    public static final byte[] EXPECTED_VALUE_BYTES = Bytes.toBytes((String)"ExpectedValue");
    public static final String ACTUAL_VALUE = "ActualValue";
    public static final byte[] ACTUAL_VALUE_BYTES = Bytes.toBytes((String)"ActualValue");
    public static final byte[] E_VALUE_PREFIX_BYTES = Bytes.toBytes((String)" E:");
    public static final byte[] A_VALUE_PREFIX_BYTES = Bytes.toBytes((String)" A:");
    public static final int PREFIX_LENGTH = 3;
    public static final int TOTAL_PREFIX_LENGTH = 6;
    public static final byte[] PHASE_BEFORE_VALUE = Bytes.toBytes((String)"BEFORE");
    public static final byte[] PHASE_AFTER_VALUE = Bytes.toBytes((String)"AFTER");

    public IndexVerificationOutputRepository() {
    }

    @VisibleForTesting
    public IndexVerificationOutputRepository(byte[] indexName, Connection conn) throws SQLException {
        ConnectionQueryServices queryServices = conn.unwrap(PhoenixConnection.class).getQueryServices();
        this.outputTable = queryServices.getTable(OUTPUT_TABLE_NAME_BYTES);
        this.indexTable = queryServices.getTable(indexName);
    }

    @VisibleForTesting
    public IndexVerificationOutputRepository(Table outputTable, Table indexTable, IndexTool.IndexDisableLoggingType disableLoggingVerifyType) throws SQLException {
        this.outputTable = outputTable;
        this.indexTable = indexTable;
        this.disableLoggingVerifyType = disableLoggingVerifyType;
    }

    public IndexVerificationOutputRepository(byte[] indexName, HTableFactory hTableFactory, IndexTool.IndexDisableLoggingType disableLoggingVerifyType) throws IOException {
        this.indexName = indexName;
        this.outputTable = hTableFactory.getTable(new ImmutableBytesPtr(OUTPUT_TABLE_NAME_BYTES));
        this.indexTable = hTableFactory.getTable(new ImmutableBytesPtr(indexName));
        this.disableLoggingVerifyType = disableLoggingVerifyType;
    }

    public void setShouldLogBeyondMaxLookback(boolean shouldLogBeyondMaxLookback) {
        this.shouldLogBeyondMaxLookback = shouldLogBeyondMaxLookback;
    }

    public static byte[] generateOutputTableRowKey(long ts, byte[] indexTableName, byte[] dataRowKey) {
        byte[] keyPrefix = Bytes.toBytes((String)Long.toString(ts));
        int targetOffset = 0;
        byte[] rowKey = new byte[keyPrefix.length + ROW_KEY_SEPARATOR_BYTE.length + indexTableName.length + ROW_KEY_SEPARATOR_BYTE.length + dataRowKey.length];
        Bytes.putBytes((byte[])rowKey, (int)targetOffset, (byte[])keyPrefix, (int)0, (int)keyPrefix.length);
        Bytes.putBytes((byte[])rowKey, (int)(targetOffset += keyPrefix.length), (byte[])ROW_KEY_SEPARATOR_BYTE, (int)0, (int)ROW_KEY_SEPARATOR_BYTE.length);
        Bytes.putBytes((byte[])rowKey, (int)(targetOffset += ROW_KEY_SEPARATOR_BYTE.length), (byte[])indexTableName, (int)0, (int)indexTableName.length);
        Bytes.putBytes((byte[])rowKey, (int)(targetOffset += indexTableName.length), (byte[])ROW_KEY_SEPARATOR_BYTE, (int)0, (int)ROW_KEY_SEPARATOR_BYTE.length);
        Bytes.putBytes((byte[])rowKey, (int)(targetOffset += ROW_KEY_SEPARATOR_BYTE.length), (byte[])dataRowKey, (int)0, (int)dataRowKey.length);
        return rowKey;
    }

    private static byte[] generatePartialOutputTableRowKey(long ts, byte[] indexTableName) {
        byte[] keyPrefix = Bytes.toBytes((String)Long.toString(ts));
        int targetOffset = 0;
        byte[] partialRowKey = new byte[keyPrefix.length + ROW_KEY_SEPARATOR_BYTE.length + indexTableName.length];
        Bytes.putBytes((byte[])partialRowKey, (int)targetOffset, (byte[])keyPrefix, (int)0, (int)keyPrefix.length);
        Bytes.putBytes((byte[])partialRowKey, (int)(targetOffset += keyPrefix.length), (byte[])ROW_KEY_SEPARATOR_BYTE, (int)0, (int)ROW_KEY_SEPARATOR_BYTE.length);
        Bytes.putBytes((byte[])partialRowKey, (int)(targetOffset += ROW_KEY_SEPARATOR_BYTE.length), (byte[])indexTableName, (int)0, (int)indexTableName.length);
        return partialRowKey;
    }

    public void createOutputTable(Connection connection) throws IOException, SQLException {
        block14: {
            ConnectionQueryServices queryServices = connection.unwrap(PhoenixConnection.class).getQueryServices();
            try (Admin admin = queryServices.getAdmin();){
                TableName outputTableName = TableName.valueOf((String)OUTPUT_TABLE_NAME);
                if (admin.tableExists(outputTableName)) break block14;
                ColumnFamilyDescriptor columnDescriptor = ColumnFamilyDescriptorBuilder.newBuilder((byte[])OUTPUT_TABLE_COLUMN_FAMILY).setTimeToLive(604800).build();
                TableDescriptor tableDescriptor = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)OUTPUT_TABLE_NAME)).setColumnFamily(columnDescriptor).build();
                try {
                    admin.createTable(tableDescriptor);
                }
                catch (TableExistsException e) {
                    LOGGER.warn("Table exists, ignoring", (Throwable)e);
                }
                this.outputTable = admin.getConnection().getTable(outputTableName);
            }
        }
    }

    @VisibleForTesting
    public void logToIndexToolOutputTable(byte[] dataRowKey, byte[] indexRowKey, long dataRowTs, long indexRowTs, String errorMsg, byte[] expectedValue, byte[] actualValue, long scanMaxTs, byte[] tableName, boolean isBeforeRebuild, IndexVerificationErrorType errorType) throws IOException {
        if (this.shouldLogOutput(isBeforeRebuild, errorType)) {
            byte[] errorMessageBytes;
            byte[] rowKey = IndexVerificationOutputRepository.generateOutputTableRowKey(scanMaxTs, this.indexTable.getName().toBytes(), dataRowKey);
            Put put = new Put(rowKey);
            put.addColumn(OUTPUT_TABLE_COLUMN_FAMILY, DATA_TABLE_NAME_BYTES, tableName);
            put.addColumn(OUTPUT_TABLE_COLUMN_FAMILY, INDEX_TABLE_NAME_BYTES, this.indexName);
            put.addColumn(OUTPUT_TABLE_COLUMN_FAMILY, DATA_TABLE_TS_BYTES, Bytes.toBytes((String)Long.toString(dataRowTs)));
            put.addColumn(OUTPUT_TABLE_COLUMN_FAMILY, INDEX_TABLE_ROW_KEY_BYTES, indexRowKey);
            put.addColumn(OUTPUT_TABLE_COLUMN_FAMILY, INDEX_TABLE_TS_BYTES, Bytes.toBytes((String)Long.toString(indexRowTs)));
            if (expectedValue != null) {
                errorMessageBytes = IndexVerificationOutputRepository.getErrorMessageBytes(errorMsg, expectedValue, actualValue);
                put.addColumn(OUTPUT_TABLE_COLUMN_FAMILY, EXPECTED_VALUE_BYTES, expectedValue);
                put.addColumn(OUTPUT_TABLE_COLUMN_FAMILY, ACTUAL_VALUE_BYTES, actualValue);
            } else {
                errorMessageBytes = Bytes.toBytes((String)errorMsg);
            }
            put.addColumn(OUTPUT_TABLE_COLUMN_FAMILY, ERROR_MESSAGE_BYTES, errorMessageBytes);
            put.addColumn(OUTPUT_TABLE_COLUMN_FAMILY, ERROR_TYPE_BYTES, Bytes.toBytes((String)errorType.toString()));
            if (isBeforeRebuild) {
                put.addColumn(OUTPUT_TABLE_COLUMN_FAMILY, VERIFICATION_PHASE_BYTES, PHASE_BEFORE_VALUE);
            } else {
                put.addColumn(OUTPUT_TABLE_COLUMN_FAMILY, VERIFICATION_PHASE_BYTES, PHASE_AFTER_VALUE);
            }
            this.outputTable.put(put);
        }
    }

    public boolean shouldLogOutput(boolean isBeforeRebuild, IndexVerificationErrorType errorType) {
        return this.shouldLogOutputForVerifyType(isBeforeRebuild) && this.shouldLogOutputForErrorType(errorType);
    }

    private boolean shouldLogOutputForVerifyType(boolean isBeforeRebuild) {
        if (this.disableLoggingVerifyType.equals((Object)IndexTool.IndexDisableLoggingType.BOTH)) {
            return false;
        }
        if (this.disableLoggingVerifyType.equals((Object)IndexTool.IndexDisableLoggingType.NONE)) {
            return true;
        }
        if (isBeforeRebuild && this.disableLoggingVerifyType.equals((Object)IndexTool.IndexDisableLoggingType.AFTER)) {
            return true;
        }
        return !isBeforeRebuild && this.disableLoggingVerifyType.equals((Object)IndexTool.IndexDisableLoggingType.BEFORE);
    }

    private boolean shouldLogOutputForErrorType(IndexVerificationErrorType errorType) {
        if (errorType != null && (errorType.equals((Object)IndexVerificationErrorType.BEYOND_MAX_LOOKBACK_INVALID) || errorType.equals((Object)IndexVerificationErrorType.BEYOND_MAX_LOOKBACK_MISSING))) {
            return this.shouldLogBeyondMaxLookback;
        }
        return true;
    }

    public static byte[] getErrorMessageBytes(String errorMsg, byte[] expectedValue, byte[] actualValue) {
        byte[] errorMessageBytes = new byte[errorMsg.length() + expectedValue.length + actualValue.length + 6];
        Bytes.putBytes((byte[])errorMessageBytes, (int)0, (byte[])Bytes.toBytes((String)errorMsg), (int)0, (int)errorMsg.length());
        int length = errorMsg.length();
        Bytes.putBytes((byte[])errorMessageBytes, (int)length, (byte[])E_VALUE_PREFIX_BYTES, (int)0, (int)3);
        Bytes.putBytes((byte[])errorMessageBytes, (int)(length += 3), (byte[])expectedValue, (int)0, (int)expectedValue.length);
        Bytes.putBytes((byte[])errorMessageBytes, (int)(length += expectedValue.length), (byte[])A_VALUE_PREFIX_BYTES, (int)0, (int)3);
        Bytes.putBytes((byte[])errorMessageBytes, (int)(length += 3), (byte[])actualValue, (int)0, (int)actualValue.length);
        return errorMessageBytes;
    }

    public List<IndexVerificationOutputRow> getOutputRows(long ts, byte[] indexName) throws IOException {
        Iterator<IndexVerificationOutputRow> iter = this.getOutputRowIterator(ts, indexName);
        return this.getIndexVerificationOutputRows(iter);
    }

    @VisibleForTesting
    public List<IndexVerificationOutputRow> getAllOutputRows() throws IOException {
        Iterator<IndexVerificationOutputRow> iter = this.getOutputRowIteratorForAllRows();
        return this.getIndexVerificationOutputRows(iter);
    }

    private List<IndexVerificationOutputRow> getIndexVerificationOutputRows(Iterator<IndexVerificationOutputRow> iter) {
        ArrayList<IndexVerificationOutputRow> outputRowList = new ArrayList<IndexVerificationOutputRow>();
        while (iter.hasNext()) {
            outputRowList.add(iter.next());
        }
        return outputRowList;
    }

    public Iterator<IndexVerificationOutputRow> getOutputRowIterator(long ts, byte[] indexName) throws IOException {
        Scan scan = new Scan();
        byte[] partialKey = IndexVerificationOutputRepository.generatePartialOutputTableRowKey(ts, indexName);
        scan.withStartRow(partialKey);
        scan.withStopRow(ByteUtil.calculateTheClosestNextRowKeyForPrefix((byte[])partialKey));
        ResultScanner scanner = this.outputTable.getScanner(scan);
        return new IndexVerificationOutputRowIterator(scanner.iterator());
    }

    @VisibleForTesting
    public Iterator<IndexVerificationOutputRow> getOutputRowIteratorForAllRows() throws IOException {
        Scan scan = new Scan();
        ResultScanner scanner = this.outputTable.getScanner(scan);
        return new IndexVerificationOutputRowIterator(scanner.iterator());
    }

    public static IndexVerificationOutputRow getOutputRowFromResult(Result result) {
        IndexVerificationErrorType errorType;
        IndexVerificationOutputRow.IndexVerificationOutputRowBuilder builder = new IndexVerificationOutputRow.IndexVerificationOutputRowBuilder();
        byte[] rowKey = result.getRow();
        byte[][] rowKeySplit = ByteUtil.splitArrayBySeparator((byte[])rowKey, (byte)ROW_KEY_SEPARATOR_BYTE[0]);
        builder.setScanMaxTimestamp(Long.parseLong(Bytes.toString((byte[])rowKeySplit[0])));
        builder.setIndexTableName(Bytes.toString((byte[])rowKeySplit[1]));
        builder.setDataTableRowKey(rowKeySplit[2]);
        builder.setDataTableName(Bytes.toString((byte[])result.getValue(OUTPUT_TABLE_COLUMN_FAMILY, DATA_TABLE_NAME_BYTES)));
        builder.setIndexTableRowKey(result.getValue(OUTPUT_TABLE_COLUMN_FAMILY, INDEX_TABLE_ROW_KEY_BYTES));
        builder.setDataTableRowTimestamp(Long.parseLong(Bytes.toString((byte[])result.getValue(OUTPUT_TABLE_COLUMN_FAMILY, DATA_TABLE_TS_BYTES))));
        builder.setIndexTableRowTimestamp(Long.parseLong(Bytes.toString((byte[])result.getValue(OUTPUT_TABLE_COLUMN_FAMILY, INDEX_TABLE_TS_BYTES))));
        builder.setErrorMessage(Bytes.toString((byte[])result.getValue(OUTPUT_TABLE_COLUMN_FAMILY, ERROR_MESSAGE_BYTES)));
        builder.setExpectedValue(result.getValue(OUTPUT_TABLE_COLUMN_FAMILY, EXPECTED_VALUE_BYTES));
        builder.setActualValue(result.getValue(OUTPUT_TABLE_COLUMN_FAMILY, ACTUAL_VALUE_BYTES));
        builder.setPhaseValue(result.getValue(OUTPUT_TABLE_COLUMN_FAMILY, VERIFICATION_PHASE_BYTES));
        try {
            errorType = IndexVerificationErrorType.valueOf(Bytes.toString((byte[])result.getValue(OUTPUT_TABLE_COLUMN_FAMILY, ERROR_TYPE_BYTES)));
        }
        catch (Throwable e) {
            errorType = IndexVerificationErrorType.UNKNOWN;
        }
        builder.setErrorType(errorType);
        return builder.build();
    }

    @Override
    public void close() throws IOException {
        if (this.outputTable != null) {
            this.outputTable.close();
        }
        if (this.indexTable != null) {
            this.indexTable.close();
        }
    }

    public void setIndexTable(Table indexTable) {
        this.indexTable = indexTable;
    }

    public void setOutputTable(Table outputTable) {
        this.outputTable = outputTable;
    }

    public static class IndexVerificationOutputRowIterator
    implements Iterator<IndexVerificationOutputRow> {
        Iterator<Result> delegate;

        public IndexVerificationOutputRowIterator(Iterator<Result> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public IndexVerificationOutputRow next() {
            Result result = this.delegate.next();
            if (result == null) {
                return null;
            }
            return IndexVerificationOutputRepository.getOutputRowFromResult(result);
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }
    }

    public static enum IndexVerificationErrorType {
        INVALID_ROW,
        MISSING_ROW,
        EXTRA_ROW,
        EXTRA_CELLS,
        BEYOND_MAX_LOOKBACK_INVALID,
        BEYOND_MAX_LOOKBACK_MISSING,
        UNKNOWN;

    }
}

