/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce.index;

import java.io.IOException;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableInputFormat;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.phoenix.compile.PostIndexDDLCompiler;
import org.apache.phoenix.hbase.index.AbstractValueGetter;
import org.apache.phoenix.hbase.index.ValueGetter;
import org.apache.phoenix.hbase.index.covered.update.ColumnReference;
import org.apache.phoenix.hbase.index.util.IndexManagementUtil;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.jdbc.PhoenixResultSet;
import org.apache.phoenix.mapreduce.CsvBulkImportUtil;
import org.apache.phoenix.mapreduce.PhoenixServerBuildIndexInputFormat;
import org.apache.phoenix.mapreduce.index.IndexScrutinyTool;
import org.apache.phoenix.mapreduce.index.IndexVerificationOutputRepository;
import org.apache.phoenix.mapreduce.index.IndexVerificationResultRepository;
import org.apache.phoenix.mapreduce.index.PhoenixIndexDBWritable;
import org.apache.phoenix.mapreduce.index.PhoenixIndexImportDirectMapper;
import org.apache.phoenix.mapreduce.index.PhoenixIndexImportDirectReducer;
import org.apache.phoenix.mapreduce.index.PhoenixIndexPartialBuildMapper;
import org.apache.phoenix.mapreduce.index.PhoenixServerBuildIndexDBWritable;
import org.apache.phoenix.mapreduce.index.PhoenixServerBuildIndexMapper;
import org.apache.phoenix.mapreduce.index.SourceTargetColumnNames;
import org.apache.phoenix.mapreduce.util.ColumnInfoToStringEncoderDecoder;
import org.apache.phoenix.mapreduce.util.ConnectionUtil;
import org.apache.phoenix.mapreduce.util.PhoenixConfigurationUtil;
import org.apache.phoenix.mapreduce.util.PhoenixMapReduceUtil;
import org.apache.phoenix.parse.HintNode;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.phoenix.thirdparty.com.google.common.base.Strings;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.CommandLine;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.DefaultParser;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.HelpFormatter;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.Option;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.Options;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.ParseException;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.EquiDepthStreamHistogram;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TransactionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexTool
extends Configured
implements Tool {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexTool.class);
    private String schemaName;
    private String dataTable;
    private String indexTable;
    private String dataTableWithSchema;
    private String indexTableWithSchema;
    private boolean isPartialBuild;
    private boolean isForeground;
    private IndexVerifyType indexVerifyType = IndexVerifyType.NONE;
    private IndexDisableLoggingType disableLoggingType = IndexDisableLoggingType.NONE;
    private IndexScrutinyTool.SourceTable sourceTable = IndexScrutinyTool.SourceTable.DATA_TABLE_SOURCE;
    private String qDataTable;
    private String qIndexTable;
    private String qSchemaName;
    private boolean useSnapshot;
    private boolean isLocalIndexBuild = false;
    private boolean shouldDeleteBeforeRebuild;
    private PTable pIndexTable = null;
    private PTable pDataTable;
    private String tenantId = null;
    private Job job;
    private Long startTime;
    private Long endTime;
    private Long lastVerifyTime;
    private PTable.IndexType indexType;
    private String basePath;
    byte[][] splitKeysBeforeJob = null;
    Configuration configuration;
    private static final Option SCHEMA_NAME_OPTION = new Option("s", "schema", true, "Phoenix schema name (optional)");
    private static final Option DATA_TABLE_OPTION = new Option("dt", "data-table", true, "Data table name (mandatory)");
    private static final Option INDEX_TABLE_OPTION = new Option("it", "index-table", true, "Index table name(not required in case of partial rebuilding)");
    private static final Option PARTIAL_REBUILD_OPTION = new Option("pr", "partial-rebuild", false, "To build indexes for a data table from least disabledTimeStamp");
    private static final Option DIRECT_API_OPTION = new Option("direct", "direct", false, "This parameter is deprecated. Direct mode will be used whether it is set or not. Keeping it for backwards compatibility.");
    private static final Option VERIFY_OPTION = new Option("v", "verify", true, "To verify every data row has a corresponding row of a global index. For other types of indexes, this option will be silently ignored. The accepted values are NONE, ONLY, BEFORE,  AFTER, and BOTH. NONE is for no inline verification, which is also the default for this option. ONLY is for verifying without rebuilding index rows. The rest for verifying before, after, and both before and after rebuilding row. If the verification is done before rebuilding rows and the correct index rows will not be rebuilt");
    private static final double DEFAULT_SPLIT_SAMPLING_RATE = 10.0;
    private static final Option SPLIT_INDEX_OPTION = new Option("sp", "split", true, "Split the index table before building, to have the same # of regions as the data table.  The data table is sampled to get uniform index splits across the index values.  Takes an optional argument specifying the sampling rate,otherwise defaults to 10.0");
    private static final int DEFAULT_AUTOSPLIT_NUM_REGIONS = 20;
    private static final Option AUTO_SPLIT_INDEX_OPTION = new Option("spa", "autosplit", true, "Automatically split the index table if the # of data table regions is greater than N. Takes an optional argument specifying N, otherwise defaults to 20.  Can be used in conjunction with -split option to specify the sampling rate");
    private static final Option RUN_FOREGROUND_OPTION = new Option("runfg", "run-foreground", false, "Applicable on top of -direct option.If specified, runs index build in Foreground. Default - Runs the build in background.");
    private static final Option OUTPUT_PATH_OPTION = new Option("op", "output-path", true, "Output path where the files are written");
    private static final Option SNAPSHOT_OPTION = new Option("snap", "snapshot", false, "If specified, uses Snapshots for async index building (optional)");
    private static final Option TENANT_ID_OPTION = new Option("tenant", "tenant-id", true, "If specified, uses Tenant connection for tenant view index building (optional)");
    private static final Option DELETE_ALL_AND_REBUILD_OPTION = new Option("deleteall", "delete-all-and-rebuild", false, "Applicable only to global indexes on tables, not to local or view indexes. If specified, truncates the index table and rebuilds (optional)");
    private static final Option HELP_OPTION = new Option("h", "help", false, "Help");
    private static final Option START_TIME_OPTION = new Option("st", "start-time", true, "Start time for indextool rebuild or verify");
    private static final Option END_TIME_OPTION = new Option("et", "end-time", true, "End time for indextool rebuild or verify");
    private static final Option RETRY_VERIFY_OPTION = new Option("rv", "retry-verify", true, "Max scan ts of the last rebuild/verify that needs to be retried incrementally");
    private static final Option DISABLE_LOGGING_OPTION = new Option("dl", "disable-logging", true, "Disable logging of failed verification rows for BEFORE, AFTER, or BOTH verify jobs");
    private static final Option USE_INDEX_TABLE_AS_SOURCE_OPTION = new Option("fi", "from-index", false, "To verify every row in the index table has a corresponding row in the data table. Only supported for global indexes. If this option is used with -v AFTER, these extra rows will be identified but not repaired.");
    public static final String INDEX_JOB_NAME_TEMPLATE = "PHOENIX_%s.%s_INDX_%s";
    public static final String INVALID_TIME_RANGE_EXCEPTION_MESSAGE = "startTime is greater than or equal to endTime or either of them are set in the future; IndexTool can't proceed.";
    public static final String FEATURE_NOT_APPLICABLE = "start-time/end-time and retry verify feature are only applicable for local or non-transactional global indexes";
    public static final String RETRY_VERIFY_NOT_APPLICABLE = "retry verify feature accepts non-zero ts set in the past and ts must be present in PHOENIX_INDEX_TOOL_RESULT table";

    private Options getOptions() {
        Options options = new Options();
        options.addOption(SCHEMA_NAME_OPTION);
        options.addOption(DATA_TABLE_OPTION);
        options.addOption(INDEX_TABLE_OPTION);
        options.addOption(PARTIAL_REBUILD_OPTION);
        options.addOption(DIRECT_API_OPTION);
        options.addOption(VERIFY_OPTION);
        options.addOption(RUN_FOREGROUND_OPTION);
        options.addOption(OUTPUT_PATH_OPTION);
        options.addOption(SNAPSHOT_OPTION);
        options.addOption(TENANT_ID_OPTION);
        options.addOption(DELETE_ALL_AND_REBUILD_OPTION);
        options.addOption(HELP_OPTION);
        AUTO_SPLIT_INDEX_OPTION.setOptionalArg(true);
        SPLIT_INDEX_OPTION.setOptionalArg(true);
        START_TIME_OPTION.setOptionalArg(true);
        END_TIME_OPTION.setOptionalArg(true);
        RETRY_VERIFY_OPTION.setOptionalArg(true);
        options.addOption(AUTO_SPLIT_INDEX_OPTION);
        options.addOption(SPLIT_INDEX_OPTION);
        options.addOption(START_TIME_OPTION);
        options.addOption(END_TIME_OPTION);
        options.addOption(RETRY_VERIFY_OPTION);
        options.addOption(DISABLE_LOGGING_OPTION);
        options.addOption(USE_INDEX_TABLE_AS_SOURCE_OPTION);
        return options;
    }

    @VisibleForTesting
    public CommandLine parseOptions(String[] args) {
        boolean splitIndex;
        Options options = this.getOptions();
        DefaultParser parser = DefaultParser.builder().setAllowPartialMatching(false).setStripLeadingAndTrailingQuotes(Boolean.valueOf(false)).build();
        CommandLine cmdLine = null;
        try {
            cmdLine = parser.parse(options, args);
        }
        catch (ParseException e) {
            this.printHelpAndExit("Error parsing command line options: " + e.getMessage(), options);
        }
        if (cmdLine.hasOption(HELP_OPTION.getOpt())) {
            this.printHelpAndExit(options, 0);
        }
        if (!cmdLine.hasOption(DATA_TABLE_OPTION.getOpt())) {
            throw new IllegalStateException(DATA_TABLE_OPTION.getLongOpt() + " is a mandatory parameter");
        }
        if (cmdLine.hasOption(PARTIAL_REBUILD_OPTION.getOpt()) && cmdLine.hasOption(INDEX_TABLE_OPTION.getOpt())) {
            throw new IllegalStateException("Index name should not be passed with " + PARTIAL_REBUILD_OPTION.getLongOpt());
        }
        if (!cmdLine.hasOption(PARTIAL_REBUILD_OPTION.getOpt()) && !cmdLine.hasOption(INDEX_TABLE_OPTION.getOpt())) {
            throw new IllegalStateException("Index name should be passed unless it is a partial rebuild.");
        }
        if (cmdLine.hasOption(PARTIAL_REBUILD_OPTION.getOpt()) && cmdLine.hasOption(DELETE_ALL_AND_REBUILD_OPTION.getOpt())) {
            throw new IllegalStateException(DELETE_ALL_AND_REBUILD_OPTION.getLongOpt() + " is not compatible with " + PARTIAL_REBUILD_OPTION.getLongOpt());
        }
        boolean bl = splitIndex = cmdLine.hasOption(AUTO_SPLIT_INDEX_OPTION.getOpt()) || cmdLine.hasOption(SPLIT_INDEX_OPTION.getOpt());
        if (splitIndex && !cmdLine.hasOption(INDEX_TABLE_OPTION.getOpt())) {
            throw new IllegalStateException("Must pass an index name for the split index option");
        }
        if (splitIndex && cmdLine.hasOption(PARTIAL_REBUILD_OPTION.getOpt())) {
            throw new IllegalStateException("Cannot split index for a partial rebuild, as the index table is dropped");
        }
        if (this.loggingDisabledMismatchesVerifyOption(cmdLine)) {
            throw new IllegalStateException("Can't disable index verification logging when no index verification or the wrong kind of index verification has been requested. VerifyType: [" + cmdLine.getOptionValue(VERIFY_OPTION.getOpt()) + "] and DisableLoggingType: [" + cmdLine.getOptionValue(DISABLE_LOGGING_OPTION.getOpt()) + "]");
        }
        return cmdLine;
    }

    private boolean loggingDisabledMismatchesVerifyOption(CommandLine cmdLine) {
        boolean loggingDisabled = cmdLine.hasOption(DISABLE_LOGGING_OPTION.getOpt());
        if (!loggingDisabled) {
            return false;
        }
        boolean hasVerifyOption = cmdLine.hasOption(VERIFY_OPTION.getOpt());
        if (!hasVerifyOption) {
            return true;
        }
        String loggingDisableValue = cmdLine.getOptionValue(DISABLE_LOGGING_OPTION.getOpt());
        String verifyValue = cmdLine.getOptionValue(VERIFY_OPTION.getOpt());
        IndexDisableLoggingType loggingDisableType = IndexDisableLoggingType.fromValue(loggingDisableValue);
        IndexVerifyType verifyType = IndexVerifyType.fromValue(verifyValue);
        if (verifyType.equals((Object)IndexVerifyType.NONE)) {
            return true;
        }
        if ((verifyType.equals((Object)IndexVerifyType.BEFORE) || verifyType.equals((Object)IndexVerifyType.ONLY)) && loggingDisableType.equals((Object)IndexDisableLoggingType.AFTER)) {
            return true;
        }
        if (verifyType.equals((Object)IndexVerifyType.AFTER) && loggingDisableType.equals((Object)IndexDisableLoggingType.BEFORE)) {
            return true;
        }
        return loggingDisableType.equals((Object)IndexDisableLoggingType.BOTH) && !verifyType.equals((Object)IndexVerifyType.BOTH);
    }

    private void printHelpAndExit(String errorMessage, Options options) {
        System.err.println(errorMessage);
        this.printHelpAndExit(options, 1);
    }

    private void printHelpAndExit(Options options, int exitCode) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("help", options);
        System.exit(exitCode);
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public Long getLastVerifyTime() {
        return this.lastVerifyTime;
    }

    public IndexDisableLoggingType getDisableLoggingType() {
        return this.disableLoggingType;
    }

    public IndexScrutinyTool.SourceTable getSourceTable() {
        return this.sourceTable;
    }

    public Job getJob() {
        return this.job;
    }

    public static void createIndexToolTables(java.sql.Connection connection) throws Exception {
        try (IndexVerificationResultRepository resultRepo = new IndexVerificationResultRepository();
             IndexVerificationOutputRepository outputRepo = new IndexVerificationOutputRepository();){
            resultRepo.createResultTable(connection);
            outputRepo.createOutputTable(connection);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int run(String[] args) throws Exception {
        CommandLine cmdLine;
        try {
            cmdLine = this.parseOptions(args);
        }
        catch (IllegalStateException e) {
            this.printHelpAndExit(e.getMessage(), this.getOptions());
            return -1;
        }
        this.configuration = HBaseConfiguration.addHbaseResources((Configuration)this.getConf());
        this.populateIndexToolAttributes(cmdLine);
        if (this.tenantId != null) {
            this.configuration.set("TenantId", this.tenantId);
        }
        try (java.sql.Connection conn = this.getConnection(this.configuration);){
            boolean result;
            IndexTool.createIndexToolTables(conn);
            if (this.dataTable != null && this.indexTable != null) {
                this.setupIndexAndDataTable(conn);
                IndexTool.checkIfFeatureApplicable(this.startTime, this.endTime, this.lastVerifyTime, this.pDataTable, this.isLocalIndexBuild);
                if (this.shouldDeleteBeforeRebuild) {
                    this.deleteBeforeRebuild(conn);
                }
                this.preSplitIndexTable(cmdLine, conn);
            }
            if (result = this.submitIndexToolJob(conn, this.configuration)) {
                int n2 = 0;
                return n2;
            }
            LOGGER.error("IndexTool job failed! Check logs for errors..");
            int n = -1;
            return n;
        }
        catch (Exception ex) {
            LOGGER.error("An exception occurred while performing the indexing job: " + ExceptionUtils.getMessage((Throwable)ex) + " at:\n" + ExceptionUtils.getStackTrace((Throwable)ex));
            return -1;
        }
    }

    public static void checkIfFeatureApplicable(Long startTime, Long endTime, Long lastVerifyTime, PTable pDataTable, boolean isLocalIndexBuild) {
        boolean isApplicable = IndexTool.isFeatureApplicable(pDataTable, isLocalIndexBuild);
        if (!isApplicable && (IndexTool.isTimeRangeSet(startTime, endTime) || lastVerifyTime != null)) {
            throw new RuntimeException(FEATURE_NOT_APPLICABLE);
        }
    }

    private boolean submitIndexToolJob(java.sql.Connection conn, Configuration configuration) throws Exception {
        Path outputPath = null;
        if (this.basePath != null) {
            outputPath = CsvBulkImportUtil.getOutputPath(new Path(this.basePath), this.pIndexTable == null ? this.pDataTable.getPhysicalName().getString() : this.pIndexTable.getPhysicalName().getString());
            FileSystem fs = outputPath.getFileSystem(configuration);
            fs.delete(outputPath, true);
        }
        JobFactory jobFactory = new JobFactory(conn, configuration, outputPath);
        this.job = jobFactory.getJob();
        if (!this.isForeground) {
            LOGGER.info("Running Index Build in Background - Submit async and exit");
            this.job.submit();
            return true;
        }
        LOGGER.info("Running Index Build in Foreground. Waits for the build to complete. This may take a long time!.");
        return this.job.waitForCompletion(true);
    }

    @VisibleForTesting
    public int populateIndexToolAttributes(CommandLine cmdLine) throws Exception {
        boolean useTenantId = cmdLine.hasOption(TENANT_ID_OPTION.getOpt());
        boolean useStartTime = cmdLine.hasOption(START_TIME_OPTION.getOpt());
        boolean useEndTime = cmdLine.hasOption(END_TIME_OPTION.getOpt());
        boolean retryVerify = cmdLine.hasOption(RETRY_VERIFY_OPTION.getOpt());
        boolean verify = cmdLine.hasOption(VERIFY_OPTION.getOpt());
        boolean disableLogging = cmdLine.hasOption(DISABLE_LOGGING_OPTION.getOpt());
        boolean useIndexTableAsSource = cmdLine.hasOption(USE_INDEX_TABLE_AS_SOURCE_OPTION.getOpt());
        if (useTenantId) {
            this.tenantId = cmdLine.getOptionValue(TENANT_ID_OPTION.getOpt());
        }
        if (useStartTime) {
            this.startTime = new Long(cmdLine.getOptionValue(START_TIME_OPTION.getOpt()));
        }
        if (useEndTime) {
            this.endTime = new Long(cmdLine.getOptionValue(END_TIME_OPTION.getOpt()));
        }
        if (retryVerify) {
            this.lastVerifyTime = new Long(cmdLine.getOptionValue(RETRY_VERIFY_OPTION.getOpt()));
            this.validateLastVerifyTime();
        }
        if (IndexTool.isTimeRangeSet(this.startTime, this.endTime)) {
            IndexTool.validateTimeRange(this.startTime, this.endTime);
        }
        if (verify) {
            String value = cmdLine.getOptionValue(VERIFY_OPTION.getOpt());
            this.indexVerifyType = IndexVerifyType.fromValue(value);
            if (disableLogging) {
                this.disableLoggingType = IndexDisableLoggingType.fromValue(cmdLine.getOptionValue(DISABLE_LOGGING_OPTION.getOpt()));
            }
        }
        if (useIndexTableAsSource) {
            this.sourceTable = IndexScrutinyTool.SourceTable.INDEX_TABLE_SOURCE;
        }
        this.schemaName = cmdLine.getOptionValue(SCHEMA_NAME_OPTION.getOpt());
        this.dataTable = cmdLine.getOptionValue(DATA_TABLE_OPTION.getOpt());
        this.indexTable = cmdLine.getOptionValue(INDEX_TABLE_OPTION.getOpt());
        this.isPartialBuild = cmdLine.hasOption(PARTIAL_REBUILD_OPTION.getOpt());
        this.dataTableWithSchema = SchemaUtil.getQualifiedPhoenixTableName((String)this.schemaName, (String)this.dataTable);
        this.indexTableWithSchema = SchemaUtil.getQualifiedPhoenixTableName((String)this.schemaName, (String)this.indexTable);
        this.qDataTable = SchemaUtil.getQualifiedTableName((String)this.schemaName, (String)this.dataTable);
        this.basePath = cmdLine.getOptionValue(OUTPUT_PATH_OPTION.getOpt());
        this.isForeground = cmdLine.hasOption(RUN_FOREGROUND_OPTION.getOpt());
        this.useSnapshot = cmdLine.hasOption(SNAPSHOT_OPTION.getOpt());
        this.shouldDeleteBeforeRebuild = cmdLine.hasOption(DELETE_ALL_AND_REBUILD_OPTION.getOpt());
        return 0;
    }

    public int validateLastVerifyTime() throws Exception {
        Long currentTime = EnvironmentEdgeManager.currentTimeMillis();
        if (this.lastVerifyTime.compareTo(currentTime) > 0 || this.lastVerifyTime == 0L || !this.isValidLastVerifyTime(this.lastVerifyTime)) {
            throw new RuntimeException(RETRY_VERIFY_NOT_APPLICABLE);
        }
        return 0;
    }

    /*
     * Exception decompiling
     */
    public boolean isValidLastVerifyTime(Long lastVerifyTime) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void validateTimeRange(Long sTime, Long eTime) {
        Long et;
        Long currentTime = EnvironmentEdgeManager.currentTimeMillis();
        Long st = sTime == null ? 0L : sTime;
        Long l = et = eTime == null ? currentTime : eTime;
        if (st.compareTo(currentTime) > 0 || et.compareTo(currentTime) > 0 || st.compareTo(et) >= 0) {
            throw new RuntimeException(INVALID_TIME_RANGE_EXCEPTION_MESSAGE);
        }
    }

    private java.sql.Connection getConnection(Configuration configuration) throws SQLException {
        return ConnectionUtil.getInputConnection((Configuration)configuration);
    }

    private void setupIndexAndDataTable(java.sql.Connection connection) throws SQLException, IOException {
        this.pDataTable = connection.unwrap(PhoenixConnection.class).getTableNoCache(this.qDataTable);
        if (!IndexTool.isValidIndexTable(connection, this.qDataTable, this.indexTable, this.tenantId)) {
            throw new IllegalArgumentException(String.format(" %s is not an index table for %s for this connection", this.indexTable, this.qDataTable));
        }
        this.qSchemaName = SchemaUtil.normalizeIdentifier((String)this.schemaName);
        this.pIndexTable = connection.unwrap(PhoenixConnection.class).getTable(SchemaUtil.getQualifiedTableName((String)this.schemaName, (String)this.indexTable));
        this.indexType = this.pIndexTable.getIndexType();
        this.qIndexTable = SchemaUtil.getQualifiedTableName((String)this.schemaName, (String)this.indexTable);
        if (PTable.IndexType.LOCAL.equals((Object)this.indexType)) {
            this.isLocalIndexBuild = true;
            if (this.useSnapshot) {
                throw new IllegalArgumentException(String.format("%s is a local index. snapshots are not supported for local indexes.", this.qIndexTable));
            }
            try (Connection hConn = this.getTemporaryHConnection(connection.unwrap(PhoenixConnection.class));){
                RegionLocator regionLocator = hConn.getRegionLocator(TableName.valueOf((byte[])this.pIndexTable.getPhysicalName().getBytes()));
                this.splitKeysBeforeJob = regionLocator.getStartKeys();
            }
        }
        this.changeDisabledIndexStateToBuiding(connection);
    }

    public static boolean isTimeRangeSet(Long startTime, Long endTime) {
        return startTime != null || endTime != null;
    }

    private static boolean isFeatureApplicable(PTable dataTable, boolean isLocalIndexBuild) {
        return isLocalIndexBuild || !dataTable.isTransactional();
    }

    private void changeDisabledIndexStateToBuiding(java.sql.Connection connection) throws SQLException {
        if (this.pIndexTable != null && this.pIndexTable.getIndexState().isDisabled()) {
            IndexUtil.updateIndexState((PhoenixConnection)connection.unwrap(PhoenixConnection.class), (String)this.pIndexTable.getName().getString(), (PIndexState)PIndexState.BUILDING, null);
        }
    }

    private void preSplitIndexTable(CommandLine cmdLine, java.sql.Connection connection) throws SQLException, IOException {
        boolean isSalted;
        boolean autosplit = cmdLine.hasOption(AUTO_SPLIT_INDEX_OPTION.getOpt());
        boolean splitIndex = cmdLine.hasOption(SPLIT_INDEX_OPTION.getOpt());
        boolean bl = isSalted = this.pIndexTable.getBucketNum() != null;
        if (!isSalted && (PTable.IndexType.GLOBAL.equals((Object)this.indexType) || PTable.IndexType.UNCOVERED_GLOBAL.equals((Object)this.indexType)) && (autosplit || splitIndex)) {
            String nOpt = cmdLine.getOptionValue(AUTO_SPLIT_INDEX_OPTION.getOpt());
            int autosplitNumRegions = nOpt == null ? 20 : Integer.parseInt(nOpt);
            String rateOpt = cmdLine.getOptionValue(SPLIT_INDEX_OPTION.getOpt());
            double samplingRate = rateOpt == null ? 10.0 : Double.parseDouble(rateOpt);
            LOGGER.info(String.format("Will split index %s , autosplit=%s , autoSplitNumRegions=%s , samplingRate=%s", this.indexTable, autosplit, autosplitNumRegions, samplingRate));
            this.splitIndexTable(connection.unwrap(PhoenixConnection.class), autosplit, autosplitNumRegions, samplingRate);
        }
    }

    private void deleteBeforeRebuild(java.sql.Connection conn) throws SQLException, IOException {
        if (MetaDataUtil.isViewIndex((String)this.pIndexTable.getPhysicalName().getString())) {
            throw new IllegalArgumentException(String.format("%s is a view index. delete-all-and-rebuild is not supported for view indexes", this.qIndexTable));
        }
        if (this.isLocalIndexBuild) {
            throw new IllegalArgumentException(String.format("%s is a local index.  delete-all-and-rebuild is not supported for local indexes", this.qIndexTable));
        }
        ConnectionQueryServices queryServices = conn.unwrap(PhoenixConnection.class).getQueryServices();
        try (Admin admin = queryServices.getAdmin();){
            TableName tableName = TableName.valueOf((String)this.qIndexTable);
            admin.disableTable(tableName);
            admin.truncateTable(tableName, true);
        }
    }

    private void splitIndexTable(PhoenixConnection pConnection, boolean autosplit, int autosplitNumRegions, double samplingRate) throws SQLException, IOException, IllegalArgumentException {
        int numRegions;
        TableName hDataName = TableName.valueOf((byte[])this.pDataTable.getPhysicalName().getBytes());
        try (Connection tempHConn = this.getTemporaryHConnection(pConnection);
             RegionLocator regionLocator = tempHConn.getRegionLocator(hDataName);){
            numRegions = regionLocator.getStartKeys().length;
            if (autosplit && numRegions <= autosplitNumRegions) {
                LOGGER.info(String.format("Will not split index %s because the data table only has %s regions, autoSplitNumRegions=%s", this.pIndexTable.getPhysicalName(), numRegions, autosplitNumRegions));
                return;
            }
        }
        SourceTargetColumnNames.DataSourceColNames colNames = new SourceTargetColumnNames.DataSourceColNames(this.pDataTable, this.pIndexTable);
        String qTableSample = String.format("%s TABLESAMPLE(%.2f)", this.qDataTable, samplingRate);
        List<String> dataColNames = colNames.getDataColNames();
        String dataSampleQuery = QueryUtil.constructSelectStatement((String)qTableSample, dataColNames, null, (HintNode.Hint)HintNode.Hint.NO_INDEX, (boolean)true);
        IndexMaintainer maintainer = IndexMaintainer.create((PTable)this.pDataTable, (PTable)this.pIndexTable, (PhoenixConnection)pConnection);
        ImmutableBytesWritable dataRowKeyPtr = new ImmutableBytesWritable();
        try (PhoenixResultSet rs = pConnection.createStatement().executeQuery(dataSampleQuery).unwrap(PhoenixResultSet.class);
             Admin admin = pConnection.getQueryServices().getAdmin();){
            EquiDepthStreamHistogram histo = new EquiDepthStreamHistogram(numRegions);
            ValueGetter getter = IndexTool.getIndexValueGetter(rs, dataColNames);
            while (rs.next()) {
                rs.getCurrentRow().getKey(dataRowKeyPtr);
                byte[] indexRowKey = maintainer.buildRowKey(getter, dataRowKeyPtr, null, null, rs.getCurrentRow().getValue(0).getTimestamp());
                histo.addValue(indexRowKey);
            }
            List buckets = histo.computeBuckets();
            byte[][] splitPoints = new byte[buckets.size() - 1][];
            int splitIdx = 0;
            for (EquiDepthStreamHistogram.Bucket b : buckets.subList(0, buckets.size() - 1)) {
                splitPoints[splitIdx++] = b.getRightBoundExclusive();
            }
            TableName hIndexName = TableName.valueOf((byte[])this.pIndexTable.getPhysicalName().getBytes());
            TableDescriptor descriptor = admin.getDescriptor(hIndexName);
            admin.disableTable(hIndexName);
            admin.deleteTable(hIndexName);
            admin.createTable(descriptor, (byte[][])splitPoints);
        }
    }

    private Connection getTemporaryHConnection(PhoenixConnection pConnection) throws SQLException, IOException {
        try (Admin admin = pConnection.getQueryServices().getAdmin();){
            Connection connection = ConnectionFactory.createConnection((Configuration)admin.getConfiguration());
            return connection;
        }
    }

    public static ValueGetter getIndexValueGetter(final PhoenixResultSet rs, List<String> dataColNames) {
        final HashMap<String, Integer> rsIndex = new HashMap<String, Integer>(dataColNames.size());
        int i = 1;
        for (String dataCol : dataColNames) {
            rsIndex.put(SchemaUtil.getEscapedFullColumnName((String)dataCol), i++);
        }
        return new AbstractValueGetter(){
            final ImmutableBytesWritable valuePtr = new ImmutableBytesWritable();
            final ImmutableBytesWritable rowKeyPtr = new ImmutableBytesWritable();

            public ImmutableBytesWritable getLatestValue(ColumnReference ref, long ts) throws IOException {
                try {
                    String fullColumnName = SchemaUtil.getEscapedFullColumnName((String)SchemaUtil.getColumnDisplayName((byte[])ref.getFamily(), (byte[])ref.getQualifier()));
                    byte[] colVal = rs.getBytes(((Integer)rsIndex.get(fullColumnName)).intValue());
                    this.valuePtr.set(colVal);
                }
                catch (SQLException e) {
                    throw new IOException(e);
                }
                return this.valuePtr;
            }

            public byte[] getRowKey() {
                rs.getCurrentRow().getKey(this.rowKeyPtr);
                return ByteUtil.copyKeyBytesIfNecessary((ImmutableBytesWritable)this.rowKeyPtr);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isValidIndexTable(java.sql.Connection connection, String masterTable, String indexTable, String tenantId) throws SQLException {
        DatabaseMetaData dbMetaData = connection.getMetaData();
        String schemaName = SchemaUtil.getSchemaNameFromFullName((String)masterTable);
        String tableName = SchemaUtil.getTableNameFromFullName((String)masterTable);
        try (ResultSet rs = null;){
            String catalog = "";
            if (tenantId != null) {
                catalog = tenantId;
            }
            rs = dbMetaData.getIndexInfo(catalog, schemaName, tableName, false, false);
            while (rs.next()) {
                String indexName = rs.getString(6);
                if (!SchemaUtil.normalizeIdentifier((String)indexTable).equalsIgnoreCase(indexName)) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public static Map.Entry<Integer, Job> run(Configuration conf, String schemaName, String dataTable, String indexTable, boolean useSnapshot, String tenantId, boolean disableBefore, boolean shouldDeleteBeforeRebuild, boolean runForeground) throws Exception {
        ArrayList args = Lists.newArrayList();
        if (schemaName != null) {
            args.add("--schema=" + schemaName);
        }
        args.add("--data-table=" + dataTable);
        args.add("--index-table=" + indexTable);
        if (runForeground) {
            args.add("-runfg");
        }
        if (useSnapshot) {
            args.add("-snap");
        }
        if (tenantId != null) {
            args.add("-tenant");
            args.add(tenantId);
        }
        if (shouldDeleteBeforeRebuild) {
            args.add("-deleteall");
        }
        args.add("-op");
        args.add("/tmp/" + UUID.randomUUID().toString());
        if (disableBefore) {
            PhoenixConfigurationUtil.setDisableIndexes(conf, indexTable);
        }
        IndexTool indexingTool = new IndexTool();
        indexingTool.setConf(conf);
        int status = indexingTool.run(args.toArray(new String[0]));
        Job job = indexingTool.getJob();
        return new AbstractMap.SimpleEntry<Integer, Job>(status, job);
    }

    public static void main(String[] args) throws Exception {
        int result = ToolRunner.run((Tool)new IndexTool(), (String[])args);
        System.exit(result);
    }

    class JobFactory {
        java.sql.Connection connection;
        Configuration configuration;
        private Path outputPath;
        private FileSystem fs;

        public JobFactory(java.sql.Connection connection, Configuration configuration, Path outputPath) {
            this.connection = connection;
            this.configuration = configuration;
            this.outputPath = outputPath;
        }

        public Job getJob() throws Exception {
            if (IndexTool.this.isPartialBuild) {
                return this.configureJobForPartialBuild();
            }
            long maxTimeRange = IndexTool.this.pIndexTable.getTimeStamp() + 1L;
            if (IndexTool.this.pDataTable.isTransactional()) {
                this.configuration.set("phoenix.mr.txscn.value", Long.toString(TransactionUtil.convertToNanoseconds((long)maxTimeRange)));
                this.configuration.set("phoenix.mr.txprovider", IndexTool.this.pDataTable.getTransactionProvider().name());
            }
            if (IndexTool.this.useSnapshot || !IndexTool.this.isLocalIndexBuild && IndexTool.this.pDataTable.isTransactional()) {
                PhoenixConfigurationUtil.setCurrentScnValue(this.configuration, maxTimeRange);
                if (IndexTool.this.indexVerifyType != IndexVerifyType.NONE) {
                    LOGGER.warn("Verification is not supported for snapshots and transactionaltable index rebuilds, verification parameter ignored");
                }
                return this.configureJobForAsyncIndex();
            }
            if (IndexTool.this.endTime != null) {
                PhoenixConfigurationUtil.setCurrentScnValue(this.configuration, IndexTool.this.endTime);
            }
            if (IndexTool.this.lastVerifyTime != null) {
                PhoenixConfigurationUtil.setIndexToolLastVerifyTime(this.configuration, IndexTool.this.lastVerifyTime);
            }
            return this.configureJobForServerBuildIndex();
        }

        private Job configureJobForPartialBuild() throws Exception {
            this.connection = ConnectionUtil.getInputConnection((Configuration)this.configuration);
            long minDisableTimestamp = Long.MAX_VALUE;
            PTable indexWithMinDisableTimestamp = null;
            ArrayList<String> disableIndexes = new ArrayList<String>();
            ArrayList<PTable> disabledPIndexes = new ArrayList<PTable>();
            for (PTable index : IndexTool.this.pDataTable.getIndexes()) {
                if (!index.getIndexState().equals((Object)PIndexState.BUILDING)) continue;
                disableIndexes.add(index.getTableName().getString());
                disabledPIndexes.add(index);
                long indexDisableTimestamp = Math.abs(index.getIndexDisableTimestamp());
                if (minDisableTimestamp <= indexDisableTimestamp) continue;
                minDisableTimestamp = indexDisableTimestamp;
                indexWithMinDisableTimestamp = index;
            }
            if (indexWithMinDisableTimestamp == null) {
                throw new Exception("There is no index for a datatable to be rebuild:" + IndexTool.this.qDataTable);
            }
            if (minDisableTimestamp == 0L) {
                throw new Exception("It seems Index " + indexWithMinDisableTimestamp + " has disable timestamp as 0 , please run IndexTool with IndexName to build it first");
            }
            long maxTimestamp = this.getMaxRebuildAsyncDate(IndexTool.this.schemaName, disableIndexes);
            ArrayList maintainers = Lists.newArrayListWithExpectedSize((int)disabledPIndexes.size());
            for (PTable index : disabledPIndexes) {
                maintainers.add(index.getIndexMaintainer(IndexTool.this.pDataTable, this.connection.unwrap(PhoenixConnection.class)));
            }
            ImmutableBytesWritable indexMetaDataPtr = new ImmutableBytesWritable(ByteUtil.EMPTY_BYTE_ARRAY);
            IndexMaintainer.serializeAdditional((PTable)IndexTool.this.pDataTable, (ImmutableBytesWritable)indexMetaDataPtr, disabledPIndexes, (PhoenixConnection)this.connection.unwrap(PhoenixConnection.class));
            PhoenixConfigurationUtil.setIndexMaintainers(this.configuration, indexMetaDataPtr);
            if (!Strings.isNullOrEmpty((String)IndexTool.this.tenantId)) {
                PhoenixConfigurationUtil.setTenantId(this.configuration, IndexTool.this.tenantId);
            }
            Scan scan = IndexManagementUtil.newLocalStateScan((List)maintainers);
            scan.setTimeRange(minDisableTimestamp - 1L, maxTimestamp);
            scan.setRaw(true);
            scan.setCacheBlocks(false);
            if (IndexTool.this.pDataTable.isTransactional()) {
                long maxTimeRange = IndexTool.this.pDataTable.getTimeStamp() + 1L;
                scan.setAttribute("_TxScn", Bytes.toBytes((long)TransactionUtil.convertToNanoseconds((long)maxTimeRange)));
            }
            String physicalTableName = IndexTool.this.pDataTable.getPhysicalName().getString();
            String jobName = String.format("Phoenix Indexes build for " + IndexTool.this.pDataTable.getName().toString(), new Object[0]);
            PhoenixConfigurationUtil.setInputTableName(this.configuration, IndexTool.this.dataTableWithSchema);
            PhoenixConfigurationUtil.setPhysicalTableName(this.configuration, physicalTableName);
            PhoenixConfigurationUtil.setDisableIndexes(this.configuration, StringUtils.join((CharSequence)",", disableIndexes));
            Job job = Job.getInstance((Configuration)this.configuration, (String)jobName);
            if (this.outputPath != null) {
                FileOutputFormat.setOutputPath((Job)job, (Path)this.outputPath);
            }
            job.setJarByClass(IndexTool.class);
            TableMapReduceUtil.initTableMapperJob((String)physicalTableName, (Scan)scan, PhoenixIndexPartialBuildMapper.class, null, null, (Job)job);
            TableMapReduceUtil.initCredentials((Job)job);
            TableInputFormat.configureSplitTable((Job)job, (TableName)TableName.valueOf((String)physicalTableName));
            return this.configureSubmittableJobUsingDirectApi(job);
        }

        private long getMaxRebuildAsyncDate(String schemaName, List<String> disableIndexes) throws SQLException {
            Long maxRebuilAsyncDate = Long.MAX_VALUE;
            Long maxDisabledTimeStamp = 0L;
            if (disableIndexes == null || disableIndexes.isEmpty()) {
                return 0L;
            }
            String query = String.format("SELECT MAX(ASYNC_REBUILD_TIMESTAMP), MAX(INDEX_DISABLE_TIMESTAMP) FROM " + PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME + " (" + "ASYNC_REBUILD_TIMESTAMP" + " BIGINT) WHERE " + "TABLE_SCHEM" + " %s  AND " + "TABLE_NAME" + " IN ( %s )", schemaName != null && schemaName.length() > 0 ? " = ? " : " IS NULL ", QueryUtil.generateInListParams((int)disableIndexes.size()));
            Throwable throwable = null;
            try (PreparedStatement selSyscat = this.connection.prepareStatement(query);){
                int param = 0;
                if (schemaName != null && schemaName.length() > 0) {
                    selSyscat.setString(++param, schemaName);
                }
                QueryUtil.setQuoteInListElements((PreparedStatement)selSyscat, disableIndexes, (int)param);
                ResultSet rs = selSyscat.executeQuery();
                if (rs.next()) {
                    maxRebuilAsyncDate = rs.getLong(1);
                    maxDisabledTimeStamp = rs.getLong(2);
                }
                if (maxRebuilAsyncDate > maxDisabledTimeStamp) {
                    long l = maxRebuilAsyncDate;
                    return l;
                }
                try {
                    throw new RuntimeException("Inconsistent state we have one or more index tables which are disabled after the async is called!!");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Job configureJobForAsyncIndex() throws Exception {
            String physicalIndexTable = IndexTool.this.pIndexTable.getPhysicalName().getString();
            PhoenixConnection pConnection = this.connection.unwrap(PhoenixConnection.class);
            PostIndexDDLCompiler ddlCompiler = new PostIndexDDLCompiler(pConnection, new TableRef(IndexTool.this.pDataTable));
            ddlCompiler.compile(IndexTool.this.pIndexTable);
            List indexColumns = ddlCompiler.getIndexColumnNames();
            String selectQuery = ddlCompiler.getSelectQuery();
            String upsertQuery = QueryUtil.constructUpsertStatement((String)IndexTool.this.indexTableWithSchema, (List)indexColumns, (HintNode.Hint)HintNode.Hint.NO_INDEX);
            this.configuration.set("phoenix.upsert.stmt", upsertQuery);
            PhoenixConfigurationUtil.setPhysicalTableName(this.configuration, physicalIndexTable);
            PhoenixConfigurationUtil.setIndexToolIndexTableName(this.configuration, IndexTool.this.qIndexTable);
            PhoenixConfigurationUtil.setDisableIndexes(this.configuration, IndexTool.this.indexTable);
            PhoenixConfigurationUtil.setUpsertColumnNames(this.configuration, indexColumns.toArray(new String[indexColumns.size()]));
            if (IndexTool.this.tenantId != null) {
                PhoenixConfigurationUtil.setTenantId(this.configuration, IndexTool.this.tenantId);
            }
            List columnMetadataList = PhoenixRuntime.generateColumnInfo((java.sql.Connection)pConnection, (String)IndexTool.this.indexTableWithSchema, (List)indexColumns);
            ColumnInfoToStringEncoderDecoder.encode(this.configuration, columnMetadataList);
            if (this.outputPath != null) {
                this.fs = this.outputPath.getFileSystem(this.configuration);
                this.fs.delete(this.outputPath, true);
            }
            String jobName = String.format(IndexTool.INDEX_JOB_NAME_TEMPLATE, IndexTool.this.schemaName, IndexTool.this.dataTable, IndexTool.this.indexTable);
            Job job = Job.getInstance((Configuration)this.configuration, (String)jobName);
            job.setJarByClass(IndexTool.class);
            job.setMapOutputKeyClass(ImmutableBytesWritable.class);
            if (this.outputPath != null) {
                FileOutputFormat.setOutputPath((Job)job, (Path)this.outputPath);
            }
            if (!IndexTool.this.useSnapshot) {
                PhoenixMapReduceUtil.setInput(job, PhoenixIndexDBWritable.class, IndexTool.this.dataTableWithSchema, selectQuery);
            } else {
                String snapshotName;
                try (Admin admin = null;){
                    admin = pConnection.getQueryServices().getAdmin();
                    TableName hDdataTableName = TableName.valueOf((byte[])IndexTool.this.pDataTable.getPhysicalName().getBytes());
                    snapshotName = "INDEXTOOL-" + IndexTool.this.pDataTable.getName().getString() + "-Snapshot-" + System.currentTimeMillis();
                    admin.snapshot(snapshotName, hDdataTableName);
                }
                Path rootDir = new Path("hdfs:///index-snapshot-dir");
                CommonFSUtils.setRootDir((Configuration)this.configuration, (Path)rootDir);
                Path restoreDir = new Path(CommonFSUtils.getRootDir((Configuration)this.configuration), "restore-dir");
                PhoenixMapReduceUtil.setInput(job, PhoenixIndexDBWritable.class, snapshotName, IndexTool.this.dataTableWithSchema, restoreDir, selectQuery);
            }
            TableMapReduceUtil.initCredentials((Job)job);
            job.setMapperClass(PhoenixIndexImportDirectMapper.class);
            return this.configureSubmittableJobUsingDirectApi(job);
        }

        private Job configureJobForServerBuildIndex() throws Exception {
            long indexRebuildQueryTimeoutMs = this.configuration.getLong("phoenix.index.rebuild.query.timeout", 9002100L);
            long indexRebuildRPCTimeoutMs = this.configuration.getLong("phoenix.index.rebuild.rpc.timeout", 1800000L);
            long indexRebuildClientScannerTimeOutMs = this.configuration.getLong("phoenix.index.rebuild.client.scanner.timeout", 1800000L);
            int indexRebuildRpcRetriesCounter = this.configuration.getInt("phoenix.index.rebuild.rpc.retries.counter", 5);
            this.configuration.set("phoenix.query.timeoutMs", Long.toString(indexRebuildQueryTimeoutMs));
            this.configuration.set("hbase.client.scanner.timeout.period", Long.toString(indexRebuildClientScannerTimeOutMs));
            this.configuration.set("hbase.rpc.timeout", Long.toString(indexRebuildRPCTimeoutMs));
            this.configuration.set("hbase.client.retries.number", Long.toString(indexRebuildRpcRetriesCounter));
            this.configuration.set("mapreduce.task.timeout", Long.toString(indexRebuildQueryTimeoutMs));
            this.configuration.setBooleanIfUnset("phoenix.mapreduce.randomize.mapper.execution.order", true);
            PhoenixConfigurationUtil.setIndexToolDataTableName(this.configuration, IndexTool.this.dataTableWithSchema);
            PhoenixConfigurationUtil.setIndexToolIndexTableName(this.configuration, IndexTool.this.qIndexTable);
            PhoenixConfigurationUtil.setIndexToolSourceTable(this.configuration, IndexTool.this.sourceTable);
            if (IndexTool.this.startTime != null) {
                PhoenixConfigurationUtil.setIndexToolStartTime(this.configuration, IndexTool.this.startTime);
            }
            PhoenixConfigurationUtil.setIndexVerifyType(this.configuration, IndexTool.this.indexVerifyType);
            PhoenixConfigurationUtil.setDisableLoggingVerifyType(this.configuration, IndexTool.this.disableLoggingType);
            String physicalIndexTable = IndexTool.this.pIndexTable.getPhysicalName().getString();
            PhoenixConfigurationUtil.setPhysicalTableName(this.configuration, physicalIndexTable);
            PhoenixConfigurationUtil.setDisableIndexes(this.configuration, IndexTool.this.indexTable);
            if (IndexTool.this.tenantId != null) {
                PhoenixConfigurationUtil.setTenantId(this.configuration, IndexTool.this.tenantId);
            }
            if (this.outputPath != null) {
                this.fs = this.outputPath.getFileSystem(this.configuration);
                this.fs.delete(this.outputPath, true);
            }
            String jobName = String.format(IndexTool.INDEX_JOB_NAME_TEMPLATE, IndexTool.this.schemaName, IndexTool.this.dataTable, IndexTool.this.indexTable);
            Job job = Job.getInstance((Configuration)this.configuration, (String)jobName);
            job.setJarByClass(IndexTool.class);
            job.setMapOutputKeyClass(ImmutableBytesWritable.class);
            if (this.outputPath != null) {
                FileOutputFormat.setOutputPath((Job)job, (Path)this.outputPath);
            }
            PhoenixMapReduceUtil.setInput(job, PhoenixServerBuildIndexDBWritable.class, PhoenixServerBuildIndexInputFormat.class, IndexTool.this.dataTableWithSchema, "");
            TableMapReduceUtil.initCredentials((Job)job);
            job.setMapperClass(PhoenixServerBuildIndexMapper.class);
            return this.configureSubmittableJobUsingDirectApi(job);
        }

        private Job configureSubmittableJobUsingDirectApi(Job job) throws Exception {
            job.setReducerClass(PhoenixIndexImportDirectReducer.class);
            Configuration conf = job.getConfiguration();
            HBaseConfiguration.merge((Configuration)conf, (Configuration)HBaseConfiguration.create((Configuration)conf));
            conf.set("hbase.mapred.outputtable", PhoenixConfigurationUtil.getPhysicalTableName(job.getConfiguration()));
            job.setMapOutputKeyClass(ImmutableBytesWritable.class);
            job.setMapOutputValueClass(IntWritable.class);
            job.setOutputKeyClass(NullWritable.class);
            job.setOutputValueClass(NullWritable.class);
            TableMapReduceUtil.addDependencyJars((Job)job);
            job.setNumReduceTasks(1);
            return job;
        }
    }

    public static enum IndexDisableLoggingType {
        NONE("NONE"),
        BEFORE("BEFORE"),
        AFTER("AFTER"),
        BOTH("BOTH");

        private String value;
        private byte[] valueBytes;

        private IndexDisableLoggingType(String value) {
            this.value = value;
            this.valueBytes = PVarchar.INSTANCE.toBytes((Object)value);
        }

        public String getValue() {
            return this.value;
        }

        public byte[] toBytes() {
            return this.valueBytes;
        }

        public static IndexDisableLoggingType fromValue(String value) {
            for (IndexDisableLoggingType disableLoggingType : IndexDisableLoggingType.values()) {
                if (!value.equals(disableLoggingType.getValue())) continue;
                return disableLoggingType;
            }
            throw new IllegalStateException("Invalid value: " + value + " for " + IndexDisableLoggingType.class);
        }

        public static IndexDisableLoggingType fromValue(byte[] value) {
            return IndexDisableLoggingType.fromValue(Bytes.toString((byte[])value));
        }
    }

    public static enum IndexVerifyType {
        BEFORE("BEFORE"),
        AFTER("AFTER"),
        BOTH("BOTH"),
        ONLY("ONLY"),
        NONE("NONE");

        private String value;
        private byte[] valueBytes;

        private IndexVerifyType(String value) {
            this.value = value;
            this.valueBytes = PVarchar.INSTANCE.toBytes((Object)value);
        }

        public String getValue() {
            return this.value;
        }

        public byte[] toBytes() {
            return this.valueBytes;
        }

        public static IndexVerifyType fromValue(String value) {
            for (IndexVerifyType verifyType : IndexVerifyType.values()) {
                if (!value.equals(verifyType.getValue())) continue;
                return verifyType;
            }
            throw new IllegalStateException("Invalid value: " + value + " for " + IndexVerifyType.class);
        }

        public static IndexVerifyType fromValue(byte[] value) {
            return IndexVerifyType.fromValue(Bytes.toString((byte[])value));
        }
    }
}

