/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce.index;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.phoenix.coprocessorclient.BaseScannerRegionObserverConstants;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.mapreduce.CsvBulkImportUtil;
import org.apache.phoenix.mapreduce.index.IndexScrutinyMapper;
import org.apache.phoenix.mapreduce.index.IndexScrutinyTableOutput;
import org.apache.phoenix.mapreduce.index.IndexTool;
import org.apache.phoenix.mapreduce.index.PhoenixIndexDBWritable;
import org.apache.phoenix.mapreduce.index.SourceTargetColumnNames;
import org.apache.phoenix.mapreduce.util.ConnectionUtil;
import org.apache.phoenix.mapreduce.util.IndexColumnNames;
import org.apache.phoenix.mapreduce.util.PhoenixConfigurationUtil;
import org.apache.phoenix.mapreduce.util.PhoenixMapReduceUtil;
import org.apache.phoenix.parse.HintNode;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.thirdparty.com.google.common.base.Strings;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.CommandLine;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.DefaultParser;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.HelpFormatter;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.Option;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.Options;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.ParseException;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexScrutinyTool
extends Configured
implements Tool {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexScrutinyTool.class);
    private static final Option SCHEMA_NAME_OPTION = new Option("s", "schema", true, "Phoenix schema name (optional)");
    private static final Option DATA_TABLE_OPTION = new Option("dt", "data-table", true, "Data table name (mandatory)");
    private static final Option INDEX_TABLE_OPTION = new Option("it", "index-table", true, "Index table name (mandatory).");
    private static final Option TIMESTAMP = new Option("t", "time", true, "Timestamp in millis used to compare the index and data tables.  Defaults to current time minus 60 seconds");
    private static final Option RUN_FOREGROUND_OPTION = new Option("runfg", "run-foreground", false, "Applicable on top of -direct option.If specified, runs index scrutiny in Foreground. Default - Runs the build in background.");
    private static final Option SNAPSHOT_OPTION = new Option("snap", "snapshot", false, "If specified, uses Snapshots for async index building (optional)");
    public static final Option BATCH_SIZE_OPTION = new Option("b", "batch-size", true, "Number of rows to compare at a time");
    public static final Option SOURCE_TABLE_OPTION = new Option("src", "source", true, "Table to use as the source table, whose rows are iterated over and compared to the other table. Options are DATA_TABLE_SOURCE, INDEX_TABLE_SOURCE, BOTH.  Defaults to BOTH, which does two separate jobs to iterate over both tables");
    private static final Option HELP_OPTION = new Option("h", "help", false, "Help");
    private static final Option OUTPUT_INVALID_ROWS_OPTION = new Option("o", "output", false, "Whether to output invalid rows");
    private static final Option OUTPUT_FORMAT_OPTION = new Option("of", "output-format", true, "Format in which to output invalid rows.  Options are FILE, TABLE.  Defaults to TABLE");
    private static final Option OUTPUT_PATH_OPTION = new Option("op", "output-path", true, "Output path where the files are written");
    private static final Option OUTPUT_MAX = new Option("om", "output-max", true, "Max number of invalid rows to output per mapper.  Defaults to 1M");
    private static final Option TENANT_ID_OPTION = new Option("tenant", "tenant-id", true, "If specified, uses Tenant connection for tenant view index scrutiny (optional)");
    public static final String INDEX_JOB_NAME_TEMPLATE = "PHOENIX_SCRUTINY_[%s]_[%s]";
    Class<? extends IndexScrutinyMapper> mapperClass = null;
    private List<Job> jobs = Lists.newArrayList();

    public IndexScrutinyTool(Class<? extends IndexScrutinyMapper> indexScrutinyMapperForTestClass) {
        this.mapperClass = indexScrutinyMapperForTestClass;
    }

    public IndexScrutinyTool() {
    }

    private Options getOptions() {
        Options options = new Options();
        options.addOption(SCHEMA_NAME_OPTION);
        options.addOption(DATA_TABLE_OPTION);
        options.addOption(INDEX_TABLE_OPTION);
        options.addOption(RUN_FOREGROUND_OPTION);
        options.addOption(OUTPUT_INVALID_ROWS_OPTION);
        options.addOption(OUTPUT_FORMAT_OPTION);
        options.addOption(OUTPUT_PATH_OPTION);
        options.addOption(OUTPUT_MAX);
        options.addOption(SNAPSHOT_OPTION);
        options.addOption(HELP_OPTION);
        options.addOption(TIMESTAMP);
        options.addOption(BATCH_SIZE_OPTION);
        options.addOption(SOURCE_TABLE_OPTION);
        options.addOption(TENANT_ID_OPTION);
        return options;
    }

    private CommandLine parseOptions(String[] args) {
        Options options = this.getOptions();
        DefaultParser parser = DefaultParser.builder().setAllowPartialMatching(false).setStripLeadingAndTrailingQuotes(Boolean.valueOf(false)).build();
        CommandLine cmdLine = null;
        try {
            cmdLine = parser.parse(options, args);
        }
        catch (ParseException e) {
            this.printHelpAndExit("Error parsing command line options: " + e.getMessage(), options);
        }
        if (cmdLine.hasOption(HELP_OPTION.getOpt())) {
            this.printHelpAndExit(options, 0);
        }
        this.requireOption(cmdLine, DATA_TABLE_OPTION);
        this.requireOption(cmdLine, INDEX_TABLE_OPTION);
        return cmdLine;
    }

    private void requireOption(CommandLine cmdLine, Option option) {
        if (!cmdLine.hasOption(option.getOpt())) {
            throw new IllegalStateException(option.getLongOpt() + " is a mandatory parameter");
        }
    }

    private void printHelpAndExit(String errorMessage, Options options) {
        System.err.println(errorMessage);
        this.printHelpAndExit(options, 1);
    }

    private void printHelpAndExit(Options options, int exitCode) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("help", options);
        System.exit(exitCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] args) throws Exception {
        Connection connection = null;
        try {
            long outputMaxRows;
            CommandLine cmdLine = null;
            try {
                cmdLine = this.parseOptions(args);
            }
            catch (IllegalStateException e) {
                this.printHelpAndExit(e.getMessage(), this.getOptions());
            }
            Configuration configuration = HBaseConfiguration.addHbaseResources((Configuration)this.getConf());
            boolean useTenantId = cmdLine.hasOption(TENANT_ID_OPTION.getOpt());
            String tenantId = null;
            if (useTenantId) {
                tenantId = cmdLine.getOptionValue(TENANT_ID_OPTION.getOpt());
                configuration.set("TenantId", tenantId);
                LOGGER.info(String.format("IndexScrutinyTool uses a tenantId %s", tenantId));
            }
            connection = ConnectionUtil.getInputConnection((Configuration)configuration);
            String schemaName = cmdLine.getOptionValue(SCHEMA_NAME_OPTION.getOpt());
            String dataTable = cmdLine.getOptionValue(DATA_TABLE_OPTION.getOpt());
            String indexTable = cmdLine.getOptionValue(INDEX_TABLE_OPTION.getOpt());
            String qDataTable = SchemaUtil.getQualifiedTableName((String)schemaName, (String)dataTable);
            String basePath = cmdLine.getOptionValue(OUTPUT_PATH_OPTION.getOpt());
            boolean isForeground = cmdLine.hasOption(RUN_FOREGROUND_OPTION.getOpt());
            boolean useSnapshot = cmdLine.hasOption(SNAPSHOT_OPTION.getOpt());
            boolean outputInvalidRows = cmdLine.hasOption(OUTPUT_INVALID_ROWS_OPTION.getOpt());
            SourceTable sourceTable = cmdLine.hasOption(SOURCE_TABLE_OPTION.getOpt()) ? SourceTable.valueOf(cmdLine.getOptionValue(SOURCE_TABLE_OPTION.getOpt())) : SourceTable.BOTH;
            long batchSize = cmdLine.hasOption(BATCH_SIZE_OPTION.getOpt()) ? Long.parseLong(cmdLine.getOptionValue(BATCH_SIZE_OPTION.getOpt())) : 1000L;
            long ts = cmdLine.hasOption(TIMESTAMP.getOpt()) ? Long.parseLong(cmdLine.getOptionValue(TIMESTAMP.getOpt())) : EnvironmentEdgeManager.currentTimeMillis() - 60000L;
            this.validateTimestamp(configuration, ts);
            if (indexTable != null && !IndexTool.isValidIndexTable(connection, qDataTable, indexTable, tenantId)) {
                throw new IllegalArgumentException(String.format(" %s is not an index table for %s ", indexTable, qDataTable));
            }
            String outputFormatOption = cmdLine.getOptionValue(OUTPUT_FORMAT_OPTION.getOpt());
            OutputFormat outputFormat = outputFormatOption != null ? OutputFormat.valueOf(outputFormatOption.toUpperCase()) : OutputFormat.TABLE;
            long l = outputMaxRows = cmdLine.hasOption(OUTPUT_MAX.getOpt()) ? Long.parseLong(cmdLine.getOptionValue(OUTPUT_MAX.getOpt())) : 1000000L;
            if (outputInvalidRows && OutputFormat.TABLE.equals((Object)outputFormat)) {
                Configuration outputConfiguration = HBaseConfiguration.create((Configuration)configuration);
                outputConfiguration.unset("TenantId");
                Connection outputConn = ConnectionUtil.getOutputConnection((Configuration)outputConfiguration);
                Object object = null;
                try (Statement stmt2 = outputConn.createStatement();){
                    stmt2.execute("CREATE TABLE IF NOT EXISTS PHOENIX_INDEX_SCRUTINY\n(\n    SOURCE_TABLE VARCHAR NOT NULL,\n    TARGET_TABLE VARCHAR NOT NULL,\n    SCRUTINY_EXECUTE_TIME BIGINT NOT NULL,\n    SOURCE_ROW_PK_HASH VARCHAR NOT NULL,\n    SOURCE_TS BIGINT,\n    TARGET_TS BIGINT,\n    HAS_TARGET_ROW BOOLEAN,\n    BEYOND_MAX_LOOKBACK BOOLEAN,\n    CONSTRAINT PK PRIMARY KEY\n    (\n        SOURCE_TABLE,\n        TARGET_TABLE,\n        SCRUTINY_EXECUTE_TIME,\n        SOURCE_ROW_PK_HASH\n    )\n)  COLUMN_ENCODED_BYTES = 0 ");
                    stmt2.execute("ALTER TABLE PHOENIX_INDEX_SCRUTINY\n ADD IF NOT EXISTS BEYOND_MAX_LOOKBACK BOOLEAN");
                    stmt2.execute("CREATE TABLE IF NOT EXISTS PHOENIX_INDEX_SCRUTINY_METADATA\n(\n    SOURCE_TABLE VARCHAR NOT NULL,\n    TARGET_TABLE VARCHAR NOT NULL,\n    SCRUTINY_EXECUTE_TIME BIGINT NOT NULL,\n    SOURCE_TYPE VARCHAR,\n    CMD_LINE_ARGS VARCHAR,\n    INPUT_RECORDS BIGINT,\n    FAILED_RECORDS BIGINT,\n    VALID_ROW_COUNT BIGINT,\n    INVALID_ROW_COUNT BIGINT,\n    INCORRECT_COVERED_COL_VAL_COUNT BIGINT,\n    BATCHES_PROCESSED_COUNT BIGINT,\n    SOURCE_DYNAMIC_COLS VARCHAR,\n    TARGET_DYNAMIC_COLS VARCHAR,\n    INVALID_ROWS_QUERY_ALL VARCHAR,\n    INVALID_ROWS_QUERY_MISSING_TARGET VARCHAR,\n    INVALID_ROWS_QUERY_BAD_COVERED_COL_VAL VARCHAR,\n    INVALID_ROWS_QUERY_BEYOND_MAX_LOOKBACK VARCHAR,\n    BEYOND_MAX_LOOKBACK_COUNT BIGINT,\n    CONSTRAINT PK PRIMARY KEY\n    (\n        SOURCE_TABLE,\n        TARGET_TABLE,\n        SCRUTINY_EXECUTE_TIME\n    )\n)\n");
                    stmt2.execute("ALTER TABLE PHOENIX_INDEX_SCRUTINY_METADATA\n ADD IF NOT EXISTS INVALID_ROWS_QUERY_BEYOND_MAX_LOOKBACK VARCHAR, \n BEYOND_MAX_LOOKBACK_COUNT BIGINT");
                }
                catch (Throwable stmt2) {
                    object = stmt2;
                    throw stmt2;
                }
                finally {
                    if (outputConn != null) {
                        if (object != null) {
                            try {
                                outputConn.close();
                            }
                            catch (Throwable stmt2) {
                                ((Throwable)object).addSuppressed(stmt2);
                            }
                        } else {
                            outputConn.close();
                        }
                    }
                }
            }
            LOGGER.info(String.format("Running scrutiny [schemaName=%s, dataTable=%s, indexTable=%s, useSnapshot=%s, timestamp=%s, batchSize=%s, outputBasePath=%s, outputFormat=%s, outputMaxRows=%s]", new Object[]{schemaName, dataTable, indexTable, useSnapshot, ts, batchSize, basePath, outputFormat, outputMaxRows}));
            JobFactory jobFactory = new JobFactory(connection, configuration, batchSize, useSnapshot, ts, outputInvalidRows, outputFormat, basePath, outputMaxRows, tenantId, this.mapperClass);
            if (SourceTable.BOTH.equals((Object)sourceTable)) {
                this.jobs.add(jobFactory.createSubmittableJob(schemaName, indexTable, dataTable, SourceTable.DATA_TABLE_SOURCE, this.mapperClass));
                this.jobs.add(jobFactory.createSubmittableJob(schemaName, indexTable, dataTable, SourceTable.INDEX_TABLE_SOURCE, this.mapperClass));
            } else {
                this.jobs.add(jobFactory.createSubmittableJob(schemaName, indexTable, dataTable, sourceTable, this.mapperClass));
            }
            if (!isForeground) {
                LOGGER.info("Running Index Scrutiny in Background - Submit async and exit");
                for (Job job : this.jobs) {
                    job.submit();
                }
                int outputConn = 0;
                return outputConn;
            }
            LOGGER.info("Running Index Scrutiny in Foreground. Waits for the build to complete. This may take a long time!.");
            boolean result = true;
            for (Job job : this.jobs) {
                result = result && job.waitForCompletion(true);
            }
            if (outputInvalidRows && OutputFormat.TABLE.equals((Object)outputFormat)) {
                LOGGER.info("Writing results of jobs to output table PHOENIX_INDEX_SCRUTINY_METADATA");
                IndexScrutinyTableOutput.writeJobResults(connection, args, this.jobs);
            }
            if (result) {
                int n = 0;
                return n;
            }
            LOGGER.error("IndexScrutinyTool job failed! Check logs for errors..");
            int n = -1;
            return n;
        }
        catch (Exception ex) {
            LOGGER.error("An exception occurred while performing the indexing job: " + ExceptionUtils.getMessage((Throwable)ex) + " at:\n" + ExceptionUtils.getStackTrace((Throwable)ex));
            int n = -1;
            return n;
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException sqle) {
                LOGGER.error("Failed to close connection ", (Object)sqle.getMessage());
                throw new RuntimeException("Failed to close connection");
            }
        }
    }

    private void validateTimestamp(Configuration configuration, long ts) {
        long minTimestamp;
        long maxLookBackAge = BaseScannerRegionObserverConstants.getMaxLookbackInMillis((Configuration)configuration);
        if (maxLookBackAge != 0L && ts < (minTimestamp = EnvironmentEdgeManager.currentTimeMillis() - maxLookBackAge)) {
            throw new IllegalArgumentException("Index scrutiny can't look back past the configured max lookback age: " + maxLookBackAge / 1000L + " seconds");
        }
    }

    @VisibleForTesting
    public List<Job> getJobs() {
        return this.jobs;
    }

    public static void main(String[] args) throws Exception {
        int result = ToolRunner.run((Tool)new IndexScrutinyTool(), (String[])args);
        System.exit(result);
    }

    private static class JobFactory {
        Connection connection;
        Configuration configuration;
        private final boolean useSnapshot;
        private final long ts;
        private final boolean outputInvalidRows;
        private final OutputFormat outputFormat;
        private final String basePath;
        private final long scrutinyExecuteTime;
        private final long outputMaxRows;
        private final String tenantId;
        Class<? extends IndexScrutinyMapper> mapperClass;

        public JobFactory(Connection connection, Configuration configuration, long batchSize, boolean useSnapshot, long ts, boolean outputInvalidRows, OutputFormat outputFormat, String basePath, long outputMaxRows, String tenantId, Class<? extends IndexScrutinyMapper> mapperClass) {
            this.outputInvalidRows = outputInvalidRows;
            this.outputFormat = outputFormat;
            this.basePath = basePath;
            this.outputMaxRows = outputMaxRows;
            PhoenixConfigurationUtil.setScrutinyBatchSize(configuration, batchSize);
            this.connection = connection;
            this.configuration = configuration;
            this.useSnapshot = useSnapshot;
            this.tenantId = tenantId;
            this.ts = ts;
            this.scrutinyExecuteTime = EnvironmentEdgeManager.currentTimeMillis();
            PhoenixConfigurationUtil.setScrutinyExecuteTimestamp(configuration, this.scrutinyExecuteTime);
            if (!Strings.isNullOrEmpty((String)tenantId)) {
                PhoenixConfigurationUtil.setTenantId(configuration, tenantId);
            }
            this.mapperClass = mapperClass;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Job createSubmittableJob(String schemaName, String indexTable, String dataTable, SourceTable sourceTable, Class<? extends IndexScrutinyMapper> mapperClass) throws Exception {
            Preconditions.checkArgument((SourceTable.DATA_TABLE_SOURCE.equals((Object)sourceTable) || SourceTable.INDEX_TABLE_SOURCE.equals((Object)sourceTable) ? 1 : 0) != 0);
            String qDataTable = SchemaUtil.getQualifiedTableName((String)schemaName, (String)dataTable);
            String qIndexTable = schemaName != null && !schemaName.isEmpty() ? SchemaUtil.getQualifiedTableName((String)schemaName, (String)indexTable) : indexTable;
            PhoenixConfigurationUtil.setScrutinyDataTable(this.configuration, qDataTable);
            PhoenixConfigurationUtil.setScrutinyIndexTable(this.configuration, qIndexTable);
            PhoenixConfigurationUtil.setScrutinySourceTable(this.configuration, sourceTable);
            PhoenixConfigurationUtil.setScrutinyOutputInvalidRows(this.configuration, this.outputInvalidRows);
            PhoenixConfigurationUtil.setScrutinyOutputMax(this.configuration, this.outputMaxRows);
            PhoenixConnection phoenixConnection = this.connection.unwrap(PhoenixConnection.class);
            PTable pdataTable = phoenixConnection.getTable(qDataTable);
            PTable pindexTable = phoenixConnection.getTable(qIndexTable);
            this.configuration.setBooleanIfUnset("phoenix.mapreduce.randomize.mapper.execution.order", true);
            this.configuration.set("phoenix.mr.currentscn.value", Long.toString(this.ts));
            IndexColumnNames columnNames = SourceTable.DATA_TABLE_SOURCE.equals((Object)sourceTable) ? new SourceTargetColumnNames.DataSourceColNames(pdataTable, pindexTable) : new SourceTargetColumnNames.IndexSourceColNames(pdataTable, pindexTable);
            String qSourceTable = columnNames.getQualifiedSourceTableName();
            List<String> sourceColumnNames = columnNames.getSourceColNames();
            List<String> sourceDynamicCols = columnNames.getSourceDynamicCols();
            List<String> targetDynamicCols = columnNames.getTargetDynamicCols();
            String selectQuery = QueryUtil.constructSelectStatement((String)qSourceTable, sourceColumnNames, null, (HintNode.Hint)HintNode.Hint.NO_INDEX, (boolean)true);
            LOGGER.info("Query used on source table to feed the mapper: " + selectQuery);
            PhoenixConfigurationUtil.setScrutinyOutputFormat(this.configuration, this.outputFormat);
            if (this.outputInvalidRows && OutputFormat.TABLE.equals((Object)this.outputFormat)) {
                String upsertStmt = IndexScrutinyTableOutput.constructOutputTableUpsert(sourceDynamicCols, targetDynamicCols, this.connection);
                PhoenixConfigurationUtil.setUpsertStatement(this.configuration, upsertStmt);
                LOGGER.info("Upsert statement used for output table: " + upsertStmt);
            }
            String jobName = String.format(IndexScrutinyTool.INDEX_JOB_NAME_TEMPLATE, qSourceTable, columnNames.getQualifiedTargetTableName());
            Job job = Job.getInstance((Configuration)this.configuration, (String)jobName);
            if (!this.useSnapshot) {
                PhoenixMapReduceUtil.setInput(job, PhoenixIndexDBWritable.class, qDataTable, selectQuery);
            } else {
                try (Admin admin = null;){
                    PhoenixConnection pConnection = this.connection.unwrap(PhoenixConnection.class);
                    admin = pConnection.getQueryServices().getAdmin();
                    String pdataTableName = pdataTable.getName().getString();
                    String snapshotName = pdataTableName + "-Snapshot";
                    admin.snapshot(snapshotName, TableName.valueOf((String)pdataTableName));
                }
                Path rootDir = new Path("hdfs:///index-snapshot-dir");
                CommonFSUtils.setRootDir((Configuration)this.configuration, (Path)rootDir);
            }
            TableMapReduceUtil.initCredentials((Job)job);
            Path outputPath = this.getOutputPath(this.configuration, this.basePath, SourceTable.DATA_TABLE_SOURCE.equals((Object)sourceTable) ? pdataTable : pindexTable);
            return this.configureSubmittableJob(job, outputPath, mapperClass);
        }

        private Job configureSubmittableJob(Job job, Path outputPath, Class<? extends IndexScrutinyMapper> mapperClass) throws Exception {
            Configuration conf = job.getConfiguration();
            conf.setBoolean("mapreduce.job.user.classpath.first", true);
            HBaseConfiguration.merge((Configuration)conf, (Configuration)HBaseConfiguration.create((Configuration)conf));
            job.setJarByClass(IndexScrutinyTool.class);
            job.setOutputFormatClass(NullOutputFormat.class);
            if (this.outputInvalidRows && OutputFormat.FILE.equals((Object)this.outputFormat)) {
                job.setOutputFormatClass(TextOutputFormat.class);
                FileOutputFormat.setOutputPath((Job)job, (Path)outputPath);
            }
            job.setMapperClass(mapperClass == null ? IndexScrutinyMapper.class : mapperClass);
            job.setNumReduceTasks(0);
            job.setMapOutputKeyClass(Text.class);
            job.setMapOutputValueClass(Text.class);
            TableMapReduceUtil.addDependencyJars((Job)job);
            return job;
        }

        Path getOutputPath(Configuration configuration, String basePath, PTable table) throws IOException {
            Path outputPath = null;
            if (basePath != null) {
                outputPath = CsvBulkImportUtil.getOutputPath(new Path(basePath), table.getPhysicalName().getString());
                FileSystem fs = outputPath.getFileSystem(configuration);
                fs.delete(outputPath, true);
            }
            return outputPath;
        }
    }

    public static enum OutputFormat {
        FILE,
        TABLE;

    }

    public static enum SourceTable {
        DATA_TABLE_SOURCE,
        INDEX_TABLE_SOURCE,
        BOTH;

    }
}

