/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce.index;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.Job;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.mapreduce.PhoenixJobCounters;
import org.apache.phoenix.mapreduce.index.IndexScrutinyTool;
import org.apache.phoenix.mapreduce.index.PhoenixScrutinyJobCounters;
import org.apache.phoenix.mapreduce.index.SourceTargetColumnNames;
import org.apache.phoenix.mapreduce.util.IndexColumnNames;
import org.apache.phoenix.mapreduce.util.PhoenixConfigurationUtil;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.thirdparty.com.google.common.base.Joiner;
import org.apache.phoenix.thirdparty.com.google.common.collect.Iterables;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.SchemaUtil;

public class IndexScrutinyTableOutput {
    public static final String OUTPUT_TABLE_NAME = "PHOENIX_INDEX_SCRUTINY";
    public static final String SCRUTINY_EXECUTE_TIME_COL_NAME = "SCRUTINY_EXECUTE_TIME";
    public static final String TARGET_TABLE_COL_NAME = "TARGET_TABLE";
    public static final String SOURCE_TABLE_COL_NAME = "SOURCE_TABLE";
    public static final String OUTPUT_TABLE_DDL = "CREATE TABLE IF NOT EXISTS PHOENIX_INDEX_SCRUTINY\n(\n    SOURCE_TABLE VARCHAR NOT NULL,\n    TARGET_TABLE VARCHAR NOT NULL,\n    SCRUTINY_EXECUTE_TIME BIGINT NOT NULL,\n    SOURCE_ROW_PK_HASH VARCHAR NOT NULL,\n    SOURCE_TS BIGINT,\n    TARGET_TS BIGINT,\n    HAS_TARGET_ROW BOOLEAN,\n    BEYOND_MAX_LOOKBACK BOOLEAN,\n    CONSTRAINT PK PRIMARY KEY\n    (\n        SOURCE_TABLE,\n        TARGET_TABLE,\n        SCRUTINY_EXECUTE_TIME,\n        SOURCE_ROW_PK_HASH\n    )\n)  COLUMN_ENCODED_BYTES = 0 ";
    public static final String OUTPUT_TABLE_BEYOND_LOOKBACK_DDL = "ALTER TABLE PHOENIX_INDEX_SCRUTINY\n ADD IF NOT EXISTS BEYOND_MAX_LOOKBACK BOOLEAN";
    public static final String OUTPUT_METADATA_TABLE_NAME = "PHOENIX_INDEX_SCRUTINY_METADATA";
    public static final String OUTPUT_METADATA_DDL = "CREATE TABLE IF NOT EXISTS PHOENIX_INDEX_SCRUTINY_METADATA\n(\n    SOURCE_TABLE VARCHAR NOT NULL,\n    TARGET_TABLE VARCHAR NOT NULL,\n    SCRUTINY_EXECUTE_TIME BIGINT NOT NULL,\n    SOURCE_TYPE VARCHAR,\n    CMD_LINE_ARGS VARCHAR,\n    INPUT_RECORDS BIGINT,\n    FAILED_RECORDS BIGINT,\n    VALID_ROW_COUNT BIGINT,\n    INVALID_ROW_COUNT BIGINT,\n    INCORRECT_COVERED_COL_VAL_COUNT BIGINT,\n    BATCHES_PROCESSED_COUNT BIGINT,\n    SOURCE_DYNAMIC_COLS VARCHAR,\n    TARGET_DYNAMIC_COLS VARCHAR,\n    INVALID_ROWS_QUERY_ALL VARCHAR,\n    INVALID_ROWS_QUERY_MISSING_TARGET VARCHAR,\n    INVALID_ROWS_QUERY_BAD_COVERED_COL_VAL VARCHAR,\n    INVALID_ROWS_QUERY_BEYOND_MAX_LOOKBACK VARCHAR,\n    BEYOND_MAX_LOOKBACK_COUNT BIGINT,\n    CONSTRAINT PK PRIMARY KEY\n    (\n        SOURCE_TABLE,\n        TARGET_TABLE,\n        SCRUTINY_EXECUTE_TIME\n    )\n)\n";
    public static final String OUTPUT_METADATA_BEYOND_LOOKBACK_COUNTER_DDL = "ALTER TABLE PHOENIX_INDEX_SCRUTINY_METADATA\n ADD IF NOT EXISTS INVALID_ROWS_QUERY_BEYOND_MAX_LOOKBACK VARCHAR, \n BEYOND_MAX_LOOKBACK_COUNT BIGINT";
    public static final String UPSERT_METADATA_SQL = "UPSERT INTO PHOENIX_INDEX_SCRUTINY_METADATA VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

    public static String constructOutputTableUpsert(List<String> sourceDynamicCols, List<String> targetDynamicCols, Connection connection) throws SQLException {
        List<String> outputTableColumns = IndexScrutinyTableOutput.getOutputTableColumns(connection);
        ArrayList upsertCols = Lists.newArrayList((Iterable)Iterables.concat(outputTableColumns, sourceDynamicCols, targetDynamicCols));
        String upsertStmt = QueryUtil.constructUpsertStatement((String)OUTPUT_TABLE_NAME, (List)upsertCols, null);
        return upsertStmt;
    }

    public static String getSqlQueryAllInvalidRows(Connection conn, SourceTargetColumnNames columnNames, long scrutinyTimeMillis) throws SQLException {
        String paramQuery = IndexScrutinyTableOutput.getAllInvalidParamQuery(conn, columnNames);
        paramQuery = IndexScrutinyTableOutput.bindPkCols(columnNames, scrutinyTimeMillis, paramQuery);
        return paramQuery;
    }

    public static String getSqlQueryMissingTargetRows(Connection conn, SourceTargetColumnNames columnNames, long scrutinyTimeMillis) throws SQLException {
        String paramQuery = IndexScrutinyTableOutput.getHasTargetRowQuery(conn, columnNames, scrutinyTimeMillis);
        return paramQuery.replaceFirst("\\?", "false");
    }

    public static String getSqlQueryBadCoveredColVal(Connection conn, SourceTargetColumnNames columnNames, long scrutinyTimeMillis) throws SQLException {
        String paramQuery = IndexScrutinyTableOutput.getHasTargetRowQuery(conn, columnNames, scrutinyTimeMillis);
        return paramQuery.replaceFirst("\\?", "true");
    }

    public static String getSqlQueryBeyondMaxLookback(Connection conn, SourceTargetColumnNames columnNames, long scrutinyTimeMillis) throws SQLException {
        String whereQuery = IndexScrutinyTableOutput.constructOutputTableQuery(conn, columnNames, IndexScrutinyTableOutput.getPksCsv() + ", " + SchemaUtil.getEscapedFullColumnName((String)"HAS_TARGET_ROW") + ", " + SchemaUtil.getEscapedFullColumnName((String)"BEYOND_MAX_LOOKBACK"));
        String inClause = " IN " + QueryUtil.constructParameterizedInClause((int)(IndexScrutinyTableOutput.getPkCols().size() + 2), (int)1);
        String paramQuery = whereQuery + inClause;
        paramQuery = IndexScrutinyTableOutput.bindPkCols(columnNames, scrutinyTimeMillis, paramQuery);
        paramQuery = paramQuery.replaceFirst("\\?", "false");
        paramQuery = paramQuery.replaceFirst("\\?", "true");
        return paramQuery;
    }

    public static ResultSet queryMetadata(Connection conn, List<String> selectCols, String qSourceTableName, String qTargetTableName, long scrutinyTimeMillis) throws SQLException {
        PreparedStatement ps = conn.prepareStatement(IndexScrutinyTableOutput.constructMetadataParamQuery(selectCols));
        ps.setString(1, qSourceTableName);
        ps.setString(2, qTargetTableName);
        ps.setLong(3, scrutinyTimeMillis);
        return ps.executeQuery();
    }

    public static ResultSet queryAllLatestMetadata(Connection conn, String qSourceTableName, String qTargetTableName) throws SQLException {
        String sql = "SELECT MAX(SCRUTINY_EXECUTE_TIME) FROM PHOENIX_INDEX_SCRUTINY_METADATA WHERE SOURCE_TABLE = ? AND TARGET_TABLE= ?";
        PreparedStatement stmt = conn.prepareStatement(sql);
        stmt.setString(1, qSourceTableName);
        stmt.setString(2, qTargetTableName);
        ResultSet rs = stmt.executeQuery();
        long scrutinyTimeMillis = 0L;
        if (rs.next()) {
            scrutinyTimeMillis = rs.getLong(1);
        }
        return IndexScrutinyTableOutput.queryAllMetadata(conn, qSourceTableName, qTargetTableName, scrutinyTimeMillis);
    }

    public static ResultSet queryAllMetadata(Connection conn, String qSourceTableName, String qTargetTableName, long scrutinyTimeMillis) throws SQLException {
        PTable pMetadata = conn.unwrap(PhoenixConnection.class).getTable(OUTPUT_METADATA_TABLE_NAME);
        List metadataCols = SchemaUtil.getColumnNames((List)pMetadata.getColumns());
        return IndexScrutinyTableOutput.queryMetadata(conn, metadataCols, qSourceTableName, qTargetTableName, scrutinyTimeMillis);
    }

    public static void writeJobResults(Connection conn, String[] cmdLineArgs, List<Job> completedJobs) throws IOException, SQLException {
        PreparedStatement pStmt = conn.prepareStatement(UPSERT_METADATA_SQL);
        for (Job job : completedJobs) {
            Configuration conf = job.getConfiguration();
            String qDataTable = PhoenixConfigurationUtil.getScrutinyDataTableName(conf);
            PhoenixConnection phoenixConnection = conn.unwrap(PhoenixConnection.class);
            PTable pdataTable = phoenixConnection.getTable(qDataTable);
            String qIndexTable = PhoenixConfigurationUtil.getScrutinyIndexTableName(conf);
            PTable pindexTable = phoenixConnection.getTable(qIndexTable);
            IndexScrutinyTool.SourceTable sourceTable = PhoenixConfigurationUtil.getScrutinySourceTable(conf);
            long scrutinyExecuteTime = PhoenixConfigurationUtil.getScrutinyExecuteTimestamp(conf);
            IndexColumnNames columnNames = IndexScrutinyTool.SourceTable.DATA_TABLE_SOURCE.equals((Object)sourceTable) ? new SourceTargetColumnNames.DataSourceColNames(pdataTable, pindexTable) : new SourceTargetColumnNames.IndexSourceColNames(pdataTable, pindexTable);
            Counters counters = job.getCounters();
            int index = 1;
            pStmt.setString(index++, columnNames.getQualifiedSourceTableName());
            pStmt.setString(index++, columnNames.getQualifiedTargetTableName());
            pStmt.setLong(index++, scrutinyExecuteTime);
            pStmt.setString(index++, sourceTable.name());
            pStmt.setString(index++, Arrays.toString(cmdLineArgs));
            pStmt.setLong(index++, counters.findCounter((Enum)PhoenixJobCounters.INPUT_RECORDS).getValue());
            pStmt.setLong(index++, counters.findCounter((Enum)PhoenixJobCounters.FAILED_RECORDS).getValue());
            pStmt.setLong(index++, counters.findCounter((Enum)PhoenixScrutinyJobCounters.VALID_ROW_COUNT).getValue());
            pStmt.setLong(index++, counters.findCounter((Enum)PhoenixScrutinyJobCounters.INVALID_ROW_COUNT).getValue());
            pStmt.setLong(index++, counters.findCounter((Enum)PhoenixScrutinyJobCounters.BAD_COVERED_COL_VAL_COUNT).getValue());
            pStmt.setLong(index++, counters.findCounter((Enum)PhoenixScrutinyJobCounters.BATCHES_PROCESSED_COUNT).getValue());
            pStmt.setString(index++, Arrays.toString(columnNames.getSourceDynamicCols().toArray()));
            pStmt.setString(index++, Arrays.toString(columnNames.getTargetDynamicCols().toArray()));
            pStmt.setString(index++, IndexScrutinyTableOutput.getSqlQueryAllInvalidRows(conn, (SourceTargetColumnNames)((Object)columnNames), scrutinyExecuteTime));
            pStmt.setString(index++, IndexScrutinyTableOutput.getSqlQueryMissingTargetRows(conn, (SourceTargetColumnNames)((Object)columnNames), scrutinyExecuteTime));
            pStmt.setString(index++, IndexScrutinyTableOutput.getSqlQueryBadCoveredColVal(conn, (SourceTargetColumnNames)((Object)columnNames), scrutinyExecuteTime));
            pStmt.setString(index++, IndexScrutinyTableOutput.getSqlQueryBeyondMaxLookback(conn, (SourceTargetColumnNames)((Object)columnNames), scrutinyExecuteTime));
            pStmt.setLong(index++, counters.findCounter((Enum)PhoenixScrutinyJobCounters.BEYOND_MAX_LOOKBACK_COUNT).getValue());
            pStmt.addBatch();
        }
        pStmt.executeBatch();
        conn.commit();
    }

    static String constructMetadataParamQuery(List<String> metadataSelectCols) {
        String pkColsCsv = IndexScrutinyTableOutput.getPksCsv();
        String query = QueryUtil.constructSelectStatement((String)OUTPUT_METADATA_TABLE_NAME, metadataSelectCols, (String)pkColsCsv, null, (boolean)true);
        String inClause = " IN " + QueryUtil.constructParameterizedInClause((int)3, (int)1);
        return query + inClause;
    }

    private static String getAllInvalidParamQuery(Connection conn, SourceTargetColumnNames columnNames) throws SQLException {
        String whereQuery = IndexScrutinyTableOutput.constructOutputTableQuery(conn, columnNames, IndexScrutinyTableOutput.getPksCsv());
        String inClause = " IN " + QueryUtil.constructParameterizedInClause((int)IndexScrutinyTableOutput.getPkCols().size(), (int)1);
        String paramQuery = whereQuery + inClause;
        return paramQuery;
    }

    private static String bindPkCols(SourceTargetColumnNames columnNames, long scrutinyTimeMillis, String paramQuery) {
        paramQuery = paramQuery.replaceFirst("\\?", "'" + columnNames.getQualifiedSourceTableName() + "'");
        paramQuery = paramQuery.replaceFirst("\\?", "'" + columnNames.getQualifiedTargetTableName() + "'");
        paramQuery = paramQuery.replaceFirst("\\?", scrutinyTimeMillis + "");
        return paramQuery;
    }

    private static String getHasTargetRowQuery(Connection conn, SourceTargetColumnNames columnNames, long scrutinyTimeMillis) throws SQLException {
        String whereQuery = IndexScrutinyTableOutput.constructOutputTableQuery(conn, columnNames, IndexScrutinyTableOutput.getPksCsv() + ", " + SchemaUtil.getEscapedFullColumnName((String)"HAS_TARGET_ROW"));
        String inClause = " IN " + QueryUtil.constructParameterizedInClause((int)(IndexScrutinyTableOutput.getPkCols().size() + 1), (int)1);
        String paramQuery = whereQuery + inClause;
        paramQuery = IndexScrutinyTableOutput.bindPkCols(columnNames, scrutinyTimeMillis, paramQuery);
        return paramQuery;
    }

    private static String getPksCsv() {
        String pkColsCsv = Joiner.on((String)",").join((Iterable)SchemaUtil.getEscapedFullColumnNames(IndexScrutinyTableOutput.getPkCols()));
        return pkColsCsv;
    }

    private static List<String> getPkCols() {
        return Arrays.asList(SOURCE_TABLE_COL_NAME, TARGET_TABLE_COL_NAME, SCRUTINY_EXECUTE_TIME_COL_NAME);
    }

    private static String constructOutputTableQuery(Connection connection, SourceTargetColumnNames columnNames, String conditions) throws SQLException {
        PTable pOutputTable = connection.unwrap(PhoenixConnection.class).getTable(OUTPUT_TABLE_NAME);
        List outputTableColumns = SchemaUtil.getColumnNames((List)pOutputTable.getColumns());
        ArrayList selectCols = Lists.newArrayList((Iterable)Iterables.concat((Iterable)outputTableColumns, columnNames.getUnqualifiedSourceColNames(), columnNames.getUnqualifiedTargetColNames()));
        String dynamicCols = Joiner.on((String)",").join(Iterables.concat(columnNames.getSourceDynamicCols(), columnNames.getTargetDynamicCols()));
        String dynamicTableName = "PHOENIX_INDEX_SCRUTINY(" + dynamicCols + ")";
        return QueryUtil.constructSelectStatement((String)dynamicTableName, (List)selectCols, (String)conditions, null, (boolean)true);
    }

    private static List<String> getOutputTableColumns(Connection connection) throws SQLException {
        PTable pOutputTable = connection.unwrap(PhoenixConnection.class).getTable(OUTPUT_TABLE_NAME);
        List outputTableColumns = SchemaUtil.getColumnNames((List)pOutputTable.getColumns());
        return outputTableColumns;
    }
}

