/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.lib.db.DBWritable;
import org.apache.phoenix.compile.MutationPlan;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.ServerBuildIndexCompiler;
import org.apache.phoenix.compile.ServerBuildTransformingTableCompiler;
import org.apache.phoenix.coprocessorclient.MetaDataProtocol;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.mapreduce.PhoenixInputFormat;
import org.apache.phoenix.mapreduce.index.IndexScrutinyTool;
import org.apache.phoenix.mapreduce.util.ConnectionUtil;
import org.apache.phoenix.mapreduce.util.PhoenixConfigurationUtil;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.ScanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoenixServerBuildIndexInputFormat<T extends DBWritable>
extends PhoenixInputFormat {
    QueryPlan queryPlan = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(PhoenixServerBuildIndexInputFormat.class);
    private QueryPlanBuilder queryPlanBuilder;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected QueryPlan getQueryPlan(JobContext context, Configuration configuration) throws IOException {
        Preconditions.checkNotNull((Object)context);
        if (this.queryPlan != null) {
            return this.queryPlan;
        }
        String txnScnValue = configuration.get("phoenix.mr.txscn.value");
        String currentScnValue = PhoenixConfigurationUtil.getCurrentScnValue(configuration);
        String startTimeValue = PhoenixConfigurationUtil.getIndexToolStartTime(configuration);
        String tenantId = configuration.get("phoenix.mapreduce.tenantid");
        String lastVerifyTime = PhoenixConfigurationUtil.getIndexToolLastVerifyTime(configuration);
        Properties overridingProps = new Properties();
        if (txnScnValue == null && currentScnValue != null) {
            overridingProps.put("CurrentSCN", currentScnValue);
        }
        if (tenantId != null && configuration.get("TenantId") == null) {
            overridingProps.put("TenantId", tenantId);
        }
        String dataTableFullName = PhoenixConfigurationUtil.getIndexToolDataTableName(configuration);
        String indexTableFullName = PhoenixConfigurationUtil.getIndexToolIndexTableName(configuration);
        IndexScrutinyTool.SourceTable sourceTable = PhoenixConfigurationUtil.getIndexToolSourceTable(configuration);
        this.queryPlanBuilder = PhoenixConfigurationUtil.getIsTransforming(configuration) != false && PhoenixConfigurationUtil.getTransformingTableType(configuration) == IndexScrutinyTool.SourceTable.DATA_TABLE_SOURCE ? new TransformingDataTableQueryPlanBuilder() : (sourceTable.equals((Object)IndexScrutinyTool.SourceTable.DATA_TABLE_SOURCE) ? new DataTableQueryPlanBuilder() : new IndexTableQueryPlanBuilder());
        try (Connection connection = ConnectionUtil.getInputConnection((Configuration)configuration, (Properties)overridingProps);){
            PhoenixConnection phoenixConnection = connection.unwrap(PhoenixConnection.class);
            Long scn = currentScnValue != null ? Long.parseLong(currentScnValue) : EnvironmentEdgeManager.currentTimeMillis();
            PhoenixConfigurationUtil.setCurrentScnValue(configuration, scn);
            Long startTime = startTimeValue == null ? 0L : Long.parseLong(startTimeValue);
            this.queryPlan = this.queryPlanBuilder.getQueryPlan(phoenixConnection, dataTableFullName, indexTableFullName);
            Scan scan = this.queryPlan.getContext().getScan();
            Long lastVerifyTimeValue = lastVerifyTime == null ? 0L : Long.parseLong(lastVerifyTime);
            try {
                scan.setTimeRange(startTime.longValue(), scn.longValue());
                scan.setAttribute("_IndexRebuildPaging", PDataType.TRUE_BYTES);
                String rebuildPageRowSize = configuration.get("phoenix.index.rebuild_page_size_in_rows");
                if (rebuildPageRowSize != null) {
                    scan.setAttribute("_IndexRebuildPageRows", Bytes.toBytes((long)Long.parseLong(rebuildPageRowSize)));
                }
                scan.setAttribute("_IndexRebuildVerifyType", PhoenixConfigurationUtil.getIndexVerifyType(configuration).toBytes());
                scan.setAttribute("_IndexRetryVerify", Bytes.toBytes((long)lastVerifyTimeValue));
                scan.setAttribute("_IndexRebuildDisableLoggingVerifyType", PhoenixConfigurationUtil.getDisableLoggingVerifyType(configuration).toBytes());
                String shouldLogMaxLookbackOutput = configuration.get("phoenix.index.mr.log.beyond.max.lookback.errors");
                if (shouldLogMaxLookbackOutput != null) {
                    scan.setAttribute("_IndexRebuildDisableLoggingBeyondMaxLookbackAge", Bytes.toBytes((String)shouldLogMaxLookbackOutput));
                }
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
            if (txnScnValue != null) {
                scan.setAttribute("_TxScn", Bytes.toBytes((long)Long.parseLong(txnScnValue)));
            }
            QueryPlan queryPlan = this.queryPlan;
            return queryPlan;
        }
        catch (Exception exception) {
            LOGGER.error(String.format("Failed to get the query plan with error [%s]", exception.getMessage()));
            throw new RuntimeException(exception);
        }
    }

    private class IndexTableQueryPlanBuilder
    implements QueryPlanBuilder {
        private IndexTableQueryPlanBuilder() {
        }

        @Override
        public QueryPlan getQueryPlan(PhoenixConnection phoenixConnection, String dataTableFullName, String indexTableFullName) throws SQLException {
            QueryPlan plan;
            try (PhoenixStatement statement = new PhoenixStatement(phoenixConnection);){
                String query = "SELECT count(*) FROM " + indexTableFullName;
                plan = statement.compileQuery(query);
                TableRef tableRef = plan.getTableRef();
                Scan scan = plan.getContext().getScan();
                ImmutableBytesWritable ptr = new ImmutableBytesWritable();
                PTable pIndexTable = tableRef.getTable();
                PTable pDataTable = phoenixConnection.getTable(dataTableFullName);
                IndexMaintainer.serialize((PTable)pDataTable, (ImmutableBytesWritable)ptr, Collections.singletonList(pIndexTable), (PhoenixConnection)phoenixConnection);
                scan.setAttribute("INDEX_IDX_MAINTAINER", pIndexTable.getTableName().getBytes());
                ScanUtil.annotateScanWithMetadataAttributes((PTable)pDataTable, (Scan)scan);
                scan.setAttribute("IdxProtoMD", ByteUtil.copyKeyBytesIfNecessary((ImmutableBytesWritable)ptr));
                scan.setAttribute("_RebuildIndexes", PDataType.TRUE_BYTES);
                ScanUtil.setClientVersion((Scan)scan, (int)MetaDataProtocol.PHOENIX_VERSION);
            }
            return plan;
        }
    }

    private class DataTableQueryPlanBuilder
    implements QueryPlanBuilder {
        private DataTableQueryPlanBuilder() {
        }

        @Override
        public QueryPlan getQueryPlan(PhoenixConnection phoenixConnection, String dataTableFullName, String indexTableFullName) throws SQLException {
            PTable indexTable = phoenixConnection.getTableNoCache(indexTableFullName);
            ServerBuildIndexCompiler compiler = new ServerBuildIndexCompiler(phoenixConnection, dataTableFullName);
            MutationPlan plan = compiler.compile(indexTable);
            return plan.getQueryPlan();
        }
    }

    private class TransformingDataTableQueryPlanBuilder
    implements QueryPlanBuilder {
        private TransformingDataTableQueryPlanBuilder() {
        }

        @Override
        public QueryPlan getQueryPlan(PhoenixConnection phoenixConnection, String oldTableFullName, String newTableFullName) throws SQLException {
            PTable newTable = phoenixConnection.getTableNoCache(newTableFullName);
            ServerBuildTransformingTableCompiler compiler = new ServerBuildTransformingTableCompiler(phoenixConnection, oldTableFullName);
            MutationPlan plan = compiler.compile(newTable);
            return plan.getQueryPlan();
        }
    }

    private static interface QueryPlanBuilder {
        public QueryPlan getQueryPlan(PhoenixConnection var1, String var2, String var3) throws SQLException;
    }
}

