/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.mapreduce.RegionSizeCalculator;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.db.DBWritable;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.iterate.MapReduceParallelScanGrouper;
import org.apache.phoenix.iterate.ParallelScanGrouper;
import org.apache.phoenix.mapreduce.PhoenixInputSplit;
import org.apache.phoenix.mapreduce.PhoenixRecordReader;
import org.apache.phoenix.mapreduce.util.PhoenixConfigurationUtil;
import org.apache.phoenix.query.HBaseFactoryProvider;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoenixInputFormat<T extends DBWritable>
extends InputFormat<NullWritable, T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhoenixInputFormat.class);

    public RecordReader<NullWritable, T> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        Configuration configuration = context.getConfiguration();
        QueryPlan queryPlan = this.getQueryPlan((JobContext)context, configuration);
        Class<?> inputClass = PhoenixConfigurationUtil.getInputClass(configuration);
        return this.getPhoenixRecordReader(inputClass, configuration, queryPlan);
    }

    public List<InputSplit> getSplits(JobContext context) throws IOException, InterruptedException {
        Configuration configuration = context.getConfiguration();
        QueryPlan queryPlan = this.getQueryPlan(context, configuration);
        return this.generateSplits(queryPlan, configuration);
    }

    protected void randomizeSplitLength(List<InputSplit> splits) {
        LOGGER.info("Randomizing split size");
        if (splits.size() == 0) {
            return;
        }
        double defaultLength = 1000000.0;
        double totalLength = splits.stream().mapToDouble(s -> {
            try {
                return s.getLength();
            }
            catch (IOException | InterruptedException e1) {
                return defaultLength;
            }
        }).sum();
        long avgLength = (long)(totalLength / (double)splits.size());
        splits.stream().forEach(s -> ((PhoenixInputSplit)((Object)s)).setLength(avgLength + (long)ThreadLocalRandom.current().nextInt(10000)));
    }

    protected List<InputSplit> generateSplits(QueryPlan qplan, Configuration config) throws IOException {
        this.setupParallelScansFromQueryPlan(qplan);
        List splits = qplan.getSplits();
        Preconditions.checkNotNull((Object)splits);
        try (Connection connection = HBaseFactoryProvider.getHConnectionFactory().createConnection(config);){
            RegionLocator regionLocator = connection.getRegionLocator(TableName.valueOf((String)qplan.getTableRef().getTable().getPhysicalName().toString()));
            RegionSizeCalculator sizeCalculator = new RegionSizeCalculator(regionLocator, connection.getAdmin());
            ArrayList psplits = Lists.newArrayListWithExpectedSize((int)splits.size());
            for (List scans : qplan.getScans()) {
                HRegionLocation location = regionLocator.getRegionLocation(((Scan)scans.get(0)).getStartRow(), false);
                String regionLocation = location.getHostname();
                long regionSize = sizeCalculator.getRegionSize(location.getRegion().getRegionName());
                boolean splitByStats = PhoenixConfigurationUtil.getSplitByStats(config);
                if (splitByStats) {
                    for (Scan aScan : scans) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Split for  scan : " + aScan + "with scanAttribute : " + aScan.getAttributesMap() + " [scanCache, cacheBlock, scanBatch] : [" + aScan.getCaching() + ", " + aScan.getCacheBlocks() + ", " + aScan.getBatch() + "] and  regionLocation : " + regionLocation);
                        }
                        psplits.add(new PhoenixInputSplit(Collections.singletonList(aScan), regionSize, regionLocation));
                    }
                    continue;
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Scan count[" + scans.size() + "] : " + Bytes.toStringBinary((byte[])((Scan)scans.get(0)).getStartRow()) + " ~ " + Bytes.toStringBinary((byte[])((Scan)scans.get(scans.size() - 1)).getStopRow()));
                    LOGGER.debug("First scan : " + scans.get(0) + "with scanAttribute : " + ((Scan)scans.get(0)).getAttributesMap() + " [scanCache, cacheBlock, scanBatch] : [" + ((Scan)scans.get(0)).getCaching() + ", " + ((Scan)scans.get(0)).getCacheBlocks() + ", " + ((Scan)scans.get(0)).getBatch() + "] and  regionLocation : " + regionLocation);
                    int limit = scans.size();
                    for (int i = 0; i < limit; ++i) {
                        LOGGER.debug("EXPECTED_UPPER_REGION_KEY[" + i + "] : " + Bytes.toStringBinary((byte[])((Scan)scans.get(i)).getAttribute("_ExpectedUpperRegionKey")));
                    }
                }
                psplits.add(new PhoenixInputSplit(scans, regionSize, regionLocation));
            }
            if (PhoenixConfigurationUtil.isMRRandomizeMapperExecutionOrder(config)) {
                this.randomizeSplitLength(psplits);
            }
            ArrayList arrayList = psplits;
            return arrayList;
        }
    }

    /*
     * Exception decompiling
     */
    protected QueryPlan getQueryPlan(JobContext context, Configuration configuration) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void setupParallelScansFromQueryPlan(QueryPlan queryPlan) {
        this.setupParallelScansWithScanGrouper(queryPlan, MapReduceParallelScanGrouper.getInstance());
    }

    RecordReader<NullWritable, T> getPhoenixRecordReader(Class<T> inputClass, Configuration configuration, QueryPlan queryPlan) {
        return new PhoenixRecordReader<T>(inputClass, configuration, queryPlan, MapReduceParallelScanGrouper.getInstance());
    }

    void setupParallelScansWithScanGrouper(QueryPlan queryPlan, ParallelScanGrouper scanGrouper) {
        Preconditions.checkNotNull((Object)queryPlan);
        try {
            queryPlan.iterator(scanGrouper);
        }
        catch (SQLException e) {
            LOGGER.error(String.format("Setting up parallel scans for the query plan failed with error [%s]", e.getMessage()));
            throw new RuntimeException(e);
        }
    }
}

