/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.RestoreSnapshotHelper;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotManifest;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.phoenix.compile.ExplainPlanAttributes;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.iterate.ScanningResultIterator;
import org.apache.phoenix.iterate.SnapshotScanner;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.mapreduce.util.PhoenixConfigurationUtil;
import org.apache.phoenix.monitoring.ScanMetricsHolder;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.ClientUtil;
import org.apache.phoenix.util.ScanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableSnapshotResultIterator
implements ResultIterator {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableSnapshotResultIterator.class);
    private final Scan scan;
    private ResultIterator scanIterator;
    private Configuration configuration;
    private final ScanMetricsHolder scanMetricsHolder;
    private Tuple lastTuple = null;
    private static final ResultIterator UNINITIALIZED_SCANNER = ResultIterator.EMPTY_ITERATOR;
    private List<RegionInfo> regions;
    private TableDescriptor htd;
    private String snapshotName;
    private Path restoreDir;
    private Path rootDir;
    private FileSystem fs;
    private int currentRegion;
    private boolean closed = false;
    private StatementContext context;
    private final boolean isMapReduceContext;
    private final long maxQueryEndTime;

    public TableSnapshotResultIterator(Configuration configuration, Scan scan, ScanMetricsHolder scanMetricsHolder, StatementContext context, boolean isMapReduceContext, long maxQueryEndTime) throws IOException {
        this.configuration = configuration;
        this.currentRegion = -1;
        this.scan = scan;
        this.context = context;
        this.scanMetricsHolder = scanMetricsHolder;
        this.scanIterator = UNINITIALIZED_SCANNER;
        this.restoreDir = PhoenixConfigurationUtil.isMRSnapshotManagedExternally(configuration) ? new Path(configuration.get("phoenix.tableSnapshot.restore.dir")) : new Path(configuration.get("phoenix.tableSnapshot.restore.dir"), UUID.randomUUID().toString());
        this.snapshotName = configuration.get("phoenix.mapreduce.snapshot.name");
        this.rootDir = CommonFSUtils.getRootDir((Configuration)configuration);
        this.fs = this.rootDir.getFileSystem(configuration);
        this.isMapReduceContext = isMapReduceContext;
        this.maxQueryEndTime = maxQueryEndTime;
        this.init();
    }

    private void init() throws IOException {
        if (!PhoenixConfigurationUtil.isMRSnapshotManagedExternally(this.configuration)) {
            RestoreSnapshotHelper.RestoreMetaChanges meta = RestoreSnapshotHelper.copySnapshotForScanner((Configuration)this.configuration, (FileSystem)this.fs, (Path)this.rootDir, (Path)this.restoreDir, (String)this.snapshotName);
            List restoredRegions = meta.getRegionsToAdd();
            this.htd = meta.getTableDescriptor();
            this.regions = new ArrayList<RegionInfo>(restoredRegions.size());
            for (RegionInfo restoredRegion : restoredRegions) {
                if (!this.isValidRegion(restoredRegion)) continue;
                this.regions.add(restoredRegion);
            }
        } else {
            Path snapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir((String)this.snapshotName, (Path)this.rootDir);
            SnapshotProtos.SnapshotDescription snapshotDesc = SnapshotDescriptionUtils.readSnapshotInfo((FileSystem)this.fs, (Path)snapshotDir);
            SnapshotManifest manifest = SnapshotManifest.open((Configuration)this.configuration, (FileSystem)this.fs, (Path)snapshotDir, (SnapshotProtos.SnapshotDescription)snapshotDesc);
            List regionManifests = manifest.getRegionManifests();
            this.regions = new ArrayList<RegionInfo>(regionManifests.size());
            this.htd = manifest.getTableDescriptor();
            for (SnapshotProtos.SnapshotRegionManifest srm : regionManifests) {
                RegionInfo hri = ProtobufUtil.toRegionInfo((HBaseProtos.RegionInfo)srm.getRegionInfo());
                if (!this.isValidRegion(hri)) continue;
                this.regions.add(hri);
            }
        }
        this.regions.sort(RegionInfo.COMPARATOR);
        ScanUtil.setScanAttributeForPaging((Scan)this.scan, (PhoenixConnection)this.context.getConnection());
        LOGGER.info("Initialization complete with " + this.regions.size() + " valid regions");
    }

    private boolean isValidRegion(RegionInfo hri) {
        if (hri.isOffline() && (hri.isSplit() || hri.isSplitParent())) {
            return false;
        }
        return PrivateCellUtil.overlappingKeys((byte[])this.scan.getStartRow(), (byte[])this.scan.getStopRow(), (byte[])hri.getStartKey(), (byte[])hri.getEndKey());
    }

    public boolean initSnapshotScanner() throws SQLException {
        if (this.closed) {
            return true;
        }
        ResultIterator delegate = this.scanIterator;
        if (delegate == UNINITIALIZED_SCANNER) {
            ++this.currentRegion;
            if (this.currentRegion >= this.regions.size()) {
                return false;
            }
            try {
                RegionInfo hri = this.regions.get(this.currentRegion);
                this.scanIterator = new ScanningResultIterator((ResultScanner)new SnapshotScanner(this.configuration, this.fs, this.restoreDir, this.htd, hri, this.scan), this.scan, this.scanMetricsHolder, this.context, this.isMapReduceContext, this.maxQueryEndTime);
            }
            catch (Throwable e) {
                throw ClientUtil.parseServerException((Throwable)e);
            }
        }
        return true;
    }

    public Tuple next() throws SQLException {
        while (this.initSnapshotScanner()) {
            try {
                this.lastTuple = this.scanIterator.next();
                if (this.lastTuple == null) continue;
                ImmutableBytesWritable ptr = new ImmutableBytesWritable();
                this.lastTuple.getKey(ptr);
                Tuple tuple = this.lastTuple;
                return tuple;
            }
            finally {
                if (this.lastTuple != null) continue;
                this.scanIterator.close();
                this.scanIterator = UNINITIALIZED_SCANNER;
                continue;
            }
            break;
        }
        return null;
    }

    public void close() throws SQLException {
        this.closed = true;
        try {
            this.scanIterator.close();
            if (!PhoenixConfigurationUtil.isMRSnapshotManagedExternally(this.configuration)) {
                this.fs.delete(this.restoreDir, true);
            }
        }
        catch (IOException e) {
            throw ClientUtil.parseServerException((Throwable)e);
        }
        finally {
            this.scanIterator = UNINITIALIZED_SCANNER;
        }
    }

    public void explain(List<String> planSteps) {
    }

    public void explain(List<String> planSteps, ExplainPlanAttributes.ExplainPlanAttributesBuilder explainPlanAttributesBuilder) {
    }
}

