/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.regionserver.ScannerContextUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.cache.GlobalCache;
import org.apache.phoenix.cache.TenantCache;
import org.apache.phoenix.coprocessor.BaseRegionScanner;
import org.apache.phoenix.coprocessor.HashJoinRegionScanner;
import org.apache.phoenix.coprocessorclient.MetaDataProtocol;
import org.apache.phoenix.execute.TupleProjector;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.KeyValueColumnExpression;
import org.apache.phoenix.expression.OrderByExpression;
import org.apache.phoenix.expression.SingleCellColumnExpression;
import org.apache.phoenix.expression.function.ArrayIndexFunction;
import org.apache.phoenix.expression.function.BsonValueFunction;
import org.apache.phoenix.expression.function.JsonQueryFunction;
import org.apache.phoenix.expression.function.JsonValueFunction;
import org.apache.phoenix.hbase.index.covered.update.ColumnReference;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.hbase.index.util.VersionUtil;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.iterate.OffsetResultIterator;
import org.apache.phoenix.iterate.OrderedResultIterator;
import org.apache.phoenix.iterate.RegionScannerFactory;
import org.apache.phoenix.iterate.RegionScannerResultIterator;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.join.HashJoinInfo;
import org.apache.phoenix.memory.MemoryManager;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.KeyValueSchema;
import org.apache.phoenix.schema.PDatum;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.ValueBitSet;
import org.apache.phoenix.schema.ValueSchema;
import org.apache.phoenix.schema.tuple.ResultTuple;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.collect.Sets;
import org.apache.phoenix.transaction.PhoenixTransactionContext;
import org.apache.phoenix.transaction.TransactionFactory;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.ClientUtil;
import org.apache.phoenix.util.EncodedColumnsUtil;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.ScanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonAggregateRegionScannerFactory
extends RegionScannerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(NonAggregateRegionScannerFactory.class);

    public NonAggregateRegionScannerFactory(RegionCoprocessorEnvironment env) {
        this.env = env;
    }

    @Override
    public RegionScanner getRegionScanner(Scan scan, RegionScanner s) throws Throwable {
        long thresholdBytes;
        boolean spoolingEnabled;
        OrderedResultIteratorWithScannerContext ic;
        OrderedResultIterator iterator;
        boolean useQualifierAsIndex;
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        int offset = 0;
        if (ScanUtil.isLocalIndex((Scan)scan)) {
            Region region = this.getRegion();
            offset = region.getRegionInfo().getStartKey().length != 0 ? region.getRegionInfo().getStartKey().length : region.getRegionInfo().getEndKey().length;
            ScanUtil.setRowKeyOffset((Scan)scan, (int)offset);
        }
        byte[] scanOffsetBytes = scan.getAttribute("_RowOffset");
        Integer scanOffset = null;
        if (scanOffsetBytes != null) {
            scanOffset = (Integer)PInteger.INSTANCE.toObject(scanOffsetBytes);
        }
        RegionScanner innerScanner = s;
        PTable.QualifierEncodingScheme encodingScheme = EncodedColumnsUtil.getQualifierEncodingScheme((Scan)scan);
        boolean useNewValueColumnQualifier = EncodedColumnsUtil.useNewValueColumnQualifier((Scan)scan);
        HashSet serverParsedKVRefs = Sets.newHashSet();
        KeyValueSchema kvSchema = null;
        ValueBitSet kvSchemaBitSet = null;
        List<Expression> resultList = this.getServerParsedExpressions(scan, serverParsedKVRefs);
        Expression[] serverParsedFuncRefs = resultList.toArray(new Expression[0]);
        if (serverParsedFuncRefs != null && serverParsedFuncRefs.length > 0) {
            KeyValueSchema.KeyValueSchemaBuilder builder = new KeyValueSchema.KeyValueSchemaBuilder(0);
            for (Expression expression : serverParsedFuncRefs) {
                builder.addField((PDatum)expression);
            }
            kvSchema = builder.build();
            kvSchemaBitSet = ValueBitSet.newInstance((ValueSchema)kvSchema);
        }
        TupleProjector tupleProjector = null;
        Region dataRegion = null;
        IndexMaintainer indexMaintainer = null;
        byte[][] viewConstants = null;
        PhoenixTransactionContext tx = null;
        ColumnReference[] dataColumns = IndexUtil.deserializeDataTableColumnsToJoin((Scan)scan);
        if (dataColumns != null || ScanUtil.isUncoveredGlobalIndex((Scan)scan)) {
            if (dataColumns != null) {
                tupleProjector = IndexUtil.getTupleProjector((Scan)scan, (ColumnReference[])dataColumns);
            }
            dataRegion = this.env.getRegion();
            int clientVersion = ScanUtil.getClientVersion((Scan)scan);
            List indexMaintainers = IndexUtil.deSerializeIndexMaintainersFromScan((Scan)scan);
            indexMaintainer = (IndexMaintainer)indexMaintainers.get(0);
            viewConstants = IndexUtil.deserializeViewConstantsFromScan((Scan)scan);
            byte[] txState = scan.getAttribute("_TxState");
            tx = TransactionFactory.getTransactionContext((byte[])txState, (int)clientVersion);
        }
        TupleProjector p = TupleProjector.deserializeProjectorFromScan((Scan)scan);
        HashJoinInfo j = HashJoinInfo.deserializeHashJoinFromScan((Scan)scan);
        boolean bl = useQualifierAsIndex = EncodedColumnsUtil.useQualifierAsIndex((Pair)EncodedColumnsUtil.getMinMaxQualifiersFromScan((Scan)scan)) && scan.getAttribute("_TopN") != null;
        if (dataRegion == null && this.env.getConfiguration().get("phoenix.mapreduce.snapshot.name") != null) {
            dataRegion = this.env.getRegion();
        }
        innerScanner = this.getWrappedScanner(this.env, innerScanner, serverParsedKVRefs, serverParsedFuncRefs, offset, scan, dataColumns, tupleProjector, dataRegion, indexMaintainer, tx, viewConstants, kvSchema, kvSchemaBitSet, (TupleProjector)(j == null ? p : null), ptr, useQualifierAsIndex);
        ImmutableBytesPtr tenantId = ScanUtil.getTenantId((Scan)scan);
        if (j != null) {
            innerScanner = new HashJoinRegionScanner(this.env, innerScanner, scan, serverParsedKVRefs, serverParsedFuncRefs, p, j, tenantId, useQualifierAsIndex, useNewValueColumnQualifier);
        }
        if (scanOffset != null) {
            boolean isIncompatibleClient = ScanUtil.isIncompatibleClientForServerReturnValidRowKey((Scan)scan);
            RegionScannerResultIterator iterator2 = new RegionScannerResultIterator(scan, innerScanner, (Pair<Integer, Integer>)EncodedColumnsUtil.getMinMaxQualifiersFromScan((Scan)scan), encodingScheme);
            ScannerContext sc = iterator2.getRegionScannerContext();
            innerScanner = this.getOffsetScanner(innerScanner, new OffsetResultIterator((ResultIterator)iterator2, scanOffset, ScanUtil.getPageSizeMsForRegionScanner((Scan)scan), isIncompatibleClient), scan.getAttribute("LAST_SCAN") != null, isIncompatibleClient, scan, sc);
        }
        if ((iterator = (ic = NonAggregateRegionScannerFactory.deserializeFromScan(scan, innerScanner, spoolingEnabled = this.env.getConfiguration().getBoolean("phoenix.query.server.orderBy.spooling.enabled", true), thresholdBytes = this.env.getConfiguration().getLongBytes("phoenix.query.server.spoolThresholdBytes", 0x1400000L))).getIterator()) == null) {
            return innerScanner;
        }
        return this.getTopNScanner(this.env, innerScanner, iterator, tenantId, ic.getScannerContext());
    }

    private List<Expression> getServerParsedExpressions(Scan scan, Set<KeyValueColumnExpression> serverParsedKVRefs) {
        Expression[] serverParsedArrayFuncRefs = null;
        if (scan.getAttribute("_SpecificArrayIndex") != null) {
            serverParsedArrayFuncRefs = this.deserializeServerParsedPositionalExpressionInfoFromScan(scan, "_SpecificArrayIndex", serverParsedKVRefs);
        }
        ArrayList<Expression> resultList = new ArrayList<Expression>();
        if (serverParsedArrayFuncRefs != null) {
            Collections.addAll(resultList, serverParsedArrayFuncRefs);
        }
        this.deserializeAndAddComplexDataTypeFunctions(scan, "_JsonValueFunction", serverParsedKVRefs, resultList);
        this.deserializeAndAddComplexDataTypeFunctions(scan, "_BsonValueFunction", serverParsedKVRefs, resultList);
        Expression[] serverParsedJsonQueryFuncRefs = null;
        if (scan.getAttribute("_JsonQueryFunction") != null) {
            serverParsedJsonQueryFuncRefs = this.deserializeServerParsedPositionalExpressionInfoFromScan(scan, "_JsonQueryFunction", serverParsedKVRefs);
        }
        if (serverParsedJsonQueryFuncRefs != null) {
            Collections.addAll(resultList, serverParsedJsonQueryFuncRefs);
        }
        return resultList;
    }

    private void deserializeAndAddComplexDataTypeFunctions(Scan scan, String functionName, Set<KeyValueColumnExpression> serverParsedKVRefs, List<Expression> resultList) {
        Expression[] serverParsedJsonValueFuncRefs;
        if (scan.getAttribute(functionName) != null && (serverParsedJsonValueFuncRefs = this.deserializeServerParsedPositionalExpressionInfoFromScan(scan, functionName, serverParsedKVRefs)) != null) {
            Collections.addAll(resultList, serverParsedJsonValueFuncRefs);
        }
    }

    @VisibleForTesting
    static OrderedResultIteratorWithScannerContext deserializeFromScan(Scan scan, RegionScanner s, boolean spoolingEnabled, long thresholdBytes) {
        byte[] topN = scan.getAttribute("_TopN");
        if (topN == null) {
            return new OrderedResultIteratorWithScannerContext(null, null);
        }
        int clientVersion = ScanUtil.getClientVersion((Scan)scan);
        boolean shouldDecodeSpoolThreshold = scan.getAttribute("_ClientVersion") == null || VersionUtil.decodeMajorVersion((int)clientVersion) > 5 || VersionUtil.decodeMajorVersion((int)clientVersion) == 5 && clientVersion < MetaDataProtocol.MIN_5_x_DISABLE_SERVER_SPOOL_THRESHOLD || VersionUtil.decodeMajorVersion((int)clientVersion) == 4 && clientVersion < MetaDataProtocol.MIN_4_x_DISABLE_SERVER_SPOOL_THRESHOLD;
        ByteArrayInputStream stream = new ByteArrayInputStream(topN);
        try {
            DataInputStream input = new DataInputStream(stream);
            if (shouldDecodeSpoolThreshold) {
                WritableUtils.readVInt((DataInput)input);
            }
            int limit = WritableUtils.readVInt((DataInput)input);
            int estimatedRowSize = WritableUtils.readVInt((DataInput)input);
            int size = WritableUtils.readVInt((DataInput)input);
            ArrayList orderByExpressions = Lists.newArrayListWithExpectedSize((int)size);
            for (int i = 0; i < size; ++i) {
                OrderByExpression orderByExpression = new OrderByExpression();
                orderByExpression.readFields((DataInput)input);
                orderByExpressions.add(orderByExpression);
            }
            PTable.QualifierEncodingScheme encodingScheme = EncodedColumnsUtil.getQualifierEncodingScheme((Scan)scan);
            RegionScannerResultIterator inner = new RegionScannerResultIterator(scan, s, (Pair<Integer, Integer>)EncodedColumnsUtil.getMinMaxQualifiersFromScan((Scan)scan), encodingScheme);
            OrderedResultIterator iterator = new OrderedResultIterator((ResultIterator)inner, (List)orderByExpressions, spoolingEnabled, thresholdBytes, limit >= 0 ? Integer.valueOf(limit) : null, null, estimatedRowSize, ScanUtil.getPageSizeMsForRegionScanner((Scan)scan), scan, s.getRegionInfo());
            OrderedResultIteratorWithScannerContext orderedResultIteratorWithScannerContext = new OrderedResultIteratorWithScannerContext(inner.getRegionScannerContext(), iterator);
            return orderedResultIteratorWithScannerContext;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private Expression[] deserializeServerParsedPositionalExpressionInfoFromScan(Scan scan, String scanAttribute, Set<KeyValueColumnExpression> serverParsedKVRefs) {
        byte[] specificArrayIdx = scan.getAttribute(scanAttribute);
        if (specificArrayIdx == null) {
            return null;
        }
        ByteArrayInputStream stream = new ByteArrayInputStream(specificArrayIdx);
        try {
            DataInputStream input = new DataInputStream(stream);
            int kvRefSize = WritableUtils.readVInt((DataInput)input);
            for (int i = 0; i < kvRefSize; ++i) {
                PTable.ImmutableStorageScheme scheme = EncodedColumnsUtil.getImmutableStorageScheme((Scan)scan);
                SingleCellColumnExpression kvExp = scheme != PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN ? new SingleCellColumnExpression(scheme) : new KeyValueColumnExpression();
                kvExp.readFields((DataInput)input);
                serverParsedKVRefs.add((KeyValueColumnExpression)kvExp);
            }
            int kvFuncSize = WritableUtils.readVInt((DataInput)input);
            Expression[] funcRefs = new Expression[kvFuncSize];
            for (int i = 0; i < kvFuncSize; ++i) {
                ArrayIndexFunction func = null;
                if (scanAttribute.equals("_SpecificArrayIndex")) {
                    func = new ArrayIndexFunction();
                } else if (scanAttribute.equals("_JsonValueFunction")) {
                    func = new JsonValueFunction();
                } else if (scanAttribute.equals("_JsonQueryFunction")) {
                    func = new JsonQueryFunction();
                } else if (scanAttribute.equals("_BsonValueFunction")) {
                    func = new BsonValueFunction();
                }
                if (func == null) continue;
                func.readFields((DataInput)input);
                funcRefs[i] = func;
            }
            Expression[] expressionArray = funcRefs;
            return expressionArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RegionScanner getOffsetScanner(final RegionScanner s, final OffsetResultIterator iterator, boolean isLastScan, final boolean incompatibleClient, Scan scan, final ScannerContext sc) throws IOException {
        Tuple firstTuple;
        Region region = this.getRegion();
        region.startRegionOperation();
        final byte[] initStartRowKey = scan.getStartRow().length > 0 ? scan.getStartRow() : (scan.isReversed() ? region.getRegionInfo().getEndKey() : region.getRegionInfo().getStartKey());
        byte[] prevScanStartRowKey = scan.getAttribute("_ScanActualStartRow");
        if (Bytes.compareTo((byte[])prevScanStartRowKey, (byte[])initStartRowKey) != 0 && Bytes.compareTo((byte[])ByteUtil.concat((byte[])prevScanStartRowKey, (byte[][])new byte[][]{ByteUtil.ZERO_BYTE}), (byte[])initStartRowKey) != 0) {
            iterator.setRowCountToOffset();
        }
        try {
            Tuple tuple = iterator.next();
            if (tuple == null && !isLastScan) {
                KeyValue kv;
                ArrayList<KeyValue> kvList = new ArrayList<KeyValue>(1);
                byte[] remainingOffset = PInteger.INSTANCE.toBytes((Object)iterator.getRemainingOffset());
                if (incompatibleClient) {
                    kv = new KeyValue(QueryConstants.OFFSET_ROW_KEY_BYTES, QueryConstants.OFFSET_FAMILY, QueryConstants.OFFSET_COLUMN, remainingOffset);
                } else {
                    Tuple lastScannedTuple = iterator.getLastScannedTuple();
                    if (lastScannedTuple != null) {
                        kv = NonAggregateRegionScannerFactory.getOffsetKvWithLastScannedRowKey(remainingOffset, lastScannedTuple);
                    } else {
                        byte[] endKey;
                        byte[] startKey = scan.getStartRow().length > 0 ? scan.getStartRow() : region.getRegionInfo().getStartKey();
                        byte[] rowKey = ByteUtil.getLargestPossibleRowKeyInRange((byte[])startKey, (byte[])(endKey = scan.getStopRow().length > 0 ? scan.getStopRow() : region.getRegionInfo().getEndKey()));
                        if (rowKey == null) {
                            rowKey = scan.includeStartRow() ? startKey : (scan.includeStopRow() ? endKey : HConstants.EMPTY_END_ROW);
                        }
                        kv = new KeyValue(rowKey, QueryConstants.OFFSET_FAMILY, QueryConstants.OFFSET_COLUMN, remainingOffset);
                    }
                }
                kvList.add(kv);
                Result r = Result.create(kvList);
                firstTuple = new ResultTuple(r);
            } else {
                firstTuple = tuple;
            }
        }
        catch (Throwable t) {
            ClientUtil.throwIOException((String)this.getRegion().getRegionInfo().getRegionNameAsString(), (Throwable)t);
            RegionScanner regionScanner = null;
            return regionScanner;
        }
        finally {
            region.closeRegionOperation();
        }
        return new BaseRegionScanner(s){
            private Tuple tuple;
            private byte[] previousResultRowKey;
            private ScannerContext regionScannerContext;
            {
                super(delegate);
                this.tuple = firstTuple;
                this.regionScannerContext = sc;
            }

            @Override
            public boolean isFilterDone() {
                return this.tuple == null;
            }

            @Override
            public boolean next(List<Cell> results) throws IOException {
                return this.next(results, null);
            }

            @Override
            public boolean next(List<Cell> results, ScannerContext scannerContext) throws IOException {
                try {
                    if (this.isFilterDone()) {
                        return false;
                    }
                    Tuple nextTuple = iterator.next();
                    if (this.tuple.size() > 0 && !ScanUtil.isDummy((Tuple)this.tuple)) {
                        for (int i = 0; i < this.tuple.size(); ++i) {
                            results.add(this.tuple.getValue(i));
                            if (i != 0) continue;
                            this.previousResultRowKey = CellUtil.cloneRow((Cell)this.tuple.getValue(i));
                        }
                    } else if (nextTuple == null) {
                        byte[] remainingOffset = PInteger.INSTANCE.toBytes((Object)iterator.getRemainingOffset());
                        KeyValue kv = incompatibleClient ? new KeyValue(QueryConstants.OFFSET_ROW_KEY_BYTES, QueryConstants.OFFSET_FAMILY, QueryConstants.OFFSET_COLUMN, remainingOffset) : NonAggregateRegionScannerFactory.getOffsetKvWithLastScannedRowKey(remainingOffset, this.tuple);
                        results.add((Cell)kv);
                    } else {
                        NonAggregateRegionScannerFactory.this.updateDummyWithPrevRowKey(results, initStartRowKey, this.previousResultRowKey);
                    }
                    this.tuple = nextTuple;
                    if (this.regionScannerContext != null) {
                        ScannerContextUtil.updateMetrics(this.regionScannerContext, scannerContext);
                        this.regionScannerContext = null;
                    }
                    return !this.isFilterDone();
                }
                catch (Throwable t) {
                    LOGGER.error("Error while iterating Offset scanner.", t);
                    ClientUtil.throwIOException((String)NonAggregateRegionScannerFactory.this.getRegion().getRegionInfo().getRegionNameAsString(), (Throwable)t);
                    return false;
                }
            }

            @Override
            public boolean nextRaw(List<Cell> results, ScannerContext scannerContext) throws IOException {
                return this.next(results, scannerContext);
            }

            @Override
            public void close() throws IOException {
                try {
                    s.close();
                }
                finally {
                    try {
                        iterator.close();
                    }
                    catch (SQLException e) {
                        ClientUtil.throwIOException((String)NonAggregateRegionScannerFactory.this.getRegion().getRegionInfo().getRegionNameAsString(), (Throwable)e);
                    }
                }
            }
        };
    }

    private void updateDummyWithPrevRowKey(List<Cell> result, byte[] initStartRowKey, byte[] previousResultRowKey) {
        result.clear();
        if (previousResultRowKey != null) {
            ScanUtil.getDummyResult((byte[])previousResultRowKey, result);
        } else {
            ScanUtil.getDummyResult((byte[])initStartRowKey, result);
        }
    }

    private static KeyValue getOffsetKvWithLastScannedRowKey(byte[] value, Tuple tuple) {
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        tuple.getKey(ptr);
        byte[] rowKey = new byte[ptr.getLength()];
        System.arraycopy(ptr.get(), ptr.getOffset(), rowKey, 0, rowKey.length);
        return new KeyValue(rowKey, QueryConstants.OFFSET_FAMILY, QueryConstants.OFFSET_COLUMN, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RegionScanner getTopNScanner(RegionCoprocessorEnvironment env, final RegionScanner s, final OrderedResultIterator iterator, ImmutableBytesPtr tenantId, final ScannerContext sc) throws Throwable {
        Tuple firstTuple;
        TenantCache tenantCache = GlobalCache.getTenantCache(env, tenantId);
        long estSize = iterator.getEstimatedByteSize();
        final MemoryManager.MemoryChunk chunk = tenantCache.getMemoryManager().allocate(estSize);
        final Region region = this.getRegion();
        region.startRegionOperation();
        try {
            firstTuple = iterator.next();
            long actualSize = iterator.getByteSize();
            chunk.resize(actualSize);
        }
        catch (Throwable t) {
            ClientUtil.throwIOException((String)region.getRegionInfo().getRegionNameAsString(), (Throwable)t);
            RegionScanner regionScanner = null;
            return regionScanner;
        }
        finally {
            region.closeRegionOperation();
        }
        return new BaseRegionScanner(s){
            private Tuple tuple;
            private ScannerContext regionScannerContext;
            {
                super(delegate);
                this.tuple = firstTuple;
                this.regionScannerContext = sc;
            }

            @Override
            public boolean isFilterDone() {
                return this.tuple == null;
            }

            @Override
            public boolean next(List<Cell> results) throws IOException {
                return this.next(results, null);
            }

            @Override
            public boolean next(List<Cell> results, ScannerContext scannerContext) throws IOException {
                try {
                    if (this.isFilterDone()) {
                        return false;
                    }
                    if (ScanUtil.isDummy((Tuple)this.tuple)) {
                        ScanUtil.getDummyResult((byte[])CellUtil.cloneRow((Cell)this.tuple.getValue(0)), results);
                    } else {
                        for (int i = 0; i < this.tuple.size(); ++i) {
                            results.add(this.tuple.getValue(i));
                        }
                    }
                    this.tuple = iterator.next();
                    if (this.regionScannerContext != null) {
                        ScannerContextUtil.updateMetrics(this.regionScannerContext, scannerContext);
                        this.regionScannerContext = null;
                    }
                    return !this.isFilterDone();
                }
                catch (Throwable t) {
                    ClientUtil.throwIOException((String)region.getRegionInfo().getRegionNameAsString(), (Throwable)t);
                    return false;
                }
            }

            @Override
            public boolean nextRaw(List<Cell> results, ScannerContext scannerContext) throws IOException {
                return this.next(results, scannerContext);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                try {
                    s.close();
                }
                finally {
                    try {
                        if (iterator != null) {
                            iterator.close();
                        }
                    }
                    catch (SQLException e) {
                        ClientUtil.throwIOException((String)region.getRegionInfo().getRegionNameAsString(), (Throwable)e);
                    }
                    finally {
                        chunk.close();
                    }
                }
            }
        };
    }

    private static class OrderedResultIteratorWithScannerContext {
        private ScannerContext scannerContext;
        private OrderedResultIterator iterator;

        OrderedResultIteratorWithScannerContext(ScannerContext sc, OrderedResultIterator ori) {
            this.scannerContext = sc;
            this.iterator = ori;
        }

        public ScannerContext getScannerContext() {
            return this.scannerContext;
        }

        public OrderedResultIterator getIterator() {
            return this.iterator;
        }
    }
}

