/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotManifest;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.iterate.ParallelScanGrouper;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;

public class MapReduceParallelScanGrouper
implements ParallelScanGrouper {
    private static final MapReduceParallelScanGrouper INSTANCE = new MapReduceParallelScanGrouper();

    public static MapReduceParallelScanGrouper getInstance() {
        return INSTANCE;
    }

    @VisibleForTesting
    MapReduceParallelScanGrouper() {
    }

    public boolean shouldStartNewScan(QueryPlan plan, Scan lastScan, byte[] startKey, boolean crossesRegionBoundary) {
        return (!plan.isRowKeyOrdered() || crossesRegionBoundary) && lastScan != null;
    }

    public List<HRegionLocation> getRegionBoundaries(StatementContext context, byte[] tableName) throws SQLException {
        Configuration conf = context.getConnection().getQueryServices().getConfiguration();
        String snapshotName = this.getSnapshotName(conf);
        if (snapshotName != null) {
            return this.getRegionLocationsFromSnapshot(conf, snapshotName);
        }
        return context.getConnection().getQueryServices().getAllTableRegions(tableName, context.getStatement().getQueryTimeoutInMillis());
    }

    public List<HRegionLocation> getRegionBoundaries(StatementContext context, byte[] tableName, byte[] startRegionBoundaryKey, byte[] stopRegionBoundaryKey) throws SQLException {
        Configuration conf = context.getConnection().getQueryServices().getConfiguration();
        String snapshotName = this.getSnapshotName(conf);
        if (snapshotName != null) {
            return this.getRegionLocationsFromSnapshot(conf, snapshotName);
        }
        return context.getConnection().getQueryServices().getTableRegions(tableName, startRegionBoundaryKey, stopRegionBoundaryKey, context.getStatement().getQueryTimeoutInMillis());
    }

    private List<HRegionLocation> getRegionLocationsFromSnapshot(Configuration conf, String snapshotName) {
        try {
            Path rootDir = new Path(conf.get("hbase.rootdir"));
            FileSystem fs = rootDir.getFileSystem(conf);
            Path snapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir((String)snapshotName, (Path)rootDir);
            SnapshotProtos.SnapshotDescription snapshotDescription = SnapshotDescriptionUtils.readSnapshotInfo((FileSystem)fs, (Path)snapshotDir);
            SnapshotManifest manifest = SnapshotManifest.open((Configuration)conf, (FileSystem)fs, (Path)snapshotDir, (SnapshotProtos.SnapshotDescription)snapshotDescription);
            return this.getRegionLocationsFromManifest(manifest);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private List<HRegionLocation> getRegionLocationsFromManifest(SnapshotManifest manifest) {
        List regionManifests = manifest.getRegionManifests();
        Preconditions.checkNotNull((Object)regionManifests);
        ArrayList regionInfos = Lists.newArrayListWithCapacity((int)regionManifests.size());
        ArrayList hRegionLocations = Lists.newArrayListWithCapacity((int)regionManifests.size());
        for (SnapshotProtos.SnapshotRegionManifest regionManifest : regionManifests) {
            RegionInfo regionInfo = ProtobufUtil.toRegionInfo((HBaseProtos.RegionInfo)regionManifest.getRegionInfo());
            if (!this.isValidRegion(regionInfo)) continue;
            regionInfos.add(regionInfo);
        }
        regionInfos.sort(RegionInfo.COMPARATOR);
        for (RegionInfo regionInfo : regionInfos) {
            hRegionLocations.add(new HRegionLocation(regionInfo, null));
        }
        return hRegionLocations;
    }

    private boolean isValidRegion(RegionInfo hri) {
        return !hri.isOffline() || !hri.isSplit() && !hri.isSplitParent();
    }

    private String getSnapshotName(Configuration conf) {
        return conf.get("phoenix.mapreduce.snapshot.name");
    }
}

