/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.index;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.coprocessorclient.MetaDataProtocol;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.hbase.index.exception.MultiIndexWriteFailureException;
import org.apache.phoenix.hbase.index.table.HTableInterfaceReference;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.hbase.index.write.DelegateIndexFailurePolicy;
import org.apache.phoenix.hbase.index.write.KillServerOnFailurePolicy;
import org.apache.phoenix.hbase.index.write.LeaveIndexActiveFailurePolicy;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.index.PhoenixIndexMetaData;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.thirdparty.com.google.common.base.Function;
import org.apache.phoenix.thirdparty.com.google.common.collect.Iterables;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.collect.Multimap;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.ServerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoenixIndexFailurePolicy
extends DelegateIndexFailurePolicy {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhoenixIndexFailurePolicy.class);
    public static final String THROW_INDEX_WRITE_FAILURE = "THROW_INDEX_WRITE_FAILURE";
    public static final String DISABLE_INDEX_ON_WRITE_FAILURE = "DISABLE_INDEX_ON_WRITE_FAILURE";
    public static final String REBUILD_INDEX_ON_WRITE_FAILURE = "REBUILD_INDEX_ON_WRITE_FAILURE";
    public static final String BLOCK_DATA_TABLE_WRITES_ON_WRITE_FAILURE = "BLOCK_DATA_TABLE_WRITES_ON_WRITE_FAILURE";
    private RegionCoprocessorEnvironment env;
    private boolean blockDataTableWritesOnFailure;
    private boolean disableIndexOnFailure;
    private boolean rebuildIndexOnFailure;
    private boolean throwIndexWriteFailure;

    public PhoenixIndexFailurePolicy() {
        super(new KillServerOnFailurePolicy());
    }

    @Override
    public void setup(Stoppable parent, RegionCoprocessorEnvironment env) {
        String value;
        super.setup(parent, env);
        this.env = env;
        this.rebuildIndexOnFailure = env.getConfiguration().getBoolean("phoenix.index.failure.handling.rebuild", true);
        TableDescriptor htd = env.getRegion().getTableDescriptor();
        if (this.rebuildIndexOnFailure && (value = htd.getValue(REBUILD_INDEX_ON_WRITE_FAILURE)) != null) {
            this.rebuildIndexOnFailure = Boolean.parseBoolean(value);
        }
        this.disableIndexOnFailure = PhoenixIndexFailurePolicy.getDisableIndexOnFailure(env);
        value = htd.getValue(BLOCK_DATA_TABLE_WRITES_ON_WRITE_FAILURE);
        this.blockDataTableWritesOnFailure = value == null ? env.getConfiguration().getBoolean("phoenix.index.failure.block.write", false) : Boolean.parseBoolean(value);
        value = htd.getValue(THROW_INDEX_WRITE_FAILURE);
        this.throwIndexWriteFailure = value == null ? env.getConfiguration().getBoolean("phoenix.index.failure.throw.exception", true) : Boolean.parseBoolean(value);
        boolean killServer = env.getConfiguration().getBoolean("phoenix.index.failure.unhandled.killserver", true);
        if (!killServer) {
            this.setDelegate(new LeaveIndexActiveFailurePolicy());
        }
    }

    public static boolean getDisableIndexOnFailure(RegionCoprocessorEnvironment env) {
        TableDescriptor htd = env.getRegion().getTableDescriptor();
        Configuration config = env.getConfiguration();
        String value = htd.getValue(DISABLE_INDEX_ON_WRITE_FAILURE);
        boolean disableIndexOnFailure = value == null ? config.getBoolean("phoenix.index.failure.disable.index", true) : Boolean.parseBoolean(value);
        return disableIndexOnFailure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleFailure(Multimap<HTableInterfaceReference, Mutation> attempted, Exception cause) throws IOException {
        boolean throwing = true;
        long timestamp = Long.MAX_VALUE;
        Mutation checkMutationForRebuilder = (Mutation)((Map.Entry)attempted.entries().iterator().next()).getValue();
        boolean isIndexRebuild = PhoenixIndexMetaData.isIndexRebuild((Map)checkMutationForRebuilder.getAttributesMap());
        if (isIndexRebuild) {
            SQLException sqlException = new SQLExceptionInfo.Builder(SQLExceptionCode.INDEX_WRITE_FAILURE).setRootCause((Throwable)cause).setMessage(cause.getLocalizedMessage()).build().buildException();
            DoNotRetryIOException ioException = ServerUtil.wrapInDoNotRetryIOException("Retrying Index rebuild mutation, we will update Index state to DISABLE if all retries are exhusated", sqlException, timestamp);
            throw ioException;
        }
        try {
            timestamp = this.handleFailureWithExceptions(attempted, cause);
            throwing = false;
        }
        catch (Throwable t) {
            LOGGER.warn("handleFailure failed", t);
            super.handleFailure(attempted, cause);
            throwing = false;
        }
        finally {
            if (!throwing) {
                SQLException sqlException = new SQLExceptionInfo.Builder(SQLExceptionCode.INDEX_WRITE_FAILURE).setRootCause((Throwable)cause).setMessage(cause.getLocalizedMessage()).build().buildException();
                DoNotRetryIOException ioException = ServerUtil.wrapInDoNotRetryIOException(null, sqlException, timestamp);
                if (this.throwIndexWriteFailure) {
                    throw ioException;
                }
                LOGGER.warn("Swallowing index write failure", (Throwable)ioException);
            }
        }
    }

    private long handleFailureWithExceptions(Multimap<HTableInterfaceReference, Mutation> attempted, final Exception cause) throws Throwable {
        Set refs = attempted.asMap().keySet();
        final HashMap<String, Long> indexTableNames = new HashMap<String, Long>(refs.size());
        long timestamp = 0L;
        final boolean leaveIndexActive = this.blockDataTableWritesOnFailure || !this.disableIndexOnFailure;
        HashSet failedTables = cause instanceof MultiIndexWriteFailureException ? new HashSet(((MultiIndexWriteFailureException)((Object)cause)).getFailedTables()) : Collections.emptySet();
        for (HTableInterfaceReference ref : refs) {
            if (failedTables.size() > 0 && !failedTables.contains(ref)) continue;
            long minTimeStamp = 0L;
            Collection mutations = attempted.get((Object)ref);
            if (mutations != null) {
                for (Mutation mutation : mutations) {
                    for (List kvs : mutation.getFamilyCellMap().values()) {
                        for (Cell kv : kvs) {
                            if (minTimeStamp != 0L && (kv.getTimestamp() < 0L || minTimeStamp <= kv.getTimestamp())) continue;
                            minTimeStamp = kv.getTimestamp();
                        }
                    }
                }
            }
            timestamp = minTimeStamp;
            if (ref.getTableName().equals(this.env.getRegion().getTableDescriptor().getTableName().getNameAsString()) && MetaDataUtil.hasLocalIndexColumnFamily((TableDescriptor)this.env.getRegion().getTableDescriptor())) {
                for (String string : this.getLocalIndexNames(ref, mutations)) {
                    indexTableNames.put(string, minTimeStamp);
                }
                if (!(cause instanceof MultiIndexWriteFailureException)) continue;
                ArrayList failedLocalIndexes = Lists.newArrayList((Iterable)Iterables.transform(indexTableNames.entrySet(), (Function)new Function<Map.Entry<String, Long>, HTableInterfaceReference>(){

                    public HTableInterfaceReference apply(Map.Entry<String, Long> input) {
                        return new HTableInterfaceReference(new ImmutableBytesPtr(Bytes.toBytes((String)input.getKey())));
                    }
                }));
                ((MultiIndexWriteFailureException)((Object)cause)).setFailedTables((List)failedLocalIndexes);
                continue;
            }
            indexTableNames.put(ref.getTableName(), minTimeStamp);
        }
        if (!this.disableIndexOnFailure && !this.rebuildIndexOnFailure) {
            return timestamp;
        }
        final PIndexState newState = this.disableIndexOnFailure ? PIndexState.PENDING_DISABLE : PIndexState.PENDING_ACTIVE;
        final long fTimestamp = timestamp;
        return (Long)User.runAsLoginUser((PrivilegedExceptionAction)new PrivilegedExceptionAction<Long>(){

            @Override
            public Long run() throws Exception {
                for (Map.Entry tableTimeElement : indexTableNames.entrySet()) {
                    String indexTableName = (String)tableTimeElement.getKey();
                    long minTimeStamp = (Long)tableTimeElement.getValue();
                    if (!PhoenixIndexFailurePolicy.this.disableIndexOnFailure && !PhoenixIndexFailurePolicy.this.blockDataTableWritesOnFailure) {
                        minTimeStamp *= -1L;
                    }
                    try {
                        Table systemTable = PhoenixIndexFailurePolicy.this.env.getConnection().getTable(SchemaUtil.getPhysicalTableName((byte[])PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES, (Configuration)PhoenixIndexFailurePolicy.this.env.getConfiguration()));
                        Throwable throwable = null;
                        try {
                            MetaDataProtocol.MetaDataMutationResult result = IndexUtil.updateIndexState((String)indexTableName, (long)minTimeStamp, (Table)systemTable, (PIndexState)newState);
                            if (result.getMutationCode() == MetaDataProtocol.MutationCode.TABLE_NOT_FOUND) {
                                LOGGER.info("Index " + indexTableName + " has been dropped. Ignore uncommitted mutations");
                                continue;
                            }
                            if (result.getMutationCode() != MetaDataProtocol.MutationCode.TABLE_ALREADY_EXISTS) {
                                if (leaveIndexActive) {
                                    LOGGER.warn("Attempt to update INDEX_DISABLE_TIMESTAMP  failed with code = " + result.getMutationCode());
                                    if (PhoenixIndexFailurePolicy.this.blockDataTableWritesOnFailure) {
                                        throw new DoNotRetryIOException("Attempt to update INDEX_DISABLE_TIMESTAMP failed.");
                                    }
                                } else {
                                    LOGGER.warn("Attempt to disable index " + indexTableName + " failed with code = " + result.getMutationCode() + ". Will use default failure policy instead.");
                                    throw new DoNotRetryIOException("Attempt to disable " + indexTableName + " failed.");
                                }
                            }
                            LOGGER.info("Successfully update INDEX_DISABLE_TIMESTAMP for " + indexTableName + " due to an exception while writing updates. indexState=" + newState, (Throwable)cause);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (systemTable == null) continue;
                            if (throwable != null) {
                                try {
                                    systemTable.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            systemTable.close();
                        }
                    }
                    catch (Throwable t) {
                        if (t instanceof Exception) {
                            throw (Exception)t;
                        }
                        throw new Exception(t);
                    }
                }
                return fTimestamp;
            }
        });
    }

    private Collection<? extends String> getLocalIndexNames(HTableInterfaceReference ref, Collection<Mutation> mutations) throws IOException {
        HashSet<String> indexTableNames = new HashSet<String>(1);
        PhoenixConnection conn = null;
        try {
            conn = QueryUtil.getConnectionOnServer((Configuration)this.env.getConfiguration()).unwrap(PhoenixConnection.class);
            PTable dataTable = conn.getTableNoCache(ref.getTableName());
            List indexes = dataTable.getIndexes();
            PTable localIndex = null;
            HashMap<ImmutableBytesWritable, String> localIndexNames = new HashMap<ImmutableBytesWritable, String>();
            for (PTable index : indexes) {
                if (localIndex == null) {
                    localIndex = index;
                }
                localIndexNames.put(new ImmutableBytesWritable(index.getviewIndexIdType().toBytes((Object)index.getViewIndexId())), index.getName().getString());
            }
            if (localIndex == null) {
                Set set = Collections.emptySet();
                return set;
            }
            IndexMaintainer indexMaintainer = localIndex.getIndexMaintainer(dataTable, conn);
            RegionInfo regionInfo = this.env.getRegion().getRegionInfo();
            int offset = regionInfo.getStartKey().length == 0 ? regionInfo.getEndKey().length : regionInfo.getStartKey().length;
            byte[] viewId = null;
            for (Mutation mutation : mutations) {
                viewId = indexMaintainer.getViewIndexIdFromIndexRowKey(new ImmutableBytesWritable(mutation.getRow(), offset, mutation.getRow().length - offset));
                String indexTableName = (String)localIndexNames.get(new ImmutableBytesWritable(viewId));
                if (indexTableName == null) {
                    LOGGER.error("Unable to find local index on " + ref.getTableName() + " with viewID of " + Bytes.toStringBinary((byte[])viewId));
                    continue;
                }
                indexTableNames.add(indexTableName);
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    throw new IOException(e);
                }
            }
        }
        return indexTableNames;
    }
}

