/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.index;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.PackagePrivateFieldAccessor;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.coprocessor.BaseRegionScanner;
import org.apache.phoenix.coprocessor.BaseScannerRegionObserver;
import org.apache.phoenix.coprocessor.DelegateRegionScanner;
import org.apache.phoenix.filter.EmptyColumnOnlyFilter;
import org.apache.phoenix.filter.PagingFilter;
import org.apache.phoenix.filter.UnverifiedRowFilter;
import org.apache.phoenix.hbase.index.covered.update.ColumnReference;
import org.apache.phoenix.hbase.index.metrics.GlobalIndexCheckerSource;
import org.apache.phoenix.hbase.index.metrics.MetricsIndexerSourceFactory;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.transform.TransformMaintainer;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.util.ClientUtil;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.ServerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalIndexChecker
extends BaseScannerRegionObserver
implements RegionCoprocessor {
    private static final Logger LOG = LoggerFactory.getLogger(GlobalIndexChecker.class);
    private static final String REPAIR_LOGGING_PERCENT_ATTRIB = "phoenix.index.repair.logging.percent";
    private static final double DEFAULT_REPAIR_LOGGING_PERCENT = 100.0;
    private GlobalIndexCheckerSource metricsSource;
    private CoprocessorEnvironment env;

    @Override
    protected boolean isRegionObserverFor(Scan scan) {
        return scan.getAttribute("_CheckVerifyColumn") != null;
    }

    @Override
    protected RegionScanner doPostScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Scan scan, RegionScanner s) throws IOException, SQLException {
        return new GlobalIndexScanner((RegionCoprocessorEnvironment)c.getEnvironment(), scan, s, this.metricsSource);
    }

    public Optional<RegionObserver> getRegionObserver() {
        return Optional.of(this);
    }

    public void start(CoprocessorEnvironment e) throws IOException {
        this.env = e;
        this.metricsSource = MetricsIndexerSourceFactory.getInstance().getGlobalIndexCheckerSource();
    }

    public class GlobalIndexScanner
    extends BaseRegionScanner {
        private RegionScanner scanner;
        private long ageThreshold;
        private Scan scan;
        private Scan indexScan;
        private Scan singleRowIndexScan;
        private Scan buildIndexScanForDataTable;
        private Table dataHTable;
        private byte[] emptyCF;
        private byte[] emptyCQ;
        private IndexMaintainer indexMaintainer;
        private byte[][] viewConstants;
        private RegionCoprocessorEnvironment env;
        private Region region;
        private long minTimestamp;
        private long maxTimestamp;
        private GlobalIndexCheckerSource metricsSource;
        private long rowCount;
        private long pageSize;
        private boolean hasMore;
        private double loggingPercent;
        private Random random;
        private String indexName;
        private long pageSizeMs;
        private boolean initialized;

        public GlobalIndexScanner(RegionCoprocessorEnvironment env, Scan scan, RegionScanner scanner, GlobalIndexCheckerSource metricsSource) throws IOException {
            super(scanner);
            this.buildIndexScanForDataTable = null;
            this.dataHTable = null;
            this.indexMaintainer = null;
            this.viewConstants = null;
            this.rowCount = 0L;
            this.pageSize = Long.MAX_VALUE;
            this.initialized = false;
            this.env = env;
            this.scan = scan;
            this.scanner = scanner;
            this.metricsSource = metricsSource;
            this.region = env.getRegion();
            this.emptyCF = scan.getAttribute("_EmptyCFName");
            this.emptyCQ = scan.getAttribute("_EmptyCQName");
            this.ageThreshold = env.getConfiguration().getLong("phoenix.global.index.row.age.threshold.to.delete.ms", 604800000L);
            this.minTimestamp = scan.getTimeRange().getMin();
            this.maxTimestamp = scan.getTimeRange().getMax();
            byte[] indexTableNameBytes = this.region.getRegionInfo().getTable().getName();
            this.indexName = Bytes.toString((byte[])indexTableNameBytes);
            byte[] md = scan.getAttribute("IdxProtoMD");
            List maintainers = IndexMaintainer.deserialize((byte[])md, (boolean)true);
            this.indexMaintainer = IndexMaintainer.getIndexMaintainer((List)maintainers, (byte[])indexTableNameBytes);
            if (this.indexMaintainer == null) {
                throw new DoNotRetryIOException("repairIndexRows: IndexMaintainer is not included in scan attributes for " + this.region.getRegionInfo().getTable().getNameAsString());
            }
            this.loggingPercent = env.getConfiguration().getDouble(GlobalIndexChecker.REPAIR_LOGGING_PERCENT_ATTRIB, 100.0);
            this.random = new Random(EnvironmentEdgeManager.currentTimeMillis());
            this.pageSizeMs = ScanUtil.getPageSizeMsForRegionScanner((Scan)scan);
        }

        @Override
        public int getBatch() {
            return this.scanner.getBatch();
        }

        @Override
        public long getMaxResultSize() {
            return this.scanner.getMaxResultSize();
        }

        private void init() throws IOException {
            Filter filter;
            PageFilter pageFilter = ScanUtil.removePageFilter((Scan)this.scan);
            if (pageFilter != null) {
                this.pageSize = pageFilter.getPageSize();
                this.scanner.close();
                this.scanner = ((DelegateRegionScanner)this.delegate).getNewRegionScanner(this.scan);
            } else {
                this.pageSize = Long.MAX_VALUE;
            }
            Filter delegateFilter = filter = this.scan.getFilter();
            if (filter instanceof PagingFilter) {
                delegateFilter = ((PagingFilter)filter).getDelegateFilter();
            }
            if (this.shouldCreateUnverifiedRowFilter(delegateFilter)) {
                UnverifiedRowFilter unverifiedRowFilter = new UnverifiedRowFilter(delegateFilter, this.emptyCF, this.emptyCQ);
                if (filter instanceof PagingFilter) {
                    ((PagingFilter)filter).setDelegateFilter((Filter)unverifiedRowFilter);
                } else {
                    this.scan.setFilter((Filter)unverifiedRowFilter);
                }
                this.scanner.close();
                this.scanner = ((DelegateRegionScanner)this.delegate).getNewRegionScanner(this.scan);
            }
        }

        private boolean shouldCreateUnverifiedRowFilter(Filter delegateFilter) {
            if (delegateFilter == null) {
                return false;
            }
            Filter wrappedFilter = delegateFilter;
            if (delegateFilter instanceof FilterList) {
                List filters = ((FilterList)delegateFilter).getFilters();
                wrappedFilter = (Filter)filters.get(0);
            }
            return !(wrappedFilter instanceof FirstKeyOnlyFilter) && !(wrappedFilter instanceof EmptyColumnOnlyFilter);
        }

        public boolean next(List<Cell> result, boolean raw, ScannerContext scannerContext) throws IOException {
            try {
                if (!this.initialized) {
                    this.init();
                    this.initialized = true;
                }
                long startTime = EnvironmentEdgeManager.currentTimeMillis();
                do {
                    if (raw) {
                        this.hasMore = scannerContext == null ? this.scanner.nextRaw(result) : this.scanner.nextRaw(result, scannerContext);
                    } else {
                        boolean bl = this.hasMore = scannerContext == null ? this.scanner.next(result) : this.scanner.next(result, scannerContext);
                    }
                    if (result.isEmpty()) {
                        return this.hasMore;
                    }
                    if (ScanUtil.isDummy(result)) {
                        return true;
                    }
                    Cell cell = result.get(0);
                    if (this.verifyRowAndRepairIfNecessary(result)) break;
                    if (!this.hasMore || EnvironmentEdgeManager.currentTimeMillis() - startTime < this.pageSizeMs) continue;
                    byte[] rowKey = CellUtil.cloneRow((Cell)cell);
                    result.clear();
                    ScanUtil.getDummyResult((byte[])rowKey, result);
                    return true;
                } while (this.hasMore);
                ++this.rowCount;
                if (this.rowCount == this.pageSize) {
                    return false;
                }
                return this.hasMore;
            }
            catch (Throwable t) {
                ClientUtil.throwIOException((String)this.region.getRegionInfo().getRegionNameAsString(), (Throwable)t);
                return false;
            }
        }

        @Override
        public boolean next(List<Cell> result) throws IOException {
            return this.next(result, false, null);
        }

        @Override
        public boolean nextRaw(List<Cell> result) throws IOException {
            return this.next(result, true, null);
        }

        @Override
        public boolean next(List<Cell> result, ScannerContext scannerContext) throws IOException {
            return this.next(result, false, scannerContext);
        }

        @Override
        public boolean nextRaw(List<Cell> result, ScannerContext scannerContext) throws IOException {
            return this.next(result, true, scannerContext);
        }

        @Override
        public void close() throws IOException {
            this.scanner.close();
            if (this.dataHTable != null) {
                this.dataHTable.close();
            }
        }

        @Override
        public RegionInfo getRegionInfo() {
            return this.scanner.getRegionInfo();
        }

        @Override
        public boolean reseek(byte[] row) throws IOException {
            return this.scanner.reseek(row);
        }

        @Override
        public long getMvccReadPoint() {
            return this.scanner.getMvccReadPoint();
        }

        private void repairIndexRows(byte[] indexRowKey, long ts, List<Cell> row) throws IOException {
            if (this.buildIndexScanForDataTable == null) {
                this.buildIndexScanForDataTable = new Scan();
                this.indexScan = new Scan(this.scan);
                this.singleRowIndexScan = new Scan(this.scan);
                PackagePrivateFieldAccessor.setMvccReadPoint((Scan)this.indexScan, (long)-1L);
                PackagePrivateFieldAccessor.setMvccReadPoint((Scan)this.singleRowIndexScan, (long)-1L);
                byte[] dataTableName = this.scan.getAttribute("_PhysicalDataTableName");
                this.dataHTable = ServerUtil.ConnectionFactory.getConnection(ServerUtil.ConnectionType.INDEX_WRITER_CONNECTION, this.env).getTable(TableName.valueOf((byte[])dataTableName));
                this.viewConstants = IndexUtil.deserializeViewConstantsFromScan((Scan)this.scan);
                this.buildIndexScanForDataTable.setAttribute("_UngroupedAgg", PDataType.TRUE_BYTES);
                this.buildIndexScanForDataTable.setAttribute("IdxProtoMD", this.scan.getAttribute("IdxProtoMD"));
                ScanUtil.annotateScanWithMetadataAttributes((Scan)this.scan, (Scan)this.buildIndexScanForDataTable);
                this.buildIndexScanForDataTable.setAttribute("_RebuildIndexes", PDataType.TRUE_BYTES);
                this.buildIndexScanForDataTable.setAttribute("_SKIP_REGION_BOUNDARY_CHECK", Bytes.toBytes((boolean)true));
                this.buildIndexScanForDataTable.setAttribute("_EmptyCQName", this.emptyCQ);
                for (ColumnReference column : this.indexMaintainer.getAllColumnsForDataTable()) {
                    this.buildIndexScanForDataTable.addColumn(column.getFamily(), column.getQualifier());
                }
                this.buildIndexScanForDataTable.addColumn(this.indexMaintainer.getDataEmptyKeyValueCF(), this.indexMaintainer.getEmptyKeyValueQualifierForDataTable());
            }
            byte[] dataRowKey = this.indexMaintainer.buildDataRowKey(new ImmutableBytesWritable(indexRowKey), this.viewConstants);
            this.buildIndexScanForDataTable.withStartRow(dataRowKey, true);
            this.buildIndexScanForDataTable.withStopRow(dataRowKey, true);
            this.buildIndexScanForDataTable.setTimeRange(0L, this.maxTimestamp);
            this.buildIndexScanForDataTable.setAttribute("_IndexRowKey", indexRowKey);
            Result result = null;
            try (ResultScanner resultScanner = this.dataHTable.getScanner(this.buildIndexScanForDataTable);){
                result = resultScanner.next();
            }
            catch (Throwable t) {
                ClientUtil.throwIOException((String)this.dataHTable.getName().toString(), (Throwable)t);
            }
            byte[] value = result.value();
            long code = PLong.INSTANCE.getCodec().decodeLong(new ImmutableBytesWritable(value), SortOrder.getDefault());
            if (code == (long)RebuildReturnCode.NO_DATA_ROW.getValue()) {
                if (this.indexMaintainer.isAgedEnough(ts, this.ageThreshold).booleanValue()) {
                    this.region.delete(this.indexMaintainer.createDelete(indexRowKey, ts, false));
                }
                row.clear();
                return;
            }
            this.scanner.close();
            if (code == (long)RebuildReturnCode.NO_INDEX_ROW.getValue()) {
                if (this.indexMaintainer.isAgedEnough(ts, this.ageThreshold).booleanValue()) {
                    this.region.delete(this.indexMaintainer.createDelete(indexRowKey, ts, false));
                }
                this.indexScan.withStartRow(indexRowKey, false);
                this.scanner = ((DelegateRegionScanner)this.delegate).getNewRegionScanner(this.indexScan);
                this.hasMore = true;
                row.clear();
                return;
            }
            this.indexScan.withStartRow(indexRowKey, true);
            this.scanner = ((DelegateRegionScanner)this.delegate).getNewRegionScanner(this.indexScan);
            this.hasMore = this.scanner.next(row);
            if (row.isEmpty()) {
                return;
            }
            if (ScanUtil.isDummy(row)) {
                return;
            }
            if (Bytes.compareTo((byte[])row.get(0).getRowArray(), (int)row.get(0).getRowOffset(), (int)row.get(0).getRowLength(), (byte[])indexRowKey, (int)0, (int)indexRowKey.length) != 0) {
                if (this.verifyRowAndRemoveEmptyColumn(row)) {
                    return;
                }
                this.scanner.close();
                this.indexScan.withStartRow(CellUtil.cloneRow((Cell)row.get(0)), true);
                this.scanner = ((DelegateRegionScanner)this.delegate).getNewRegionScanner(this.indexScan);
                this.hasMore = true;
                row.clear();
                return;
            }
            if (this.verifyRowAndRemoveEmptyColumn(row)) {
                return;
            }
            do {
                if (this.indexMaintainer.isAgedEnough(ts, this.ageThreshold).booleanValue()) {
                    this.region.delete(this.indexMaintainer.createDelete(indexRowKey, ts, true));
                }
                this.singleRowIndexScan.withStartRow(indexRowKey, true);
                this.singleRowIndexScan.withStopRow(indexRowKey, true);
                this.singleRowIndexScan.setTimeRange(this.minTimestamp, ts);
                RegionScanner singleRowScanner = ((DelegateRegionScanner)this.delegate).getNewRegionScanner(this.singleRowIndexScan);
                row.clear();
                singleRowScanner.next(row);
                singleRowScanner.close();
                if (row.isEmpty()) {
                    return;
                }
                if (ScanUtil.isDummy(row)) {
                    return;
                }
                if (this.verifyRowAndRemoveEmptyColumn(row)) {
                    return;
                }
                ts = this.getMaxTimestamp(row);
            } while (Bytes.compareTo((byte[])row.get(0).getRowArray(), (int)row.get(0).getRowOffset(), (int)row.get(0).getRowLength(), (byte[])indexRowKey, (int)0, (int)indexRowKey.length) == 0);
            Cell cell = row.get(0);
            byte[] rowKey = CellUtil.cloneRow((Cell)cell);
            throw new DoNotRetryIOException("The scan returned a row with row key (" + Bytes.toStringBinary((byte[])rowKey) + ") different than indexRowKey (" + Bytes.toStringBinary((byte[])indexRowKey) + ") for table " + this.region.getRegionInfo().getTable().getNameAsString());
        }

        private boolean isEmptyColumn(Cell cell) {
            return Bytes.compareTo((byte[])cell.getFamilyArray(), (int)cell.getFamilyOffset(), (int)cell.getFamilyLength(), (byte[])this.emptyCF, (int)0, (int)this.emptyCF.length) == 0 && Bytes.compareTo((byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength(), (byte[])this.emptyCQ, (int)0, (int)this.emptyCQ.length) == 0;
        }

        private boolean verifyRowAndRemoveEmptyColumn(List<Cell> cellList) throws IOException {
            if (this.indexMaintainer.isUncovered()) {
                return true;
            }
            long cellListSize = cellList.size();
            Cell cell2 = null;
            if (cellListSize == 0L) {
                return true;
            }
            for (Cell cell2 : cellList) {
                if (!this.isEmptyColumn(cell2)) continue;
                return !(this.indexMaintainer instanceof TransformMaintainer ? Bytes.compareTo((byte[])cell2.getValueArray(), (int)cell2.getValueOffset(), (int)cell2.getValueLength(), (byte[])QueryConstants.UNVERIFIED_BYTES, (int)0, (int)QueryConstants.UNVERIFIED_BYTES.length) == 0 : Bytes.compareTo((byte[])cell2.getValueArray(), (int)cell2.getValueOffset(), (int)cell2.getValueLength(), (byte[])QueryConstants.VERIFIED_BYTES, (int)0, (int)QueryConstants.VERIFIED_BYTES.length) != 0);
            }
            return false;
        }

        private long getMaxTimestamp(List<Cell> cellList) {
            long maxTs = 0L;
            long ts = 0L;
            for (Cell cell : cellList) {
                ts = cell.getTimestamp();
                if (ts <= maxTs) continue;
                maxTs = ts;
            }
            return maxTs;
        }

        private boolean verifyRowAndRepairIfNecessary(List<Cell> cellList) throws IOException {
            this.metricsSource.incrementIndexInspections(this.indexName);
            Cell cell = cellList.get(0);
            if (this.verifyRowAndRemoveEmptyColumn(cellList)) {
                return true;
            }
            long repairStart = EnvironmentEdgeManager.currentTimeMillis();
            byte[] rowKey = CellUtil.cloneRow((Cell)cell);
            long ts = cellList.get(0).getTimestamp();
            cellList.clear();
            try {
                this.repairIndexRows(rowKey, ts, cellList);
                long repairTime = EnvironmentEdgeManager.currentTimeMillis() - repairStart;
                this.metricsSource.incrementIndexRepairs(this.indexName);
                this.metricsSource.updateUnverifiedIndexRowAge(this.indexName, EnvironmentEdgeManager.currentTimeMillis() - ts);
                this.metricsSource.updateIndexRepairTime(this.indexName, EnvironmentEdgeManager.currentTimeMillis() - repairStart);
                if (this.shouldLog()) {
                    LOG.info("Index row repair on region {} row ts {} took {} ms.", new Object[]{this.env.getRegionInfo().getRegionNameAsString(), ts, repairTime});
                }
            }
            catch (IOException e) {
                long repairTime = EnvironmentEdgeManager.currentTimeMillis() - repairStart;
                this.metricsSource.incrementIndexRepairFailures(this.indexName);
                this.metricsSource.updateIndexRepairFailureTime(this.indexName, EnvironmentEdgeManager.currentTimeMillis() - repairStart);
                if (this.shouldLog()) {
                    LOG.warn("Index row repair failure on region {} row ts {} took {} ms.", new Object[]{this.env.getRegionInfo().getRegionNameAsString(), ts, repairTime});
                }
                throw e;
            }
            return !cellList.isEmpty();
        }

        private boolean shouldLog() {
            if (this.loggingPercent == 0.0) {
                return false;
            }
            return this.random.nextDouble() <= this.loggingPercent / 100.0;
        }
    }

    public static enum RebuildReturnCode {
        NO_DATA_ROW(0),
        NO_INDEX_ROW(1),
        INDEX_ROW_EXISTS(2);

        private int value;

        private RebuildReturnCode(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

