/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.write;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.coprocessorclient.MetaDataProtocol;
import org.apache.phoenix.hbase.index.exception.MultiIndexWriteFailureException;
import org.apache.phoenix.hbase.index.exception.SingleIndexWriteFailureException;
import org.apache.phoenix.hbase.index.parallel.EarlyExitFailure;
import org.apache.phoenix.hbase.index.parallel.Task;
import org.apache.phoenix.hbase.index.parallel.TaskBatch;
import org.apache.phoenix.hbase.index.parallel.TaskRunner;
import org.apache.phoenix.hbase.index.parallel.ThreadPoolBuilder;
import org.apache.phoenix.hbase.index.parallel.ThreadPoolManager;
import org.apache.phoenix.hbase.index.parallel.WaitForCompletionTaskRunner;
import org.apache.phoenix.hbase.index.table.HTableFactory;
import org.apache.phoenix.hbase.index.table.HTableInterfaceReference;
import org.apache.phoenix.hbase.index.util.KeyValueBuilder;
import org.apache.phoenix.hbase.index.write.IndexCommitter;
import org.apache.phoenix.hbase.index.write.IndexWriter;
import org.apache.phoenix.hbase.index.write.IndexWriterUtils;
import org.apache.phoenix.index.PhoenixIndexFailurePolicy;
import org.apache.phoenix.thirdparty.com.google.common.collect.Multimap;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.ServerIndexUtil;
import org.apache.phoenix.util.ServerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackingParallelWriterIndexCommitter
implements IndexCommitter {
    private static final Logger LOGGER = LoggerFactory.getLogger(TrackingParallelWriterIndexCommitter.class);
    public static final String NUM_CONCURRENT_INDEX_WRITER_THREADS_CONF_KEY = "phoenix.index.writer.threads.max";
    private static final int DEFAULT_CONCURRENT_INDEX_WRITER_THREADS = 10;
    private static final String INDEX_WRITER_KEEP_ALIVE_TIME_CONF_KEY = "phoenix.index.writer.threads.keepalivetime";
    private TaskRunner pool;
    private HTableFactory retryingFactory;
    private HTableFactory noRetriesFactory;
    private Stoppable stopped;
    private RegionCoprocessorEnvironment env;
    private KeyValueBuilder kvBuilder;
    protected boolean disableIndexOnFailure = false;

    public TrackingParallelWriterIndexCommitter(String hbaseVersion) {
        this.kvBuilder = KeyValueBuilder.get((String)hbaseVersion);
    }

    public TrackingParallelWriterIndexCommitter() {
    }

    @Override
    public void setup(IndexWriter parent, RegionCoprocessorEnvironment env, String name, boolean disableIndexOnFailure) {
        this.env = env;
        this.disableIndexOnFailure = disableIndexOnFailure;
        Configuration conf = env.getConfiguration();
        this.setup(IndexWriterUtils.getDefaultDelegateHTableFactory(env), ThreadPoolManager.getExecutor(new ThreadPoolBuilder(name, conf).setMaxThread(NUM_CONCURRENT_INDEX_WRITER_THREADS_CONF_KEY, 10).setCoreTimeout(INDEX_WRITER_KEEP_ALIVE_TIME_CONF_KEY), env), parent, env);
        this.kvBuilder = KeyValueBuilder.get((String)env.getHBaseVersion());
    }

    void setup(HTableFactory factory, ExecutorService pool, Stoppable stop, RegionCoprocessorEnvironment env) {
        this.pool = new WaitForCompletionTaskRunner(pool);
        this.retryingFactory = factory;
        this.noRetriesFactory = IndexWriterUtils.getNoRetriesHTableFactory(env);
        this.stopped = stop;
        this.env = env;
    }

    @Override
    public void write(Multimap<HTableInterfaceReference, Mutation> toWrite, final boolean allowLocalUpdates, final int clientVersion) throws IOException {
        Set entries = toWrite.asMap().entrySet();
        TaskBatch tasks = new TaskBatch(entries.size());
        ArrayList<HTableInterfaceReference> tables = new ArrayList<HTableInterfaceReference>(entries.size());
        for (Map.Entry entry : entries) {
            final List mutations = this.kvBuilder.cloneIfNecessary((List)entry.getValue());
            final HTableInterfaceReference tableReference = (HTableInterfaceReference)entry.getKey();
            final RegionCoprocessorEnvironment env = this.env;
            if (env != null && !allowLocalUpdates && tableReference.getTableName().equals(env.getRegion().getTableDescriptor().getTableName().getNameAsString())) continue;
            tables.add(tableReference);
            tasks.add((Task)new Task<Boolean>(){

                public Boolean call() throws Exception {
                    try {
                        block19: {
                            this.throwFailureIfDone();
                            if (allowLocalUpdates && env != null && tableReference.getTableName().equals(env.getRegion().getTableDescriptor().getTableName().getNameAsString())) {
                                try {
                                    this.throwFailureIfDone();
                                    ServerIndexUtil.writeLocalUpdates(env.getRegion(), mutations, true);
                                    return Boolean.TRUE;
                                }
                                catch (IOException ignord) {
                                    if (!LOGGER.isTraceEnabled()) break block19;
                                    LOGGER.trace("indexRegion.batchMutate failed and fall back to HTable.batch(). Got error=" + ignord);
                                }
                            }
                        }
                        if (LOGGER.isTraceEnabled()) {
                            LOGGER.trace("Writing index update:" + mutations + " to table: " + tableReference);
                        }
                        HTableFactory factory = TrackingParallelWriterIndexCommitter.this.disableIndexOnFailure ? (clientVersion < MetaDataProtocol.MIN_CLIENT_RETRY_INDEX_WRITES ? TrackingParallelWriterIndexCommitter.this.retryingFactory : TrackingParallelWriterIndexCommitter.this.noRetriesFactory) : TrackingParallelWriterIndexCommitter.this.retryingFactory;
                        try (Table table = factory.getTable(tableReference.get());){
                            this.throwFailureIfDone();
                            table.batch(mutations, null);
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw e;
                    }
                    catch (Exception e) {
                        throw e;
                    }
                    return Boolean.TRUE;
                }

                private void throwFailureIfDone() throws SingleIndexWriteFailureException {
                    if (TrackingParallelWriterIndexCommitter.this.stopped.isStopped() || env != null && (env.getConnection() == null || env.getConnection().isClosed() || env.getConnection().isAborted()) || Thread.currentThread().isInterrupted()) {
                        throw new SingleIndexWriteFailureException("Pool closed, not attempting to write to the index!", null);
                    }
                }
            });
        }
        Pair resultsAndFutures = null;
        try {
            LOGGER.debug("Waiting on index update tasks to complete...");
            resultsAndFutures = this.pool.submitUninterruptible(tasks);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Should not fail on the results while using a WaitForCompletionTaskRunner", e);
        }
        catch (EarlyExitFailure e) {
            throw new RuntimeException("Stopped while waiting for batch, quiting!", e);
        }
        ArrayList<HTableInterfaceReference> failedTables = new ArrayList<HTableInterfaceReference>();
        ArrayList<Future<Boolean>> failedFutures = new ArrayList<Future<Boolean>>();
        int index = 0;
        for (Boolean result : (List)resultsAndFutures.getFirst()) {
            if (result == null) {
                failedTables.add((HTableInterfaceReference)tables.get(index));
                failedFutures.add((Future<Boolean>)((List)resultsAndFutures.getSecond()).get(index));
            }
            ++index;
        }
        if (failedTables.size() > 0) {
            Throwable cause = this.logFailedTasksAndGetCause(failedFutures, failedTables);
            MultiIndexWriteFailureException exception = null;
            if (this.disableIndexOnFailure) {
                exception = new MultiIndexWriteFailureException(Collections.unmodifiableList(failedTables), this.disableIndexOnFailure && PhoenixIndexFailurePolicy.getDisableIndexOnFailure(this.env));
                throw exception;
            }
            exception = new MultiIndexWriteFailureException(Collections.unmodifiableList(failedTables), false, cause);
            throw ServerUtil.wrapInDoNotRetryIOException("At least one index write failed after retries", exception, EnvironmentEdgeManager.currentTimeMillis());
        }
    }

    private Throwable logFailedTasksAndGetCause(List<Future<Boolean>> failedFutures, List<HTableInterfaceReference> failedTables) {
        int i = 0;
        Exception t = null;
        for (Future<Boolean> future : failedFutures) {
            block3: {
                try {
                    future.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    LOGGER.warn("Index Write failed for table " + failedTables.get(i), (Throwable)e);
                    if (t != null) break block3;
                    t = e;
                }
            }
            ++i;
        }
        return t;
    }

    public void stop(String why) {
        LOGGER.info("Shutting down " + this.getClass().getSimpleName());
        this.pool.stop(why);
        this.retryingFactory.shutdown();
        this.noRetriesFactory.shutdown();
    }

    public boolean isStopped() {
        return this.stopped.isStopped();
    }

    static {
        Configuration.addDeprecation((String)"index.writer.threads.max", (String)NUM_CONCURRENT_INDEX_WRITER_THREADS_CONF_KEY);
        Configuration.addDeprecation((String)"index.writer.threads.keepalivetime", (String)INDEX_WRITER_KEEP_ALIVE_TIME_CONF_KEY);
    }
}

