/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.write;

import java.util.concurrent.ExecutionException;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.phoenix.hbase.index.exception.SingleIndexWriteFailureException;
import org.apache.phoenix.hbase.index.parallel.EarlyExitFailure;
import org.apache.phoenix.hbase.index.table.HTableInterfaceReference;
import org.apache.phoenix.hbase.index.write.AbstractParallelWriterIndexCommitter;
import org.apache.phoenix.thirdparty.com.google.common.collect.Multimap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelWriterIndexCommitter
extends AbstractParallelWriterIndexCommitter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParallelWriterIndexCommitter.class);

    public ParallelWriterIndexCommitter() {
    }

    public ParallelWriterIndexCommitter(String hbaseVersion) {
        super(hbaseVersion);
    }

    @Override
    public void write(Multimap<HTableInterfaceReference, Mutation> toWrite, boolean allowLocalUpdates, int clientVersion) throws SingleIndexWriteFailureException {
        super.write(toWrite, allowLocalUpdates, clientVersion);
        try {
            this.pool.submitUninterruptible(this.tasks);
        }
        catch (EarlyExitFailure e) {
            this.propagateFailure(e);
        }
        catch (ExecutionException e) {
            LOGGER.error("Found a failed index update!");
            this.propagateFailure(e.getCause());
        }
    }
}

