/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.covered;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.hbase.index.builder.BaseIndexBuilder;
import org.apache.phoenix.hbase.index.covered.Batch;
import org.apache.phoenix.hbase.index.covered.IndexMetaData;
import org.apache.phoenix.hbase.index.covered.IndexUpdate;
import org.apache.phoenix.hbase.index.covered.LocalTableState;
import org.apache.phoenix.hbase.index.covered.TableState;
import org.apache.phoenix.hbase.index.covered.data.LocalHBaseState;
import org.apache.phoenix.hbase.index.covered.update.ColumnTracker;
import org.apache.phoenix.hbase.index.covered.update.IndexUpdateManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonTxIndexBuilder
extends BaseIndexBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(NonTxIndexBuilder.class);

    @Override
    public void setup(RegionCoprocessorEnvironment env) throws IOException {
        super.setup(env);
    }

    @Override
    public Collection<Pair<Mutation, byte[]>> getIndexUpdate(Mutation mutation, IndexMetaData indexMetaData, LocalHBaseState localHBaseState) throws IOException {
        LocalTableState state2 = new LocalTableState(localHBaseState, mutation);
        IndexUpdateManager manager = new IndexUpdateManager(indexMetaData);
        this.batchMutationAndAddUpdates(manager, state2, mutation, indexMetaData);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Found index updates for Mutation: " + mutation + "\n" + manager);
        }
        return manager.toMap();
    }

    private void batchMutationAndAddUpdates(IndexUpdateManager manager, LocalTableState state2, Mutation m, IndexMetaData indexMetaData) throws IOException {
        long ts = ((Cell)((List)m.getFamilyCellMap().values().iterator().next()).iterator().next()).getTimestamp();
        Batch batch = new Batch(ts);
        for (List family : m.getFamilyCellMap().values()) {
            for (Cell kv : family) {
                batch.add(kv);
                if (ts == kv.getTimestamp()) continue;
                throw new IllegalStateException("Time stamps must match for all cells in a batch");
            }
        }
        this.addMutationsForBatch(manager, batch, state2, indexMetaData);
    }

    private boolean addMutationsForBatch(IndexUpdateManager updateMap, Batch batch, LocalTableState state2, IndexMetaData indexMetaData) throws IOException {
        long batchTs = batch.getTimestamp();
        state2.setPendingUpdates(batch.getKvs());
        this.addCleanupForCurrentBatch(updateMap, batchTs, state2, indexMetaData);
        state2.applyPendingUpdates();
        this.addUpdateForGivenTimestamp(batchTs, state2, updateMap, indexMetaData);
        return false;
    }

    private long addUpdateForGivenTimestamp(long ts, LocalTableState state2, IndexUpdateManager updateMap, IndexMetaData indexMetaData) throws IOException {
        state2.setCurrentTimestamp(ts);
        ts = this.addCurrentStateMutationsForBatch(updateMap, state2, indexMetaData);
        return ts;
    }

    private void addCleanupForCurrentBatch(IndexUpdateManager updateMap, long batchTs, LocalTableState state2, IndexMetaData indexMetaData) throws IOException {
        state2.setCurrentTimestamp(batchTs);
        this.addDeleteUpdatesToMap(updateMap, state2, batchTs, indexMetaData);
        state2.resetTrackedColumns();
    }

    private long addCurrentStateMutationsForBatch(IndexUpdateManager updateMap, LocalTableState state2, IndexMetaData indexMetaData) throws IOException {
        Iterable upserts = this.codec.getIndexUpserts((TableState)state2, indexMetaData, this.env.getRegionInfo().getStartKey(), this.env.getRegionInfo().getEndKey(), false);
        state2.resetTrackedColumns();
        long minTs = Long.MAX_VALUE;
        for (IndexUpdate update : upserts) {
            ColumnTracker tracker = update.getIndexedColumns();
            long trackerTs = tracker.getTS();
            if (trackerTs < minTs) {
                minTs = tracker.getTS();
            }
            if (tracker.hasNewerTimestamps() || !update.isValid()) continue;
            byte[] table = update.getTableName();
            Mutation mutation = update.getUpdate();
            updateMap.addIndexUpdate(table, mutation);
        }
        return minTs;
    }

    protected void addDeleteUpdatesToMap(IndexUpdateManager updateMap, LocalTableState state2, long ts, IndexMetaData indexMetaData) throws IOException {
        Iterable cleanup = this.codec.getIndexDeletes((TableState)state2, indexMetaData, this.env.getRegionInfo().getStartKey(), this.env.getRegionInfo().getEndKey());
        if (cleanup != null) {
            for (IndexUpdate d : cleanup) {
                ColumnTracker tracker;
                if (!d.isValid() || (tracker = d.getIndexedColumns()).hasNewerTimestamps()) continue;
                Delete remove = (Delete)d.getUpdate();
                remove.setTimestamp(ts);
                updateMap.addIndexUpdate(d.getTableName(), (Mutation)remove);
            }
        }
    }

    @Override
    public Collection<Pair<Mutation, byte[]>> getIndexUpdateForFilteredRows(Collection<Cell> filtered, IndexMetaData indexMetaData) throws IOException {
        return null;
    }
}

