/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.covered;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.hbase.index.ValueGetter;
import org.apache.phoenix.hbase.index.covered.CoveredColumns;
import org.apache.phoenix.hbase.index.covered.IndexMetaData;
import org.apache.phoenix.hbase.index.covered.IndexUpdate;
import org.apache.phoenix.hbase.index.covered.KeyValueStore;
import org.apache.phoenix.hbase.index.covered.TableState;
import org.apache.phoenix.hbase.index.covered.data.IndexMemStore;
import org.apache.phoenix.hbase.index.covered.data.LocalHBaseState;
import org.apache.phoenix.hbase.index.covered.update.ColumnReference;
import org.apache.phoenix.hbase.index.covered.update.ColumnTracker;
import org.apache.phoenix.hbase.index.covered.update.IndexedColumnGroup;
import org.apache.phoenix.hbase.index.scanner.ScannerBuilder;
import org.apache.phoenix.hbase.index.util.IndexManagementUtil;

public class LocalTableState
implements TableState {
    private long ts;
    private KeyValueStore memstore;
    private LocalHBaseState table;
    private Mutation update;
    private Set<ColumnTracker> trackedColumns = new HashSet<ColumnTracker>();
    private ScannerBuilder scannerBuilder;
    private List<Cell> kvs = new ArrayList<Cell>();
    private List<? extends IndexedColumnGroup> hints;
    private CoveredColumns columnSet;

    public LocalTableState(LocalHBaseState table, Mutation update) {
        this.table = table;
        this.update = update;
        this.memstore = new IndexMemStore();
        this.scannerBuilder = new ScannerBuilder(this.memstore, update);
        this.columnSet = new CoveredColumns();
    }

    public void addPendingUpdates(Cell ... kvs) {
        if (kvs == null) {
            return;
        }
        this.addPendingUpdates(Arrays.asList(kvs));
    }

    public void addPendingUpdates(List<Cell> kvs) {
        if (kvs == null) {
            return;
        }
        this.setPendingUpdates(kvs);
        this.addUpdate(kvs);
    }

    private void addUpdate(List<Cell> list) {
        this.addUpdate(list, true);
    }

    private void addUpdate(List<Cell> list, boolean overwrite) {
        if (list == null) {
            return;
        }
        for (Cell kv : list) {
            this.memstore.add(kv, overwrite);
        }
    }

    private void addUpdateCells(List<Cell> list, boolean overwrite) {
        if (list == null) {
            return;
        }
        for (Cell c : list) {
            this.memstore.add(c, overwrite);
        }
    }

    public long getCurrentTimestamp() {
        return this.ts;
    }

    public void setCurrentTimestamp(long timestamp) {
        this.ts = timestamp;
    }

    public void resetTrackedColumns() {
        this.trackedColumns.clear();
    }

    public Set<ColumnTracker> getTrackedColumns() {
        return this.trackedColumns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<ScannerBuilder.CoveredDeleteScanner, IndexUpdate> getIndexedColumnsTableState(Collection<? extends ColumnReference> indexedColumns, boolean ignoreNewerMutations, boolean isStateForDeletes, IndexMetaData indexMetaData) throws IOException {
        Collection<? extends ColumnReference> toCover = this.columnSet.findNonCoveredColumns(indexedColumns);
        for (ColumnReference columnReference : toCover) {
            this.columnSet.addColumn(columnReference);
        }
        boolean requiresPriorRowState = indexMetaData.requiresPriorRowState(this.update);
        if (!toCover.isEmpty() && requiresPriorRowState) {
            this.addUpdateCells(this.table.getCurrentRowState(this.update, toCover, ignoreNewerMutations), false);
        }
        ColumnTracker columnTracker = new ColumnTracker(indexedColumns);
        Set<ColumnTracker> set = this.trackedColumns;
        synchronized (set) {
            if (!this.trackedColumns.contains(columnTracker)) {
                this.trackedColumns.add(columnTracker);
            }
        }
        ScannerBuilder.CoveredDeleteScanner scanner = this.scannerBuilder.buildIndexedColumnScanner(indexedColumns, columnTracker, this.ts, isStateForDeletes && (requiresPriorRowState || LocalTableState.insertingData(this.update)));
        return new Pair((Object)scanner, (Object)new IndexUpdate(columnTracker));
    }

    private static boolean insertingData(Mutation m) {
        for (Collection cells : m.getFamilyCellMap().values()) {
            for (Cell cell : cells) {
                if (cell.getType() == Cell.Type.Put) continue;
                return false;
            }
        }
        return true;
    }

    public byte[] getCurrentRowKey() {
        return this.update.getRow();
    }

    public void setHints(List<? extends IndexedColumnGroup> hints) {
        this.hints = hints;
    }

    public List<? extends IndexedColumnGroup> getIndexColumnHints() {
        return this.hints;
    }

    public Collection<Cell> getPendingUpdate() {
        return this.kvs;
    }

    public void setPendingUpdates(Collection<Cell> update) {
        this.kvs.clear();
        this.kvs.addAll(update);
    }

    public void applyPendingUpdates() {
        this.addUpdate(this.kvs);
    }

    public void rollback(Collection<KeyValue> values) {
        for (KeyValue kv : values) {
            this.memstore.rollback((Cell)kv);
        }
    }

    public Pair<ValueGetter, IndexUpdate> getIndexUpdateState(Collection<? extends ColumnReference> indexedColumns, boolean ignoreNewerMutations, boolean isStateForDeletes, IndexMetaData indexMetaData) throws IOException {
        Pair<ScannerBuilder.CoveredDeleteScanner, IndexUpdate> pair = this.getIndexedColumnsTableState(indexedColumns, ignoreNewerMutations, isStateForDeletes, indexMetaData);
        ValueGetter valueGetter = IndexManagementUtil.createGetterFromScanner((ScannerBuilder.CoveredDeleteScanner)((ScannerBuilder.CoveredDeleteScanner)pair.getFirst()), (byte[])this.getCurrentRowKey());
        return new Pair((Object)valueGetter, pair.getSecond());
    }
}

