/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.hbase.exceptions.TimeoutIOException;
import org.apache.htrace.Trace;
import org.apache.htrace.TraceScope;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(LockManager.class);
    private final ConcurrentHashMap<ImmutableBytesPtr, RowLockImpl> lockedRows = new ConcurrentHashMap();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RowLock lockRow(ImmutableBytesPtr rowKey, long waitDurationMs) throws IOException {
        RowLockImpl rowLock = new RowLockImpl(rowKey);
        TraceScope traceScope = null;
        if (Trace.isTracing()) {
            traceScope = Trace.startSpan((String)"LockManager.lockRow");
            traceScope.getSpan().addTimelineAnnotation("Getting a row lock");
        }
        boolean success = false;
        try {
            while (true) {
                RowLockImpl existingRowLock;
                if ((existingRowLock = this.lockedRows.putIfAbsent(rowKey, rowLock)) == null) {
                    success = true;
                    RowLockImpl rowLockImpl = rowLock;
                    return rowLockImpl;
                }
                long startTime = EnvironmentEdgeManager.currentTimeMillis();
                RowLockImpl usableRowLock = existingRowLock.lock(waitDurationMs);
                if (usableRowLock != null) {
                    success = true;
                    RowLockImpl rowLockImpl = usableRowLock;
                    return rowLockImpl;
                }
                long now = EnvironmentEdgeManager.currentTimeMillis();
                long timePassed = now - startTime;
                if (timePassed > waitDurationMs) {
                    throw new TimeoutIOException("Timed out waiting for lock for row: " + rowKey);
                }
                waitDurationMs -= timePassed;
                continue;
                break;
            }
        }
        catch (InterruptedException ie) {
            LOGGER.warn("Thread interrupted waiting for lock on row: " + rowKey);
            InterruptedIOException iie = new InterruptedIOException();
            iie.initCause(ie);
            Thread.currentThread().interrupt();
            throw iie;
        }
        finally {
            if (traceScope != null) {
                if (!success) {
                    traceScope.getSpan().addTimelineAnnotation("Failed to get row lock");
                }
                traceScope.close();
            }
        }
    }

    public RowLock lockRow(byte[] row, long waitDurationMs) throws IOException {
        ImmutableBytesPtr rowKey = new ImmutableBytesPtr(row);
        return this.lockRow(rowKey, waitDurationMs);
    }

    public static interface RowLock {
        public void release();

        public ImmutableBytesPtr getRowKey();
    }

    public class RowLockImpl
    implements RowLock {
        private final ImmutableBytesPtr rowKey;
        private int count = 1;
        private boolean usable = true;
        private final ReentrantLock lock = new ReentrantLock(true);
        private String threadName;

        private RowLockImpl(ImmutableBytesPtr rowKey) {
            this.rowKey = rowKey;
            this.lock.lock();
            this.threadName = Thread.currentThread().getName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        RowLockImpl lock(long waitDuration) throws InterruptedException, TimeoutIOException {
            RowLockImpl rowLockImpl = this;
            synchronized (rowLockImpl) {
                if (!this.usable) {
                    return null;
                }
                ++this.count;
            }
            boolean success = false;
            this.threadName = Thread.currentThread().getName();
            try {
                if (!this.lock.tryLock(waitDuration, TimeUnit.MILLISECONDS)) {
                    throw new TimeoutIOException("Timed out waiting for lock for row: " + this.rowKey);
                }
                success = true;
            }
            finally {
                if (!success) {
                    this.cleanUp();
                    return null;
                }
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cleanUp() {
            RowLockImpl rowLockImpl = this;
            synchronized (rowLockImpl) {
                --this.count;
                if (this.count == 0) {
                    RowLockImpl removed = (RowLockImpl)LockManager.this.lockedRows.remove(this.rowKey);
                    assert (removed == this) : "We should never remove a different lock";
                    this.usable = false;
                } else assert (this.count > 0) : "Reference count should never be less than zero";
            }
        }

        @Override
        public void release() {
            this.lock.unlock();
            this.cleanUp();
        }

        @Override
        public ImmutableBytesPtr getRowKey() {
            return this.rowKey;
        }

        public String toString() {
            return "RowLockImpl{row=" + this.rowKey + ", count=" + this.count + ", threadName=" + this.threadName + ", lock=" + this.lock + ", usable=" + this.usable + "}";
        }
    }
}

