/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.MiniBatchOperationInProgress;
import org.apache.hadoop.hbase.regionserver.OperationStatus;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hadoop.io.WritableUtils;
import org.apache.htrace.Span;
import org.apache.htrace.Trace;
import org.apache.htrace.TraceScope;
import org.apache.phoenix.compile.ScanRanges;
import org.apache.phoenix.coprocessor.DelegateRegionCoprocessorEnvironment;
import org.apache.phoenix.coprocessor.IndexRebuildRegionScanner;
import org.apache.phoenix.coprocessor.generated.PTableProtos;
import org.apache.phoenix.exception.DataExceedsCapacityException;
import org.apache.phoenix.exception.MutationBlockedIOException;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.expression.CaseExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.ExpressionType;
import org.apache.phoenix.expression.KeyValueColumnExpression;
import org.apache.phoenix.expression.visitor.ExpressionVisitor;
import org.apache.phoenix.expression.visitor.StatelessTraverseAllExpressionVisitor;
import org.apache.phoenix.filter.SkipScanFilter;
import org.apache.phoenix.hbase.index.Indexer;
import org.apache.phoenix.hbase.index.LockManager;
import org.apache.phoenix.hbase.index.MultiMutation;
import org.apache.phoenix.hbase.index.ValueGetter;
import org.apache.phoenix.hbase.index.builder.FatalIndexBuildingFailureException;
import org.apache.phoenix.hbase.index.builder.IndexBuildManager;
import org.apache.phoenix.hbase.index.covered.IndexMetaData;
import org.apache.phoenix.hbase.index.covered.update.ColumnReference;
import org.apache.phoenix.hbase.index.metrics.MetricsIndexerSource;
import org.apache.phoenix.hbase.index.metrics.MetricsIndexerSourceFactory;
import org.apache.phoenix.hbase.index.table.HTableInterfaceReference;
import org.apache.phoenix.hbase.index.util.GenericKeyValueBuilder;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.hbase.index.util.IndexManagementUtil;
import org.apache.phoenix.hbase.index.write.IndexWriter;
import org.apache.phoenix.hbase.index.write.LazyParallelWriterIndexCommitter;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.index.PhoenixIndexBuilderHelper;
import org.apache.phoenix.index.PhoenixIndexMetaData;
import org.apache.phoenix.jdbc.HAGroupStoreManager;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.CompiledConditionalTTLExpression;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PRow;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableImpl;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TTLExpressionFactory;
import org.apache.phoenix.schema.transform.TransformMaintainer;
import org.apache.phoenix.schema.tuple.MultiKeyValueTuple;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;
import org.apache.phoenix.thirdparty.com.google.common.collect.ArrayListMultimap;
import org.apache.phoenix.thirdparty.com.google.common.collect.ListMultimap;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.thirdparty.com.google.common.collect.Multimap;
import org.apache.phoenix.thirdparty.com.google.common.collect.Sets;
import org.apache.phoenix.trace.TracingUtils;
import org.apache.phoenix.trace.util.NullSpan;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.ClientUtil;
import org.apache.phoenix.util.EncodedColumnsUtil;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.MutationUtil;
import org.apache.phoenix.util.PhoenixKeyValueUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.ServerIndexUtil;
import org.apache.phoenix.util.ServerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexRegionObserver
implements RegionCoprocessor,
RegionObserver {
    private static final Logger LOG = LoggerFactory.getLogger(IndexRegionObserver.class);
    private static final OperationStatus IGNORE = new OperationStatus(HConstants.OperationStatusCode.SUCCESS);
    private static final OperationStatus NOWRITE = new OperationStatus(HConstants.OperationStatusCode.SUCCESS);
    public static final String PHOENIX_APPEND_METADATA_TO_WAL = "phoenix.append.metadata.to.wal";
    public static final boolean DEFAULT_PHOENIX_APPEND_METADATA_TO_WAL = false;
    private static boolean ignoreIndexRebuildForTesting = false;
    private static boolean failPreIndexUpdatesForTesting = false;
    private static boolean failPostIndexUpdatesForTesting = false;
    private static boolean failDataTableUpdatesForTesting = false;
    private static boolean ignoreWritingDeleteColumnsToIndex = false;
    private ThreadLocal<BatchMutateContext> batchMutateContext = new ThreadLocal();
    public static final String CHECK_VERSION_CONF_KEY = "com.saleforce.hbase.index.checkversion";
    public static final String INDEX_LAZY_POST_BATCH_WRITE = "org.apache.hadoop.hbase.index.lazy.post_batch.write";
    private static final boolean INDEX_LAZY_POST_BATCH_WRITE_DEFAULT = false;
    private static final String INDEXER_INDEX_WRITE_SLOW_THRESHOLD_KEY = "phoenix.indexer.slow.post.batch.mutate.threshold";
    private static final long INDEXER_INDEX_WRITE_SLOW_THRESHOLD_DEFAULT = 3000L;
    private static final String INDEXER_PRE_INCREMENT_SLOW_THRESHOLD_KEY = "phoenix.indexer.slow.pre.increment";
    private static final long INDEXER_PRE_INCREMENT_SLOW_THRESHOLD_DEFAULT = 3000L;
    protected IndexWriter preWriter;
    protected IndexWriter postWriter;
    protected IndexBuildManager builder;
    private LockManager lockManager;
    private Map<ImmutableBytesPtr, PendingRow> pendingRows = new ConcurrentHashMap<ImmutableBytesPtr, PendingRow>();
    private MetricsIndexerSource metricSource;
    private boolean stopped;
    private boolean disabled;
    private long slowIndexPrepareThreshold;
    private long slowPreIncrementThreshold;
    private int rowLockWaitDuration;
    private int concurrentMutationWaitDuration;
    private String dataTableName;
    private boolean shouldWALAppend = false;
    private boolean isNamespaceEnabled = false;
    private boolean useBloomFilter = false;
    private long lastTimestamp = 0L;
    private List<Set<ImmutableBytesPtr>> batchesWithLastTimestamp = new ArrayList<Set<ImmutableBytesPtr>>();
    private static final int DEFAULT_ROWLOCK_WAIT_DURATION = 30000;
    private static final int DEFAULT_CONCURRENT_MUTATION_WAIT_DURATION_IN_MS = 100;
    private byte[] encodedRegionName;

    public static void setIgnoreIndexRebuildForTesting(boolean ignore) {
        ignoreIndexRebuildForTesting = ignore;
    }

    public static void setFailPreIndexUpdatesForTesting(boolean fail) {
        failPreIndexUpdatesForTesting = fail;
    }

    public static void setFailPostIndexUpdatesForTesting(boolean fail) {
        failPostIndexUpdatesForTesting = fail;
    }

    public static void setFailDataTableUpdatesForTesting(boolean fail) {
        failDataTableUpdatesForTesting = fail;
    }

    public static void setIgnoreWritingDeleteColumnsToIndex(boolean ignore) {
        ignoreWritingDeleteColumnsToIndex = ignore;
    }

    public Optional<RegionObserver> getRegionObserver() {
        return Optional.of(this);
    }

    public void start(CoprocessorEnvironment e) throws IOException {
        try {
            String errormsg;
            RegionCoprocessorEnvironment env = (RegionCoprocessorEnvironment)e;
            this.encodedRegionName = env.getRegion().getRegionInfo().getEncodedNameAsBytes();
            String serverName = env.getServerName().getServerName();
            if (env.getConfiguration().getBoolean(CHECK_VERSION_CONF_KEY, true) && (errormsg = Indexer.validateVersion(env.getHBaseVersion(), env.getConfiguration())) != null) {
                throw new FatalIndexBuildingFailureException(errormsg);
            }
            this.builder = new IndexBuildManager(env);
            DelegateRegionCoprocessorEnvironment indexWriterEnv = new DelegateRegionCoprocessorEnvironment(env, ServerUtil.ConnectionType.INDEX_WRITER_CONNECTION);
            this.preWriter = new IndexWriter(indexWriterEnv, serverName + "-index-preWriter", false);
            this.postWriter = env.getConfiguration().getBoolean(INDEX_LAZY_POST_BATCH_WRITE, false) ? new IndexWriter(indexWriterEnv, new LazyParallelWriterIndexCommitter(), serverName + "-index-postWriter", false) : this.preWriter;
            this.rowLockWaitDuration = env.getConfiguration().getInt("hbase.rowlock.wait.duration", 30000);
            this.lockManager = new LockManager();
            this.concurrentMutationWaitDuration = env.getConfiguration().getInt("phoenix.index.concurrent.wait.duration.ms", 100);
            this.metricSource = MetricsIndexerSourceFactory.getInstance().getIndexerSource();
            this.setSlowThresholds(e.getConfiguration());
            this.dataTableName = env.getRegionInfo().getTable().getNameAsString();
            this.shouldWALAppend = env.getConfiguration().getBoolean(PHOENIX_APPEND_METADATA_TO_WAL, false);
            this.isNamespaceEnabled = SchemaUtil.isNamespaceMappingEnabled((PTableType)PTableType.INDEX, (Configuration)env.getConfiguration());
            TableDescriptor tableDescriptor = env.getRegion().getTableDescriptor();
            BloomType bloomFilterType = tableDescriptor.getColumnFamilies()[0].getBloomFilterType();
            this.useBloomFilter = bloomFilterType == BloomType.ROW;
        }
        catch (NoSuchMethodError ex) {
            this.disabled = true;
            LOG.error("Must be too early a version of HBase. Disabled coprocessor ", (Throwable)ex);
        }
    }

    private void setSlowThresholds(Configuration c) {
        this.slowIndexPrepareThreshold = c.getLong(INDEXER_INDEX_WRITE_SLOW_THRESHOLD_KEY, 3000L);
        this.slowPreIncrementThreshold = c.getLong(INDEXER_PRE_INCREMENT_SLOW_THRESHOLD_KEY, 3000L);
    }

    private String getCallTooSlowMessage(String callName, long duration, long threshold) {
        StringBuilder sb = new StringBuilder(64);
        sb.append("(callTooSlow) ").append(callName).append(" duration=").append(duration);
        sb.append("ms, threshold=").append(threshold).append("ms");
        return sb.toString();
    }

    public void stop(CoprocessorEnvironment e) throws IOException {
        if (this.stopped) {
            return;
        }
        if (this.disabled) {
            return;
        }
        this.stopped = true;
        String msg = "Indexer is being stopped";
        this.builder.stop(msg);
        this.preWriter.stop(msg);
        this.postWriter.stop(msg);
    }

    public Result preIncrementAfterRowLock(ObserverContext<RegionCoprocessorEnvironment> e, Increment inc) throws IOException {
        long start = EnvironmentEdgeManager.currentTimeMillis();
        try {
            List<Mutation> mutations = this.builder.executeAtomicOp(inc);
            if (mutations == null) {
                Result result = null;
                return result;
            }
            e.bypass();
            if (!mutations.isEmpty()) {
                Region region = ((RegionCoprocessorEnvironment)e.getEnvironment()).getRegion();
                region.batchMutate(mutations.toArray(new Mutation[0]));
            }
            Result result = Result.EMPTY_RESULT;
            return result;
        }
        catch (Throwable t) {
            throw ClientUtil.createIOException((String)("Unable to process ON DUPLICATE IGNORE for " + ((RegionCoprocessorEnvironment)e.getEnvironment()).getRegion().getRegionInfo().getTable().getNameAsString() + "(" + Bytes.toStringBinary((byte[])inc.getRow()) + ")"), (Throwable)t);
        }
        finally {
            long duration = EnvironmentEdgeManager.currentTimeMillis() - start;
            if (duration >= this.slowIndexPrepareThreshold) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(this.getCallTooSlowMessage("preIncrementAfterRowLock", duration, this.slowPreIncrementThreshold));
                }
                this.metricSource.incrementSlowDuplicateKeyCheckCalls(this.dataTableName);
            }
            this.metricSource.updateDuplicateKeyCheckTime(this.dataTableName, duration);
        }
    }

    public void preBatchMutate(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
        if (this.disabled) {
            return;
        }
        try {
            Configuration conf = ((RegionCoprocessorEnvironment)c.getEnvironment()).getConfiguration();
            HAGroupStoreManager haGroupStoreManager = HAGroupStoreManager.getInstance((Configuration)conf);
            if (haGroupStoreManager.isMutationBlocked()) {
                throw new MutationBlockedIOException("Blocking Mutation as some CRRs are in ACTIVE_TO_STANDBY state and CLUSTER_ROLE_BASED_MUTATION_BLOCK_ENABLED is true");
            }
            this.preBatchMutateWithExceptions(c, miniBatchOp);
            return;
        }
        catch (Throwable t) {
            IndexManagementUtil.rethrowIndexingException((Throwable)t);
            throw new RuntimeException("Somehow didn't return an index update but also didn't propagate the failure to the client!");
        }
    }

    private void populateRowsToLock(MiniBatchOperationInProgress<Mutation> miniBatchOp, BatchMutateContext context) {
        for (int i = 0; i < miniBatchOp.size(); ++i) {
            Mutation m = (Mutation)miniBatchOp.getOperation(i);
            if (!this.builder.isAtomicOp(m) && !context.returnResult && !this.builder.isEnabled(m) && (!this.builder.hasConditionalTTL(m) || !this.isStrictTTLEnabled(miniBatchOp))) continue;
            ImmutableBytesPtr row = new ImmutableBytesPtr(m.getRow());
            context.rowsToLock.add(row);
        }
    }

    private void addOnDupMutationsToBatch(MiniBatchOperationInProgress<Mutation> miniBatchOp, int index, List<Mutation> mutations) {
        ArrayList deleteMutations = Lists.newArrayListWithExpectedSize((int)mutations.size());
        for (Mutation m : mutations) {
            if (m instanceof Put) {
                Mutation original = (Mutation)miniBatchOp.getOperation(index);
                original.getFamilyCellMap().putAll(m.getFamilyCellMap());
                continue;
            }
            if (!(m instanceof Delete)) continue;
            deleteMutations.add((Delete)m);
        }
        if (!deleteMutations.isEmpty()) {
            miniBatchOp.addOperationsFromCP(index, deleteMutations.toArray(new Mutation[deleteMutations.size()]));
        }
    }

    private void addOnDupMutationsToBatch(MiniBatchOperationInProgress<Mutation> miniBatchOp, BatchMutateContext context) throws IOException {
        for (int i = 0; i < miniBatchOp.size(); ++i) {
            Put currentDataRowState;
            Mutation m = (Mutation)miniBatchOp.getOperation(i);
            if ((this.builder.isAtomicOp(m) || this.builder.returnResult(m)) && m instanceof Put) {
                List<Mutation> mutations = this.generateOnDupMutations(context, (Put)m, miniBatchOp);
                if (!mutations.isEmpty()) {
                    this.addOnDupMutationsToBatch(miniBatchOp, i, mutations);
                    continue;
                }
                byte[] retVal = PInteger.INSTANCE.toBytes((Object)0);
                ArrayList<Cell> cells = new ArrayList<Cell>();
                cells.add(PhoenixKeyValueUtil.newKeyValue((byte[])m.getRow(), (byte[])Bytes.toBytes((String)"_UpsertCF"), (byte[])Bytes.toBytes((String)"_UpsertStatusCQ"), (long)0L, (byte[])retVal, (int)0, (int)retVal.length));
                if (context.returnResult) {
                    context.currColumnCellExprMap.forEach((key, value) -> cells.add((Cell)value.getFirst()));
                    cells.sort((Comparator<Cell>)CellComparator.getInstance());
                }
                Result result = Result.create(cells);
                miniBatchOp.setOperationStatus(i, new OperationStatus(HConstants.OperationStatusCode.SUCCESS, result));
                continue;
            }
            if (!context.returnResult) continue;
            HashMap<ColumnReference, Pair<Cell, Boolean>> currColumnCellExprMap = new HashMap<ColumnReference, Pair<Cell, Boolean>>();
            byte[] rowKey = m.getRow();
            ImmutableBytesPtr rowKeyPtr = new ImmutableBytesPtr(rowKey);
            Pair dataRowState = (Pair)context.dataRowStates.get(rowKeyPtr);
            Put put = currentDataRowState = dataRowState != null ? (Put)dataRowState.getFirst() : null;
            if (currentDataRowState == null) continue;
            IndexRegionObserver.updateCurrColumnCellExpr(currentDataRowState, currColumnCellExprMap);
            context.currColumnCellExprMap = currColumnCellExprMap;
        }
    }

    private void updateMutationsForConditionalTTL(MiniBatchOperationInProgress<Mutation> miniBatchOp, BatchMutateContext context) throws IOException {
        if (!this.isStrictTTLEnabled(miniBatchOp)) {
            return;
        }
        HashMap expiredVersions = Maps.newHashMap();
        HashSet notExpiredVersions = Sets.newHashSet();
        for (int i = 0; i < miniBatchOp.size(); ++i) {
            List<Cell> currentRow;
            Put currentVersion;
            Mutation m = (Mutation)miniBatchOp.getOperation(i);
            if (!this.builder.hasConditionalTTL(m) || IndexUtil.isDeleteFamily((Mutation)m)) continue;
            ImmutableBytesPtr row = new ImmutableBytesPtr(m.getRow());
            Pair dataRowState = (Pair)context.dataRowStates.get(row);
            if (dataRowState == null || (currentVersion = (Put)dataRowState.getFirst()) == null || notExpiredVersions.contains(row)) continue;
            List positions = (List)expiredVersions.get(row);
            if (positions != null) {
                positions.add(i);
                continue;
            }
            byte[] ttl = m.getAttribute("_TTL");
            CompiledConditionalTTLExpression ttlExpr = (CompiledConditionalTTLExpression)TTLExpressionFactory.create((byte[])ttl);
            if (ttlExpr.isExpired(currentRow = IndexRegionObserver.flattenCells((Mutation)currentVersion), false)) {
                positions = Lists.newArrayListWithExpectedSize((int)2);
                positions.add(i);
                expiredVersions.put(row, positions);
                continue;
            }
            notExpiredVersions.add(row);
        }
        for (Map.Entry entry : expiredVersions.entrySet()) {
            ImmutableBytesPtr key = (ImmutableBytesPtr)entry.getKey();
            List positions = (List)entry.getValue();
            Pair dataRowState = (Pair)context.dataRowStates.get(key);
            Put currentVersion = (Put)dataRowState.getFirst();
            ArrayList colsToBeMasked = Lists.newArrayList();
            for (List cells : currentVersion.getFamilyCellMap().values()) {
                for (Cell cell : cells) {
                    boolean masked = true;
                    byte[] family = CellUtil.cloneFamily((Cell)cell);
                    byte[] qualifier = CellUtil.cloneQualifier((Cell)cell);
                    for (Integer pos : positions) {
                        Mutation m = (Mutation)miniBatchOp.getOperation(pos.intValue());
                        if (!m.has(family, qualifier)) continue;
                        masked = false;
                        break;
                    }
                    if (!masked) continue;
                    ColumnReference colRef = new ColumnReference(family, qualifier);
                    colsToBeMasked.add(colRef);
                }
            }
            if (!colsToBeMasked.isEmpty()) {
                Mutation m = (Mutation)miniBatchOp.getOperation(((Integer)positions.get(0)).intValue());
                Delete masked = new Delete(m.getRow());
                for (ColumnReference col : colsToBeMasked) {
                    KeyValue kv = GenericKeyValueBuilder.INSTANCE.buildDeleteColumns((ImmutableBytesWritable)key, (ImmutableBytesWritable)col.getFamilyWritable(), (ImmutableBytesWritable)col.getQualifierWritable(), Long.MAX_VALUE);
                    masked.add((Cell)kv);
                }
                miniBatchOp.addOperationsFromCP(((Integer)positions.get(0)).intValue(), new Mutation[]{masked});
            }
            context.dataRowStates.put(key, null);
        }
    }

    private void lockRows(BatchMutateContext context) throws IOException {
        for (ImmutableBytesPtr rowKey : context.rowsToLock) {
            context.rowLocks.add(this.lockManager.lockRow(rowKey, (long)this.rowLockWaitDuration));
        }
    }

    private void unlockRows(BatchMutateContext context) throws IOException {
        for (LockManager.RowLock rowLock : context.rowLocks) {
            rowLock.release();
        }
        context.rowLocks.clear();
    }

    private Collection<? extends Mutation> groupMutations(MiniBatchOperationInProgress<Mutation> miniBatchOp, BatchMutateContext context) throws IOException {
        context.multiMutationMap = new HashMap();
        for (int i = 0; i < miniBatchOp.size(); ++i) {
            Mutation m = (Mutation)miniBatchOp.getOperation(i);
            if (IndexRegionObserver.isAtomicOperationComplete(miniBatchOp.getOperationStatus(i)) || !this.builder.isEnabled(m)) continue;
            ImmutableBytesPtr row = new ImmutableBytesPtr(m.getRow());
            MultiMutation stored = (MultiMutation)context.multiMutationMap.get(row);
            if (stored == null) {
                stored = new MultiMutation(row);
                context.multiMutationMap.put(row, stored);
            }
            stored.addAll(m);
            Mutation[] mutationsAddedByCP = miniBatchOp.getOperationsFromCoprocessors(i);
            if (mutationsAddedByCP == null) continue;
            for (Mutation addedMutation : mutationsAddedByCP) {
                stored.addAll(addedMutation);
            }
        }
        return context.multiMutationMap.values();
    }

    public static void setTimestamps(MiniBatchOperationInProgress<Mutation> miniBatchOp, IndexBuildManager builder, long ts, boolean isTTLStrict) throws IOException {
        Integer i = 0;
        while (i < miniBatchOp.size()) {
            Mutation m;
            if (!IndexRegionObserver.isAtomicOperationComplete(miniBatchOp.getOperationStatus(i.intValue())) && (builder.isEnabled(m = (Mutation)miniBatchOp.getOperation(i.intValue())) || builder.hasConditionalTTL(m) && isTTLStrict || (builder.isAtomicOp(m) || builder.returnResult(m)) && IndexUtil.getMaxTimestamp((Mutation)m) == Long.MAX_VALUE)) {
                IndexRegionObserver.setTimestampOnMutation(m, ts);
                Mutation[] mutationsAddedByCP = miniBatchOp.getOperationsFromCoprocessors(i.intValue());
                if (mutationsAddedByCP != null) {
                    for (Mutation addedMutation : mutationsAddedByCP) {
                        IndexRegionObserver.setTimestampOnMutation(addedMutation, ts);
                    }
                }
            }
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
    }

    private static void setTimestampOnMutation(Mutation m, long ts) throws IOException {
        for (List cells : m.getFamilyCellMap().values()) {
            for (Cell cell : cells) {
                CellUtil.setTimestamp((Cell)cell, (long)ts);
            }
        }
    }

    private void applyPendingDeleteMutations(MiniBatchOperationInProgress<Mutation> miniBatchOp, BatchMutateContext context) throws IOException {
        for (int i = 0; i < miniBatchOp.size(); ++i) {
            Mutation m;
            if (miniBatchOp.getOperationStatus(i) == IGNORE || !this.builder.isEnabled(m = (Mutation)miniBatchOp.getOperation(i)) || !(m instanceof Delete) || this.applyOnePendingDeleteMutation(context, (Delete)m)) continue;
            miniBatchOp.setOperationStatus(i, NOWRITE);
        }
    }

    private boolean isStrictTTLEnabled(MiniBatchOperationInProgress<Mutation> miniBatchOp) {
        for (int i = 0; i < miniBatchOp.size(); ++i) {
            Mutation m = (Mutation)miniBatchOp.getOperation(i);
            byte[] isStrictTTLBytes = m.getAttribute("_IS_STRICT_TTL");
            if (isStrictTTLBytes == null) continue;
            try {
                return (Boolean)PBoolean.INSTANCE.toObject(isStrictTTLBytes);
            }
            catch (Exception e) {
                break;
            }
        }
        return true;
    }

    private boolean applyOnePendingDeleteMutation(BatchMutateContext context, Delete delete) {
        Put nextDataRowState;
        ImmutableBytesPtr rowKeyPtr = new ImmutableBytesPtr(delete.getRow());
        Pair dataRowState = (Pair)context.dataRowStates.get(rowKeyPtr);
        if (dataRowState == null) {
            dataRowState = new Pair(null, null);
            context.dataRowStates.put(rowKeyPtr, dataRowState);
        }
        if ((nextDataRowState = (Put)dataRowState.getSecond()) == null && dataRowState.getFirst() == null) {
            return false;
        }
        for (List cells : delete.getFamilyCellMap().values()) {
            for (Cell cell : cells) {
                switch (cell.getType()) {
                    case DeleteFamily: 
                    case DeleteFamilyVersion: {
                        nextDataRowState.getFamilyCellMap().remove(CellUtil.cloneFamily((Cell)cell));
                        break;
                    }
                    case DeleteColumn: 
                    case Delete: {
                        IndexRebuildRegionScanner.removeColumn(nextDataRowState, cell);
                    }
                }
            }
        }
        if (nextDataRowState != null && nextDataRowState.getFamilyCellMap().size() == 0) {
            dataRowState.setSecond(null);
        }
        return true;
    }

    private void applyPendingPutMutations(MiniBatchOperationInProgress<Mutation> miniBatchOp, BatchMutateContext context, long now) throws IOException {
        Integer i = 0;
        while (i < miniBatchOp.size()) {
            Mutation m;
            if (!IndexRegionObserver.isAtomicOperationComplete(miniBatchOp.getOperationStatus(i.intValue())) && this.builder.isEnabled(m = (Mutation)miniBatchOp.getOperation(i.intValue())) && m instanceof Put) {
                Put nextDataRowState;
                ImmutableBytesPtr rowKeyPtr = new ImmutableBytesPtr(m.getRow());
                Pair dataRowState = (Pair)context.dataRowStates.get(rowKeyPtr);
                if (dataRowState == null) {
                    dataRowState = new Pair(null, null);
                    context.dataRowStates.put(rowKeyPtr, dataRowState);
                }
                dataRowState.setSecond((Object)((nextDataRowState = (Put)dataRowState.getSecond()) != null ? IndexRebuildRegionScanner.applyNew((Put)m, nextDataRowState) : new Put((Put)m)));
                Mutation[] mutationsAddedByCP = miniBatchOp.getOperationsFromCoprocessors(i.intValue());
                if (mutationsAddedByCP != null) {
                    for (Mutation addedMutation : mutationsAddedByCP) {
                        this.applyOnePendingDeleteMutation(context, (Delete)addedMutation);
                    }
                }
            }
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
    }

    private void prepareDataRowStates(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Mutation> miniBatchOp, BatchMutateContext context, long now) throws IOException {
        if (context.rowsToLock.size() == 0) {
            return;
        }
        this.applyPendingPutMutations(miniBatchOp, context, now);
        this.applyPendingDeleteMutations(miniBatchOp, context);
    }

    private void handleLocalIndexUpdates(TableName table, MiniBatchOperationInProgress<Mutation> miniBatchOp, Collection<? extends Mutation> pendingMutations, PhoenixIndexMetaData indexMetaData) throws Throwable {
        ArrayListMultimap indexUpdates = ArrayListMultimap.create();
        this.builder.getIndexUpdates((ListMultimap<HTableInterfaceReference, Pair<Mutation, byte[]>>)indexUpdates, miniBatchOp, pendingMutations, (IndexMetaData)indexMetaData);
        byte[] tableName = table.getName();
        HTableInterfaceReference hTableInterfaceReference = new HTableInterfaceReference(new ImmutableBytesPtr(tableName));
        List localIndexUpdates = indexUpdates.removeAll((Object)hTableInterfaceReference);
        if (localIndexUpdates == null || localIndexUpdates.isEmpty()) {
            return;
        }
        ArrayList<Object> localUpdates = new ArrayList<Object>();
        for (Pair next : localIndexUpdates) {
            localUpdates.add(next.getFirst());
        }
        if (!localUpdates.isEmpty()) {
            Mutation[] mutationsAddedByCP = miniBatchOp.getOperationsFromCoprocessors(0);
            if (mutationsAddedByCP != null) {
                localUpdates.addAll(Arrays.asList(mutationsAddedByCP));
            }
            miniBatchOp.addOperationsFromCP(0, localUpdates.toArray(new Mutation[localUpdates.size()]));
        }
    }

    private boolean isPartialUncoveredIndexMutation(PhoenixIndexMetaData indexMetaData, MiniBatchOperationInProgress<Mutation> miniBatchOp) {
        int indexedColumnCount = 0;
        for (Object indexMaintainer : indexMetaData.getIndexMaintainers()) {
            indexedColumnCount += indexMaintainer.getIndexedColumns().size();
            if (indexMaintainer.getIndexWhereColumns() == null) continue;
            indexedColumnCount += indexMaintainer.getIndexWhereColumns().size();
        }
        HashSet columns = new HashSet(indexedColumnCount);
        for (IndexMaintainer indexMaintainer : indexMetaData.getIndexMaintainers()) {
            columns.addAll(indexMaintainer.getIndexedColumns());
            if (indexMaintainer.getIndexWhereColumns() == null) continue;
            columns.addAll(indexMaintainer.getIndexWhereColumns());
        }
        for (int i = 0; i < miniBatchOp.size(); ++i) {
            Mutation m;
            if (IndexRegionObserver.isAtomicOperationComplete(miniBatchOp.getOperationStatus(i)) || !this.builder.isEnabled(m = (Mutation)miniBatchOp.getOperation(i))) continue;
            for (ColumnReference column : columns) {
                if (!m.get(column.getFamily(), column.getQualifier()).isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    private void getCurrentRowStates(ObserverContext<RegionCoprocessorEnvironment> c, BatchMutateContext context) throws IOException {
        HashSet<KeyRange> keys = new HashSet<KeyRange>(context.rowsToLock.size());
        for (ImmutableBytesPtr rowKeyPtr : context.rowsToLock) {
            PendingRow pendingRow;
            PendingRow existingPendingRow = this.pendingRows.putIfAbsent(rowKeyPtr, pendingRow = new PendingRow(rowKeyPtr, context));
            if (existingPendingRow == null) {
                keys.add(PVarbinary.INSTANCE.getKeyRange(rowKeyPtr.get(), SortOrder.ASC));
                continue;
            }
            BatchMutateContext lastContext = existingPendingRow.getLastContext();
            if (existingPendingRow.add(context)) {
                BatchMutatePhase phase = lastContext.getCurrentPhase();
                Preconditions.checkArgument((phase != BatchMutatePhase.POST ? 1 : 0) != 0, (Object)"the phase of the last batch cannot be POST");
                if (phase == BatchMutatePhase.PRE) {
                    Put put;
                    if (context.lastConcurrentBatchContext == null) {
                        context.lastConcurrentBatchContext = new HashMap();
                    }
                    context.lastConcurrentBatchContext.put(rowKeyPtr, lastContext);
                    if (context.maxPendingRowCount < existingPendingRow.getCount()) {
                        context.maxPendingRowCount = existingPendingRow.getCount();
                    }
                    if ((put = lastContext.getNextDataRowState(rowKeyPtr)) == null) continue;
                    Put copy = MutationUtil.copyPut((Put)put, (boolean)true);
                    context.dataRowStates.put(rowKeyPtr, new Pair((Object)copy, (Object)new Put(copy)));
                    continue;
                }
                keys.add(PVarbinary.INSTANCE.getKeyRange(rowKeyPtr.get(), SortOrder.ASC));
                continue;
            }
            this.pendingRows.put(rowKeyPtr, pendingRow);
            keys.add(PVarbinary.INSTANCE.getKeyRange(rowKeyPtr.get(), SortOrder.ASC));
        }
        if (keys.isEmpty()) {
            return;
        }
        if (this.useBloomFilter) {
            for (KeyRange key : keys) {
                Scan scan = new Scan();
                scan.withStartRow(key.getLowerRange(), true);
                scan.withStopRow(key.getLowerRange(), true);
                this.readDataTableRows(c, context, scan);
            }
        } else {
            Scan scan = new Scan();
            ScanRanges scanRanges = ScanRanges.createPointLookup(new ArrayList(keys));
            scanRanges.initializeScan(scan);
            SkipScanFilter skipScanFilter = scanRanges.getSkipScanFilter();
            scan.setFilter((Filter)skipScanFilter);
            this.readDataTableRows(c, context, scan);
        }
    }

    private void readDataTableRows(ObserverContext<RegionCoprocessorEnvironment> c, BatchMutateContext context, Scan scan) throws IOException {
        try (RegionScanner scanner = ((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion().getScanner(scan);){
            boolean more = true;
            while (more) {
                ArrayList cells = new ArrayList();
                more = scanner.next(cells);
                if (cells.isEmpty()) continue;
                byte[] rowKey = CellUtil.cloneRow((Cell)((Cell)cells.get(0)));
                Put put = new Put(rowKey);
                for (Cell cell : cells) {
                    put.add(cell);
                }
                context.dataRowStates.put(new ImmutableBytesPtr(rowKey), new Pair((Object)put, (Object)new Put(put)));
            }
        }
    }

    public static Mutation getDeleteIndexMutation(Put dataRowState, IndexMaintainer indexMaintainer, long ts, ImmutableBytesPtr rowKeyPtr, byte[] encodedRegionName) {
        IndexUtil.SimpleValueGetter dataRowVG = new IndexUtil.SimpleValueGetter(dataRowState);
        byte[] indexRowKey = indexMaintainer.buildRowKey((ValueGetter)dataRowVG, (ImmutableBytesWritable)rowKeyPtr, null, null, ts, encodedRegionName);
        return indexMaintainer.buildRowDeleteMutation(indexRowKey, IndexMaintainer.DeleteType.ALL_VERSIONS, ts);
    }

    private void prepareIndexMutations(BatchMutateContext context, List<IndexMaintainer> maintainers, long ts) throws IOException {
        ArrayList<Pair> indexTables = new ArrayList<Pair>(maintainers.size());
        for (IndexMaintainer indexMaintainer : maintainers) {
            if (indexMaintainer.isLocalIndex()) continue;
            HTableInterfaceReference hTableInterfaceReference = new HTableInterfaceReference(new ImmutableBytesPtr(indexMaintainer.getIndexTableName()));
            indexTables.add(new Pair((Object)indexMaintainer, (Object)hTableInterfaceReference));
        }
        for (Map.Entry entry : context.dataRowStates.entrySet()) {
            ImmutableBytesPtr rowKeyPtr = (ImmutableBytesPtr)entry.getKey();
            Pair dataRowState = (Pair)entry.getValue();
            Put currentDataRowState = (Put)dataRowState.getFirst();
            Put nextDataRowState = (Put)dataRowState.getSecond();
            if (currentDataRowState == null && nextDataRowState == null) continue;
            for (Pair pair : indexTables) {
                IndexMaintainer indexMaintainer = (IndexMaintainer)pair.getFirst();
                HTableInterfaceReference hTableInterfaceReference = (HTableInterfaceReference)pair.getSecond();
                if (nextDataRowState != null && indexMaintainer.shouldPrepareIndexMutations(nextDataRowState)) {
                    Delete deleteColumn;
                    IndexUtil.SimpleValueGetter nextDataRowVG = new IndexUtil.SimpleValueGetter(nextDataRowState);
                    Put indexPut = indexMaintainer.buildUpdateMutation(GenericKeyValueBuilder.INSTANCE, (ValueGetter)nextDataRowVG, (ImmutableBytesWritable)rowKeyPtr, ts, null, null, false, this.encodedRegionName);
                    if (indexPut == null) {
                        byte[] indexRowKey = indexMaintainer.buildRowKey((ValueGetter)nextDataRowVG, (ImmutableBytesWritable)rowKeyPtr, null, null, ts, this.encodedRegionName);
                        indexPut = new Put(indexRowKey);
                    } else {
                        IndexUtil.removeEmptyColumn((Mutation)indexPut, (byte[])indexMaintainer.getEmptyKeyValueFamily().copyBytesIfNecessary(), (byte[])indexMaintainer.getEmptyKeyValueQualifier());
                    }
                    indexPut.addColumn(indexMaintainer.getEmptyKeyValueFamily().copyBytesIfNecessary(), indexMaintainer.getEmptyKeyValueQualifier(), ts, QueryConstants.UNVERIFIED_BYTES);
                    context.indexUpdates.put((Object)hTableInterfaceReference, (Object)new Pair((Object)indexPut, (Object)rowKeyPtr.get()));
                    if (!ignoreWritingDeleteColumnsToIndex && (deleteColumn = indexMaintainer.buildDeleteColumnMutation(indexPut, ts)) != null) {
                        context.indexUpdates.put((Object)hTableInterfaceReference, (Object)new Pair((Object)deleteColumn, (Object)rowKeyPtr.get()));
                    }
                    if (currentDataRowState == null) continue;
                    IndexUtil.SimpleValueGetter currentDataRowVG = new IndexUtil.SimpleValueGetter(currentDataRowState);
                    byte[] indexRowKeyForCurrentDataRow = indexMaintainer.buildRowKey((ValueGetter)currentDataRowVG, (ImmutableBytesWritable)rowKeyPtr, null, null, ts, this.encodedRegionName);
                    if (indexMaintainer.isCDCIndex() || Bytes.compareTo((byte[])indexPut.getRow(), (byte[])indexRowKeyForCurrentDataRow) == 0) continue;
                    Delete del = indexMaintainer.buildRowDeleteMutation(indexRowKeyForCurrentDataRow, IndexMaintainer.DeleteType.ALL_VERSIONS, ts);
                    context.indexUpdates.put((Object)hTableInterfaceReference, (Object)new Pair((Object)del, (Object)rowKeyPtr.get()));
                    continue;
                }
                if (currentDataRowState == null || !indexMaintainer.shouldPrepareIndexMutations(currentDataRowState)) continue;
                if (indexMaintainer.isCDCIndex()) {
                    Put cdcDataRowState = new Put(currentDataRowState.getRow());
                    cdcDataRowState.addColumn(indexMaintainer.getDataEmptyKeyValueCF(), indexMaintainer.getEmptyKeyValueQualifierForDataTable(), ts, ByteUtil.EMPTY_BYTE_ARRAY);
                    context.indexUpdates.put((Object)hTableInterfaceReference, (Object)new Pair((Object)IndexRegionObserver.getDeleteIndexMutation(cdcDataRowState, indexMaintainer, ts, rowKeyPtr, this.encodedRegionName), (Object)rowKeyPtr.get()));
                    continue;
                }
                context.indexUpdates.put((Object)hTableInterfaceReference, (Object)new Pair((Object)IndexRegionObserver.getDeleteIndexMutation(currentDataRowState, indexMaintainer, ts, rowKeyPtr, this.encodedRegionName), (Object)rowKeyPtr.get()));
            }
        }
    }

    private void preparePreIndexMutations(BatchMutateContext context, long batchTimestamp, PhoenixIndexMetaData indexMetaData) throws Throwable {
        List maintainers = indexMetaData.getIndexMaintainers();
        try (TraceScope scope = Trace.startSpan((String)"Starting to build index updates");){
            Span current = scope.getSpan();
            if (current == null) {
                current = NullSpan.INSTANCE;
            }
            current.addTimelineAnnotation("Built index updates, doing preStep");
            context.indexUpdates = (ListMultimap)ArrayListMultimap.create();
            this.prepareIndexMutations(context, maintainers, batchTimestamp);
            context.preIndexUpdates = (ListMultimap)ArrayListMultimap.create();
            int updateCount = 0;
            for (IndexMaintainer indexMaintainer : maintainers) {
                ++updateCount;
                byte[] emptyCF = indexMaintainer.getEmptyKeyValueFamily().copyBytesIfNecessary();
                byte[] emptyCQ = indexMaintainer.getEmptyKeyValueQualifier();
                HTableInterfaceReference hTableInterfaceReference = new HTableInterfaceReference(new ImmutableBytesPtr(indexMaintainer.getIndexTableName()));
                List updates = context.indexUpdates.get((Object)hTableInterfaceReference);
                for (Pair update : updates) {
                    Mutation m = (Mutation)update.getFirst();
                    if (m instanceof Put) {
                        context.preIndexUpdates.put((Object)hTableInterfaceReference, (Object)m);
                        continue;
                    }
                    if (!IndexUtil.isDeleteFamily((Mutation)m)) continue;
                    Put unverifiedPut = new Put(m.getRow());
                    unverifiedPut.addColumn(emptyCF, emptyCQ, batchTimestamp, QueryConstants.UNVERIFIED_BYTES);
                    context.preIndexUpdates.put((Object)hTableInterfaceReference, (Object)unverifiedPut);
                }
            }
            TracingUtils.addAnnotation((Span)current, (String)"index update count", (int)updateCount);
        }
    }

    protected PhoenixIndexMetaData getPhoenixIndexMetaData(ObserverContext<RegionCoprocessorEnvironment> observerContext, MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
        IndexMetaData indexMetaData = this.builder.getIndexMetaData(miniBatchOp);
        if (!(indexMetaData instanceof PhoenixIndexMetaData)) {
            throw new DoNotRetryIOException("preBatchMutateWithExceptions: indexMetaData is not an instance of " + PhoenixIndexMetaData.class.getName() + ", current table is:" + ((RegionCoprocessorEnvironment)observerContext.getEnvironment()).getRegion().getRegionInfo().getTable().getNameAsString());
        }
        return (PhoenixIndexMetaData)indexMetaData;
    }

    private void preparePostIndexMutations(BatchMutateContext context, long batchTimestamp, PhoenixIndexMetaData indexMetaData) {
        context.postIndexUpdates = (ListMultimap)ArrayListMultimap.create();
        List maintainers = indexMetaData.getIndexMaintainers();
        for (IndexMaintainer indexMaintainer : maintainers) {
            byte[] emptyCF = indexMaintainer.getEmptyKeyValueFamily().copyBytesIfNecessary();
            byte[] emptyCQ = indexMaintainer.getEmptyKeyValueQualifier();
            HTableInterfaceReference hTableInterfaceReference = new HTableInterfaceReference(new ImmutableBytesPtr(indexMaintainer.getIndexTableName()));
            List updates = context.indexUpdates.get((Object)hTableInterfaceReference);
            for (Pair update : updates) {
                Mutation m = (Mutation)update.getFirst();
                if (m instanceof Put) {
                    if (indexMaintainer.isUncovered()) continue;
                    Put verifiedPut = new Put(m.getRow());
                    verifiedPut.addColumn(emptyCF, emptyCQ, batchTimestamp, QueryConstants.VERIFIED_BYTES);
                    context.postIndexUpdates.put((Object)hTableInterfaceReference, (Object)verifiedPut);
                    continue;
                }
                context.postIndexUpdates.put((Object)hTableInterfaceReference, (Object)m);
            }
        }
    }

    private static void identifyIndexMaintainerTypes(PhoenixIndexMetaData indexMetaData, BatchMutateContext context) {
        for (IndexMaintainer indexMaintainer : indexMetaData.getIndexMaintainers()) {
            if (indexMaintainer instanceof TransformMaintainer) {
                context.hasTransform = true;
                continue;
            }
            if (indexMaintainer.isLocalIndex()) {
                context.hasLocalIndex = true;
                continue;
            }
            if (indexMaintainer.isUncovered()) {
                context.hasUncoveredIndex = true;
                continue;
            }
            context.hasGlobalIndex = true;
        }
    }

    private void identifyMutationTypes(MiniBatchOperationInProgress<Mutation> miniBatchOp, BatchMutateContext context) throws IOException {
        for (int i = 0; i < miniBatchOp.size(); ++i) {
            Mutation m = (Mutation)miniBatchOp.getOperation(i);
            if (this.builder.returnResult(m) && miniBatchOp.size() == 1) {
                context.returnResult = true;
                byte[] returnResult = m.getAttribute("_RETURN_RESULT");
                if (returnResult != null && Arrays.equals(returnResult, PhoenixIndexBuilderHelper.RETURN_RESULT_OLD_ROW)) {
                    context.returnOldRow = true;
                }
            }
            if (this.builder.hasConditionalTTL(m) && this.isStrictTTLEnabled(miniBatchOp)) {
                context.hasConditionalTTL = true;
            }
            if (this.builder.isAtomicOp(m) || this.builder.returnResult(m)) {
                context.hasAtomic = true;
                if (context.hasRowDelete) {
                    return;
                }
            } else if (m instanceof Delete) {
                CellScanner scanner = m.cellScanner();
                if (m.isEmpty()) {
                    context.hasRowDelete = true;
                } else {
                    while (scanner.advance()) {
                        if (scanner.current().getType() != Cell.Type.DeleteFamily) continue;
                        context.hasRowDelete = true;
                        break;
                    }
                }
            }
            if (!context.hasAtomic && !context.returnResult) continue;
            return;
        }
    }

    private void waitForPreviousConcurrentBatch(TableName table, BatchMutateContext context) throws Throwable {
        for (BatchMutateContext lastContext : context.lastConcurrentBatchContext.values()) {
            BatchMutatePhase phase = lastContext.getCurrentPhase();
            if (phase == BatchMutatePhase.FAILED) {
                context.currentPhase = BatchMutatePhase.FAILED;
                break;
            }
            if (phase != BatchMutatePhase.PRE) continue;
            CountDownLatch countDownLatch = lastContext.getCountDownLatch();
            if (countDownLatch == null) {
                if (phase != BatchMutatePhase.FAILED) continue;
                context.currentPhase = BatchMutatePhase.FAILED;
                break;
            }
            this.unlockRows(context);
            if (!countDownLatch.await((lastContext.getMaxPendingRowCount() + 1) * this.concurrentMutationWaitDuration, TimeUnit.MILLISECONDS)) {
                context.currentPhase = BatchMutatePhase.FAILED;
                LOG.debug(String.format("latch timeout context %s last %s", context, lastContext));
                break;
            }
            if (lastContext.getCurrentPhase() == BatchMutatePhase.FAILED) {
                context.currentPhase = BatchMutatePhase.FAILED;
                break;
            }
            this.lockRows(context);
            LOG.debug(String.format("context %s last %s exit phase %s", new Object[]{context, lastContext, lastContext.getCurrentPhase()}));
        }
        if (context.currentPhase == BatchMutatePhase.FAILED) {
            throw new IOException("One of the previous concurrent mutations has not completed. The batch needs to be retried " + table.getNameAsString());
        }
    }

    private boolean shouldSleep(BatchMutateContext context) {
        for (ImmutableBytesPtr ptr : context.rowsToLock) {
            for (Set<ImmutableBytesPtr> set : this.batchesWithLastTimestamp) {
                if (!set.contains(ptr)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getBatchTimestamp(BatchMutateContext context, TableName table) throws InterruptedException {
        long ts;
        IndexRegionObserver indexRegionObserver = this;
        synchronized (indexRegionObserver) {
            ts = EnvironmentEdgeManager.currentTimeMillis();
            if (ts != this.lastTimestamp) {
                this.lastTimestamp = ts;
                this.batchesWithLastTimestamp.clear();
                this.batchesWithLastTimestamp.add(context.rowsToLock);
                return ts;
            }
            if (!this.shouldSleep(context)) {
                this.batchesWithLastTimestamp.add(context.rowsToLock);
                return ts;
            }
        }
        Thread.sleep(1L);
        LOG.debug("slept 1ms for " + table.getNameAsString());
        indexRegionObserver = this;
        synchronized (indexRegionObserver) {
            ts = EnvironmentEdgeManager.currentTimeMillis();
            if (ts != this.lastTimestamp) {
                this.lastTimestamp = ts;
                this.batchesWithLastTimestamp.clear();
            }
            this.batchesWithLastTimestamp.add(context.rowsToLock);
            return ts;
        }
    }

    public void preBatchMutateWithExceptions(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Mutation> miniBatchOp) throws Throwable {
        long start;
        PhoenixIndexMetaData indexMetaData = this.getPhoenixIndexMetaData(c, miniBatchOp);
        BatchMutateContext context = new BatchMutateContext(indexMetaData.getClientVersion());
        this.setBatchMutateContext(c, context);
        IndexRegionObserver.identifyIndexMaintainerTypes(indexMetaData, context);
        this.identifyMutationTypes(miniBatchOp, context);
        context.populateOriginalMutations(miniBatchOp);
        if (context.hasRowDelete) {
            ServerIndexUtil.setDeleteAttributes(miniBatchOp);
        }
        this.populateRowsToLock(miniBatchOp, context);
        if (context.rowsToLock.isEmpty()) {
            return;
        }
        this.lockRows(context);
        context.currentPhase = BatchMutatePhase.PRE;
        long onDupCheckTime = 0L;
        if (context.hasAtomic || context.returnResult || context.hasGlobalIndex || context.hasUncoveredIndex || context.hasTransform || context.hasConditionalTTL) {
            start = EnvironmentEdgeManager.currentTimeMillis();
            context.dataRowStates = new HashMap(context.rowsToLock.size());
            if (context.hasGlobalIndex || context.hasTransform || context.hasAtomic || context.returnResult || context.hasRowDelete || context.hasConditionalTTL || context.hasUncoveredIndex && this.isPartialUncoveredIndexMutation(indexMetaData, miniBatchOp)) {
                this.getCurrentRowStates(c, context);
            }
            onDupCheckTime += EnvironmentEdgeManager.currentTimeMillis() - start;
        }
        if (context.hasConditionalTTL) {
            this.updateMutationsForConditionalTTL(miniBatchOp, context);
        }
        if (context.hasAtomic || context.returnResult) {
            start = EnvironmentEdgeManager.currentTimeMillis();
            this.addOnDupMutationsToBatch(miniBatchOp, context);
            this.releaseLocksForOnDupIgnoreMutations(miniBatchOp, context);
            this.metricSource.updateDuplicateKeyCheckTime(this.dataTableName, onDupCheckTime += EnvironmentEdgeManager.currentTimeMillis() - start);
            if (context.rowsToLock.isEmpty()) {
                return;
            }
        }
        TableName table = ((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion().getRegionInfo().getTable();
        long batchTimestamp = this.getBatchTimestamp(context, table);
        IndexRegionObserver.setTimestamps(miniBatchOp, this.builder, batchTimestamp, this.isStrictTTLEnabled(miniBatchOp));
        if (context.hasGlobalIndex || context.hasUncoveredIndex || context.hasTransform) {
            this.prepareDataRowStates(c, miniBatchOp, context, batchTimestamp);
            long start2 = EnvironmentEdgeManager.currentTimeMillis();
            this.preparePreIndexMutations(context, batchTimestamp, indexMetaData);
            this.metricSource.updateIndexPrepareTime(this.dataTableName, EnvironmentEdgeManager.currentTimeMillis() - start2);
            this.unlockRows(context);
            this.doPre(context);
            this.lockRows(context);
            if (context.lastConcurrentBatchContext != null) {
                this.waitForPreviousConcurrentBatch(table, context);
            }
            this.preparePostIndexMutations(context, batchTimestamp, indexMetaData);
        }
        if (context.hasLocalIndex) {
            Collection<? extends Mutation> mutations = this.groupMutations(miniBatchOp, context);
            this.handleLocalIndexUpdates(table, miniBatchOp, mutations, indexMetaData);
        }
        if (failDataTableUpdatesForTesting) {
            throw new DoNotRetryIOException("Simulating the data table write failure");
        }
    }

    private void releaseLocksForOnDupIgnoreMutations(MiniBatchOperationInProgress<Mutation> miniBatchOp, BatchMutateContext context) {
        block0: for (int i = 0; i < miniBatchOp.size(); ++i) {
            Mutation m;
            if (!IndexRegionObserver.isAtomicOperationComplete(miniBatchOp.getOperationStatus(i)) || !this.builder.isAtomicOp(m = (Mutation)miniBatchOp.getOperation(i)) && !this.builder.returnResult(m)) continue;
            ImmutableBytesPtr row = new ImmutableBytesPtr(m.getRow());
            Iterator rowLockIterator = context.rowLocks.iterator();
            while (rowLockIterator.hasNext()) {
                LockManager.RowLock rowLock = (LockManager.RowLock)rowLockIterator.next();
                ImmutableBytesPtr rowKey = rowLock.getRowKey();
                if (!row.equals((Object)rowKey)) continue;
                PendingRow pendingRow = this.pendingRows.get(rowKey);
                if (pendingRow != null) {
                    pendingRow.remove();
                }
                rowLock.release();
                rowLockIterator.remove();
                context.rowsToLock.remove(row);
                continue block0;
            }
        }
    }

    private void setBatchMutateContext(ObserverContext<RegionCoprocessorEnvironment> c, BatchMutateContext context) {
        this.batchMutateContext.set(context);
    }

    private BatchMutateContext getBatchMutateContext(ObserverContext<RegionCoprocessorEnvironment> c) {
        return this.batchMutateContext.get();
    }

    private void removeBatchMutateContext(ObserverContext<RegionCoprocessorEnvironment> c) {
        this.batchMutateContext.remove();
    }

    public void preWALAppend(ObserverContext<RegionCoprocessorEnvironment> c, WALKey key, WALEdit edit) {
        if (this.shouldWALAppend) {
            BatchMutateContext context = this.getBatchMutateContext(c);
            this.appendMutationAttributesToWALKey(key, context);
        }
    }

    public void appendMutationAttributesToWALKey(WALKey key, BatchMutateContext context) {
        if (context != null && context.getOriginalMutations().size() > 0) {
            Mutation firstMutation = context.getOriginalMutations().get(0);
            Map attrMap = firstMutation.getAttributesMap();
            for (MutationState.MutationMetadataType metadataType : MutationState.MutationMetadataType.values()) {
                String metadataTypeKey = metadataType.toString();
                if (!attrMap.containsKey(metadataTypeKey)) continue;
                IndexRegionObserver.appendToWALKey(key, metadataTypeKey, (byte[])attrMap.get(metadataTypeKey));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postBatchMutateIndispensably(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Mutation> miniBatchOp, boolean success) throws IOException {
        if (this.disabled) {
            return;
        }
        BatchMutateContext context = this.getBatchMutateContext(c);
        if (context == null) {
            return;
        }
        try {
            if (context.getCurrentPhase() != BatchMutatePhase.INIT) {
                this.removePendingRows(context);
            }
            if (success) {
                context.currentPhase = BatchMutatePhase.POST;
                if ((context.hasAtomic || context.returnResult) && miniBatchOp.size() == 1 && !IndexRegionObserver.isAtomicOperationComplete(miniBatchOp.getOperationStatus(0))) {
                    byte[] retVal = PInteger.INSTANCE.toBytes((Object)1);
                    Cell cell = PhoenixKeyValueUtil.newKeyValue((byte[])((Mutation)miniBatchOp.getOperation(0)).getRow(), (byte[])Bytes.toBytes((String)"_UpsertCF"), (byte[])Bytes.toBytes((String)"_UpsertStatusCQ"), (long)0L, (byte[])retVal, (int)0, (int)retVal.length);
                    ArrayList<Cell> cells = new ArrayList<Cell>();
                    cells.add(cell);
                    if (!context.returnOldRow) {
                        IndexRegionObserver.addCellsIfResultReturned(miniBatchOp, context.returnResult, cells, context.currColumnCellExprMap, false);
                    } else {
                        IndexRegionObserver.addCellsIfResultReturned(miniBatchOp, context.returnResult, cells, context.oldRowColumnCellExprMap, true);
                    }
                    Result result = Result.create(cells);
                    miniBatchOp.setOperationStatus(0, new OperationStatus(HConstants.OperationStatusCode.SUCCESS, result));
                }
            } else {
                context.currentPhase = BatchMutatePhase.FAILED;
            }
            context.countDownAllLatches();
            if (context.indexUpdates != null) {
                context.indexUpdates.clear();
            }
            this.unlockRows(context);
            this.builder.batchCompleted(miniBatchOp);
            if (success) {
                this.doPost(c, context);
            }
        }
        finally {
            this.removeBatchMutateContext(c);
        }
    }

    private static void addCellsIfResultReturned(MiniBatchOperationInProgress<Mutation> miniBatchOp, boolean returnResult, List<Cell> cells, Map<ColumnReference, Pair<Cell, Boolean>> currColumnCellExprMap, boolean retainOldRow) {
        if (returnResult) {
            Mutation[] mutations;
            if (currColumnCellExprMap == null) {
                return;
            }
            Mutation mutation = (Mutation)miniBatchOp.getOperation(0);
            if (mutation instanceof Put && !retainOldRow) {
                IndexRegionObserver.updateColumnCellExprMap(mutation, currColumnCellExprMap);
            }
            if ((mutations = miniBatchOp.getOperationsFromCoprocessors(0)) != null && !retainOldRow) {
                for (Mutation m : mutations) {
                    IndexRegionObserver.updateColumnCellExprMap(m, currColumnCellExprMap);
                }
            }
            for (Pair pair : currColumnCellExprMap.values()) {
                cells.add((Cell)pair.getFirst());
            }
            cells.sort((Comparator<Cell>)CellComparator.getInstance());
        }
    }

    private static void updateColumnCellExprMap(Mutation mutation, Map<ColumnReference, Pair<Cell, Boolean>> currColumnCellExprMap) {
        if (mutation != null) {
            for (Map.Entry entry : mutation.getFamilyCellMap().entrySet()) {
                for (Cell entryCell : (List)entry.getValue()) {
                    byte[] family = CellUtil.cloneFamily((Cell)entryCell);
                    byte[] qualifier = CellUtil.cloneQualifier((Cell)entryCell);
                    ColumnReference colRef = new ColumnReference(family, qualifier);
                    if (mutation instanceof Put) {
                        currColumnCellExprMap.put(colRef, (Pair<Cell, Boolean>)new Pair((Object)entryCell, null));
                        continue;
                    }
                    if (!(mutation instanceof Delete)) continue;
                    currColumnCellExprMap.remove(colRef);
                }
            }
        }
    }

    private void doPost(ObserverContext<RegionCoprocessorEnvironment> c, BatchMutateContext context) throws IOException {
        long start = EnvironmentEdgeManager.currentTimeMillis();
        try {
            if (failPostIndexUpdatesForTesting) {
                throw new DoNotRetryIOException("Simulating the last (i.e., post) index table write failure");
            }
            this.doIndexWritesWithExceptions(context, true);
            this.metricSource.updatePostIndexUpdateTime(this.dataTableName, EnvironmentEdgeManager.currentTimeMillis() - start);
        }
        catch (Throwable e) {
            this.metricSource.updatePostIndexUpdateFailureTime(this.dataTableName, EnvironmentEdgeManager.currentTimeMillis() - start);
            this.metricSource.incrementPostIndexUpdateFailures(this.dataTableName);
        }
    }

    private void doIndexWritesWithExceptions(BatchMutateContext context, boolean post) throws IOException {
        ListMultimap indexUpdates;
        ListMultimap listMultimap = indexUpdates = post ? context.postIndexUpdates : context.preIndexUpdates;
        if (context == null || indexUpdates == null || indexUpdates.isEmpty()) {
            return;
        }
        try (TraceScope scope = Trace.startSpan((String)("Completing " + (post ? "post" : "pre") + " index writes"));){
            Span current = scope.getSpan();
            if (current == null) {
                current = NullSpan.INSTANCE;
            }
            current.addTimelineAnnotation("Actually doing " + (post ? "post" : "pre") + " index update for first time");
            if (post) {
                this.postWriter.write((Multimap<HTableInterfaceReference, Mutation>)indexUpdates, false, context.clientVersion);
            } else {
                this.preWriter.write((Multimap<HTableInterfaceReference, Mutation>)indexUpdates, false, context.clientVersion);
            }
        }
    }

    private void removePendingRows(BatchMutateContext context) {
        for (ImmutableBytesPtr rowKey : context.rowsToLock) {
            PendingRow pendingRow = this.pendingRows.get(rowKey);
            if (pendingRow == null) continue;
            pendingRow.remove();
        }
    }

    private void doPre(BatchMutateContext context) throws IOException {
        long start = 0L;
        try {
            start = EnvironmentEdgeManager.currentTimeMillis();
            if (failPreIndexUpdatesForTesting) {
                throw new DoNotRetryIOException("Simulating the first (i.e., pre) index table write failure");
            }
            this.doIndexWritesWithExceptions(context, false);
            this.metricSource.updatePreIndexUpdateTime(this.dataTableName, EnvironmentEdgeManager.currentTimeMillis() - start);
        }
        catch (Throwable e) {
            this.metricSource.updatePreIndexUpdateFailureTime(this.dataTableName, EnvironmentEdgeManager.currentTimeMillis() - start);
            this.metricSource.incrementPreIndexUpdateFailures(this.dataTableName);
            this.lockRows(context);
            IndexManagementUtil.rethrowIndexingException((Throwable)e);
        }
    }

    private void extractExpressionsAndColumns(DataInputStream input, List<Pair<PTable, List<Expression>>> operations, final Set<ColumnReference> colsReadInExpr) throws IOException {
        while (true) {
            StatelessTraverseAllExpressionVisitor<Void> visitor = new StatelessTraverseAllExpressionVisitor<Void>(){

                public Void visit(KeyValueColumnExpression expression) {
                    colsReadInExpr.add(new ColumnReference(expression.getColumnFamily(), expression.getColumnQualifier()));
                    return null;
                }
            };
            try {
                int nExpressions = WritableUtils.readVInt((DataInput)input);
                ArrayList expressions = Lists.newArrayListWithExpectedSize((int)nExpressions);
                for (int i = 0; i < nExpressions; ++i) {
                    Expression expression = ExpressionType.values()[WritableUtils.readVInt((DataInput)input)].newInstance();
                    expression.readFields((DataInput)input);
                    expressions.add(expression);
                    expression.accept((ExpressionVisitor)visitor);
                }
                PTableProtos.PTable tableProto = PTableProtos.PTable.parseDelimitedFrom((InputStream)input);
                PTable table = PTableImpl.createFromProto((PTableProtos.PTable)tableProto);
                operations.add((Pair<PTable, List<Expression>>)new Pair((Object)table, (Object)expressions));
            }
            catch (EOFException e) {
                return;
            }
        }
    }

    private List<Mutation> generateOnDupMutations(BatchMutateContext context, Put atomicPut, MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
        List<Cell> flattenedCells;
        boolean isUpdateOnly;
        Put currentDataRowState;
        ArrayList mutations = Lists.newArrayListWithExpectedSize((int)2);
        byte[] opBytes = atomicPut.getAttribute("_ATOMIC_OP_ATTRIB");
        byte[] returnResult = atomicPut.getAttribute("_RETURN_RESULT");
        if (opBytes == null && returnResult == null || opBytes == null && miniBatchOp.size() != 1) {
            return null;
        }
        Put put = null;
        Delete delete = null;
        long ts = Long.MAX_VALUE;
        HashMap<ColumnReference, Pair<Cell, Boolean>> currColumnCellExprMap = new HashMap<ColumnReference, Pair<Cell, Boolean>>();
        byte[] rowKey = atomicPut.getRow();
        ImmutableBytesPtr rowKeyPtr = new ImmutableBytesPtr(rowKey);
        Pair dataRowState = (Pair)context.dataRowStates.get(rowKeyPtr);
        Put put2 = currentDataRowState = dataRowState != null ? (Put)dataRowState.getFirst() : null;
        if (context.returnResult && context.returnOldRow && currentDataRowState != null) {
            context.oldRowColumnCellExprMap = new HashMap();
            IndexRegionObserver.updateCurrColumnCellExpr(currentDataRowState, context.oldRowColumnCellExprMap);
        }
        if (opBytes == null) {
            mutations.add(atomicPut);
            IndexRegionObserver.updateCurrColumnCellExpr(currentDataRowState != null ? currentDataRowState : atomicPut, currColumnCellExprMap);
            if (context.returnResult) {
                context.currColumnCellExprMap = currColumnCellExprMap;
            }
            return mutations;
        }
        if (PhoenixIndexBuilderHelper.isDupKeyIgnore((byte[])opBytes)) {
            if (currentDataRowState == null) {
                mutations.add(atomicPut);
                IndexRegionObserver.updateCurrColumnCellExpr(atomicPut, currColumnCellExprMap);
            } else {
                IndexRegionObserver.updateCurrColumnCellExpr(currentDataRowState, currColumnCellExprMap);
            }
            if (context.returnResult) {
                context.currColumnCellExprMap = currColumnCellExprMap;
            }
            return mutations;
        }
        boolean bl = isUpdateOnly = atomicPut.getAttribute("_ATOMIC_OP_UPDATE_ONLY_ATTRIB") != null;
        if (isUpdateOnly && currentDataRowState == null) {
            if (context.returnResult) {
                context.currColumnCellExprMap = currColumnCellExprMap;
            }
            return Collections.emptyList();
        }
        ByteArrayInputStream stream = new ByteArrayInputStream(opBytes);
        DataInputStream input = new DataInputStream(stream);
        boolean skipFirstOp = input.readBoolean();
        int repeat = input.readShort();
        ArrayList operations = Lists.newArrayListWithExpectedSize((int)3);
        HashSet<ColumnReference> colsReadInExpr = new HashSet<ColumnReference>();
        this.extractExpressionsAndColumns(input, operations, colsReadInExpr);
        int estimatedSize = colsReadInExpr.size();
        List<Cell> cells = IndexUtil.readColumnsFromRow((Put)currentDataRowState, colsReadInExpr);
        if (currentDataRowState == null) {
            IndexRegionObserver.updateCurrColumnCellExpr(atomicPut, currColumnCellExprMap);
            if (skipFirstOp) {
                if (operations.size() <= 1 && repeat <= 1) {
                    mutations.add(atomicPut);
                    if (context.returnResult) {
                        context.currColumnCellExprMap = currColumnCellExprMap;
                    }
                    return mutations;
                }
                repeat = (short)(repeat - 1);
            }
            flattenedCells = IndexRegionObserver.flattenCells((Mutation)atomicPut);
        } else {
            flattenedCells = cells;
            IndexRegionObserver.updateCurrColumnCellExpr(currentDataRowState, currColumnCellExprMap);
        }
        if (context.returnResult) {
            context.currColumnCellExprMap = currColumnCellExprMap;
        }
        MultiKeyValueTuple tuple = new MultiKeyValueTuple(flattenedCells);
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        for (int opIndex = 0; opIndex < operations.size(); ++opIndex) {
            Pair operation = (Pair)operations.get(opIndex);
            PTable table = (PTable)operation.getFirst();
            List expressions = (List)operation.getSecond();
            for (int j = 0; j < repeat; ++j) {
                ptr.set(rowKey);
                if (flattenedCells != null) {
                    Collections.sort(flattenedCells, CellComparator.getInstance());
                }
                PRow row = table.newRow(GenericKeyValueBuilder.INSTANCE, ts, ptr, false, (byte[][])new byte[0][]);
                int adjust = table.getBucketNum() == null ? 1 : 2;
                for (int i = 0; i < expressions.size(); ++i) {
                    Object value;
                    Expression expression = (Expression)expressions.get(i);
                    ptr.set(ByteUtil.EMPTY_BYTE_ARRAY);
                    expression.evaluate((Tuple)tuple, ptr);
                    PColumn column = (PColumn)table.getColumns().get(i + adjust);
                    Object object = value = expression.isNullable() ? null : expression.getDataType().toObject(ptr, column.getSortOrder());
                    if (!column.getDataType().isSizeCompatible(ptr, value, column.getDataType(), expression.getSortOrder(), expression.getMaxLength(), expression.getScale(), column.getMaxLength(), column.getScale())) {
                        throw new DataExceedsCapacityException(column.getDataType(), column.getMaxLength(), column.getScale(), column.getName().getString());
                    }
                    column.getDataType().coerceBytes(ptr, value, expression.getDataType(), expression.getMaxLength(), expression.getScale(), expression.getSortOrder(), column.getMaxLength(), column.getScale(), column.getSortOrder(), table.rowKeyOrderOptimizable());
                    byte[] bytes = ByteUtil.copyKeyBytesIfNecessary((ImmutableBytesWritable)ptr);
                    row.setValue(column, bytes);
                    ColumnReference colRef = new ColumnReference(column.getFamilyName().getBytes(), column.getColumnQualifierBytes());
                    if (!currColumnCellExprMap.containsKey(colRef)) continue;
                    Pair valuePair = (Pair)currColumnCellExprMap.get(colRef);
                    if (expression instanceof CaseExpression && ((CaseExpression)expression).evaluateIndexOf((Tuple)tuple, ptr) == expression.getChildren().size() - 1) {
                        valuePair.setSecond((Object)true);
                        continue;
                    }
                    valuePair.setSecond((Object)false);
                }
                ArrayList updatedCells = Lists.newArrayListWithExpectedSize((int)estimatedSize);
                List newMutations = row.toRowMutations();
                for (Mutation source : newMutations) {
                    IndexRegionObserver.flattenCells(source, updatedCells);
                }
                flattenedCells = IndexRegionObserver.mergeCells(flattenedCells, updatedCells);
                flattenedCells.sort((Comparator<Cell>)CellComparator.getInstance());
                tuple.setKeyValues(flattenedCells);
            }
            repeat = 1;
        }
        put = new Put(rowKey);
        delete = new Delete(rowKey);
        IndexRegionObserver.transferAttributes((Mutation)atomicPut, (Mutation)put);
        IndexRegionObserver.transferAttributes((Mutation)atomicPut, (Mutation)delete);
        for (int i = 0; i < tuple.size(); ++i) {
            Cell cell = tuple.getValue(i);
            if (cell.getType() == Cell.Type.Put) {
                if (!this.checkCellNeedUpdate(cell, currColumnCellExprMap)) continue;
                put.add(cell);
                continue;
            }
            delete.add(cell);
        }
        if (!put.isEmpty() || !delete.isEmpty()) {
            PTable table = (PTable)((Pair)operations.get(0)).getFirst();
            this.addEmptyKVCellToPut(put, tuple, table);
        }
        if (!put.isEmpty()) {
            mutations.add(put);
        }
        if (!delete.isEmpty()) {
            mutations.add(delete);
        }
        return mutations;
    }

    private static void updateCurrColumnCellExpr(Put put, Map<ColumnReference, Pair<Cell, Boolean>> currColumnCellExprMap) {
        if (put == null) {
            return;
        }
        for (Map.Entry entry : put.getFamilyCellMap().entrySet()) {
            for (Cell cell : (List)entry.getValue()) {
                byte[] family = CellUtil.cloneFamily((Cell)cell);
                byte[] qualifier = CellUtil.cloneQualifier((Cell)cell);
                ColumnReference colRef = new ColumnReference(family, qualifier);
                currColumnCellExprMap.put(colRef, (Pair<Cell, Boolean>)new Pair((Object)cell, null));
            }
        }
    }

    private void addEmptyKVCellToPut(Put put, MultiKeyValueTuple tuple, PTable table) throws IOException {
        byte[] emptyCQ;
        byte[] emptyCF = SchemaUtil.getEmptyColumnFamily((PTable)table);
        Cell emptyKVCell = tuple.getValue(emptyCF, emptyCQ = (byte[])EncodedColumnsUtil.getEmptyKeyValueInfo((PTable)table).getFirst());
        if (emptyKVCell != null) {
            put.add(emptyKVCell);
        }
    }

    private static List<Cell> flattenCells(Mutation m) {
        ArrayList<Cell> flattenedCells = new ArrayList<Cell>();
        IndexRegionObserver.flattenCells(m, flattenedCells);
        return flattenedCells;
    }

    private static void flattenCells(Mutation m, List<Cell> flattenedCells) {
        for (List cells : m.getFamilyCellMap().values()) {
            flattenedCells.addAll(cells);
        }
    }

    private boolean checkCellNeedUpdate(Cell cell, Map<ColumnReference, Pair<Cell, Boolean>> colCellExprMap) {
        byte[] family = CellUtil.cloneFamily((Cell)cell);
        byte[] qualifier = CellUtil.cloneQualifier((Cell)cell);
        ColumnReference colRef = new ColumnReference(family, qualifier);
        if (colCellExprMap.isEmpty() || !colCellExprMap.containsKey(colRef)) {
            return true;
        }
        Pair<Cell, Boolean> valuePair = colCellExprMap.get(colRef);
        Boolean isInCaseExpressionElseClause = (Boolean)valuePair.getSecond();
        if (isInCaseExpressionElseClause == null) {
            return false;
        }
        if (!isInCaseExpressionElseClause.booleanValue()) {
            return true;
        }
        Cell oldCell = (Cell)valuePair.getFirst();
        ImmutableBytesPtr newValuePtr = new ImmutableBytesPtr(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
        ImmutableBytesPtr oldValuePtr = new ImmutableBytesPtr(oldCell.getValueArray(), oldCell.getValueOffset(), oldCell.getValueLength());
        return !Bytes.equals((byte[])oldValuePtr.get(), (int)oldValuePtr.getOffset(), (int)oldValuePtr.getLength(), (byte[])newValuePtr.get(), (int)newValuePtr.getOffset(), (int)newValuePtr.getLength());
    }

    private static void transferAttributes(Mutation source, Mutation target) {
        for (Map.Entry entry : source.getAttributesMap().entrySet()) {
            target.setAttribute((String)entry.getKey(), (byte[])entry.getValue());
        }
    }

    private static List<Cell> mergeCells(List<Cell> current, List<Cell> latest) {
        ColumnReference colInfo;
        byte[] qualifier;
        byte[] family;
        HashMap latestColVals = Maps.newHashMapWithExpectedSize((int)(latest.size() + current.size()));
        for (Cell cell : latest) {
            family = CellUtil.cloneFamily((Cell)cell);
            qualifier = CellUtil.cloneQualifier((Cell)cell);
            colInfo = new ColumnReference(family, qualifier);
            latestColVals.put(colInfo, cell);
        }
        for (Cell cell : current) {
            family = CellUtil.cloneFamily((Cell)cell);
            colInfo = new ColumnReference(family, qualifier = CellUtil.cloneQualifier((Cell)cell));
            if (latestColVals.containsKey(colInfo)) continue;
            latestColVals.put(colInfo, cell);
        }
        return Lists.newArrayList(latestColVals.values());
    }

    public static void appendToWALKey(WALKey key, String attrKey, byte[] attrValue) {
        key.addExtendedAttribute(attrKey, attrValue);
    }

    public static byte[] getAttributeValueFromWALKey(WALKey key, String attrKey) {
        return key.getExtendedAttribute(attrKey);
    }

    public static Map<String, byte[]> getAttributeValuesFromWALKey(WALKey key) {
        return new HashMap<String, byte[]>(key.getExtendedAttributes());
    }

    public static boolean isAtomicOperationComplete(OperationStatus status) {
        return status.getOperationStatusCode() == HConstants.OperationStatusCode.SUCCESS && status.getResult() != null;
    }

    public static class BatchMutateContext {
        private volatile BatchMutatePhase currentPhase = BatchMutatePhase.INIT;
        private int maxPendingRowCount = 0;
        private final int clientVersion;
        private ListMultimap<HTableInterfaceReference, Mutation> preIndexUpdates;
        private ListMultimap<HTableInterfaceReference, Mutation> postIndexUpdates;
        private ListMultimap<HTableInterfaceReference, Pair<Mutation, byte[]>> indexUpdates;
        private List<LockManager.RowLock> rowLocks = Lists.newArrayListWithExpectedSize((int)100);
        private Set<ImmutableBytesPtr> rowsToLock = new TreeSet<ImmutableBytesPtr>();
        private HashMap<ImmutableBytesPtr, Pair<Put, Put>> dataRowStates;
        private HashMap<ImmutableBytesPtr, BatchMutateContext> lastConcurrentBatchContext = null;
        private List<CountDownLatch> waitList = null;
        private Map<ImmutableBytesPtr, MultiMutation> multiMutationMap;
        private Map<ColumnReference, Pair<Cell, Boolean>> currColumnCellExprMap;
        private Map<ColumnReference, Pair<Cell, Boolean>> oldRowColumnCellExprMap;
        private List<Mutation> originalMutations;
        private boolean hasAtomic;
        private boolean hasRowDelete;
        private boolean hasUncoveredIndex;
        private boolean hasGlobalIndex;
        private boolean hasLocalIndex;
        private boolean hasTransform;
        private boolean returnResult;
        private boolean returnOldRow;
        private boolean hasConditionalTTL;

        public BatchMutateContext() {
            this.clientVersion = 0;
        }

        public BatchMutateContext(int clientVersion) {
            this.clientVersion = clientVersion;
        }

        public void populateOriginalMutations(MiniBatchOperationInProgress<Mutation> miniBatchOp) {
            this.originalMutations = new ArrayList<Mutation>(miniBatchOp.size());
            for (int k = 0; k < miniBatchOp.size(); ++k) {
                this.originalMutations.add((Mutation)miniBatchOp.getOperation(k));
            }
        }

        public List<Mutation> getOriginalMutations() {
            return this.originalMutations;
        }

        public BatchMutatePhase getCurrentPhase() {
            return this.currentPhase;
        }

        public Put getNextDataRowState(ImmutableBytesPtr rowKeyPtr) {
            Pair<Put, Put> rowState = this.dataRowStates.get(rowKeyPtr);
            if (rowState != null) {
                return (Put)rowState.getSecond();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CountDownLatch getCountDownLatch() {
            BatchMutateContext batchMutateContext = this;
            synchronized (batchMutateContext) {
                if (this.currentPhase != BatchMutatePhase.PRE) {
                    return null;
                }
                if (this.waitList == null) {
                    this.waitList = new ArrayList<CountDownLatch>();
                }
                CountDownLatch countDownLatch = new CountDownLatch(1);
                this.waitList.add(countDownLatch);
                return countDownLatch;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void countDownAllLatches() {
            BatchMutateContext batchMutateContext = this;
            synchronized (batchMutateContext) {
                if (this.waitList != null) {
                    for (CountDownLatch countDownLatch : this.waitList) {
                        countDownLatch.countDown();
                    }
                }
            }
        }

        public int getMaxPendingRowCount() {
            return this.maxPendingRowCount;
        }
    }

    public static enum BatchMutatePhase {
        INIT,
        PRE,
        POST,
        FAILED;

    }

    private class PendingRow {
        private int count = 1;
        private boolean usable = true;
        private ImmutableBytesPtr rowKey;
        private BatchMutateContext lastContext;

        PendingRow(ImmutableBytesPtr rowKey, BatchMutateContext context) {
            this.lastContext = context;
            this.rowKey = rowKey;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean add(BatchMutateContext context) {
            PendingRow pendingRow = this;
            synchronized (pendingRow) {
                if (this.usable) {
                    ++this.count;
                    this.lastContext = context;
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove() {
            PendingRow pendingRow = this;
            synchronized (pendingRow) {
                --this.count;
                if (this.count == 0) {
                    IndexRegionObserver.this.pendingRows.remove(this.rowKey);
                    this.usable = false;
                }
            }
        }

        public int getCount() {
            return this.count;
        }

        public BatchMutateContext getLastContext() {
            return this.lastContext;
        }
    }
}

