/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor.tasks;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.mapreduce.Cluster;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.phoenix.coprocessor.TaskRegionObserver;
import org.apache.phoenix.coprocessor.tasks.BaseTask;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.mapreduce.transform.TransformTool;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.task.ServerTask;
import org.apache.phoenix.schema.task.SystemTaskParams;
import org.apache.phoenix.schema.task.Task;
import org.apache.phoenix.schema.transform.SystemTransformRecord;
import org.apache.phoenix.schema.transform.Transform;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformMonitorTask
extends BaseTask {
    public static final String DEFAULT = "IndexName";
    public static final Logger LOGGER = LoggerFactory.getLogger(TransformMonitorTask.class);
    private static boolean isDisabled = false;

    @VisibleForTesting
    public static void disableTransformMonitorTask(boolean disabled) {
        isDisabled = disabled;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public TaskRegionObserver.TaskResult run(Task.TaskRecord taskRecord) {
        Configuration conf = HBaseConfiguration.create((Configuration)this.env.getConfiguration());
        Configuration configuration = HBaseConfiguration.addHbaseResources((Configuration)conf);
        boolean transformMonitorEnabled = configuration.getBoolean("phoenix.transform.monitor.enabled", true);
        if (!transformMonitorEnabled) return new TaskRegionObserver.TaskResult(TaskRegionObserver.TaskResultCode.FAIL, "TransformMonitor is disabled");
        if (isDisabled) {
            return new TaskRegionObserver.TaskResult(TaskRegionObserver.TaskResultCode.FAIL, "TransformMonitor is disabled");
        }
        try (PhoenixConnection conn = QueryUtil.getConnectionOnServer((Configuration)conf).unwrap(PhoenixConnection.class);){
            block48: {
                SystemTransformRecord systemTransformRecord;
                block51: {
                    String tableName;
                    block50: {
                        block49: {
                            systemTransformRecord = Transform.getTransformRecord((String)taskRecord.getSchemaName(), (String)taskRecord.getTableName(), null, (String)taskRecord.getTenantId(), (PhoenixConnection)conn);
                            if (systemTransformRecord == null) {
                                TaskRegionObserver.TaskResult taskResult = new TaskRegionObserver.TaskResult(TaskRegionObserver.TaskResultCode.FAIL, "No transform record is found");
                                return taskResult;
                            }
                            tableName = SchemaUtil.getTableName((String)systemTransformRecord.getSchemaName(), (String)systemTransformRecord.getLogicalTableName());
                            if (!systemTransformRecord.getTransformStatus().equals(PTable.TransformStatus.CREATED.name())) break block49;
                            LOGGER.info("Transform is created, starting the TransformTool ", (Object)tableName);
                            TransformTool transformTool = TransformTool.runTransformTool(systemTransformRecord, conf, false, null, null, false, false);
                            if (transformTool == null) {
                                TaskRegionObserver.TaskResult taskResult = new TaskRegionObserver.TaskResult(TaskRegionObserver.TaskResultCode.FAIL, "TransformTool run failed. Check the parameters.");
                                return taskResult;
                            }
                            break block48;
                        }
                        if (systemTransformRecord.getTransformStatus().equals(PTable.TransformStatus.COMPLETED.name())) {
                            LOGGER.info("Transform is completed, TransformMonitor is done ", (Object)tableName);
                            TaskRegionObserver.TaskResult transformTool = new TaskRegionObserver.TaskResult(TaskRegionObserver.TaskResultCode.SUCCESS, "");
                            return transformTool;
                        }
                        if (!systemTransformRecord.getTransformStatus().equals(PTable.TransformStatus.PENDING_CUTOVER.name()) || PTable.TransformType.isPartialTransform((PTable.TransformType)systemTransformRecord.getTransformType())) break block50;
                        LOGGER.info("Transform is pending cutover ", (Object)tableName);
                        Transform.doCutover(conn, systemTransformRecord);
                        PTable.TransformType partialTransform = PTable.TransformType.getPartialTransform((PTable.TransformType)systemTransformRecord.getTransformType());
                        if (partialTransform != null) {
                            SystemTransformRecord.SystemTransformBuilder builder = new SystemTransformRecord.SystemTransformBuilder(systemTransformRecord);
                            builder.setTransformType(partialTransform);
                            builder.setTransformRetryCount(systemTransformRecord.getTransformRetryCount() - 1);
                            Transform.upsertTransform((SystemTransformRecord)builder.build(), (PhoenixConnection)conn);
                            long startFromTs = 0L;
                            if (systemTransformRecord.getTransformLastStateTs() != null) {
                                startFromTs = systemTransformRecord.getTransformLastStateTs().getTime() - 1L;
                            }
                            TransformTool.runTransformTool(systemTransformRecord, conf, true, startFromTs, null, true, false);
                            break block48;
                        } else {
                            LOGGER.warn("No partial type of the transform is found. Completing the transform ", (Object)tableName);
                            Transform.updateTransformRecord(conn, systemTransformRecord, PTable.TransformStatus.COMPLETED);
                        }
                        break block48;
                    }
                    if (!systemTransformRecord.getTransformStatus().equals(PTable.TransformStatus.STARTED.name()) && (!systemTransformRecord.getTransformStatus().equals(PTable.TransformStatus.PENDING_CUTOVER.name()) || !PTable.TransformType.isPartialTransform((PTable.TransformType)systemTransformRecord.getTransformType()))) break block51;
                    LOGGER.info(systemTransformRecord.getTransformStatus().equals(PTable.TransformStatus.STARTED.name()) ? "Transform is started, we will monitor " : "Partial transform is going on, we will monitor", (Object)tableName);
                    String jobId = systemTransformRecord.getTransformJobId();
                    if (jobId == null) break block48;
                    Cluster cluster = new Cluster(configuration);
                    Job job = cluster.getJob(JobID.forName((String)jobId));
                    if (job == null) {
                        LOGGER.warn(String.format("Transform job with Id=%s is not found", jobId));
                        TaskRegionObserver.TaskResult taskResult = new TaskRegionObserver.TaskResult(TaskRegionObserver.TaskResultCode.SKIPPED, "The job cannot be found");
                        return taskResult;
                    }
                    if (job == null || !job.isComplete()) break block48;
                    if (job.isSuccessful()) {
                        LOGGER.warn("TransformTool job is successful. Transform should have been in a COMPLETED state " + taskRecord.getTableName());
                        break block48;
                    } else {
                        int maxRetryCount = configuration.getInt("phoenix.transform.retry.count", 50);
                        if (systemTransformRecord.getTransformRetryCount() < maxRetryCount) {
                            TransformTool.runTransformTool(systemTransformRecord, conf, false, null, null, false, true);
                        }
                    }
                    break block48;
                }
                if (systemTransformRecord.getTransformStatus().equals(PTable.TransformStatus.FAILED.name())) {
                    String str = "Transform is marked as failed because either TransformTool is run on the foreground and failed or it is run as async but there is something wrong with the TransformTool parameters";
                    LOGGER.error(str);
                    TaskRegionObserver.TaskResult taskResult = new TaskRegionObserver.TaskResult(TaskRegionObserver.TaskResultCode.FAIL, str);
                    return taskResult;
                }
                if (systemTransformRecord.getTransformStatus().equals(PTable.TransformStatus.PAUSED.name())) {
                    TaskRegionObserver.TaskResult str = new TaskRegionObserver.TaskResult(TaskRegionObserver.TaskResultCode.SUCCESS, "Transform is paused. No need to monitor");
                    return str;
                }
                String str = "Transform status is not known " + systemTransformRecord.getString();
                LOGGER.error(str);
                TaskRegionObserver.TaskResult taskResult = new TaskRegionObserver.TaskResult(TaskRegionObserver.TaskResultCode.FAIL, str);
                return taskResult;
            }
            ServerTask.addTask(new SystemTaskParams.SystemTaskParamsBuilder().setConn(conn).setTaskType(taskRecord.getTaskType()).setTenantId(taskRecord.getTenantId()).setSchemaName(taskRecord.getSchemaName()).setTableName(taskRecord.getTableName()).setTaskStatus(PTable.TaskStatus.RETRY.toString()).setData(taskRecord.getData()).setPriority(Integer.valueOf(taskRecord.getPriority())).setStartTs(taskRecord.getTimeStamp()).setEndTs(null).setAccessCheckEnabled(true).build());
            TaskRegionObserver.TaskResult taskResult = null;
            return taskResult;
        }
        catch (Throwable t) {
            LOGGER.warn("Exception while running transform monitor task. It will be retried in the next system task table scan : " + taskRecord.getSchemaName() + "." + taskRecord.getTableName() + " with tenant id " + (taskRecord.getTenantId() == null ? " IS NULL" : taskRecord.getTenantId()) + " and data " + taskRecord.getData(), t);
            return new TaskRegionObserver.TaskResult(TaskRegionObserver.TaskResultCode.FAIL, t.toString());
        }
    }

    @Override
    public TaskRegionObserver.TaskResult checkCurrentResult(Task.TaskRecord taskRecord) throws Exception {
        return null;
    }
}

