/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor.tasks;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.phoenix.coprocessor.TaskRegionObserver;
import org.apache.phoenix.coprocessor.tasks.BaseTask;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.task.ServerTask;
import org.apache.phoenix.schema.task.SystemTaskParams;
import org.apache.phoenix.schema.task.Task;
import org.apache.phoenix.util.CDCUtil;
import org.apache.phoenix.util.QueryUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdcStreamPartitionMetadataTask
extends BaseTask {
    public static final Logger LOGGER = LoggerFactory.getLogger(CdcStreamPartitionMetadataTask.class);
    private static final String CDC_STREAM_STATUS_UPSERT_SQL = "UPSERT INTO " + PhoenixDatabaseMetaData.SYSTEM_CDC_STREAM_STATUS_NAME + " VALUES (?, ?, ?)";
    private static final String CDC_STREAM_PARTITION_UPSERT_SQL = "UPSERT INTO " + PhoenixDatabaseMetaData.SYSTEM_CDC_STREAM_NAME + " VALUES (?,?,?,?,?,?,?,?,?)";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskRegionObserver.TaskResult run(Task.TaskRecord taskRecord) {
        Configuration conf = HBaseConfiguration.create((Configuration)this.env.getConfiguration());
        Configuration configuration = HBaseConfiguration.addHbaseResources((Configuration)conf);
        int getTableRegionsTimeout = configuration.getInt("phoenix.streams.get.table.regions.timeout", 300000);
        PhoenixConnection pconn = null;
        String tableName = taskRecord.getTableName();
        String streamName = taskRecord.getSchemaName();
        Timestamp timestamp = taskRecord.getTimeStamp();
        try {
            pconn = QueryUtil.getConnectionOnServer((Configuration)this.env.getConfiguration()).unwrap(PhoenixConnection.class);
            List tableRegions = pconn.getQueryServices().getAllTableRegions(tableName.getBytes(), getTableRegionsTimeout);
            this.upsertPartitionMetadata(pconn, tableName, streamName, tableRegions);
            this.updateStreamStatus(pconn, tableName, streamName);
            TaskRegionObserver.TaskResult taskResult = new TaskRegionObserver.TaskResult(TaskRegionObserver.TaskResultCode.SUCCESS, "");
            return taskResult;
        }
        catch (SQLException e) {
            try {
                ServerTask.addTask(new SystemTaskParams.SystemTaskParamsBuilder().setConn(pconn).setTaskType(taskRecord.getTaskType()).setSchemaName(taskRecord.getSchemaName()).setTableName(taskRecord.getTableName()).setTaskStatus(PTable.TaskStatus.RETRY.toString()).setStartTs(taskRecord.getTimeStamp()).setEndTs(null).build());
                LOGGER.warn("Marking task as RETRY. SQLException while bootstrapping CDC Stream Partition Metadata for " + taskRecord.getTableName() + " and timestamp " + timestamp.toString(), (Throwable)e);
                TaskRegionObserver.TaskResult taskResult = null;
                return taskResult;
            }
            catch (IOException ioe) {
                LOGGER.error("Unable to mark task as RETRY. SQLException while bootstrapping CDC Stream Partition Metadata for " + taskRecord.getTableName() + " and timestamp " + timestamp.toString(), (Throwable)e);
                TaskRegionObserver.TaskResult ignored = new TaskRegionObserver.TaskResult(TaskRegionObserver.TaskResultCode.FAIL, e.toString());
                return ignored;
            }
        }
        catch (Throwable t) {
            LOGGER.error("Marking task as FAIL. Exception while bootstrapping CDC Stream Partition Metadata for " + taskRecord.getTableName() + " and timestamp " + timestamp.toString(), t);
            TaskRegionObserver.TaskResult taskResult = new TaskRegionObserver.TaskResult(TaskRegionObserver.TaskResultCode.FAIL, t.toString());
            return taskResult;
        }
        finally {
            if (pconn != null) {
                try {
                    pconn.close();
                }
                catch (SQLException ignored) {
                    LOGGER.debug("CdcStreamPartitionMetadataTask can't close connection", (Throwable)ignored);
                }
            }
        }
    }

    @Override
    public TaskRegionObserver.TaskResult checkCurrentResult(Task.TaskRecord taskRecord) throws Exception {
        return null;
    }

    private void updateStreamStatus(PhoenixConnection pconn, String tableName, String streamName) throws SQLException {
        try (PreparedStatement ps = pconn.prepareStatement(CDC_STREAM_STATUS_UPSERT_SQL);){
            ps.setString(1, tableName);
            ps.setString(2, streamName);
            ps.setString(3, CDCUtil.CdcStreamStatus.ENABLED.getSerializedValue());
            ps.executeUpdate();
            pconn.commit();
            LOGGER.info("Marked stream {} for table {} as ENABLED", (Object)streamName, (Object)tableName);
        }
    }

    private void upsertPartitionMetadata(PhoenixConnection pconn, String tableName, String streamName, List<HRegionLocation> tableRegions) throws SQLException {
        try (PreparedStatement ps = pconn.prepareStatement(CDC_STREAM_PARTITION_UPSERT_SQL);){
            for (HRegionLocation tableRegion : tableRegions) {
                RegionInfo ri = tableRegion.getRegion();
                ps.setString(1, tableName);
                ps.setString(2, streamName);
                ps.setString(3, ri.getEncodedName());
                ps.setNull(4, 12);
                ps.setLong(5, ri.getRegionId());
                ps.setNull(6, -5);
                ps.setBytes(7, ri.getStartKey());
                ps.setBytes(8, ri.getEndKey());
                ps.setNull(9, -5);
                ps.executeUpdate();
            }
            pconn.commit();
            LOGGER.info("Upserted {} partition metadata rows for table : {}, stream: {}", new Object[]{tableRegions.size(), tableName, streamName});
        }
    }
}

