/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.compile.ScanRanges;
import org.apache.phoenix.coprocessor.BaseRegionScanner;
import org.apache.phoenix.execute.TupleProjector;
import org.apache.phoenix.filter.SkipScanFilter;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.ResultTuple;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.ServerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UncoveredIndexRegionScanner
extends BaseRegionScanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(UncoveredIndexRegionScanner.class);
    protected State state = State.INITIAL;
    protected final byte[][] viewConstants;
    protected final RegionCoprocessorEnvironment env;
    protected long pageSizeInRows;
    protected final long ageThreshold;
    protected byte[] emptyCF;
    protected byte[] emptyCQ;
    protected final Scan scan;
    protected final Scan dataTableScan;
    protected final RegionScanner innerScanner;
    protected final Region region;
    protected final IndexMaintainer indexMaintainer;
    protected final TupleProjector tupleProjector;
    protected final ImmutableBytesWritable ptr;
    protected List<List<Cell>> indexRows = null;
    protected Map<ImmutableBytesPtr, Result> dataRows = null;
    protected Iterator<List<Cell>> indexRowIterator = null;
    protected Map<byte[], byte[]> indexToDataRowKeyMap = null;
    protected int indexRowCount = 0;
    protected final long pageSizeMs;
    protected byte[] lastIndexRowKey = null;
    private byte[] previousResultRowKey = null;
    private final byte[] initStartRowKey;
    private final boolean includeInitStartRowKey;

    public UncoveredIndexRegionScanner(RegionScanner innerScanner, Region region, Scan scan, RegionCoprocessorEnvironment env, Scan dataTableScan, TupleProjector tupleProjector, IndexMaintainer indexMaintainer, byte[][] viewConstants, ImmutableBytesWritable ptr, long pageSizeMs, long queryLimit) {
        super(innerScanner);
        Configuration config = env.getConfiguration();
        byte[] pageSizeFromScan = scan.getAttribute("_IndexPageRows");
        this.pageSizeInRows = pageSizeFromScan != null ? (long)((int)Bytes.toLong((byte[])pageSizeFromScan)) : (long)((int)config.getLong("phoenix.index.page_size_in_rows", 32768L));
        if (queryLimit != -1L) {
            this.pageSizeInRows = Long.min(this.pageSizeInRows, queryLimit);
        }
        this.ageThreshold = env.getConfiguration().getLong("phoenix.global.index.row.age.threshold.to.delete.ms", 604800000L);
        this.emptyCF = scan.getAttribute("_EmptyCFName");
        this.emptyCQ = scan.getAttribute("_EmptyCQName");
        this.indexMaintainer = indexMaintainer;
        this.viewConstants = viewConstants;
        this.scan = scan;
        this.dataTableScan = dataTableScan;
        this.innerScanner = innerScanner;
        this.region = region;
        this.env = env;
        this.ptr = ptr;
        this.tupleProjector = tupleProjector;
        this.pageSizeMs = pageSizeMs;
        this.initStartRowKey = ServerUtil.getScanStartRowKeyFromScanOrRegionBoundaries(scan, region);
        this.includeInitStartRowKey = scan.includeStartRow();
    }

    @Override
    public long getMvccReadPoint() {
        return this.innerScanner.getMvccReadPoint();
    }

    @Override
    public RegionInfo getRegionInfo() {
        return this.region.getRegionInfo();
    }

    @Override
    public boolean isFilterDone() {
        return false;
    }

    @Override
    public void close() throws IOException {
        this.innerScanner.close();
    }

    @Override
    public long getMaxResultSize() {
        return this.innerScanner.getMaxResultSize();
    }

    @Override
    public int getBatch() {
        return this.innerScanner.getBatch();
    }

    protected abstract void scanDataTableRows(long var1) throws IOException;

    protected Scan prepareDataTableScan(Collection<byte[]> dataRowKeys) throws IOException {
        return this.prepareDataTableScan(dataRowKeys, false);
    }

    protected Scan prepareDataTableScan(Collection<byte[]> dataRowKeys, boolean includeMultipleVersions) throws IOException {
        ArrayList<KeyRange> keys = new ArrayList<KeyRange>(dataRowKeys.size());
        for (byte[] dataRowKey : dataRowKeys) {
            if (this.dataRows.containsKey(new ImmutableBytesPtr(dataRowKey))) continue;
            keys.add(PVarbinary.INSTANCE.getKeyRange(dataRowKey, SortOrder.ASC));
        }
        if (!keys.isEmpty()) {
            ScanRanges scanRanges = ScanRanges.createPointLookup(keys);
            Scan dataScan = new Scan(this.dataTableScan);
            dataScan.setTimeRange(this.scan.getTimeRange().getMin(), this.scan.getTimeRange().getMax());
            scanRanges.initializeScan(dataScan);
            SkipScanFilter skipScanFilter = scanRanges.getSkipScanFilter();
            dataScan.setFilter((Filter)new SkipScanFilter(skipScanFilter, includeMultipleVersions, true));
            dataScan.setAttribute("_ServerPageSizeMs", Bytes.toBytes((long)this.pageSizeMs));
            return dataScan;
        }
        LOGGER.info("All data rows have already been fetched");
        return null;
    }

    protected boolean scanIndexTableRows(List<Cell> result, long startTime, byte[] actualStartKey, int offset, ScannerContext scannerContext) throws IOException {
        boolean hasMore = false;
        if (actualStartKey != null) {
            do {
                boolean bl = hasMore = scannerContext != null ? this.innerScanner.nextRaw(result, scannerContext) : this.innerScanner.nextRaw(result);
                if (result.isEmpty()) {
                    return hasMore;
                }
                if (ScanUtil.isDummy(result)) {
                    return true;
                }
                Cell firstCell = result.get(0);
                if (Bytes.compareTo((byte[])firstCell.getRowArray(), (int)firstCell.getRowOffset(), (int)firstCell.getRowLength(), (byte[])actualStartKey, (int)0, (int)actualStartKey.length) >= 0) break;
                result.clear();
                if (EnvironmentEdgeManager.currentTimeMillis() - startTime < this.pageSizeMs) continue;
                byte[] rowKey = CellUtil.cloneRow((Cell)firstCell);
                ScanUtil.getDummyResult((byte[])rowKey, result);
                return true;
            } while (hasMore);
        }
        do {
            ArrayList<Cell> row = new ArrayList<Cell>();
            if (result.isEmpty()) {
                hasMore = scannerContext != null ? this.innerScanner.nextRaw(row, scannerContext) : this.innerScanner.nextRaw(row);
            } else {
                row.addAll(result);
                result.clear();
            }
            if (row.isEmpty()) continue;
            if (ScanUtil.isDummy(row)) {
                result.addAll(row);
                return true;
            }
            Cell firstCell = (Cell)row.get(0);
            this.lastIndexRowKey = ImmutableBytesPtr.copyBytesIfNecessary((byte[])firstCell.getRowArray(), (int)(firstCell.getRowOffset() + offset), (int)(firstCell.getRowLength() - offset));
            this.indexToDataRowKeyMap.put(offset == 0 ? this.lastIndexRowKey : CellUtil.cloneRow((Cell)firstCell), this.indexMaintainer.buildDataRowKey(new ImmutableBytesWritable(this.lastIndexRowKey), this.viewConstants));
            this.indexRows.add(row);
            ++this.indexRowCount;
            if (!hasMore || EnvironmentEdgeManager.currentTimeMillis() - startTime < this.pageSizeMs) continue;
            ScanUtil.getDummyResult((byte[])this.lastIndexRowKey, result);
            return true;
        } while (hasMore && (long)this.indexRowCount < this.pageSizeInRows);
        return hasMore;
    }

    protected boolean scanIndexTableRows(List<Cell> result, long startTime, ScannerContext scannerContext) throws IOException {
        return this.scanIndexTableRows(result, startTime, null, 0, scannerContext);
    }

    private boolean verifyIndexRowAndRepairIfNecessary(Result dataRow, byte[] indexRowKey, long indexTimestamp) throws IOException {
        Put put = new Put(dataRow.getRow());
        for (Cell cell : dataRow.rawCells()) {
            put.add(cell);
        }
        if (this.indexMaintainer.isCDCIndex()) {
            if (this.scan.isRaw() || IndexUtil.getMaxTimestamp((Mutation)put) == indexTimestamp) {
                return true;
            }
        } else if (this.indexMaintainer.checkIndexRow(indexRowKey, put)) {
            if (IndexUtil.getMaxTimestamp((Mutation)put) != indexTimestamp) {
                Mutation[] mutations;
                Put indexPut = new Put(indexRowKey);
                indexPut.addColumn(this.emptyCF, this.emptyCQ, indexTimestamp, QueryConstants.VERIFIED_BYTES);
                if (EnvironmentEdgeManager.currentTimeMillis() - indexTimestamp > this.ageThreshold) {
                    Delete indexDelete = this.indexMaintainer.buildRowDeleteMutation(indexRowKey, IndexMaintainer.DeleteType.SINGLE_VERSION, indexTimestamp);
                    mutations = new Mutation[]{indexPut, indexDelete};
                } else {
                    mutations = new Mutation[]{indexPut};
                }
                this.region.batchMutate(mutations);
            }
            return true;
        }
        if (this.indexMaintainer.isAgedEnough(IndexUtil.getMaxTimestamp((Mutation)put), this.ageThreshold).booleanValue() && !this.indexMaintainer.isCDCIndex()) {
            this.region.delete(this.indexMaintainer.createDelete(indexRowKey, IndexUtil.getMaxTimestamp((Mutation)put), false));
        }
        return false;
    }

    protected boolean getNextCoveredIndexRow(List<Cell> result) throws IOException {
        if (this.indexRowIterator.hasNext()) {
            List<Cell> indexRow = this.indexRowIterator.next();
            result.addAll(indexRow);
            try {
                byte[] indexRowKey = CellUtil.cloneRow((Cell)indexRow.get(0));
                Result dataRow = this.dataRows.get(new ImmutableBytesPtr(this.indexToDataRowKeyMap.get(indexRowKey)));
                if (dataRow != null) {
                    long ts = indexRow.get(0).getTimestamp();
                    if (!this.indexMaintainer.isUncovered() || this.verifyIndexRowAndRepairIfNecessary(dataRow, indexRowKey, ts)) {
                        if (this.tupleProjector != null) {
                            IndexUtil.addTupleAsOneCell(result, (Tuple)new ResultTuple(dataRow), (TupleProjector)this.tupleProjector, (ImmutableBytesWritable)this.ptr);
                        }
                    } else {
                        result.clear();
                    }
                } else if (this.indexMaintainer.isUncovered()) {
                    long ts = indexRow.get(0).getTimestamp();
                    if (this.indexMaintainer.isAgedEnough(ts, this.ageThreshold).booleanValue()) {
                        this.region.delete(this.indexMaintainer.createDelete(indexRowKey, ts, false));
                    }
                    result.clear();
                }
            }
            catch (Throwable e) {
                LOGGER.error("Exception in UncoveredIndexRegionScanner for region " + this.region.getRegionInfo().getRegionNameAsString(), e);
                throw e;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean next(List<Cell> result) throws IOException {
        return this.next(result, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean next(List<Cell> result, ScannerContext scannerContext) throws IOException {
        block14: {
            block13: {
                startTime = EnvironmentEdgeManager.currentTimeMillis();
                this.region.startRegionOperation();
                var6_4 = this.innerScanner;
                // MONITORENTER : var6_4
                if (this.state == State.READY && !this.indexRowIterator.hasNext()) {
                    this.state = State.INITIAL;
                }
                if (this.state == State.INITIAL) {
                    this.indexRowCount = 0;
                    this.indexRows = new ArrayList<List<Cell>>();
                    this.dataRows = Maps.newConcurrentMap();
                    this.indexToDataRowKeyMap = Maps.newTreeMap((Comparator)Bytes.BYTES_COMPARATOR);
                    this.state = State.SCANNING_INDEX;
                }
                if (this.state != State.SCANNING_INDEX) ** GOTO lbl25
                hasMore = this.scanIndexTableRows(result, startTime, scannerContext);
                if (!ScanUtil.isDummy(result)) break block13;
                this.updateDummyWithPrevRowKey(result, this.initStartRowKey, this.includeInitStartRowKey, this.scan);
                var7_7 = hasMore;
                // MONITOREXIT : var6_4
                this.region.closeRegionOperation();
                return var7_7;
            }
            this.state = State.SCANNING_DATA;
lbl25:
            // 2 sources

            if (this.state == State.SCANNING_DATA) {
                this.scanDataTableRows(startTime);
                this.indexRowIterator = this.indexRows.iterator();
            }
            if (this.state != State.READY) break block14;
            moreRows = this.getNextCoveredIndexRow(result);
            if (!result.isEmpty()) {
                this.previousResultRowKey = CellUtil.cloneRow((Cell)result.get(0));
            }
            var8_10 = moreRows;
            // MONITOREXIT : var6_4
            {
                catch (Throwable e) {
                    UncoveredIndexRegionScanner.LOGGER.error("Exception in UncoveredIndexRegionScanner for region " + this.region.getRegionInfo().getRegionNameAsString(), e);
                    throw e;
                }
            }
            this.region.closeRegionOperation();
            return var8_10;
        }
        this.updateDummyWithPrevRowKey(result, this.initStartRowKey, this.includeInitStartRowKey, this.scan);
        var7_9 = true;
        // MONITOREXIT : var6_4
        this.region.closeRegionOperation();
        return var7_9;
        catch (Throwable var10_11) {
            this.region.closeRegionOperation();
            throw var10_11;
        }
    }

    private void updateDummyWithPrevRowKey(List<Cell> result, byte[] initStartRowKey, boolean includeInitStartRowKey, Scan scan) {
        result.clear();
        if (this.previousResultRowKey != null) {
            ScanUtil.getDummyResult((byte[])this.previousResultRowKey, result);
        } else if (includeInitStartRowKey && initStartRowKey.length > 0) {
            byte[] prevKey;
            int regionLookupInMetaLen = RegionInfo.createRegionName((TableName)this.region.getTableDescriptor().getTableName(), (byte[])new byte[1], (String)"99999999999999", (boolean)false).length;
            if (Bytes.compareTo((byte[])initStartRowKey, (int)(initStartRowKey.length - 1), (int)1, (byte[])ByteUtil.ZERO_BYTE, (int)0, (int)1) == 0) {
                prevKey = new byte[initStartRowKey.length - 1];
                System.arraycopy(initStartRowKey, 0, prevKey, 0, prevKey.length);
            } else {
                prevKey = initStartRowKey.length < 32766 - regionLookupInMetaLen ? ByteUtil.previousKeyWithLength((byte[])ByteUtil.concat((byte[])initStartRowKey, (byte[][])new byte[][]{new byte[Short.MAX_VALUE - initStartRowKey.length - 1 - regionLookupInMetaLen]}), (int)(32766 - regionLookupInMetaLen)) : initStartRowKey;
            }
            ScanUtil.getDummyResult((byte[])prevKey, result);
        } else {
            ScanUtil.getDummyResult((byte[])initStartRowKey, result);
        }
    }

    protected static enum State {
        INITIAL,
        SCANNING_INDEX,
        SCANNING_DATA,
        SCANNING_DATA_INTERRUPTED,
        READY;

    }
}

