/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import java.io.IOException;
import java.util.Optional;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.phoenix.filter.SystemCatalogViewIndexIdFilter;
import org.apache.phoenix.util.ScanUtil;

public class SystemCatalogRegionObserver
implements RegionObserver,
RegionCoprocessor {
    public void preScannerOpen(ObserverContext<RegionCoprocessorEnvironment> e, Scan scan) throws IOException {
        int clientVersion = ScanUtil.getClientVersion((Scan)scan);
        if (clientVersion != ScanUtil.UNKNOWN_CLIENT_VERSION) {
            ScanUtil.andFilterAtBeginning((Scan)scan, (Filter)new SystemCatalogViewIndexIdFilter(clientVersion));
        }
    }

    public Optional<RegionObserver> getRegionObserver() {
        return Optional.of(this);
    }
}

