/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.NavigableMap;
import java.util.Optional;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.regionserver.MiniBatchOperationInProgress;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.coprocessor.BaseScannerRegionObserver;
import org.apache.phoenix.coprocessor.generated.DynamicColumnMetaDataProtos;
import org.apache.phoenix.coprocessor.generated.PTableProtos;
import org.apache.phoenix.coprocessorclient.ScanRegionObserverConstants;
import org.apache.phoenix.hbase.index.metrics.GlobalIndexCheckerSource;
import org.apache.phoenix.hbase.index.metrics.MetricsIndexerSourceFactory;
import org.apache.phoenix.index.GlobalIndexChecker;
import org.apache.phoenix.iterate.NonAggregateRegionScannerFactory;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnImpl;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.util.ClientUtil;
import org.apache.phoenix.util.ScanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanRegionObserver
extends BaseScannerRegionObserver
implements RegionCoprocessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScanRegionObserver.class);
    private static boolean readRepairTransformingTable = false;
    private static GlobalIndexChecker.GlobalIndexScanner globalIndexScanner;
    private static GlobalIndexChecker globalIndexChecker;
    private static GlobalIndexCheckerSource metricsSource;

    public Optional<RegionObserver> getRegionObserver() {
        return Optional.of(this);
    }

    public void preBatchMutate(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
        try {
            this.preBatchMutateWithExceptions(miniBatchOp, ((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion().getTableDescriptor().getTableName().getNameAsString());
        }
        catch (Throwable t) {
            throw ClientUtil.createIOException((String)("Unable to Put cells corresponding to dynamiccolumn metadata for " + ((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion().getRegionInfo().getTable().getNameAsString()), (Throwable)t);
        }
    }

    private void preBatchMutateWithExceptions(MiniBatchOperationInProgress<Mutation> miniBatchOp, String tableName) throws IOException {
        for (int i = 0; i < miniBatchOp.size(); ++i) {
            Mutation m = (Mutation)miniBatchOp.getOperation(i);
            Put dynColShadowCellsPut = null;
            if (m instanceof Put && Bytes.equals((byte[])m.getAttribute("_DynColsMetadataStoredForMutation"), (byte[])PDataType.TRUE_BYTES)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Adding dynamic column metadata for table: " + tableName + ". Put :" + m.toString());
                }
                NavigableMap famCellMap = m.getFamilyCellMap();
                for (byte[] fam : famCellMap.keySet()) {
                    List dynColsInThisFam;
                    byte[] serializedDynColsList = m.getAttribute(Bytes.toString((byte[])fam));
                    if (serializedDynColsList == null || (dynColsInThisFam = DynamicColumnMetaDataProtos.DynamicColumnMetaData.parseFrom((byte[])serializedDynColsList).getDynamicColumnsList()).isEmpty()) continue;
                    if (dynColShadowCellsPut == null) {
                        dynColShadowCellsPut = new Put(m.getRow());
                    }
                    for (PTableProtos.PColumn dynColProto : dynColsInThisFam) {
                        dynColShadowCellsPut.addColumn(fam, ScanRegionObserver.getQualifierForDynamicColumnMetaDataCell(dynColProto), dynColProto.toByteArray());
                    }
                }
            }
            if (dynColShadowCellsPut == null) continue;
            miniBatchOp.addOperationsFromCP(i, new Mutation[]{dynColShadowCellsPut});
        }
    }

    private static byte[] getQualifierForDynamicColumnMetaDataCell(PTableProtos.PColumn dynColProto) throws IOException {
        PColumn dynCol = PColumnImpl.createFromProto((PTableProtos.PColumn)dynColProto);
        ByteArrayOutputStream qual = new ByteArrayOutputStream();
        qual.write(ScanRegionObserverConstants.DYN_COLS_METADATA_CELL_QUALIFIER);
        qual.write(dynCol.getColumnQualifierBytes());
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Storing shadow cell for dynamic column metadata for dynamic column : " + dynCol.getFamilyName().getString() + "." + dynCol.getName().getString());
        }
        return qual.toByteArray();
    }

    @Override
    protected RegionScanner doPostScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Scan scan, RegionScanner s) throws Throwable {
        NonAggregateRegionScannerFactory nonAggregateROUtil = new NonAggregateRegionScannerFactory((RegionCoprocessorEnvironment)c.getEnvironment());
        if (scan.getAttribute("_ReadRepairTransformingTable") != null) {
            readRepairTransformingTable = true;
            GlobalIndexChecker globalIndexChecker = ScanRegionObserver.globalIndexChecker;
            globalIndexChecker.getClass();
            globalIndexScanner = new GlobalIndexChecker.GlobalIndexScanner(globalIndexChecker, (RegionCoprocessorEnvironment)c.getEnvironment(), scan, s, metricsSource);
            return nonAggregateROUtil.getRegionScanner(scan, globalIndexScanner);
        }
        return nonAggregateROUtil.getRegionScanner(scan, s);
    }

    @Override
    protected boolean skipRegionBoundaryCheck(Scan scan) {
        return super.skipRegionBoundaryCheck(scan) || ScanUtil.isSimpleScan((Scan)scan);
    }

    @Override
    protected boolean isRegionObserverFor(Scan scan) {
        return ScanUtil.isNonAggregateScan((Scan)scan);
    }

    static {
        globalIndexChecker = new GlobalIndexChecker();
        metricsSource = MetricsIndexerSourceFactory.getInstance().getGlobalIndexCheckerSource();
    }
}

