/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionServerObserver;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.WALProtos;

public class ReplicationSinkEndpoint
implements RegionServerCoprocessor,
RegionServerObserver {
    public Optional<RegionServerObserver> getRegionServerObserver() {
        return Optional.of(this);
    }

    public void preReplicationSinkBatchMutate(ObserverContext<RegionServerCoprocessorEnvironment> ctx, AdminProtos.WALEntry walEntry, Mutation mutation) throws IOException {
        super.preReplicationSinkBatchMutate(ctx, walEntry, mutation);
        List attributeList = walEntry.getKey().getExtendedAttributesList();
        this.attachWALExtendedAttributesToMutation(mutation, attributeList);
    }

    private void attachWALExtendedAttributesToMutation(Mutation mutation, List<WALProtos.Attribute> attributeList) {
        if (attributeList != null) {
            for (WALProtos.Attribute attribute : attributeList) {
                mutation.setAttribute(attribute.getKey(), attribute.getValue().toByteArray());
            }
        }
    }
}

