/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import com.google.protobuf.Service;
import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessor;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.cache.ServerMetadataCache;
import org.apache.phoenix.cache.ServerMetadataCacheImpl;
import org.apache.phoenix.coprocessor.VerifyLastDDLTimestamp;
import org.apache.phoenix.coprocessor.generated.RegionServerEndpointProtos;
import org.apache.phoenix.coprocessorclient.metrics.MetricsMetadataCachingSource;
import org.apache.phoenix.coprocessorclient.metrics.MetricsPhoenixCoprocessorSourceFactory;
import org.apache.phoenix.hbase.index.parallel.TaskRunner;
import org.apache.phoenix.hbase.index.parallel.ThreadPoolBuilder;
import org.apache.phoenix.hbase.index.parallel.ThreadPoolManager;
import org.apache.phoenix.hbase.index.parallel.WaitForCompletionTaskRunner;
import org.apache.phoenix.jdbc.HAGroupStoreManager;
import org.apache.phoenix.protobuf.ProtobufUtil;
import org.apache.phoenix.util.ClientUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.ServerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoenixRegionServerEndpoint
extends RegionServerEndpointProtos.RegionServerEndpointService
implements RegionServerCoprocessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhoenixRegionServerEndpoint.class);
    private MetricsMetadataCachingSource metricsSource;
    protected Configuration conf;
    private static TaskRunner uncoveredIndexThreadPool;

    public void start(CoprocessorEnvironment env) throws IOException {
        this.conf = env.getConfiguration();
        this.metricsSource = MetricsPhoenixCoprocessorSourceFactory.getInstance().getMetadataCachingSource();
        PhoenixRegionServerEndpoint.initUncoveredIndexThreadPool(this.conf);
    }

    public void stop(CoprocessorEnvironment env) throws IOException {
        super.stop(env);
        if (uncoveredIndexThreadPool != null) {
            uncoveredIndexThreadPool.stop("PhoenixRegionServerEndpoint is stopping. Shutting down uncovered index threadpool.");
        }
        ServerUtil.ConnectionFactory.shutdown();
    }

    public void validateLastDDLTimestamp(RpcController controller, RegionServerEndpointProtos.ValidateLastDDLTimestampRequest request, RpcCallback<RegionServerEndpointProtos.ValidateLastDDLTimestampResponse> done) {
        this.metricsSource.incrementValidateTimestampRequestCount();
        ServerMetadataCache cache = this.getServerMetadataCache();
        for (RegionServerEndpointProtos.LastDDLTimestampRequest lastDDLTimestampRequest : request.getLastDDLTimestampRequestsList()) {
            byte[] tenantID = lastDDLTimestampRequest.getTenantId().toByteArray();
            byte[] schemaName = lastDDLTimestampRequest.getSchemaName().toByteArray();
            byte[] tableName = lastDDLTimestampRequest.getTableName().toByteArray();
            long clientLastDDLTimestamp = lastDDLTimestampRequest.getLastDDLTimestamp();
            String tenantIDStr = Bytes.toString((byte[])tenantID);
            String fullTableName = SchemaUtil.getTableName((byte[])schemaName, (byte[])tableName);
            try {
                VerifyLastDDLTimestamp.verifyLastDDLTimestamp(cache, tenantID, schemaName, tableName, clientLastDDLTimestamp);
            }
            catch (Throwable t) {
                String errorMsg = String.format("Verifying last ddl timestamp FAILED for tenantID: %s,  fullTableName: %s", tenantIDStr, fullTableName);
                LOGGER.error(errorMsg, t);
                IOException ioe = ClientUtil.createIOException((String)errorMsg, (Throwable)t);
                ProtobufUtil.setControllerException((RpcController)controller, (IOException)ioe);
                break;
            }
        }
    }

    public void invalidateServerMetadataCache(RpcController controller, RegionServerEndpointProtos.InvalidateServerMetadataCacheRequest request, RpcCallback<RegionServerEndpointProtos.InvalidateServerMetadataCacheResponse> done) {
        for (RegionServerEndpointProtos.InvalidateServerMetadataCache invalidateCacheRequest : request.getInvalidateServerMetadataCacheRequestsList()) {
            byte[] tenantID = invalidateCacheRequest.getTenantId().toByteArray();
            byte[] schemaName = invalidateCacheRequest.getSchemaName().toByteArray();
            byte[] tableName = invalidateCacheRequest.getTableName().toByteArray();
            String fullTableName = SchemaUtil.getTableName((byte[])schemaName, (byte[])tableName);
            String tenantIDStr = Bytes.toString((byte[])tenantID);
            LOGGER.info("PhoenixRegionServerEndpoint invalidating the cache for tenantID: {}, tableName: {}", (Object)tenantIDStr, (Object)fullTableName);
            ServerMetadataCache cache = this.getServerMetadataCache();
            cache.invalidate(tenantID, schemaName, tableName);
        }
    }

    public void invalidateHAGroupStoreClient(RpcController controller, RegionServerEndpointProtos.InvalidateHAGroupStoreClientRequest request, RpcCallback<RegionServerEndpointProtos.InvalidateHAGroupStoreClientResponse> done) {
        LOGGER.info("PhoenixRegionServerEndpoint invalidating HAGroupStoreClient");
        try {
            HAGroupStoreManager haGroupStoreManager = HAGroupStoreManager.getInstance((Configuration)this.conf);
            haGroupStoreManager.invalidateHAGroupStoreClient();
        }
        catch (Throwable t) {
            String errorMsg = "Invalidating HAGroupStoreClient FAILED, check exception for specific details";
            LOGGER.error(errorMsg, t);
            IOException ioe = ClientUtil.createIOException((String)errorMsg, (Throwable)t);
            ProtobufUtil.setControllerException((RpcController)controller, (IOException)ioe);
        }
    }

    public Iterable<Service> getServices() {
        return Collections.singletonList(this);
    }

    public ServerMetadataCache getServerMetadataCache() {
        return ServerMetadataCacheImpl.getInstance((Configuration)this.conf);
    }

    public static TaskRunner getUncoveredIndexThreadPool() {
        return uncoveredIndexThreadPool;
    }

    private static void initUncoveredIndexThreadPool(Configuration conf) {
        uncoveredIndexThreadPool = new WaitForCompletionTaskRunner((ExecutorService)ThreadPoolManager.getExecutor(new ThreadPoolBuilder("Uncovered Global Index", conf).setMaxThread("phoenix.uncovered.index.threads.max", 512).setCoreTimeout("phoenix.uncovered.index.threads.keepalive.sec", 60L)));
        LOGGER.info("Initialized region level thread pool for Uncovered Global Indexes.");
    }
}

