/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.coprocessor.BaseEnvironment;
import org.apache.hadoop.hbase.coprocessor.CoprocessorHost;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionCoprocessorHost;
import org.apache.hadoop.hbase.security.User;
import org.apache.phoenix.coprocessor.MetaDataEndpointObserver;
import org.apache.phoenix.coprocessor.PhoenixCoprocessor;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;

public class PhoenixMetaDataCoprocessorHost
extends CoprocessorHost<PhoenixCoprocessor, PhoenixMetaDataControllerEnvironment> {
    private RegionCoprocessorEnvironment env;
    public static final String PHOENIX_META_DATA_COPROCESSOR_CONF_KEY = "hbase.coprocessor.phoenix.classes";
    private static final String DEFAULT_PHOENIX_META_DATA_COPROCESSOR_CONF_KEY = "org.apache.phoenix.coprocessor.PhoenixAccessController";
    private CoprocessorHost.ObserverGetter<PhoenixCoprocessor, MetaDataEndpointObserver> phoenixObserverGetter = PhoenixCoprocessor::getPhoenixObserver;

    PhoenixMetaDataCoprocessorHost(RegionCoprocessorEnvironment env) throws IOException {
        super(null);
        this.env = env;
        this.conf = new Configuration();
        for (Map.Entry entry : env.getConfiguration()) {
            this.conf.set((String)entry.getKey(), (String)entry.getValue());
        }
        boolean accessCheckEnabled = this.conf.getBoolean("phoenix.acls.enabled", false);
        if (this.conf.get(PHOENIX_META_DATA_COPROCESSOR_CONF_KEY) == null && accessCheckEnabled) {
            this.conf.set(PHOENIX_META_DATA_COPROCESSOR_CONF_KEY, DEFAULT_PHOENIX_META_DATA_COPROCESSOR_CONF_KEY);
        }
        this.loadSystemCoprocessors(this.conf, PHOENIX_META_DATA_COPROCESSOR_CONF_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean execOperation(PhoenixObserverOperation ctx) throws IOException {
        if (ctx == null) {
            return false;
        }
        boolean bypass = false;
        for (PhoenixMetaDataControllerEnvironment env : this.coprocEnvironments) {
            if (env.getInstance() instanceof MetaDataEndpointObserver) {
                ctx.prepare(env);
                Thread currentThread = Thread.currentThread();
                ClassLoader cl = currentThread.getContextClassLoader();
                try {
                    currentThread.setContextClassLoader(env.getClassLoader());
                    ctx.callObserver();
                }
                catch (Throwable e) {
                    this.handleCoprocessorThrowable(env, e);
                }
                finally {
                    currentThread.setContextClassLoader(cl);
                }
                if (bypass |= ctx.shouldBypass()) break;
            }
            ctx.postEnvCall();
        }
        return bypass;
    }

    protected void handleCoprocessorThrowable(PhoenixMetaDataControllerEnvironment env, Throwable e) throws IOException {
        if (e instanceof IOException && e.getCause() instanceof DoNotRetryIOException) {
            throw (IOException)e.getCause();
        }
        super.handleCoprocessorThrowable((CoprocessorEnvironment)env, e);
    }

    void preGetTable(final String tenantId, final String tableName, final TableName physicalTableName) throws IOException {
        this.execOperation(new PhoenixObserverOperation(){

            public void call(MetaDataEndpointObserver observer) throws IOException {
                observer.preGetTable((ObserverContext<PhoenixMetaDataControllerEnvironment>)this, tenantId, tableName, physicalTableName);
            }
        });
    }

    void preCreateTable(final String tenantId, final String tableName, final TableName physicalTableName, final TableName parentPhysicalTableName, final PTableType tableType, final Set<byte[]> familySet, final Set<TableName> indexes) throws IOException {
        this.execOperation(new PhoenixObserverOperation(){

            public void call(MetaDataEndpointObserver observer) throws IOException {
                observer.preCreateTable((ObserverContext<PhoenixMetaDataControllerEnvironment>)this, tenantId, tableName, physicalTableName, parentPhysicalTableName, tableType, familySet, indexes);
            }
        });
    }

    void preCreateViewAddChildLink(final String tableName) throws IOException {
        this.execOperation(new PhoenixObserverOperation(){

            public void call(MetaDataEndpointObserver observer) throws IOException {
                observer.preCreateViewAddChildLink((ObserverContext<PhoenixMetaDataControllerEnvironment>)this, tableName);
            }
        });
    }

    void preDropTable(final String tenantId, final String tableName, final TableName physicalTableName, final TableName parentPhysicalTableName, final PTableType tableType, final List<PTable> indexes) throws IOException {
        this.execOperation(new PhoenixObserverOperation(){

            public void call(MetaDataEndpointObserver observer) throws IOException {
                observer.preDropTable((ObserverContext<PhoenixMetaDataControllerEnvironment>)this, tenantId, tableName, physicalTableName, parentPhysicalTableName, tableType, indexes);
            }
        });
    }

    void preAlterTable(final String tenantId, final String tableName, final TableName physicalTableName, final TableName parentPhysicalTableName, final PTableType type) throws IOException {
        this.execOperation(new PhoenixObserverOperation(){

            public void call(MetaDataEndpointObserver observer) throws IOException {
                observer.preAlterTable((ObserverContext<PhoenixMetaDataControllerEnvironment>)this, tenantId, tableName, physicalTableName, parentPhysicalTableName, type);
            }
        });
    }

    void preGetSchema(final String schemaName) throws IOException {
        this.execOperation(new PhoenixObserverOperation(){

            public void call(MetaDataEndpointObserver observer) throws IOException {
                observer.preGetSchema((ObserverContext<PhoenixMetaDataControllerEnvironment>)this, schemaName);
            }
        });
    }

    public void preCreateSchema(final String schemaName) throws IOException {
        this.execOperation(new PhoenixObserverOperation(){

            public void call(MetaDataEndpointObserver observer) throws IOException {
                observer.preCreateSchema((ObserverContext<PhoenixMetaDataControllerEnvironment>)this, schemaName);
            }
        });
    }

    void preDropSchema(final String schemaName) throws IOException {
        this.execOperation(new PhoenixObserverOperation(){

            public void call(MetaDataEndpointObserver observer) throws IOException {
                observer.preDropSchema((ObserverContext<PhoenixMetaDataControllerEnvironment>)this, schemaName);
            }
        });
    }

    void preIndexUpdate(final String tenantId, final String indexName, final TableName physicalTableName, final TableName parentPhysicalTableName, final PIndexState newState) throws IOException {
        this.execOperation(new PhoenixObserverOperation(){

            public void call(MetaDataEndpointObserver observer) throws IOException {
                observer.preIndexUpdate((ObserverContext<PhoenixMetaDataControllerEnvironment>)this, tenantId, indexName, physicalTableName, parentPhysicalTableName, newState);
            }
        });
    }

    public PhoenixCoprocessor checkAndGetInstance(Class<?> implClass) throws InstantiationException, IllegalAccessException {
        if (PhoenixCoprocessor.class.isAssignableFrom(implClass)) {
            return (PhoenixCoprocessor)implClass.newInstance();
        }
        return null;
    }

    public PhoenixMetaDataControllerEnvironment createEnvironment(PhoenixCoprocessor instance, int priority, int sequence, Configuration conf) {
        return new PhoenixMetaDataControllerEnvironment(this.env, instance, priority, sequence, conf);
    }

    void preUpsertTaskDetails(final String tableName) throws IOException {
        this.execOperation(new PhoenixObserverOperation(){

            public void call(MetaDataEndpointObserver observer) throws IOException {
                observer.preUpsertTaskDetails((ObserverContext<PhoenixMetaDataControllerEnvironment>)this, tableName);
            }
        });
    }

    public static class PhoenixMetaDataControllerEnvironment
    extends BaseEnvironment<PhoenixCoprocessor>
    implements CoprocessorEnvironment<PhoenixCoprocessor> {
        private RegionCoprocessorEnvironment env;

        PhoenixMetaDataControllerEnvironment(RegionCoprocessorEnvironment env, PhoenixCoprocessor instance, int priority, int sequence, Configuration conf) {
            super((Coprocessor)instance, priority, sequence, conf);
            this.env = env;
        }

        public RegionCoprocessorHost getCoprocessorHost() {
            return ((HRegion)this.env.getRegion()).getCoprocessorHost();
        }

        RegionCoprocessorEnvironment getRegionCoprocessorEnvironment() {
            return this.env;
        }
    }

    private abstract class PhoenixObserverOperation
    extends CoprocessorHost.ObserverOperationWithoutResult<MetaDataEndpointObserver> {
        PhoenixObserverOperation() {
            super((CoprocessorHost)PhoenixMetaDataCoprocessorHost.this, PhoenixMetaDataCoprocessorHost.this.phoenixObserverGetter);
        }

        public PhoenixObserverOperation(User user) {
            super((CoprocessorHost)PhoenixMetaDataCoprocessorHost.this, PhoenixMetaDataCoprocessorHost.this.phoenixObserverGetter, user);
        }

        public PhoenixObserverOperation(User user, boolean bypassable) {
            super((CoprocessorHost)PhoenixMetaDataCoprocessorHost.this, PhoenixMetaDataCoprocessorHost.this.phoenixObserverGetter, user, bypassable);
        }

        void callObserver() throws IOException {
            Optional observer = (Optional)PhoenixMetaDataCoprocessorHost.this.phoenixObserverGetter.apply((Object)((PhoenixMetaDataControllerEnvironment)this.getEnvironment()).getInstance());
            if (observer.isPresent()) {
                this.call(observer.get());
            }
        }

        protected void postEnvCall() {
        }
    }
}

