/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.PackagePrivateFieldAccessor;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.coprocessor.BaseRegionScanner;
import org.apache.phoenix.filter.PagingFilter;
import org.apache.phoenix.filter.SkipScanFilter;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.ScanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PagingRegionScanner
extends BaseRegionScanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(PagingRegionScanner.class);
    private Region region;
    private Scan scan;
    private PagingFilter pagingFilter;
    private MultiKeyPointLookup multiKeyPointLookup = null;
    private boolean initialized = false;

    public PagingRegionScanner(Region region, RegionScanner scanner, Scan scan) {
        super(scanner);
        this.region = region;
        this.scan = scan;
        this.pagingFilter = ScanUtil.getPhoenixPagingFilter((Scan)scan);
    }

    @VisibleForTesting
    public static boolean useBloomFilterForMultiKeyPointLookup(TableDescriptor tableDescriptor) {
        String useBloomFilter = tableDescriptor.getValue("phoenix.bloomfilter.multikey.pointlookup");
        return Boolean.valueOf(useBloomFilter);
    }

    private boolean useBloomFilterForMultiKeyPointLookup() {
        return PagingRegionScanner.useBloomFilterForMultiKeyPointLookup(this.region.getTableDescriptor());
    }

    void init() throws IOException {
        SkipScanFilter skipScanFilter;
        if (this.initialized) {
            return;
        }
        TableDescriptor tableDescriptor = this.region.getTableDescriptor();
        BloomType bloomFilterType = tableDescriptor.getColumnFamilies()[0].getBloomFilterType();
        if (bloomFilterType == BloomType.ROW && this.useBloomFilterForMultiKeyPointLookup() && (skipScanFilter = ScanUtil.removeSkipScanFilter((Scan)this.scan)) != null) {
            this.multiKeyPointLookup = new MultiKeyPointLookup(skipScanFilter);
        }
        this.initialized = true;
    }

    private boolean next(List<Cell> results, boolean raw, ScannerContext scannerContext) throws IOException {
        boolean hasMore;
        this.init();
        if (this.pagingFilter != null) {
            this.pagingFilter.init();
        }
        byte[] adjustedStartRowKey = this.scan.getAttribute("phoenix.paging.start.newscan.startrow");
        byte[] adjustedStartRowKeyIncludeBytes = this.scan.getAttribute("phoenix.paging.start.newscan.startrow.include");
        if (adjustedStartRowKey != null && adjustedStartRowKeyIncludeBytes != null) {
            long mvccReadPoint = this.delegate.getMvccReadPoint();
            this.delegate.close();
            this.scan.withStartRow(adjustedStartRowKey, Bytes.toBoolean((byte[])adjustedStartRowKeyIncludeBytes));
            PackagePrivateFieldAccessor.setMvccReadPoint((Scan)this.scan, (long)mvccReadPoint);
            if (this.multiKeyPointLookup != null && !this.multiKeyPointLookup.verifyStartRowKey(adjustedStartRowKey)) {
                return false;
            }
            this.delegate = this.region.getScanner(this.scan);
            this.scan.setAttribute("phoenix.paging.start.newscan.startrow", null);
            this.scan.setAttribute("phoenix.paging.start.newscan.startrow.include", null);
        } else if (this.multiKeyPointLookup != null) {
            RegionScanner regionScanner = this.multiKeyPointLookup.getNewScanner();
            if (regionScanner == null) {
                return false;
            }
            this.delegate.close();
            this.delegate = regionScanner;
        }
        if (this.multiKeyPointLookup != null) {
            return this.multiKeyPointLookup.next(results, raw, this.delegate, scannerContext);
        }
        if (scannerContext != null) {
            hasMore = raw ? this.delegate.nextRaw(results, scannerContext) : this.delegate.next(results, scannerContext);
        } else {
            boolean bl = hasMore = raw ? this.delegate.nextRaw(results) : this.delegate.next(results);
        }
        if (this.pagingFilter == null) {
            return hasMore;
        }
        if (!hasMore) {
            if (this.pagingFilter.isStopped()) {
                if (results.isEmpty()) {
                    byte[] rowKey = this.pagingFilter.getCurrentRowKeyToBeExcluded();
                    LOGGER.info("Page filter stopped, generating dummy key {} ", (Object)Bytes.toStringBinary((byte[])rowKey));
                    ScanUtil.getDummyResult((byte[])rowKey, results);
                }
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean next(List<Cell> results) throws IOException {
        return this.next(results, false, null);
    }

    @Override
    public boolean nextRaw(List<Cell> results) throws IOException {
        return this.next(results, true, null);
    }

    @Override
    public boolean next(List<Cell> results, ScannerContext scannerContext) throws IOException {
        return this.next(results, false, scannerContext);
    }

    @Override
    public boolean nextRaw(List<Cell> results, ScannerContext scannerContext) throws IOException {
        return this.next(results, true, scannerContext);
    }

    @Override
    public RegionScanner getNewRegionScanner(Scan scan) throws IOException {
        return new PagingRegionScanner(this.region, this.region.getScanner(scan), scan);
    }

    private class MultiKeyPointLookup {
        private SkipScanFilter skipScanFilter;
        private List<KeyRange> pointLookupRanges = null;
        private int lookupPosition = 0;
        private byte[] lookupKeyPrefix = null;
        private long pageSizeMs;

        private MultiKeyPointLookup(SkipScanFilter skipScanFilter) throws IOException {
            this.skipScanFilter = skipScanFilter;
            this.pageSizeMs = ScanUtil.getPageSizeMsForRegionScanner((Scan)PagingRegionScanner.this.scan);
            this.pointLookupRanges = skipScanFilter.getPointLookupKeyRanges();
            this.lookupPosition = this.findLookupPosition(PagingRegionScanner.this.scan.getStartRow());
            if (skipScanFilter.getOffset() > 0) {
                this.lookupKeyPrefix = new byte[skipScanFilter.getOffset()];
                System.arraycopy(PagingRegionScanner.this.scan.getStartRow(), 0, this.lookupKeyPrefix, 0, skipScanFilter.getOffset());
            }
            if (PagingRegionScanner.this.pagingFilter != null) {
                PagingRegionScanner.this.scan.setFilter(PagingRegionScanner.this.pagingFilter.getDelegateFilter());
            }
        }

        private int findLookupPosition(byte[] startRowKey) {
            for (int i = 0; i < this.pointLookupRanges.size(); ++i) {
                byte[] rowKey = this.pointLookupRanges.get(i).getLowerRange();
                if (Bytes.compareTo((byte[])startRowKey, (int)this.skipScanFilter.getOffset(), (int)(startRowKey.length - this.skipScanFilter.getOffset()), (byte[])rowKey, (int)0, (int)rowKey.length) > 0) continue;
                return i;
            }
            return this.pointLookupRanges.size();
        }

        private boolean verifyStartRowKey(byte[] startRowKey) {
            this.lookupPosition = this.findLookupPosition(startRowKey);
            if (this.lookupPosition == this.pointLookupRanges.size()) {
                return false;
            }
            byte[] rowKey = this.pointLookupRanges.get(this.lookupPosition++).getLowerRange();
            PagingRegionScanner.this.scan.withStopRow(rowKey, true);
            PagingRegionScanner.this.scan.withStopRow(rowKey, true);
            return true;
        }

        private RegionScanner getNewScanner() throws IOException {
            byte[] rowKey;
            if (this.lookupPosition >= this.pointLookupRanges.size()) {
                return null;
            }
            byte[] adjustedRowKey = rowKey = this.pointLookupRanges.get(this.lookupPosition++).getLowerRange();
            if (this.lookupKeyPrefix != null) {
                int len = rowKey.length + this.lookupKeyPrefix.length;
                adjustedRowKey = new byte[len];
                System.arraycopy(this.lookupKeyPrefix, 0, adjustedRowKey, 0, this.lookupKeyPrefix.length);
                System.arraycopy(rowKey, 0, adjustedRowKey, this.lookupKeyPrefix.length, rowKey.length);
            }
            PagingRegionScanner.this.scan.withStartRow(adjustedRowKey, true);
            PagingRegionScanner.this.scan.withStopRow(adjustedRowKey, true);
            return PagingRegionScanner.this.region.getScanner(PagingRegionScanner.this.scan);
        }

        private boolean hasMore() {
            return this.lookupPosition < this.pointLookupRanges.size();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean next(List<Cell> results, boolean raw, RegionScanner scanner, ScannerContext scannerContext) throws IOException {
            try {
                long startTime = EnvironmentEdgeManager.currentTimeMillis();
                while (true) {
                    boolean hasMore;
                    if (scannerContext != null) {
                        hasMore = raw ? scanner.nextRaw(results, scannerContext) : scanner.next(results, scannerContext);
                    } else {
                        boolean bl = hasMore = raw ? scanner.nextRaw(results) : scanner.next(results);
                    }
                    if (hasMore) {
                        LOGGER.warn("Each scan is supposed to return only one row, scan " + PagingRegionScanner.this.scan + ", region " + PagingRegionScanner.this.region);
                    }
                    if (!results.isEmpty()) {
                        boolean bl = this.hasMore();
                        return bl;
                    }
                    if (!this.hasMore()) {
                        boolean bl = false;
                        return bl;
                    }
                    if (EnvironmentEdgeManager.currentTimeMillis() - startTime > this.pageSizeMs) {
                        byte[] rowKey = this.pointLookupRanges.get(this.lookupPosition - 1).getLowerRange();
                        ScanUtil.getDummyResult((byte[])rowKey, results);
                        boolean bl = true;
                        return bl;
                    }
                    RegionScanner regionScanner = this.getNewScanner();
                    if (regionScanner == null) {
                        boolean bl = false;
                        return bl;
                    }
                    scanner.close();
                    scanner = regionScanner;
                    continue;
                    break;
                }
            }
            catch (Exception e) {
                --this.lookupPosition;
                throw e;
            }
            finally {
                scanner.close();
            }
        }
    }
}

