/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.compile.ScanRanges;
import org.apache.phoenix.coprocessor.GlobalIndexRegionScanner;
import org.apache.phoenix.coprocessor.IndexToolVerificationResult;
import org.apache.phoenix.coprocessor.UngroupedAggregateRegionObserver;
import org.apache.phoenix.filter.SkipScanFilter;
import org.apache.phoenix.hbase.index.parallel.Task;
import org.apache.phoenix.hbase.index.parallel.TaskBatch;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.mapreduce.index.IndexTool;
import org.apache.phoenix.query.HBaseFactoryProvider;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.CompiledTTLExpression;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.ClientUtil;
import org.apache.phoenix.util.PhoenixKeyValueUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexRepairRegionScanner
extends GlobalIndexRegionScanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexRepairRegionScanner.class);
    private CompiledTTLExpression dataTableTTLExpr;
    private boolean isTTLStrict;

    public IndexRepairRegionScanner(RegionScanner innerScanner, Region region, Scan scan, RegionCoprocessorEnvironment env, UngroupedAggregateRegionObserver ungroupedAggregateRegionObserver) throws IOException {
        super(innerScanner, region, scan, env, ungroupedAggregateRegionObserver);
        byte[] dataTableName = scan.getAttribute("_PhysicalDataTableName");
        this.dataHTable = this.hTableFactory.getTable(new ImmutableBytesPtr(dataTableName));
        try (Connection connection = HBaseFactoryProvider.getHConnectionFactory().createConnection(env.getConfiguration());){
            this.regionEndKeys = connection.getRegionLocator(this.dataHTable.getName()).getEndKeys();
        }
        Configuration config = env.getConfiguration();
        PName tenant = PNameFactory.newName((byte[])this.tenantId);
        String tableName = SchemaUtil.getTableName((byte[])this.schemaName, (byte[])this.logicalTableName);
        try (PhoenixConnection conn = QueryUtil.getConnectionOnServer((Configuration)config).unwrap(PhoenixConnection.class);){
            PTable dataTable = conn.getTableNoCache(tenant, tableName);
            this.dataTableTTLExpr = dataTable.getCompiledTTLExpression(conn);
            this.isTTLStrict = ScanUtil.isStrictTTL((Scan)scan);
        }
        catch (SQLException e) {
            LOGGER.error("Unable to get PTable for the data table {}:{}", new Object[]{tenant, tableName, e});
            throw new IOException(e);
        }
    }

    @Override
    public byte[] getDataTableName() {
        return this.dataHTable.getName().toBytes();
    }

    public void prepareExpectedIndexMutations(Result dataRow, Map<byte[], List<Mutation>> expectedIndexMutationMap) throws IOException {
        Put put = null;
        Delete del = null;
        for (Cell cell : dataRow.rawCells()) {
            if (cell.getType() == Cell.Type.Put) {
                if (put == null) {
                    put = new Put(CellUtil.cloneRow((Cell)cell));
                }
                put.add(cell);
                continue;
            }
            if (del == null) {
                del = new Delete(CellUtil.cloneRow((Cell)cell));
            }
            del.add(cell);
        }
        List<Mutation> indexMutations = IndexRepairRegionScanner.prepareIndexMutationsForRebuild(this.indexMaintainer, put, del, null, this.dataTableTTLExpr, this.isTTLStrict);
        Collections.reverse(indexMutations);
        for (Mutation mutation : indexMutations) {
            byte[] indexRowKey = mutation.getRow();
            List<Mutation> mutationList = expectedIndexMutationMap.get(indexRowKey);
            if (mutationList == null) {
                mutationList = new ArrayList<Mutation>();
                mutationList.add(mutation);
                expectedIndexMutationMap.put(indexRowKey, mutationList);
                continue;
            }
            mutationList.add(mutation);
        }
    }

    @Override
    protected void commitBatch(List<Mutation> indexUpdates) throws IOException, InterruptedException {
        this.ungroupedAggregateRegionObserver.checkForRegionClosingOrSplitting();
        this.region.batchMutate(indexUpdates.toArray(new Mutation[indexUpdates.size()]));
    }

    protected void repairIndexRows(Map<byte[], List<Mutation>> indexMutationMap, List<Mutation> indexRowsToBeDeleted, IndexToolVerificationResult verificationResult) throws IOException {
        this.updateIndexRows(indexMutationMap, indexRowsToBeDeleted, verificationResult);
    }

    private Map<byte[], List<Mutation>> populateExpectedIndexMutationMap(Set<byte[]> dataRowKeys) throws IOException {
        TreeMap expectedIndexMutationMap = Maps.newTreeMap((Comparator)Bytes.BYTES_COMPARATOR);
        ArrayList<KeyRange> keys = new ArrayList<KeyRange>(dataRowKeys.size());
        for (byte[] indexKey : dataRowKeys) {
            keys.add(PVarbinary.INSTANCE.getKeyRange(indexKey, SortOrder.ASC));
        }
        ScanRanges scanRanges = ScanRanges.createPointLookup(keys);
        Scan dataScan = new Scan();
        dataScan.setTimeRange(this.scan.getTimeRange().getMin(), this.scan.getTimeRange().getMax());
        scanRanges.initializeScan(dataScan);
        SkipScanFilter skipScanFilter = scanRanges.getSkipScanFilter();
        dataScan.setFilter((Filter)new SkipScanFilter(skipScanFilter, true, true));
        dataScan.setRaw(true);
        dataScan.readAllVersions();
        dataScan.setCacheBlocks(false);
        try (ResultScanner resultScanner = this.dataHTable.getScanner(dataScan);){
            Result result = resultScanner.next();
            while (result != null) {
                this.ungroupedAggregateRegionObserver.checkForRegionClosingOrSplitting();
                this.prepareExpectedIndexMutations(result, expectedIndexMutationMap);
                result = resultScanner.next();
            }
        }
        catch (Throwable t) {
            ClientUtil.throwIOException((String)this.dataHTable.getName().toString(), (Throwable)t);
        }
        return expectedIndexMutationMap;
    }

    private Map<byte[], List<Mutation>> populateActualIndexMutationMap(Map<byte[], List<Mutation>> expectedIndexMutationMap) throws IOException {
        TreeMap actualIndexMutationMap = Maps.newTreeMap((Comparator)Bytes.BYTES_COMPARATOR);
        Scan indexScan = this.prepareIndexScan(expectedIndexMutationMap);
        try (RegionScanner regionScanner = this.region.getScanner(indexScan);){
            do {
                this.ungroupedAggregateRegionObserver.checkForRegionClosingOrSplitting();
                ArrayList<Cell> row = new ArrayList<Cell>();
                this.hasMore = regionScanner.nextRaw(row);
                if (row.isEmpty()) continue;
                this.populateIndexMutationFromIndexRow(row, actualIndexMutationMap);
            } while (this.hasMore);
        }
        catch (Throwable t) {
            ClientUtil.throwIOException((String)this.region.getRegionInfo().getRegionNameAsString(), (Throwable)t);
        }
        return actualIndexMutationMap;
    }

    private Map<byte[], List<Mutation>> populateActualIndexMutationMap() throws IOException {
        TreeMap actualIndexMutationMap = Maps.newTreeMap((Comparator)Bytes.BYTES_COMPARATOR);
        Scan indexScan = new Scan();
        indexScan.setTimeRange(this.scan.getTimeRange().getMin(), this.scan.getTimeRange().getMax());
        indexScan.setRaw(true);
        indexScan.readAllVersions();
        indexScan.setCacheBlocks(false);
        try (RegionScanner regionScanner = this.region.getScanner(indexScan);){
            do {
                this.ungroupedAggregateRegionObserver.checkForRegionClosingOrSplitting();
                ArrayList<Cell> row = new ArrayList<Cell>();
                this.hasMore = regionScanner.nextRaw(row);
                if (row.isEmpty()) continue;
                this.populateIndexMutationFromIndexRow(row, actualIndexMutationMap);
            } while (this.hasMore);
        }
        catch (Throwable t) {
            ClientUtil.throwIOException((String)this.region.getRegionInfo().getRegionNameAsString(), (Throwable)t);
        }
        return actualIndexMutationMap;
    }

    private void repairAndOrVerifyIndexRows(Set<byte[]> dataRowKeys, Map<byte[], List<Mutation>> actualIndexMutationMap, IndexToolVerificationResult verificationResult) throws IOException {
        ArrayList<Mutation> indexRowsToBeDeleted = new ArrayList<Mutation>();
        Map<byte[], List<Mutation>> expectedIndexMutationMap = this.populateExpectedIndexMutationMap(dataRowKeys);
        if (this.verifyType == IndexTool.IndexVerifyType.NONE) {
            this.repairIndexRows(expectedIndexMutationMap, indexRowsToBeDeleted, verificationResult);
            return;
        }
        if (this.verifyType == IndexTool.IndexVerifyType.ONLY) {
            this.verifyIndexRows(actualIndexMutationMap, expectedIndexMutationMap, Collections.EMPTY_SET, indexRowsToBeDeleted, verificationResult.getBefore(), true);
            return;
        }
        if (this.verifyType == IndexTool.IndexVerifyType.BEFORE) {
            this.verifyIndexRows(actualIndexMutationMap, expectedIndexMutationMap, Collections.EMPTY_SET, indexRowsToBeDeleted, verificationResult.getBefore(), true);
            if (!expectedIndexMutationMap.isEmpty() || !indexRowsToBeDeleted.isEmpty()) {
                this.repairIndexRows(expectedIndexMutationMap, indexRowsToBeDeleted, verificationResult);
            }
            return;
        }
        if (this.verifyType == IndexTool.IndexVerifyType.AFTER) {
            this.repairIndexRows(expectedIndexMutationMap, Collections.EMPTY_LIST, verificationResult);
            actualIndexMutationMap = this.populateActualIndexMutationMap();
            this.verifyIndexRows(actualIndexMutationMap, expectedIndexMutationMap, Collections.EMPTY_SET, indexRowsToBeDeleted, verificationResult.getAfter(), false);
            return;
        }
        if (this.verifyType == IndexTool.IndexVerifyType.BOTH) {
            this.verifyIndexRows(actualIndexMutationMap, expectedIndexMutationMap, Collections.EMPTY_SET, indexRowsToBeDeleted, verificationResult.getBefore(), true);
            if (!expectedIndexMutationMap.isEmpty() || !indexRowsToBeDeleted.isEmpty()) {
                this.repairIndexRows(expectedIndexMutationMap, indexRowsToBeDeleted, verificationResult);
            }
            if (!expectedIndexMutationMap.isEmpty()) {
                actualIndexMutationMap = this.populateActualIndexMutationMap(expectedIndexMutationMap);
                this.verifyIndexRows(actualIndexMutationMap, expectedIndexMutationMap, Collections.EMPTY_SET, Collections.EMPTY_LIST, verificationResult.getAfter(), false);
            }
        }
    }

    private void addRepairAndOrVerifyTask(TaskBatch<Boolean> tasks, final Set<byte[]> dataRowKeys, final Map<byte[], List<Mutation>> actualIndexMutationMap, final IndexToolVerificationResult verificationResult) {
        tasks.add((Task)new Task<Boolean>(){

            public Boolean call() throws Exception {
                if (Thread.currentThread().isInterrupted()) {
                    IndexRepairRegionScanner.this.exceptionMessage = "Pool closed, not attempting to rebuild and/or verify index rows! " + IndexRepairRegionScanner.this.indexHTable.getName();
                    throw new IOException(IndexRepairRegionScanner.this.exceptionMessage);
                }
                IndexRepairRegionScanner.this.repairAndOrVerifyIndexRows(dataRowKeys, actualIndexMutationMap, verificationResult);
                return Boolean.TRUE;
            }
        });
    }

    public static List<Set<byte[]>> getPerTaskDataRowKeys(TreeSet<byte[]> dataRowKeys, byte[][] endKeys, int maxSetSize) {
        int regionIndex;
        ArrayList<Set<byte[]>> setList = new ArrayList<Set<byte[]>>();
        int regionCount = endKeys.length;
        byte[] indexKey = dataRowKeys.first();
        TreeSet<byte[]> perTaskDataRowKeys = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        setList.add(perTaskDataRowKeys);
        for (regionIndex = 0; regionIndex < regionCount - 1 && Bytes.BYTES_COMPARATOR.compare(indexKey, endKeys[regionIndex]) > 0; ++regionIndex) {
        }
        Iterator<byte[]> iterator = dataRowKeys.iterator();
        while (iterator.hasNext()) {
            byte[] dataRowKey;
            indexKey = dataRowKey = iterator.next();
            if (perTaskDataRowKeys.size() == maxSetSize || regionIndex < regionCount - 1 && Bytes.BYTES_COMPARATOR.compare(indexKey, endKeys[regionIndex]) > 0) {
                perTaskDataRowKeys = new TreeSet(Bytes.BYTES_COMPARATOR);
                setList.add(perTaskDataRowKeys);
                while (regionIndex < regionCount - 1 && Bytes.BYTES_COMPARATOR.compare(indexKey, endKeys[regionIndex]) > 0) {
                    ++regionIndex;
                }
            }
            perTaskDataRowKeys.add(dataRowKey);
        }
        return setList;
    }

    private Set<byte[]> getDataRowKeys(Map<byte[], List<Mutation>> indexMutationMap) {
        TreeSet<byte[]> dataRowKeys = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        for (byte[] indexRowKey : indexMutationMap.keySet()) {
            byte[] dataRowKey = this.indexMaintainer.buildDataRowKey(new ImmutableBytesWritable(indexRowKey), this.viewConstants);
            dataRowKeys.add(dataRowKey);
        }
        return dataRowKeys;
    }

    private List<Map<byte[], List<Mutation>>> getPerTaskIndexMutationMap(Map<byte[], List<Mutation>> indexMutationMap, List<Set<byte[]>> dataRowKeysSetList) {
        ArrayList mapList = Lists.newArrayListWithExpectedSize((int)dataRowKeysSetList.size());
        for (int i = 0; i < dataRowKeysSetList.size(); ++i) {
            TreeMap perTaskIndexMutationMap = new TreeMap(Bytes.BYTES_COMPARATOR);
            mapList.add(perTaskIndexMutationMap);
        }
        block1: for (Map.Entry<byte[], List<Mutation>> entry : indexMutationMap.entrySet()) {
            byte[] indexRowKey = entry.getKey();
            List<Mutation> actualMutationList = entry.getValue();
            byte[] dataRowKey = this.indexMaintainer.buildDataRowKey(new ImmutableBytesWritable(indexRowKey), this.viewConstants);
            for (int i = 0; i < dataRowKeysSetList.size(); ++i) {
                if (!dataRowKeysSetList.get(i).contains(dataRowKey)) continue;
                ((Map)mapList.get(i)).put(indexRowKey, actualMutationList);
                continue block1;
            }
        }
        return mapList;
    }

    private void verifyAndOrRepairIndex(Map<byte[], List<Mutation>> actualIndexMutationMap) throws IOException {
        if (actualIndexMutationMap.size() == 0) {
            return;
        }
        Set<byte[]> dataRowKeys = this.getDataRowKeys(actualIndexMutationMap);
        List<Set<byte[]>> setList = IndexRepairRegionScanner.getPerTaskDataRowKeys((TreeSet)dataRowKeys, this.regionEndKeys, this.rowCountPerTask);
        List<Map<byte[], List<Mutation>>> indexMutationMapList = this.getPerTaskIndexMutationMap(actualIndexMutationMap, setList);
        int taskCount = setList.size();
        TaskBatch tasks = new TaskBatch(taskCount);
        ArrayList<IndexToolVerificationResult> verificationResultList = new ArrayList<IndexToolVerificationResult>(taskCount);
        for (int i = 0; i < taskCount; ++i) {
            IndexToolVerificationResult perTaskVerificationResult = new IndexToolVerificationResult(this.scan);
            verificationResultList.add(perTaskVerificationResult);
            this.addRepairAndOrVerifyTask((TaskBatch<Boolean>)tasks, setList.get(i), indexMutationMapList.get(i), perTaskVerificationResult);
        }
        this.submitTasks((TaskBatch<Boolean>)tasks);
        if (this.verify) {
            for (IndexToolVerificationResult result : verificationResultList) {
                this.verificationResult.add(result);
            }
        }
    }

    private int populateIndexMutationFromIndexRow(List<Cell> row, Map<byte[], List<Mutation>> indexMutationMap) throws IOException {
        byte[] indexRowKey;
        Put put = null;
        Delete del = null;
        for (Cell cell : row) {
            if (cell.getType() == Cell.Type.Put) {
                if (put == null) {
                    put = new Put(CellUtil.cloneRow((Cell)cell));
                }
                put.add(cell);
                continue;
            }
            if (del == null) {
                del = new Delete(CellUtil.cloneRow((Cell)cell));
            }
            del.add(cell);
        }
        if (put != null) {
            indexRowKey = put.getRow();
        } else if (del != null) {
            indexRowKey = del.getRow();
        } else {
            return 0;
        }
        List<Mutation> mutationList = IndexRepairRegionScanner.getMutationsWithSameTS(put, del, MUTATION_TS_DESC_COMPARATOR);
        indexMutationMap.put(indexRowKey, mutationList);
        return mutationList.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean next(List<Cell> results) throws IOException {
        Cell aggKeyValue;
        TreeMap indexMutationMap = Maps.newTreeMap((Comparator)Bytes.BYTES_COMPARATOR);
        Cell lastCell = null;
        int rowCount = 0;
        int indexMutationCount = 0;
        this.region.startRegionOperation();
        RegionScanner localScanner = null;
        try {
            localScanner = this.getLocalScanner();
            if (localScanner == null) {
                boolean bl = false;
                return bl;
            }
            RegionScanner regionScanner = localScanner;
            synchronized (regionScanner) {
                block22: {
                    if (this.shouldVerify()) break block22;
                    this.skipped = true;
                    boolean bl = false;
                    return bl;
                }
                do {
                    this.ungroupedAggregateRegionObserver.checkForRegionClosingOrSplitting();
                    ArrayList<Cell> row = new ArrayList<Cell>();
                    this.hasMore = localScanner.nextRaw(row);
                    if (row.isEmpty()) continue;
                    lastCell = (Cell)row.get(0);
                    if (ScanUtil.isDummy(row)) break;
                    indexMutationCount += this.populateIndexMutationFromIndexRow(row, indexMutationMap);
                    ++rowCount;
                } while (this.hasMore && (long)indexMutationCount < this.pageSizeInRows);
                if (!indexMutationMap.isEmpty()) {
                    this.verifyAndOrRepairIndex(indexMutationMap);
                }
                if (this.verify) {
                    this.verificationResult.setScannedDataRowCount(this.verificationResult.getScannedDataRowCount() + (long)rowCount);
                }
            }
        }
        catch (Throwable e) {
            LOGGER.error("Exception in IndexRepairRegionScanner for region " + this.region.getRegionInfo().getRegionNameAsString(), e);
            throw e;
        }
        finally {
            this.region.closeRegionOperation();
            if (localScanner != null && localScanner != this.innerScanner) {
                localScanner.close();
            }
        }
        if (this.minTimestamp != 0L) {
            this.nextStartKey = ByteUtil.calculateTheClosestNextRowKeyForPrefix((byte[])CellUtil.cloneRow((Cell)lastCell));
        }
        byte[] rowCountBytes = PLong.INSTANCE.toBytes((Object)rowCount);
        if (lastCell == null) {
            byte[] rowKey;
            byte[] startKey = this.scan.getStartRow().length > 0 ? this.scan.getStartRow() : this.region.getRegionInfo().getStartKey();
            byte[] endKey = this.scan.getStopRow().length > 0 ? this.scan.getStopRow() : this.region.getRegionInfo().getEndKey();
            boolean isIncompatibleClient = ScanUtil.isIncompatibleClientForServerReturnValidRowKey((Scan)this.scan);
            if (!isIncompatibleClient) {
                rowKey = ByteUtil.getLargestPossibleRowKeyInRange((byte[])startKey, (byte[])endKey);
                if (rowKey == null) {
                    rowKey = this.scan.includeStartRow() ? startKey : (this.scan.includeStopRow() ? endKey : HConstants.EMPTY_END_ROW);
                }
            } else {
                rowKey = QueryConstants.UNGROUPED_AGG_ROW_KEY;
            }
            aggKeyValue = PhoenixKeyValueUtil.newKeyValue((byte[])rowKey, (byte[])QueryConstants.SINGLE_COLUMN_FAMILY, (byte[])QueryConstants.SINGLE_COLUMN, (long)Long.MAX_VALUE, (byte[])rowCountBytes, (int)0, (int)rowCountBytes.length);
        } else {
            aggKeyValue = PhoenixKeyValueUtil.newKeyValue((byte[])CellUtil.cloneRow((Cell)lastCell), (byte[])QueryConstants.SINGLE_COLUMN_FAMILY, (byte[])QueryConstants.SINGLE_COLUMN, (long)Long.MAX_VALUE, (byte[])rowCountBytes, (int)0, (int)rowCountBytes.length);
        }
        results.add(aggKeyValue);
        return this.hasMore || this.hasMoreIncr;
    }

    @Override
    public boolean next(List<Cell> result, ScannerContext scannerContext) throws IOException {
        return this.next(result);
    }
}

