/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.cache.GlobalCache;
import org.apache.phoenix.cache.TenantCache;
import org.apache.phoenix.cache.aggcache.SpillableGroupByCache;
import org.apache.phoenix.coprocessor.BaseRegionScanner;
import org.apache.phoenix.coprocessor.BaseScannerRegionObserver;
import org.apache.phoenix.coprocessor.GroupByCache;
import org.apache.phoenix.coprocessor.HashJoinRegionScanner;
import org.apache.phoenix.execute.TupleProjector;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.ExpressionType;
import org.apache.phoenix.expression.aggregator.Aggregator;
import org.apache.phoenix.expression.aggregator.ServerAggregators;
import org.apache.phoenix.hbase.index.covered.update.ColumnReference;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.join.HashJoinInfo;
import org.apache.phoenix.memory.MemoryManager;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.EncodedColumnQualiferCellsList;
import org.apache.phoenix.schema.tuple.MultiKeyValueTuple;
import org.apache.phoenix.schema.tuple.PositionBasedMultiKeyValueTuple;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.Closeables;
import org.apache.phoenix.util.EncodedColumnsUtil;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.LogUtil;
import org.apache.phoenix.util.PhoenixKeyValueUtil;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.ServerUtil;
import org.apache.phoenix.util.SizedUtil;
import org.apache.phoenix.util.TupleUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupedAggregateRegionObserver
extends BaseScannerRegionObserver
implements RegionCoprocessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(GroupedAggregateRegionObserver.class);
    public static final int MIN_DISTINCT_VALUES = 100;

    public Optional<RegionObserver> getRegionObserver() {
        return Optional.of(this);
    }

    @Override
    protected RegionScanner doPostScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Scan scan, RegionScanner s) throws IOException {
        boolean keyOrdered = false;
        byte[] expressionBytes = scan.getAttribute("_UnorderedGroupByExpressions");
        if (expressionBytes == null) {
            expressionBytes = scan.getAttribute("_OrderedGroupByExpressions");
            keyOrdered = true;
        }
        int offset = 0;
        boolean useNewValueColumnQualifier = EncodedColumnsUtil.useNewValueColumnQualifier((Scan)scan);
        if (ScanUtil.isLocalIndex((Scan)scan)) {
            Region region = ((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion();
            offset = region.getRegionInfo().getStartKey().length != 0 ? region.getRegionInfo().getStartKey().length : region.getRegionInfo().getEndKey().length;
            ScanUtil.setRowKeyOffset((Scan)scan, (int)offset);
        }
        List<Expression> expressions = this.deserializeGroupByExpressions(expressionBytes, 0);
        TenantCache tenantCache = GlobalCache.getTenantCache((RegionCoprocessorEnvironment)c.getEnvironment(), ScanUtil.getTenantId((Scan)scan));
        try (MemoryManager.MemoryChunk em = tenantCache.getMemoryManager().allocate(0L);){
            ServerAggregators aggregators = ServerAggregators.deserialize((byte[])scan.getAttribute("_Aggs"), (Configuration)((RegionCoprocessorEnvironment)c.getEnvironment()).getConfiguration(), (MemoryManager.MemoryChunk)em);
            RegionScanner innerScanner = s;
            List indexMaintainers = IndexUtil.deSerializeIndexMaintainersFromScan((Scan)scan);
            TupleProjector tupleProjector = null;
            byte[][] viewConstants = null;
            ColumnReference[] dataColumns = IndexUtil.deserializeDataTableColumnsToJoin((Scan)scan);
            TupleProjector p = TupleProjector.deserializeProjectorFromScan((Scan)scan);
            HashJoinInfo j = HashJoinInfo.deserializeHashJoinFromScan((Scan)scan);
            boolean useQualifierAsIndex = EncodedColumnsUtil.useQualifierAsIndex((Pair)EncodedColumnsUtil.getMinMaxQualifiersFromScan((Scan)scan));
            if (ScanUtil.isLocalOrUncoveredGlobalIndex((Scan)scan) || j == null && p != null) {
                if (dataColumns != null) {
                    tupleProjector = IndexUtil.getTupleProjector((Scan)scan, (ColumnReference[])dataColumns);
                    viewConstants = IndexUtil.deserializeViewConstantsFromScan((Scan)scan);
                }
                ImmutableBytesPtr tempPtr = new ImmutableBytesPtr();
                innerScanner = this.getWrappedScanner(c, innerScanner, offset, scan, dataColumns, tupleProjector, ((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion(), indexMaintainers == null ? null : (IndexMaintainer)indexMaintainers.get(0), viewConstants, p, (ImmutableBytesWritable)tempPtr, useQualifierAsIndex);
            }
            if (j != null) {
                innerScanner = new HashJoinRegionScanner(innerScanner, scan, p, j, ScanUtil.getTenantId((Scan)scan), (RegionCoprocessorEnvironment)c.getEnvironment(), useQualifierAsIndex, useNewValueColumnQualifier);
            }
            long limit = Long.MAX_VALUE;
            byte[] limitBytes = scan.getAttribute("_GroupByLimit");
            if (limitBytes != null) {
                limit = PInteger.INSTANCE.getCodec().decodeInt(limitBytes, 0, SortOrder.getDefault());
            }
            long pageSizeMs = ScanUtil.getPageSizeMsForRegionScanner((Scan)scan);
            if (keyOrdered) {
                OrderedGroupByRegionScanner orderedGroupByRegionScanner = new OrderedGroupByRegionScanner(c, scan, innerScanner, expressions, aggregators, limit, pageSizeMs);
                return orderedGroupByRegionScanner;
            }
            UnorderedGroupByRegionScanner unorderedGroupByRegionScanner = new UnorderedGroupByRegionScanner(c, scan, innerScanner, expressions, aggregators, limit, pageSizeMs);
            return unorderedGroupByRegionScanner;
        }
    }

    public static long sizeOfUnorderedGroupByMap(int nRows, int valueSize) {
        return SizedUtil.sizeOfMap((int)nRows, (int)48, (int)valueSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Expression> deserializeGroupByExpressions(byte[] expressionBytes, int offset) throws IOException {
        ArrayList<Expression> expressions = new ArrayList<Expression>(3);
        ByteArrayInputStream stream = new ByteArrayInputStream(expressionBytes);
        try {
            DataInputStream input = new DataInputStream(stream);
            try {
                while (true) {
                    int expressionOrdinal = WritableUtils.readVInt((DataInput)input);
                    Expression expression = ExpressionType.values()[expressionOrdinal].newInstance();
                    expression.readFields((DataInput)input);
                    if (offset != 0) {
                        IndexUtil.setRowKeyExpressionOffset((Expression)expression, (int)offset);
                    }
                    expressions.add(expression);
                }
            }
            catch (EOFException e) {
                stream.close();
            }
        }
        catch (Throwable throwable) {
            stream.close();
            throw throwable;
        }
        return expressions;
    }

    @Override
    protected boolean isRegionObserverFor(Scan scan) {
        return scan.getAttribute("_UnorderedGroupByExpressions") != null || scan.getAttribute("_OrderedGroupByExpressions") != null;
    }

    private static class OrderedGroupByRegionScanner
    extends BaseRegionScanner {
        private final Scan scan;
        private final Region region;
        private final Pair<Integer, Integer> minMaxQualifiers;
        private final boolean useQualifierAsIndex;
        private final PTable.QualifierEncodingScheme encodingScheme;
        private final ServerAggregators aggregators;
        private final long limit;
        private final List<Expression> expressions;
        private final long pageSizeMs;
        private long rowCount = 0L;
        private ImmutableBytesPtr currentKey = null;
        private final ImmutableBytesPtr currentKeyRowKey = new ImmutableBytesPtr();
        private final boolean isIncompatibleClient;
        private final byte[] initStartRowKey;
        private final boolean includeInitStartRowKey;
        private byte[] previousResultRowKey;

        private OrderedGroupByRegionScanner(ObserverContext<RegionCoprocessorEnvironment> c, Scan scan, RegionScanner scanner, List<Expression> expressions, ServerAggregators aggregators, long limit, long pageSizeMs) {
            super(scanner);
            this.scan = scan;
            this.isIncompatibleClient = ScanUtil.isIncompatibleClientForServerReturnValidRowKey((Scan)scan);
            this.aggregators = aggregators;
            this.limit = limit;
            this.pageSizeMs = pageSizeMs;
            this.expressions = expressions;
            this.region = ((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion();
            this.minMaxQualifiers = EncodedColumnsUtil.getMinMaxQualifiersFromScan((Scan)scan);
            this.useQualifierAsIndex = EncodedColumnsUtil.useQualifierAsIndex(this.minMaxQualifiers);
            this.encodingScheme = EncodedColumnsUtil.getQualifierEncodingScheme((Scan)scan);
            this.initStartRowKey = ServerUtil.getScanStartRowKeyFromScanOrRegionBoundaries(scan, this.region);
            this.includeInitStartRowKey = scan.includeStartRow();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(LogUtil.addCustomAnnotations((String)("Grouped aggregation over ordered rows with scan " + scan + ", group by " + expressions + ", aggregators " + aggregators), (byte[])ScanUtil.getCustomAnnotations((Scan)scan)));
            }
        }

        @Override
        public boolean nextRaw(List<Cell> results, ScannerContext scannerContext) throws IOException {
            return this.next(results, scannerContext);
        }

        @Override
        public boolean next(List<Cell> results) throws IOException {
            return this.next(results, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean next(List<Cell> results, ScannerContext scannerContext) throws IOException {
            long now;
            boolean atLimit;
            boolean hasMore;
            boolean aggBoundary = false;
            long startTime = EnvironmentEdgeManager.currentTimeMillis();
            PositionBasedMultiKeyValueTuple result = this.useQualifierAsIndex ? new PositionBasedMultiKeyValueTuple() : new MultiKeyValueTuple();
            ImmutableBytesPtr key = null;
            Aggregator[] rowAggregators = this.aggregators.getAggregators();
            int countOffset = rowAggregators.length == 0 ? 1 : 0;
            boolean acquiredLock = false;
            try {
                this.region.startRegionOperation();
                acquiredLock = true;
                RegionScanner regionScanner = this.delegate;
                synchronized (regionScanner) {
                    do {
                        Object kvs = this.useQualifierAsIndex ? new EncodedColumnQualiferCellsList(((Integer)this.minMaxQualifiers.getFirst()).intValue(), ((Integer)this.minMaxQualifiers.getSecond()).intValue(), this.encodingScheme) : new ArrayList();
                        boolean bl = hasMore = scannerContext == null ? this.delegate.nextRaw((List)kvs) : this.delegate.nextRaw((List)kvs, scannerContext);
                        if (!kvs.isEmpty()) {
                            if (ScanUtil.isDummy((List)kvs)) {
                                this.updateDummyWithPrevRowKey(results, this.initStartRowKey, this.includeInitStartRowKey, this.scan);
                                boolean bl2 = true;
                                return bl2;
                            }
                            result.setKeyValues((List)kvs);
                            key = TupleUtil.getConcatenatedValue((Tuple)result, this.expressions);
                            boolean bl3 = aggBoundary = this.currentKey != null && this.currentKey.compareTo((ImmutableBytesWritable)key) != 0;
                            if (!aggBoundary) {
                                this.aggregators.aggregate(rowAggregators, (Tuple)result);
                                if (LOGGER.isDebugEnabled()) {
                                    LOGGER.debug(LogUtil.addCustomAnnotations((String)("Row passed filters: " + kvs + ", aggregated values: " + Arrays.asList(rowAggregators)), (byte[])ScanUtil.getCustomAnnotations((Scan)this.scan)));
                                }
                                this.currentKey = key;
                                if (result.size() > 0) {
                                    result.getKey((ImmutableBytesWritable)this.currentKeyRowKey);
                                }
                            }
                        }
                        atLimit = this.rowCount + (long)countOffset >= this.limit;
                        now = EnvironmentEdgeManager.currentTimeMillis();
                    } while (hasMore && !aggBoundary && !atLimit && now - startTime < this.pageSizeMs);
                }
            }
            catch (Exception e) {
                LOGGER.error("Ordered group-by scanner next encountered error for region {}", (Object)this.region.getRegionInfo().getRegionNameAsString(), (Object)e);
                if (!(e instanceof IOException)) throw new IOException(e);
                throw e;
            }
            finally {
                if (acquiredLock) {
                    this.region.closeRegionOperation();
                }
            }
            try {
                if (hasMore && !aggBoundary && !atLimit && now - startTime >= this.pageSizeMs) {
                    this.updateDummyWithPrevRowKey(results, this.initStartRowKey, this.includeInitStartRowKey, this.scan);
                    return true;
                }
                if (this.currentKey != null) {
                    if (!this.isIncompatibleClient) {
                        byte[] aggregateArrayBytes = this.aggregators.toBytes(rowAggregators);
                        byte[] aggregateGroupValueBytes = new byte[this.currentKey.getLength()];
                        System.arraycopy(this.currentKey.get(), this.currentKey.getOffset(), aggregateGroupValueBytes, 0, aggregateGroupValueBytes.length);
                        byte[] finalValue = ByteUtil.concat((byte[])PInteger.INSTANCE.toBytes((Object)aggregateGroupValueBytes.length), (byte[][])new byte[][]{aggregateGroupValueBytes, aggregateArrayBytes});
                        Cell keyValue = PhoenixKeyValueUtil.newKeyValue((byte[])this.currentKeyRowKey.get(), (int)this.currentKeyRowKey.getOffset(), (int)this.currentKeyRowKey.getLength(), (byte[])QueryConstants.GROUPED_AGGREGATOR_VALUE_BYTES, (byte[])QueryConstants.GROUPED_AGGREGATOR_VALUE_BYTES, (long)Long.MAX_VALUE, (byte[])finalValue, (int)0, (int)finalValue.length);
                        results.add(keyValue);
                    } else {
                        byte[] value = this.aggregators.toBytes(rowAggregators);
                        Cell keyValue = PhoenixKeyValueUtil.newKeyValue((byte[])this.currentKey.get(), (int)this.currentKey.getOffset(), (int)this.currentKey.getLength(), (byte[])QueryConstants.SINGLE_COLUMN_FAMILY, (byte[])QueryConstants.SINGLE_COLUMN, (long)Long.MAX_VALUE, (byte[])value, (int)0, (int)value.length);
                        results.add(keyValue);
                    }
                    if (aggBoundary) {
                        this.aggregators.reset(rowAggregators);
                        this.aggregators.aggregate(rowAggregators, (Tuple)result);
                        this.currentKey = key;
                        if (result.size() > 0) {
                            result.getKey((ImmutableBytesWritable)this.currentKeyRowKey);
                        }
                        ++this.rowCount;
                        atLimit |= this.rowCount >= this.limit;
                    }
                }
                if (!atLimit && (hasMore || aggBoundary)) {
                    if (results.isEmpty()) return true;
                    this.previousResultRowKey = CellUtil.cloneRow((Cell)results.get(results.size() - 1));
                    return true;
                }
                this.currentKey = null;
                return false;
            }
            catch (Exception e) {
                LOGGER.error("Ordered group-by scanner next encountered some issue for region {}", (Object)this.region.getRegionInfo().getRegionNameAsString(), (Object)e);
                if (!(e instanceof IOException)) throw new IOException(e);
                throw e;
            }
        }

        private void updateDummyWithPrevRowKey(List<Cell> result, byte[] initStartRowKey, boolean includeInitStartRowKey, Scan scan) {
            result.clear();
            if (this.previousResultRowKey != null) {
                ScanUtil.getDummyResult((byte[])this.previousResultRowKey, result);
            } else if (includeInitStartRowKey && initStartRowKey.length > 0) {
                byte[] prevKey;
                int regionLookupInMetaLen = RegionInfo.createRegionName((TableName)this.region.getTableDescriptor().getTableName(), (byte[])new byte[1], (String)"99999999999999", (boolean)false).length;
                if (Bytes.compareTo((byte[])initStartRowKey, (int)(initStartRowKey.length - 1), (int)1, (byte[])ByteUtil.ZERO_BYTE, (int)0, (int)1) == 0) {
                    prevKey = new byte[initStartRowKey.length - 1];
                    System.arraycopy(initStartRowKey, 0, prevKey, 0, prevKey.length);
                } else {
                    prevKey = initStartRowKey.length < 32766 - regionLookupInMetaLen ? ByteUtil.previousKeyWithLength((byte[])ByteUtil.concat((byte[])initStartRowKey, (byte[][])new byte[][]{new byte[Short.MAX_VALUE - initStartRowKey.length - 1 - regionLookupInMetaLen]}), (int)(32766 - regionLookupInMetaLen)) : initStartRowKey;
                }
                ScanUtil.getDummyResult((byte[])prevKey, result);
            } else {
                ScanUtil.getDummyResult((byte[])initStartRowKey, result);
            }
        }
    }

    private static class UnorderedGroupByRegionScanner
    extends BaseRegionScanner {
        private final Region region;
        private final Pair<Integer, Integer> minMaxQualifiers;
        private final boolean useQualifierAsIndex;
        private final PTable.QualifierEncodingScheme encodingScheme;
        private final ServerAggregators aggregators;
        private final long limit;
        private final List<Expression> expressions;
        private final long pageSizeMs;
        private RegionScanner regionScanner = null;
        private final GroupByCache groupByCache;
        private final Scan scan;
        private final byte[] scanStartRowKey;
        private final boolean includeStartRowKey;
        private final byte[] actualScanStartRowKey;
        private final boolean actualScanIncludeStartRowKey;
        private boolean firstScan = true;
        private boolean skipValidRowsSent = false;
        private byte[] lastReturnedRowKey = null;

        private UnorderedGroupByRegionScanner(ObserverContext<RegionCoprocessorEnvironment> c, Scan scan, RegionScanner scanner, List<Expression> expressions, ServerAggregators aggregators, long limit, long pageSizeMs) {
            super(scanner);
            this.region = ((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion();
            this.scan = scan;
            this.scanStartRowKey = ServerUtil.getScanStartRowKeyFromScanOrRegionBoundaries(scan, this.region);
            this.includeStartRowKey = scan.includeStartRow();
            this.actualScanStartRowKey = scan.getAttribute("_ScanActualStartRow");
            this.actualScanIncludeStartRowKey = true;
            this.aggregators = aggregators;
            this.limit = limit;
            this.pageSizeMs = pageSizeMs;
            this.expressions = expressions;
            RegionCoprocessorEnvironment env = (RegionCoprocessorEnvironment)c.getEnvironment();
            Configuration conf = env.getConfiguration();
            int estDistVals = conf.getInt("phoenix.groupby.estimatedDistinctValues", 1000);
            byte[] estDistValsBytes = scan.getAttribute("_EstDistinctValues");
            if (estDistValsBytes != null) {
                estDistVals = Math.max(100, (int)((float)Bytes.toInt((byte[])estDistValsBytes) * 1.5f));
            }
            this.minMaxQualifiers = EncodedColumnsUtil.getMinMaxQualifiersFromScan((Scan)scan);
            this.useQualifierAsIndex = EncodedColumnsUtil.useQualifierAsIndex((Pair)EncodedColumnsUtil.getMinMaxQualifiersFromScan((Scan)scan));
            boolean spillableEnabled = conf.getBoolean("phoenix.groupby.spillable", true);
            this.encodingScheme = EncodedColumnsUtil.getQualifierEncodingScheme((Scan)scan);
            boolean isIncompatibleClient = ScanUtil.isIncompatibleClientForServerReturnValidRowKey((Scan)scan);
            this.groupByCache = GroupByCacheFactory.INSTANCE.newCache(env, ScanUtil.getTenantId((Scan)scan), ScanUtil.getCustomAnnotations((Scan)scan), aggregators, estDistVals, isIncompatibleClient);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(LogUtil.addCustomAnnotations((String)("Grouped aggregation over unordered rows with scan " + scan + ", group by " + expressions + ", aggregators " + aggregators), (byte[])ScanUtil.getCustomAnnotations((Scan)scan)));
                LOGGER.debug(LogUtil.addCustomAnnotations((String)("Spillable groupby enabled: " + spillableEnabled), (byte[])ScanUtil.getCustomAnnotations((Scan)scan)));
            }
        }

        @Override
        public boolean nextRaw(List<Cell> results, ScannerContext scannerContext) throws IOException {
            return this.next(results, scannerContext);
        }

        @Override
        public boolean next(List<Cell> resultsToReturn) throws IOException {
            return this.next(resultsToReturn, null);
        }

        @Override
        public boolean next(List<Cell> resultsToReturn, ScannerContext scannerContext) throws IOException {
            if (this.firstScan && this.actualScanStartRowKey != null && this.scanStartRowKey.length > 0 && !ScanUtil.isLocalIndex((Scan)this.scan) && this.hasRegionMoved()) {
                LOGGER.info("Region has moved.. Actual scan start rowkey {} is not same as current scan start rowkey {}", (Object)Bytes.toStringBinary((byte[])this.actualScanStartRowKey), (Object)Bytes.toStringBinary((byte[])this.scanStartRowKey));
                if (Bytes.compareTo((byte[])ByteUtil.concat((byte[])this.actualScanStartRowKey, (byte[][])new byte[][]{ByteUtil.ZERO_BYTE}), (byte[])this.scanStartRowKey) == 0) {
                    this.scan.setAttribute("phoenix.paging.start.newscan.startrow", this.actualScanStartRowKey);
                    this.scan.setAttribute("phoenix.paging.start.newscan.startrow.include", Bytes.toBytes((boolean)this.actualScanIncludeStartRowKey));
                } else {
                    this.skipValidRowsSent = true;
                    this.scan.setAttribute("phoenix.paging.start.newscan.startrow", this.actualScanStartRowKey);
                    this.scan.setAttribute("phoenix.paging.start.newscan.startrow.include", Bytes.toBytes((boolean)this.actualScanIncludeStartRowKey));
                }
            }
            if (this.firstScan) {
                this.firstScan = false;
            }
            boolean moreRows = this.nextInternal(resultsToReturn, scannerContext);
            if (ScanUtil.isDummy(resultsToReturn)) {
                return true;
            }
            if (this.skipValidRowsSent) {
                do {
                    if (!moreRows) {
                        this.skipValidRowsSent = false;
                        if (resultsToReturn.size() > 0) {
                            this.lastReturnedRowKey = CellUtil.cloneRow((Cell)resultsToReturn.get(0));
                        }
                        return moreRows;
                    }
                    Cell firstCell = resultsToReturn.get(0);
                    byte[] resultRowKey = new byte[firstCell.getRowLength()];
                    System.arraycopy(firstCell.getRowArray(), firstCell.getRowOffset(), resultRowKey, 0, resultRowKey.length);
                    if (Bytes.compareTo((byte[])resultRowKey, (byte[])this.scanStartRowKey) == 0) {
                        this.skipValidRowsSent = false;
                        if (this.includeStartRowKey) {
                            if (resultsToReturn.size() > 0) {
                                this.lastReturnedRowKey = CellUtil.cloneRow((Cell)resultsToReturn.get(0));
                            }
                            return moreRows;
                        }
                        resultsToReturn.clear();
                        moreRows = this.nextInternal(resultsToReturn, scannerContext);
                        if (ScanUtil.isDummy(resultsToReturn)) {
                            return true;
                        }
                        if (resultsToReturn.size() > 0) {
                            this.lastReturnedRowKey = CellUtil.cloneRow((Cell)resultsToReturn.get(0));
                        }
                        return moreRows;
                    }
                    if (Bytes.compareTo((byte[])ByteUtil.concat((byte[])resultRowKey, (byte[][])new byte[][]{ByteUtil.ZERO_BYTE}), (byte[])this.scanStartRowKey) == 0) {
                        this.skipValidRowsSent = false;
                        if (this.includeStartRowKey) {
                            resultsToReturn.clear();
                            moreRows = this.nextInternal(resultsToReturn, scannerContext);
                            if (ScanUtil.isDummy(resultsToReturn)) {
                                return true;
                            }
                            if (resultsToReturn.size() > 0) {
                                this.lastReturnedRowKey = CellUtil.cloneRow((Cell)resultsToReturn.get(0));
                            }
                            return moreRows;
                        }
                    }
                    resultsToReturn.clear();
                    moreRows = this.nextInternal(resultsToReturn, scannerContext);
                } while (!ScanUtil.isDummy(resultsToReturn));
                return true;
            }
            if (resultsToReturn.size() > 0) {
                this.lastReturnedRowKey = CellUtil.cloneRow((Cell)resultsToReturn.get(0));
            }
            return moreRows;
        }

        /*
         * Exception decompiling
         */
        private boolean nextInternal(List<Cell> resultsToReturn, ScannerContext scannerContext) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[DOLOOP]], but top level block is 4[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private boolean getDummyResult(List<Cell> resultsToReturn) {
            if (this.lastReturnedRowKey != null) {
                ScanUtil.getDummyResult((byte[])this.lastReturnedRowKey, resultsToReturn);
                return true;
            }
            if (this.scanStartRowKey.length > 0 && !ScanUtil.isLocalIndex((Scan)this.scan)) {
                if (this.hasRegionMoved()) {
                    byte[] lastByte = new byte[]{this.scanStartRowKey[this.scanStartRowKey.length - 1]};
                    if (this.scanStartRowKey.length > 1 && Bytes.compareTo((byte[])lastByte, (byte[])ByteUtil.ZERO_BYTE) == 0) {
                        byte[] prevKey = new byte[this.scanStartRowKey.length - 1];
                        System.arraycopy(this.scanStartRowKey, 0, prevKey, 0, prevKey.length);
                        ScanUtil.getDummyResult((byte[])prevKey, resultsToReturn);
                    } else {
                        ScanUtil.getDummyResult((byte[])this.scanStartRowKey, resultsToReturn);
                    }
                } else {
                    ScanUtil.getDummyResult((byte[])this.scanStartRowKey, resultsToReturn);
                }
            } else {
                ScanUtil.getDummyResult((byte[])this.scanStartRowKey, resultsToReturn);
            }
            return true;
        }

        private boolean hasRegionMoved() {
            return Bytes.compareTo((byte[])this.actualScanStartRowKey, (byte[])this.scanStartRowKey) != 0 || this.actualScanIncludeStartRowKey != this.includeStartRowKey;
        }

        @Override
        public void close() throws IOException {
            if (this.regionScanner != null) {
                this.regionScanner.close();
            } else {
                Closeables.closeQuietly((Closeable)this.groupByCache);
            }
        }
    }

    private static final class GroupByCacheFactory {
        public static final GroupByCacheFactory INSTANCE = new GroupByCacheFactory();

        private GroupByCacheFactory() {
        }

        GroupByCache newCache(RegionCoprocessorEnvironment env, ImmutableBytesPtr tenantId, byte[] customAnnotations, ServerAggregators aggregators, int estDistVals, boolean isIncompatibleClient) {
            Configuration conf = env.getConfiguration();
            boolean spillableEnabled = conf.getBoolean("phoenix.groupby.spillable", true);
            if (spillableEnabled) {
                return new SpillableGroupByCache(env, tenantId, aggregators, estDistVals, isIncompatibleClient);
            }
            return new InMemoryGroupByCache(env, tenantId, customAnnotations, aggregators, estDistVals, isIncompatibleClient);
        }
    }

    private static final class InMemoryGroupByCache
    implements GroupByCache {
        private final MemoryManager.MemoryChunk chunk;
        private final Map<ImmutableBytesPtr, Aggregator[]> aggregateMap;
        private final ServerAggregators aggregators;
        private final RegionCoprocessorEnvironment env;
        private final byte[] customAnnotations;
        private final ConcurrentMap<ImmutableBytesWritable, ImmutableBytesWritable> aggregateValueToLastScannedRowKeys;
        private final boolean isIncompatibleClient;
        private int estDistVals;

        InMemoryGroupByCache(RegionCoprocessorEnvironment env, ImmutableBytesPtr tenantId, byte[] customAnnotations, ServerAggregators aggregators, int estDistVals, boolean isIncompatibleClient) {
            this.isIncompatibleClient = isIncompatibleClient;
            int estValueSize = aggregators.getEstimatedByteSize();
            long estSize = GroupedAggregateRegionObserver.sizeOfUnorderedGroupByMap(estDistVals, estValueSize);
            TenantCache tenantCache = GlobalCache.getTenantCache(env, tenantId);
            this.env = env;
            this.estDistVals = estDistVals;
            this.aggregators = aggregators;
            this.aggregateMap = Maps.newHashMapWithExpectedSize((int)estDistVals);
            this.chunk = tenantCache.getMemoryManager().allocate(estSize);
            this.customAnnotations = customAnnotations;
            this.aggregateValueToLastScannedRowKeys = Maps.newConcurrentMap();
        }

        @Override
        public void close() throws IOException {
            this.chunk.close();
        }

        @Override
        public Aggregator[] cache(ImmutableBytesPtr cacheKey) {
            ImmutableBytesPtr key = new ImmutableBytesPtr(cacheKey);
            Aggregator[] rowAggregators = this.aggregateMap.get(key);
            if (rowAggregators == null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(LogUtil.addCustomAnnotations((String)("Adding new aggregate bucket for row key " + Bytes.toStringBinary((byte[])key.get(), (int)key.getOffset(), (int)key.getLength())), (byte[])this.customAnnotations));
                }
                rowAggregators = this.aggregators.newAggregators(this.env.getConfiguration());
                this.aggregateMap.put(key, rowAggregators);
                if (this.aggregateMap.size() > this.estDistVals) {
                    this.estDistVals = (int)((float)this.estDistVals * 1.5f);
                    long estSize = GroupedAggregateRegionObserver.sizeOfUnorderedGroupByMap(this.estDistVals, this.aggregators.getEstimatedByteSize());
                    this.chunk.resize(estSize);
                }
            }
            return rowAggregators;
        }

        @Override
        public RegionScanner getScanner(final RegionScanner s) {
            long estSize = GroupedAggregateRegionObserver.sizeOfUnorderedGroupByMap(this.aggregateMap.size(), this.aggregators.getEstimatedByteSize());
            this.chunk.resize(estSize);
            final ArrayList<Cell> aggResults = new ArrayList<Cell>(this.aggregateMap.size());
            for (Map.Entry<ImmutableBytesPtr, Aggregator[]> entry : this.aggregateMap.entrySet()) {
                ImmutableBytesWritable aggregateGroupValPtr = (ImmutableBytesWritable)entry.getKey();
                Aggregator[] rowAggregators = entry.getValue();
                byte[] aggregateArrayBytes = this.aggregators.toBytes(rowAggregators);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(LogUtil.addCustomAnnotations((String)("Adding new distinct group: " + Bytes.toStringBinary((byte[])aggregateGroupValPtr.get(), (int)aggregateGroupValPtr.getOffset(), (int)aggregateGroupValPtr.getLength()) + " with aggregators " + Arrays.asList(rowAggregators) + " value = " + Bytes.toStringBinary((byte[])aggregateArrayBytes)), (byte[])this.customAnnotations));
                }
                if (!this.isIncompatibleClient) {
                    ImmutableBytesWritable lastScannedRowKey = (ImmutableBytesWritable)this.aggregateValueToLastScannedRowKeys.get(aggregateGroupValPtr);
                    byte[] aggregateGroupValueBytes = new byte[aggregateGroupValPtr.getLength()];
                    System.arraycopy(aggregateGroupValPtr.get(), aggregateGroupValPtr.getOffset(), aggregateGroupValueBytes, 0, aggregateGroupValueBytes.length);
                    byte[] finalValue = ByteUtil.concat((byte[])PInteger.INSTANCE.toBytes((Object)aggregateGroupValueBytes.length), (byte[][])new byte[][]{aggregateGroupValueBytes, aggregateArrayBytes});
                    aggResults.add(PhoenixKeyValueUtil.newKeyValue((byte[])lastScannedRowKey.get(), (int)lastScannedRowKey.getOffset(), (int)lastScannedRowKey.getLength(), (byte[])QueryConstants.GROUPED_AGGREGATOR_VALUE_BYTES, (byte[])QueryConstants.GROUPED_AGGREGATOR_VALUE_BYTES, (long)Long.MAX_VALUE, (byte[])finalValue, (int)0, (int)finalValue.length));
                    continue;
                }
                aggResults.add(PhoenixKeyValueUtil.newKeyValue((byte[])aggregateGroupValPtr.get(), (int)aggregateGroupValPtr.getOffset(), (int)aggregateGroupValPtr.getLength(), (byte[])QueryConstants.SINGLE_COLUMN_FAMILY, (byte[])QueryConstants.SINGLE_COLUMN, (long)Long.MAX_VALUE, (byte[])aggregateArrayBytes, (int)0, (int)aggregateArrayBytes.length));
            }
            return new BaseRegionScanner(s){
                private int index;
                {
                    super(delegate);
                    this.index = 0;
                }

                @Override
                public boolean next(List<Cell> result, ScannerContext scannerContext) throws IOException {
                    return this.next(result);
                }

                @Override
                public void close() throws IOException {
                    try {
                        s.close();
                    }
                    finally {
                        this.close();
                    }
                }

                @Override
                public boolean next(List<Cell> results) throws IOException {
                    if (this.index >= aggResults.size()) {
                        return false;
                    }
                    results.add((Cell)aggResults.get(this.index));
                    ++this.index;
                    return this.index < aggResults.size();
                }
            };
        }

        @Override
        public void cacheAggregateRowKey(ImmutableBytesPtr value, ImmutableBytesPtr rowKey) {
            this.aggregateValueToLastScannedRowKeys.put((ImmutableBytesWritable)value, (ImmutableBytesWritable)rowKey);
        }

        @Override
        public long size() {
            return this.aggregateMap.size();
        }
    }
}

